/*
 * Decompiled with CFR 0.152.
 */
package io.openliberty.microprofile.openapi20.internal;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.container.service.app.deploy.ModuleInfo;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.eclipse.microprofile.config.Config;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class ModuleSelectionConfig {
    private static final TraceComponent tc = Tr.register(ModuleSelectionConfig.class, (String)"MPOPENAPI", (String)"io.openliberty.microprofile.openapi.internal.resources.OpenAPI");
    private boolean isAll = false;
    private boolean isFirst = false;
    private List<ModuleName> included;
    private List<ModuleName> excluded;
    private static final Pattern CONFIG_VALUE_NAME_REFERENCE = Pattern.compile("(.+?)(/(.+))?");
    static final long serialVersionUID = -3004883677023041657L;

    public static ModuleSelectionConfig fromConfig(Config config) {
        ModuleSelectionConfig result = new ModuleSelectionConfig();
        String inclusion = config.getOptionalValue("mp.openapi.extensions.liberty.merged.include", String.class).orElse("first").trim();
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(null, (TraceComponent)tc, (String)("Names in config: " + config.getPropertyNames()), (Object[])new Object[0]);
            Tr.debug(null, (TraceComponent)tc, (String)("Inclusion read from config: " + inclusion), (Object[])new Object[0]);
        }
        if (inclusion.equals("none")) {
            result.included = Collections.emptyList();
        } else if (inclusion.equals("all")) {
            result.isAll = true;
        } else if (inclusion.equals("first")) {
            result.isFirst = true;
        } else {
            result.included = ModuleSelectionConfig.parseModuleNames(inclusion, "mp.openapi.extensions.liberty.merged.include");
        }
        String exclusion = config.getOptionalValue("mp.openapi.extensions.liberty.merged.exclude", String.class).orElse("none").trim();
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(null, (TraceComponent)tc, (String)("Exclusion read from config: " + exclusion), (Object[])new Object[0]);
        }
        result.excluded = exclusion.equals("none") ? Collections.emptyList() : ModuleSelectionConfig.parseModuleNames(exclusion, "mp.openapi.extensions.liberty.merged.exclude");
        return result;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("Module Selection Config[");
        if (this.isFirst) {
            sb.append("useFirstModuleOnly");
        } else {
            if (this.isAll) {
                sb.append("include = all");
            } else {
                sb.append("include = ").append(this.included);
            }
            sb.append(", ");
            sb.append("exclude = ").append(this.excluded);
        }
        sb.append("]");
        return sb.toString();
    }

    public boolean useFirstModuleOnly() {
        return this.isFirst;
    }

    public boolean isIncluded(ModuleInfo module) {
        if (this.isFirst) {
            return true;
        }
        boolean result = false;
        if (this.isAll) {
            result = true;
        } else {
            for (ModuleName name : this.included) {
                if (!this.matches(name, module)) continue;
                result = true;
                break;
            }
        }
        if (result) {
            for (ModuleName name : this.excluded) {
                if (!this.matches(name, module)) continue;
                result = false;
                break;
            }
        }
        return result;
    }

    public List<String> findIncludesNotMatchingAnything(Collection<? extends ModuleInfo> moduleInfos) {
        if (this.isAll || this.isFirst) {
            return Collections.emptyList();
        }
        ArrayList<ModuleName> includedNotYetSeen = new ArrayList<ModuleName>(this.included);
        Iterator iterator = includedNotYetSeen.iterator();
        block0: while (iterator.hasNext()) {
            ModuleName moduleName = (ModuleName)iterator.next();
            for (ModuleInfo moduleInfo : moduleInfos) {
                if (!this.matches(moduleName, moduleInfo)) continue;
                iterator.remove();
                continue block0;
            }
        }
        return includedNotYetSeen.stream().map(ModuleName::toString).collect(Collectors.toList());
    }

    private boolean matches(ModuleName name, ModuleInfo module) {
        if (name.moduleName != null && !name.moduleName.equals(module.getName())) {
            return false;
        }
        return name.appName.equals(module.getApplicationInfo().getName());
    }

    private static List<ModuleName> parseModuleNames(String nameList, String configKey) {
        ArrayList<ModuleName> result = new ArrayList<ModuleName>();
        for (String configValuePart : nameList.split(",")) {
            Matcher m = CONFIG_VALUE_NAME_REFERENCE.matcher(configValuePart);
            if (!m.matches()) {
                Tr.warning((TraceComponent)tc, (String)"OPENAPI_MERGE_INVALID_NAME_CWWKO1666W", (Object[])new Object[]{configKey, configValuePart});
                continue;
            }
            String appName = m.group(1).trim();
            String moduleName = m.group(3);
            if (moduleName != null) {
                moduleName = moduleName.trim();
            }
            result.add(new ModuleName(appName, moduleName));
        }
        return result;
    }

    @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
    @InjectedFFDC
    @TraceOptions
    private static class ModuleName {
        private final String appName;
        private final String moduleName;
        static final long serialVersionUID = 3371276020620171342L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        public ModuleName(String appName, String moduleName) {
            this.appName = appName;
            this.moduleName = moduleName;
        }

        public String toString() {
            if (this.moduleName == null) {
                return this.appName;
            }
            return this.appName + "/" + this.moduleName;
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register((String)"io.openliberty.microprofile.openapi20.internal.ModuleSelectionConfig$ModuleName", ModuleName.class, (String)"MPOPENAPI", (String)"io.openliberty.microprofile.openapi.internal.resources.OpenAPI");
        }
    }
}

