/*
 * Decompiled with CFR 0.152.
 */
package io.openliberty.microprofile.openapi20.internal;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.container.service.app.deploy.ApplicationClassesContainerInfo;
import com.ibm.ws.container.service.app.deploy.ApplicationInfo;
import com.ibm.ws.container.service.app.deploy.ContainerInfo;
import com.ibm.ws.container.service.app.deploy.ModuleClassesContainerInfo;
import com.ibm.ws.container.service.app.deploy.ModuleInfo;
import com.ibm.ws.container.service.app.deploy.WebModuleInfo;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ffdc.annotation.FFDCIgnore;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.util.ThreadContextAccessor;
import com.ibm.wsspi.adaptable.module.Container;
import com.ibm.wsspi.adaptable.module.NonPersistentCache;
import com.ibm.wsspi.adaptable.module.UnableToAdaptException;
import com.ibm.wsspi.classloading.ClassLoadingService;
import io.openliberty.microprofile.openapi20.internal.ApplicationReadException;
import io.openliberty.microprofile.openapi20.internal.ConfigProcessor;
import io.openliberty.microprofile.openapi20.internal.MergeDisabledAlerter;
import io.openliberty.microprofile.openapi20.internal.ModuleSelectionConfig;
import io.openliberty.microprofile.openapi20.internal.OpenAPIProvider;
import io.openliberty.microprofile.openapi20.internal.StaticFileProcessor;
import io.openliberty.microprofile.openapi20.internal.WebModuleOpenAPIProvider;
import io.openliberty.microprofile.openapi20.internal.cache.CacheEntry;
import io.openliberty.microprofile.openapi20.internal.cache.ConfigSerializer;
import io.openliberty.microprofile.openapi20.internal.services.ConfigFieldProvider;
import io.openliberty.microprofile.openapi20.internal.utils.IndexUtils;
import io.openliberty.microprofile.openapi20.internal.utils.LoggingUtils;
import io.openliberty.microprofile.openapi20.internal.utils.ModuleUtils;
import io.openliberty.microprofile.openapi20.internal.utils.OpenAPIUtils;
import io.smallrye.openapi.api.OpenApiConfig;
import io.smallrye.openapi.api.models.info.InfoImpl;
import io.smallrye.openapi.api.util.ConfigUtil;
import io.smallrye.openapi.api.util.FilterUtil;
import io.smallrye.openapi.api.util.MergeUtil;
import io.smallrye.openapi.runtime.OpenApiProcessor;
import io.smallrye.openapi.runtime.OpenApiStaticFile;
import io.smallrye.openapi.runtime.io.CurrentScannerInfo;
import io.smallrye.openapi.runtime.io.Format;
import io.smallrye.openapi.runtime.scanner.SchemaRegistry;
import io.smallrye.openapi.runtime.scanner.processor.JavaSecurityProcessor;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.security.AccessController;
import java.util.ArrayList;
import java.util.Collection;
import org.eclipse.microprofile.openapi.OASFactory;
import org.eclipse.microprofile.openapi.OASFilter;
import org.eclipse.microprofile.openapi.models.OpenAPI;
import org.jboss.jandex.IndexView;
import org.osgi.framework.Bundle;
import org.osgi.framework.FrameworkUtil;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.ConfigurationPolicy;
import org.osgi.service.component.annotations.Reference;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
@Component(configurationPolicy=ConfigurationPolicy.IGNORE, service={ApplicationProcessor.class})
public class ApplicationProcessor {
    private static final TraceComponent tc = Tr.register(ApplicationProcessor.class, (String)"MPOPENAPI", (String)"io.openliberty.microprofile.openapi.internal.resources.OpenAPI");
    private static final ThreadContextAccessor THREAD_CONTEXT_ACCESSOR = (ThreadContextAccessor)AccessController.doPrivileged(ThreadContextAccessor.getPrivilegedAction());
    @Reference
    private ClassLoadingService classLoadingService;
    @Reference
    private MergeDisabledAlerter mergeDisabledAlerter;
    @Reference
    private ConfigSerializer configSerializer;
    @Reference
    private ConfigFieldProvider configFieldProvider;
    static final long serialVersionUID = -5705600612848264299L;

    @FFDCIgnore(value={ApplicationReadException.class})
    public Collection<OpenAPIProvider> processApplication(ApplicationInfo appInfo, ModuleSelectionConfig selectionConfig) {
        ArrayList<OpenAPIProvider> openAPIProviders;
        block8: {
            openAPIProviders = new ArrayList<OpenAPIProvider>();
            if (LoggingUtils.isEventEnabled(tc)) {
                Tr.event((TraceComponent)tc, (String)("Application Processor: Processing application started: appInfo=" + appInfo), (Object[])new Object[0]);
            }
            try {
                Collection<ModuleClassesContainerInfo> moduleClassesContainerInfos = this.getModuleClassesContainerInfos(appInfo);
                for (ModuleClassesContainerInfo moduleClassesContainerInfo : moduleClassesContainerInfos) {
                    WebModuleInfo webModuleInfo;
                    ContainerInfo containerInfo = (ContainerInfo)moduleClassesContainerInfo;
                    if (containerInfo.getType() != ContainerInfo.Type.WEB_MODULE || (webModuleInfo = ModuleUtils.getWebModuleInfo(containerInfo.getContainer())) == null) continue;
                    if (selectionConfig.useFirstModuleOnly() && !openAPIProviders.isEmpty()) {
                        if (LoggingUtils.isEventEnabled(tc)) {
                            Tr.event((Object)this, (TraceComponent)tc, (String)("ApplicationProcessor: Ignoring module because useFirstModuleOnly is set and we already found one. module=" + webModuleInfo.getName()), (Object[])new Object[0]);
                        }
                        this.mergeDisabledAlerter.setUsingMultiModulesWithoutConfig((OpenAPIProvider)openAPIProviders.get(0));
                        break;
                    }
                    if (!selectionConfig.isIncluded((ModuleInfo)webModuleInfo)) {
                        if (!LoggingUtils.isEventEnabled(tc)) continue;
                        Tr.event((Object)this, (TraceComponent)tc, (String)("ApplicationProcessor: Module not included by config. app=" + appInfo.getName() + " module=" + webModuleInfo.getName() + ", config = " + selectionConfig), (Object[])new Object[0]);
                        continue;
                    }
                    OpenAPIProvider openAPIProvider = this.processWebModule(containerInfo.getContainer(), webModuleInfo, moduleClassesContainerInfo);
                    if (openAPIProvider == null) continue;
                    Tr.info((TraceComponent)tc, (String)"OPENAPI_APPLICATION_PROCESSED", (Object[])new Object[]{webModuleInfo.getApplicationInfo().getDeploymentName()});
                    openAPIProviders.add(openAPIProvider);
                }
                if (LoggingUtils.isEventEnabled(tc)) {
                    Tr.event((TraceComponent)tc, (String)("Application Processor: Processing application ended: appInfo=" + appInfo), (Object[])new Object[0]);
                }
            }
            catch (ApplicationReadException e) {
                if (!LoggingUtils.isEventEnabled(tc)) break block8;
                Tr.event((Object)this, (TraceComponent)tc, (String)("Application Processor: Processing application ended: " + e.toString()), (Object[])new Object[]{e});
            }
        }
        return openAPIProviders;
    }

    /*
     * WARNING - void declaration
     */
    public Collection<ModuleClassesContainerInfo> getModuleClassesContainerInfos(ApplicationInfo appInfo) throws ApplicationReadException {
        ArrayList<ModuleClassesContainerInfo> result = new ArrayList<ModuleClassesContainerInfo>();
        Container appContainer = appInfo.getContainer();
        if (appContainer == null) {
            throw new ApplicationReadException("appInfo=null");
        }
        try {
            NonPersistentCache cache = (NonPersistentCache)appContainer.adapt(NonPersistentCache.class);
            ApplicationClassesContainerInfo applicationClassesContainerInfo = (ApplicationClassesContainerInfo)cache.getFromCache(ApplicationClassesContainerInfo.class);
            if (applicationClassesContainerInfo == null) {
                throw new ApplicationReadException("appInfo=" + appInfo + ", appContainer=null");
            }
            result.addAll(applicationClassesContainerInfo.getModuleClassesContainerInfo());
        }
        catch (UnableToAdaptException cache) {
            void e;
            FFDCFilter.processException((Throwable)cache, (String)"io.openliberty.microprofile.openapi20.internal.ApplicationProcessor", (String)"187", (Object)this, (Object[])new Object[]{appInfo});
            throw new ApplicationReadException("Failed to adapt NonPersistentCache: container=" + appContainer + " : \n" + e.getMessage(), (Throwable)e);
        }
        return result;
    }

    /*
     * WARNING - void declaration
     */
    private OpenAPIProvider processWebModule(Container appContainer, WebModuleInfo moduleInfo, ModuleClassesContainerInfo moduleClassesContainerInfo) {
        WebModuleOpenAPIProvider openAPIProvider = null;
        if (LoggingUtils.isEventEnabled(tc)) {
            Tr.event((TraceComponent)tc, (String)("WebModule: Processing started : deploymentName=" + moduleInfo.getApplicationInfo().getDeploymentName() + " : contextRoot=" + moduleInfo.getContextRoot()), (Object[])new Object[0]);
        }
        ClassLoader appClassloader = moduleInfo.getClassLoader();
        OpenAPI openAPIModel = null;
        try {
            ConfigProcessor configProcessor = new ConfigProcessor(appClassloader, this.configFieldProvider);
            try {
                if (LoggingUtils.isEventEnabled(tc)) {
                    Tr.event((TraceComponent)tc, (String)("Retrieved configuration values : " + configProcessor), (Object[])new Object[0]);
                }
                CacheEntry newCacheEntry = null;
                OpenApiConfig config = configProcessor.getOpenAPIConfig();
                String modulePathString = appContainer.getPhysicalPath();
                Path modulePath = modulePathString == null ? null : Paths.get(modulePathString, new String[0]);
                Path cacheDir = ApplicationProcessor.getCacheDir();
                if (modulePath != null && ApplicationProcessor.isWar(modulePath) && cacheDir != null) {
                    newCacheEntry = CacheEntry.createNew(moduleInfo.getApplicationInfo().getDeploymentName(), cacheDir, this.configSerializer);
                    newCacheEntry.setConfig(config);
                    newCacheEntry.addDependentFile(modulePath);
                    CacheEntry loadedCacheEntry = CacheEntry.read(moduleInfo.getApplicationInfo().getDeploymentName(), cacheDir);
                    if (loadedCacheEntry != null && loadedCacheEntry.isUpToDateWith(newCacheEntry)) {
                        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)tc, (String)"Using OpenAPI model loaded from cache", (Object[])new Object[0]);
                        }
                        openAPIModel = loadedCacheEntry.getModel();
                    }
                }
                if (openAPIModel == null) {
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)"Generating OpenAPI model", (Object[])new Object[0]);
                    }
                    if ((openAPIModel = this.generateModel(config, appContainer, moduleInfo, moduleClassesContainerInfo, appClassloader)) != null && newCacheEntry != null) {
                        newCacheEntry.setModel(openAPIModel);
                        newCacheEntry.write();
                    }
                }
                if (openAPIModel != null) {
                    if (openAPIModel.getInfo() == null) {
                        openAPIModel.setInfo(new InfoImpl().title("Generated API").version("1.0"));
                    }
                    if (LoggingUtils.isEventEnabled(tc)) {
                        Tr.event((TraceComponent)tc, (String)("Generated document: " + OpenAPIUtils.getOpenAPIDocument(openAPIModel, Format.JSON)), (Object[])new Object[0]);
                    }
                    openAPIProvider = new WebModuleOpenAPIProvider(moduleInfo, openAPIModel);
                    if (configProcessor.isValidating()) {
                        try {
                            if (LoggingUtils.isEventEnabled(tc)) {
                                Tr.event((TraceComponent)tc, (String)"Validate document", (Object[])new Object[0]);
                            }
                            OpenAPIUtils.validateDocument(openAPIModel);
                        }
                        catch (Throwable loadedCacheEntry) {
                            FFDCFilter.processException((Throwable)loadedCacheEntry, (String)"io.openliberty.microprofile.openapi20.internal.ApplicationProcessor", (String)"274", (Object)this, (Object[])new Object[]{appContainer, moduleInfo, moduleClassesContainerInfo});
                            if (LoggingUtils.isEventEnabled(tc)) {
                                void e;
                                Tr.event((TraceComponent)tc, (String)("Failed to call OASValidator: " + e.getMessage()), (Object[])new Object[0]);
                            }
                        }
                    }
                } else if (LoggingUtils.isEventEnabled(tc)) {
                    Tr.event((TraceComponent)tc, (String)("WebModule: Processing ended : Not an OAS application : deploymentName=" + moduleInfo.getApplicationInfo().getDeploymentName() + " : contextRoot=" + moduleInfo.getContextRoot()), (Object[])new Object[0]);
                }
                configProcessor.close();
            }
            catch (Throwable newCacheEntry) {
                FFDCFilter.processException((Throwable)newCacheEntry, (String)"io.openliberty.microprofile.openapi20.internal.ApplicationProcessor", (String)"216", (Object)this, (Object[])new Object[]{appContainer, moduleInfo, moduleClassesContainerInfo});
                try {
                    configProcessor.close();
                }
                catch (Throwable throwable) {
                    FFDCFilter.processException((Throwable)throwable, (String)"io.openliberty.microprofile.openapi20.internal.ApplicationProcessor", (String)"216", (Object)this, (Object[])new Object[]{appContainer, moduleInfo, moduleClassesContainerInfo});
                    newCacheEntry.addSuppressed(throwable);
                }
                throw newCacheEntry;
            }
        }
        catch (Exception configProcessor) {
            void e;
            FFDCFilter.processException((Throwable)configProcessor, (String)"io.openliberty.microprofile.openapi20.internal.ApplicationProcessor", (String)"286", (Object)this, (Object[])new Object[]{appContainer, moduleInfo, moduleClassesContainerInfo});
            if (LoggingUtils.isEventEnabled(tc)) {
                String message = String.format("Failed to process application %s: %s", moduleInfo.getApplicationInfo().getDeploymentName(), e.getMessage());
                Tr.event((TraceComponent)tc, (String)("Failed to process application: " + message), (Object[])new Object[0]);
            }
            Tr.error((TraceComponent)tc, (String)"OPENAPI_APPLICATION_PROCESSING_ERROR", (Object[])new Object[]{moduleInfo.getApplicationInfo().getDeploymentName(), e.toString()});
        }
        if (LoggingUtils.isEventEnabled(tc)) {
            Tr.event((TraceComponent)tc, (String)("WebModule: Processing ended : deploymentName=" + moduleInfo.getApplicationInfo().getDeploymentName() + " : contextRoot=" + moduleInfo.getContextRoot()), (Object[])new Object[0]);
        }
        return openAPIProvider;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private OpenAPI generateModel(OpenApiConfig config, Container appContainer, WebModuleInfo moduleInfo, ModuleClassesContainerInfo moduleClassesContainerInfo, ClassLoader appClassloader) {
        OpenAPI openAPIModel;
        block18: {
            ClassLoader tccl = this.classLoadingService.createThreadContextClassLoader(appClassloader);
            Object oldClassLoader = THREAD_CONTEXT_ACCESSOR.pushContextClassLoaderForUnprivileged(tccl);
            try {
                OASFilter filter;
                block17: {
                    openAPIModel = OpenApiProcessor.modelFromReader((OpenApiConfig)config, (ClassLoader)tccl);
                    try {
                        OpenApiStaticFile staticFile = StaticFileProcessor.getOpenAPIFile(appContainer);
                        try {
                            openAPIModel = MergeUtil.merge((OpenAPI)openAPIModel, (OpenAPI)OpenApiProcessor.modelFromStaticFile((OpenApiStaticFile)staticFile));
                            if (staticFile == null) break block17;
                        }
                        catch (Throwable throwable) {
                            FFDCFilter.processException((Throwable)throwable, (String)"io.openliberty.microprofile.openapi20.internal.ApplicationProcessor", (String)"313", (Object)this, (Object[])new Object[]{config, appContainer, moduleInfo, moduleClassesContainerInfo, appClassloader});
                            if (staticFile == null) throw throwable;
                            try {
                                staticFile.close();
                                throw throwable;
                            }
                            catch (Throwable throwable2) {
                                FFDCFilter.processException((Throwable)throwable2, (String)"io.openliberty.microprofile.openapi20.internal.ApplicationProcessor", (String)"313", (Object)this, (Object[])new Object[]{config, appContainer, moduleInfo, moduleClassesContainerInfo, appClassloader});
                                throwable.addSuppressed(throwable2);
                            }
                            throw throwable;
                        }
                        staticFile.close();
                    }
                    catch (IOException staticFile) {
                        FFDCFilter.processException((Throwable)staticFile, (String)"io.openliberty.microprofile.openapi20.internal.ApplicationProcessor", (String)"315", (Object)this, (Object[])new Object[]{config, appContainer, moduleInfo, moduleClassesContainerInfo, appClassloader});
                    }
                }
                if (!config.scanDisable()) {
                    openAPIModel = MergeUtil.merge((OpenAPI)openAPIModel, (OpenAPI)OpenApiProcessor.modelFromAnnotations((OpenApiConfig)config, (IndexView)IndexUtils.getIndexView(moduleInfo, moduleClassesContainerInfo, config)));
                }
                if ((filter = OpenApiProcessor.getFilter((OpenApiConfig)config, (ClassLoader)appClassloader)) != null) {
                    openAPIModel = FilterUtil.applyFilter((OASFilter)filter, (OpenAPI)openAPIModel);
                }
                if (openAPIModel == null) break block18;
                if (openAPIModel.getOpenapi() == null) {
                    openAPIModel.setOpenapi("3.0.3");
                }
                if (openAPIModel.getPaths() == null) {
                    openAPIModel.setPaths(OASFactory.createPaths());
                }
                if (openAPIModel.getInfo() == null) {
                    openAPIModel.setInfo(OASFactory.createInfo());
                }
                if (openAPIModel.getInfo().getTitle() == null) {
                    openAPIModel.getInfo().setTitle("Generated API");
                }
                if (openAPIModel.getInfo().getVersion() == null) {
                    openAPIModel.getInfo().setVersion("1.0");
                }
                ConfigUtil.applyConfig((OpenApiConfig)config, (OpenAPI)openAPIModel);
                if (OpenAPIUtils.isDefaultOpenApiModel(openAPIModel)) {
                    openAPIModel = null;
                }
            }
            finally {
                SchemaRegistry.remove();
                JavaSecurityProcessor.remove();
                CurrentScannerInfo.remove();
                THREAD_CONTEXT_ACCESSOR.popContextClassLoaderForUnprivileged(oldClassLoader);
                this.classLoadingService.destroyThreadContextClassLoader(tccl);
            }
        }
        if (openAPIModel != null) return openAPIModel;
        if (!LoggingUtils.isEventEnabled(tc)) return openAPIModel;
        Tr.event((TraceComponent)tc, (String)"No Open API document generated", (Object[])new Object[0]);
        return openAPIModel;
    }

    private static boolean isWar(Path path) {
        return path.getFileName().toString().endsWith(".war") && Files.isRegularFile(path, new LinkOption[0]);
    }

    private static Path getCacheDir() {
        Bundle bundle = FrameworkUtil.getBundle(ApplicationProcessor.class);
        if (bundle == null) {
            return null;
        }
        File cacheFile = bundle.getDataFile("");
        if (cacheFile == null) {
            if (LoggingUtils.isEventEnabled(tc)) {
                Tr.event((TraceComponent)tc, (String)"No support from OSGi for caching", (Object[])new Object[0]);
            }
            return null;
        }
        return cacheFile.toPath();
    }
}

