/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.javaeesec.properties;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.runtime.metadata.ComponentMetaData;
import com.ibm.ws.runtime.metadata.MetaData;
import com.ibm.ws.security.javaeesec.CDIHelper;
import com.ibm.ws.security.javaeesec.properties.ModulePropertiesProvider;
import com.ibm.ws.threadContext.ComponentMetaDataAccessorImpl;
import com.ibm.ws.webcontainer.osgi.metadata.WebModuleMetaDataImpl;
import com.ibm.ws.webcontainer.security.util.WebConfigUtils;
import com.ibm.wsspi.webcontainer.metadata.WebModuleMetaData;
import jakarta.enterprise.context.ApplicationScoped;
import jakarta.enterprise.context.spi.Contextual;
import jakarta.enterprise.inject.Instance;
import jakarta.enterprise.inject.spi.Bean;
import jakarta.enterprise.inject.spi.BeanManager;
import jakarta.enterprise.inject.spi.CDI;
import jakarta.security.enterprise.authentication.mechanism.http.HttpAuthenticationMechanism;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class ModulePropertiesUtils {
    private static final TraceComponent tc = Tr.register(ModulePropertiesUtils.class, (String)"security", (String)"com.ibm.ws.security.javaeesec.internal.resources.JavaEESecMessages");
    private static ModulePropertiesUtils self = new ModulePropertiesUtils();
    private final Map<MetaData, HamObject> ModuleToHam = Collections.synchronizedMap(new WeakHashMap());
    private final Map<MetaData, HamLookupObject> ModuleToHamLookup = Collections.synchronizedMap(new WeakHashMap());
    static final long serialVersionUID = 7549924515757750308L;

    protected ModulePropertiesUtils() {
    }

    public static ModulePropertiesUtils getInstance() {
        return self;
    }

    public String getJ2EEModuleName() {
        WebModuleMetaData wmmd = this.getWebModuleMetaData();
        if (wmmd != null) {
            return wmmd.getJ2EEName().getModule();
        }
        ComponentMetaData cmd = this.getComponentMetaData();
        if (cmd != null) {
            return cmd.getModuleMetaData().getJ2EEName().getModule();
        }
        return null;
    }

    public String getJ2EEApplicationName() {
        WebModuleMetaData wmmd = this.getWebModuleMetaData();
        if (wmmd != null) {
            return wmmd.getJ2EEName().getApplication();
        }
        ComponentMetaData cmd = this.getComponentMetaData();
        if (cmd != null) {
            return cmd.getJ2EEName().getApplication();
        }
        return null;
    }

    public boolean isHttpAuthenticationMechanism() {
        HttpAuthenticationMechanism ham = this.getHttpAuthenticationMechanism(false);
        return ham != null;
    }

    public HttpAuthenticationMechanism getHttpAuthenticationMechanism() {
        return this.getHttpAuthenticationMechanism(true);
    }

    private HttpAuthenticationMechanism getHttpAuthenticationMechanism(boolean logError) {
        WebModuleMetaDataImpl metadata = null;
        WebModuleMetaDataImpl wmmd = (WebModuleMetaDataImpl)this.getWebModuleMetaData();
        if (wmmd != null) {
            metadata = wmmd;
            if (!wmmd.checkForHAM()) {
                return null;
            }
        }
        if (metadata == null) {
            metadata = this.getComponentMetaData();
        }
        Class hamClass = null;
        HttpAuthenticationMechanism ham = null;
        HamObject hamObject = this.ModuleToHam.get(metadata);
        if (hamObject != null) {
            ham = hamObject.getHam();
        } else {
            HamLookupObject hamLookupObject = this.ModuleToHamLookup.get(metadata);
            if (hamLookupObject != null) {
                ham = hamLookupObject.getHam();
            } else {
                boolean isCacheable = true;
                BeanManager beanManager = null;
                CDI cdi = this.getCDI();
                if (cdi != null && (beanManager = cdi.getBeanManager()) != null) {
                    Instance mppi = cdi.select(ModulePropertiesProvider.class, new Annotation[0]);
                    if (mppi != null && !mppi.isUnsatisfied() && !mppi.isAmbiguous()) {
                        List<Class> implClassList = ((ModulePropertiesProvider)mppi.get()).getAuthMechClassList();
                        if (implClassList != null) {
                            if (implClassList.size() == 0) {
                                if (logError) {
                                    Tr.error((TraceComponent)tc, (String)"JAVAEESEC_ERROR_NO_HAM", (Object[])new Object[]{this.getJ2EEModuleName(), this.getJ2EEApplicationName()});
                                }
                            } else {
                                Bean<HttpAuthenticationMechanism> bean = null;
                                Iterator<Class> iterator = implClassList.iterator();
                                while (iterator.hasNext()) {
                                    Class implClass;
                                    hamClass = implClass = iterator.next();
                                    bean = this.getBean(beanManager, implClass);
                                    if (bean == null) continue;
                                    break;
                                }
                                if (bean != null) {
                                    ham = (HttpAuthenticationMechanism)beanManager.getReference(bean, (Type)hamClass, beanManager.createCreationalContext(bean));
                                    isCacheable = this.isCacheable(bean);
                                    if (tc.isDebugEnabled()) {
                                        Tr.debug((TraceComponent)tc, (String)("HAM from the current CDI : " + ham), (Object[])new Object[0]);
                                    }
                                } else {
                                    BeanManager moduleBeanManager = CDIHelper.getBeanManager();
                                    if (!beanManager.equals(moduleBeanManager) && (bean = this.getBean(beanManager = moduleBeanManager, hamClass)) != null) {
                                        ham = (HttpAuthenticationMechanism)beanManager.getReference(bean, (Type)hamClass, beanManager.createCreationalContext(bean));
                                        isCacheable = this.isCacheable(bean);
                                        if (tc.isDebugEnabled()) {
                                            Tr.debug((TraceComponent)tc, (String)("HAM from the module BeanManager : " + ham), (Object[])new Object[0]);
                                        }
                                    }
                                }
                                if (ham == null) {
                                    Tr.error((TraceComponent)tc, (String)"JAVAEESEC_ERROR_NO_HAM", (Object[])new Object[]{this.getJ2EEModuleName(), this.getJ2EEApplicationName()});
                                }
                            }
                        } else if (tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)tc, (String)("No HAM implementation class defined. Module Name : " + this.getJ2EEModuleName() + ", Application Name : " + this.getJ2EEApplicationName()), (Object[])new Object[0]);
                        }
                    } else if (logError) {
                        throw new RuntimeException("ModulePropertiesProvider object cannot be identified.");
                    }
                }
                if (!isCacheable) {
                    this.ModuleToHamLookup.put((MetaData)metadata, new HamLookupObject(beanManager, hamClass));
                    if (wmmd != null) {
                        wmmd.setHasHAM(true);
                    }
                } else {
                    this.ModuleToHam.put((MetaData)metadata, new HamObject(ham));
                    if (wmmd != null) {
                        wmmd.setHasHAM(ham != null);
                    }
                }
            }
        }
        return ham;
    }

    public boolean isELExpression(String elExpression) {
        if (elExpression != null) {
            return elExpression.startsWith("#{") || elExpression.startsWith("${");
        }
        return false;
    }

    public boolean isImmediateEval(String elExpression) {
        if (elExpression != null) {
            return elExpression.startsWith("${");
        }
        return false;
    }

    public String extractExpression(String elExpression) {
        if (elExpression != null && (elExpression.startsWith("#{") || elExpression.startsWith("${")) && elExpression.endsWith("}")) {
            return elExpression.substring(2, elExpression.length() - 1);
        }
        return elExpression;
    }

    protected WebModuleMetaData getWebModuleMetaData() {
        return WebConfigUtils.getWebModuleMetaData();
    }

    protected ComponentMetaData getComponentMetaData() {
        return ComponentMetaDataAccessorImpl.getComponentMetaDataAccessor().getComponentMetaData();
    }

    private Bean<HttpAuthenticationMechanism> getBean(BeanManager beanManager, Class<HttpAuthenticationMechanism> hamClass) {
        Bean bean = null;
        Set beans = beanManager.getBeans(hamClass, new Annotation[0]);
        if (beans.size() == 1) {
            bean = (Bean)beans.iterator().next();
        }
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("HAM : " + hamClass + " Number of HAM bean: " + beans.size() + " bean.toString(): " + (bean != null ? bean.toString() : "<NO bean>")), (Object[])new Object[0]);
        }
        return bean;
    }

    private boolean isCacheable(Bean<?> bean) {
        boolean isCacheable = false;
        Class scope = bean.getScope();
        if (scope != null && scope.isAssignableFrom(ApplicationScoped.class)) {
            isCacheable = true;
        }
        return isCacheable;
    }

    protected CDI getCDI() {
        return CDIHelper.getCDI();
    }

    protected void clearModuleTable() {
        this.ModuleToHam.clear();
    }

    private MetaData getMetaData() {
        WebModuleMetaData wmmd = this.getWebModuleMetaData();
        if (wmmd != null) {
            return wmmd;
        }
        return this.getComponentMetaData();
    }

    @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
    @InjectedFFDC
    @TraceOptions
    class HamLookupObject {
        private final BeanManager beanManager;
        private final Class<HttpAuthenticationMechanism> hamClass;
        static final long serialVersionUID = 8857722800385173370L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        HamLookupObject(BeanManager beanManager, Class<HttpAuthenticationMechanism> hamClass) {
            this.beanManager = beanManager;
            this.hamClass = hamClass;
        }

        HttpAuthenticationMechanism getHam() {
            Set beans = this.beanManager.getBeans(this.hamClass, new Annotation[0]);
            Bean bean = this.beanManager.resolve(beans);
            return (HttpAuthenticationMechanism)this.beanManager.getReference(bean, this.hamClass, this.beanManager.createCreationalContext((Contextual)bean));
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register((String)"com.ibm.ws.security.javaeesec.properties.ModulePropertiesUtils$HamLookupObject", HamLookupObject.class, (String)"security", (String)"com.ibm.ws.security.javaeesec.internal.resources.JavaEESecMessages");
        }
    }

    @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
    @InjectedFFDC
    @TraceOptions
    class HamObject {
        private final HttpAuthenticationMechanism ham;
        static final long serialVersionUID = 7132484467635432716L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        HamObject(HttpAuthenticationMechanism ham) {
            this.ham = ham;
        }

        HttpAuthenticationMechanism getHam() {
            return this.ham;
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register((String)"com.ibm.ws.security.javaeesec.properties.ModulePropertiesUtils$HamObject", HamObject.class, (String)"security", (String)"com.ibm.ws.security.javaeesec.internal.resources.JavaEESecMessages");
        }
    }
}

