/*
 * Decompiled with CFR 0.152.
 */
package io.openliberty.concurrent.internal.cdi.interceptor;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.websphere.ras.annotation.Trivial;
import com.ibm.ws.concurrent.WSManagedExecutorService;
import com.ibm.ws.ffdc.annotation.FFDCIgnore;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import jakarta.annotation.Priority;
import jakarta.enterprise.concurrent.Asynchronous;
import jakarta.interceptor.AroundInvoke;
import jakarta.interceptor.Interceptor;
import jakarta.interceptor.InvocationContext;
import jakarta.transaction.Transactional;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.TreeSet;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.RejectedExecutionException;
import javax.naming.InitialContext;
import javax.naming.NamingException;

@Asynchronous
@Interceptor
@Priority(value=5)
@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class AsyncInterceptor
implements Serializable {
    private static final long serialVersionUID = 7447792334053278336L;
    private static final TraceComponent tc = Tr.register(AsyncInterceptor.class, (String)"concurrent", (String)"io.openliberty.concurrent.internal.cdi.resources.CWWKCMessages");

    @AroundInvoke
    @FFDCIgnore(value={ClassCastException.class, NamingException.class})
    public Object intercept(InvocationContext invocation) throws Exception {
        WSManagedExecutorService managedExecutor;
        Object executor;
        Method method = invocation.getMethod();
        AsyncInterceptor.validateTransactional(method);
        if (method.getDeclaringClass().getAnnotation(Asynchronous.class) != null) {
            throw new UnsupportedOperationException(Tr.formatMessage((TraceComponent)tc, (String)"CWWKC1401.class.anno.disallowed", (Object[])new Object[]{"@Asynchronous", method.getDeclaringClass().getName()}));
        }
        Asynchronous anno = method.getAnnotation(Asynchronous.class);
        Class<?> returnType = method.getReturnType();
        if (!(returnType.equals(CompletableFuture.class) || returnType.equals(CompletionStage.class) || returnType.equals(Void.TYPE))) {
            throw new UnsupportedOperationException(Tr.formatMessage((TraceComponent)tc, (String)"CWWKC1400.unsupported.return.type", (Object[])new Object[]{returnType, method.getName(), method.getClass().getName(), "@Asynchronous", "[CompletableFuture, CompletionStage, void]"}));
        }
        try {
            executor = InitialContext.doLookup(anno.executor());
        }
        catch (NamingException x) {
            throw new RejectedExecutionException(x);
        }
        try {
            managedExecutor = (WSManagedExecutorService)executor;
        }
        catch (ClassCastException x) {
            TreeSet<String> interfaces = new TreeSet<String>();
            for (Class<?> c = executor.getClass(); c != null; c = c.getSuperclass()) {
                for (Class<?> i : executor.getClass().getInterfaces()) {
                    interfaces.add(i.getName());
                }
            }
            throw new RejectedExecutionException(Tr.formatMessage((TraceComponent)tc, (String)"CWWKC1402.not.managed.executor", (Object[])new Object[]{"@Asynchronous", method.getName(), method.getClass().getName(), anno.executor(), executor.getClass().getName(), interfaces}), x);
        }
        return managedExecutor.newAsyncMethod(this::invoke, (Object)invocation);
    }

    @FFDCIgnore(value={Throwable.class})
    public <T> CompletionStage<T> invoke(InvocationContext invocation, CompletableFuture<T> future) {
        Asynchronous.Result.setFuture(future);
        try {
            CompletionStage asyncMethodResultStage;
            CompletionStage completionStage = asyncMethodResultStage = (CompletionStage)invocation.proceed();
            return completionStage;
        }
        catch (Throwable x) {
            throw x instanceof CompletionException ? (CompletionException)x : new CompletionException(x);
        }
        finally {
            Asynchronous.Result.setFuture(null);
        }
    }

    @Trivial
    private static void validateTransactional(Method method) throws UnsupportedOperationException {
        Transactional tx = method.getAnnotation(Transactional.class);
        if (tx == null) {
            tx = method.getDeclaringClass().getAnnotation(Transactional.class);
        }
        if (tx != null) {
            switch (tx.value()) {
                case NOT_SUPPORTED: 
                case REQUIRES_NEW: {
                    break;
                }
                default: {
                    throw new UnsupportedOperationException(Tr.formatMessage((TraceComponent)tc, (String)"CWWKC1403.unsupported.tx.type", (Object[])new Object[]{"@Transactional", tx.value(), "@Asynchronous", method.getName(), method.getDeclaringClass().getName(), Arrays.asList(Transactional.TxType.REQUIRES_NEW, Transactional.TxType.NOT_SUPPORTED)}));
                }
            }
        }
    }
}

