/*
 * Decompiled with CFR 0.152.
 */
package io.openliberty.security.oidcclientcore.token.auth;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.Sensitive;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ffdc.annotation.FFDCIgnore;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import io.openliberty.security.oidcclientcore.exceptions.PrivateKeyJwtAuthException;
import io.openliberty.security.oidcclientcore.exceptions.PrivateKeyJwtAuthMissingKeyException;
import java.security.Key;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Base64;
import org.jose4j.jws.JsonWebSignature;
import org.jose4j.jwt.JwtClaims;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class PrivateKeyJwtAuthMethod {
    public static final TraceComponent tc = Tr.register(PrivateKeyJwtAuthMethod.class, (String)"OpenIdConnect", (String)"io.openliberty.security.oidcclientcore.internal.resources.OidcClientCoreMessages");
    private static final float EXP_TIME_IN_MINUTES = 5.0f;
    private final String clientId;
    private final String tokenEndpoint;
    private final String clientAssertionSigningAlgorithm;
    @Sensitive
    private final Key clientAssertionSigningKey;
    static final long serialVersionUID = -3508881953103185195L;

    public PrivateKeyJwtAuthMethod(String clientId, String tokenEndpoint, String clientAssertionSigningAlgorithm, @Sensitive Key clientAssertionSigningKey) {
        this.clientId = clientId;
        this.tokenEndpoint = tokenEndpoint;
        this.clientAssertionSigningAlgorithm = clientAssertionSigningAlgorithm;
        this.clientAssertionSigningKey = clientAssertionSigningKey;
    }

    /*
     * WARNING - void declaration
     */
    public String createPrivateKeyJwt() throws PrivateKeyJwtAuthException {
        String jwt = null;
        try {
            if (this.clientAssertionSigningKey == null) {
                throw new PrivateKeyJwtAuthMissingKeyException(this.clientId);
            }
            JwtClaims claims = this.populateJwtClaims();
            jwt = this.getSignedJwt(claims);
        }
        catch (Exception claims) {
            void e;
            FFDCFilter.processException((Throwable)claims, (String)"io.openliberty.security.oidcclientcore.token.auth.PrivateKeyJwtAuthMethod", (String)"55", (Object)this, (Object[])new Object[0]);
            throw new PrivateKeyJwtAuthException(this.clientId, e.getMessage());
        }
        return jwt;
    }

    private JwtClaims populateJwtClaims() {
        JwtClaims claims = new JwtClaims();
        claims.setIssuer(this.clientId);
        claims.setSubject(this.clientId);
        claims.setAudience(this.tokenEndpoint);
        claims.setExpirationTimeMinutesInTheFuture(5.0f);
        claims.setGeneratedJwtId();
        claims.setIssuedAtToNow();
        return claims;
    }

    private String getSignedJwt(JwtClaims claims) throws Exception {
        JsonWebSignature jws = new JsonWebSignature();
        this.setHeaderValues(jws);
        jws.setPayload(claims.toJson());
        jws.setKey(this.clientAssertionSigningKey);
        jws.setDoKeyValidation(false);
        return jws.getCompactSerialization();
    }

    @FFDCIgnore(value={NoSuchAlgorithmException.class})
    private void setHeaderValues(JsonWebSignature jws) {
        block2: {
            jws.setAlgorithmHeaderValue(this.clientAssertionSigningAlgorithm);
            jws.setHeader("typ", "JWT");
            try {
                String x5t = new String(Base64.getUrlEncoder().encode(MessageDigest.getInstance("SHA-1").digest(this.clientAssertionSigningKey.getEncoded())));
                jws.setHeader("x5t", x5t);
            }
            catch (NoSuchAlgorithmException e) {
                if (!tc.isDebugEnabled()) break block2;
                Tr.debug((TraceComponent)tc, (String)("Caught exception getting x5t for signing key: " + e), (Object[])new Object[0]);
            }
        }
    }
}

