/*
 * Decompiled with CFR 0.152.
 */
package io.openliberty.security.oidcclientcore.token;

import com.ibm.json.java.JSONObject;
import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.Sensitive;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.kernel.productinfo.ProductInfo;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import io.openliberty.security.oidcclientcore.exceptions.PrivateKeyJwtAuthException;
import io.openliberty.security.oidcclientcore.exceptions.TokenRequestException;
import io.openliberty.security.oidcclientcore.http.OidcClientHttpUtil;
import io.openliberty.security.oidcclientcore.token.TokenResponse;
import io.openliberty.security.oidcclientcore.token.auth.PrivateKeyJwtAuthMethod;
import java.security.Key;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.net.ssl.SSLSocketFactory;
import org.apache.http.NameValuePair;
import org.apache.http.message.BasicNameValuePair;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class TokenRequestor {
    public static final TraceComponent tc = Tr.register(TokenRequestor.class, (String)"OpenIdConnect", (String)"io.openliberty.security.oidcclientcore.internal.resources.OidcClientCoreMessages");
    private final String tokenEndpoint;
    private final String clientId;
    @Sensitive
    private final String clientSecret;
    private final String grantType;
    private final String redirectUri;
    private final String code;
    private final String refreshToken;
    private final SSLSocketFactory sslSocketFactory;
    private final boolean isHostnameVerification;
    private final String authMethod;
    private final String resources;
    private final List<NameValuePair> params;
    private final HashMap<String, String> customParams;
    private final boolean useSystemPropertiesForHttpClientConnections;
    private final String clientAssertionSigningAlgorithm;
    @Sensitive
    private final Key clientAssertionSigningKey;
    OidcClientHttpUtil oidcClientHttpUtil = OidcClientHttpUtil.getInstance();
    private static boolean issuedBetaMessage = false;
    static final long serialVersionUID = 8098420860593164211L;

    private TokenRequestor(Builder builder) throws TokenRequestException {
        this.tokenEndpoint = builder.tokenEndpoint;
        this.clientId = builder.clientId;
        this.clientSecret = builder.clientSecret;
        this.grantType = builder.grantType;
        this.redirectUri = builder.redirectUri;
        this.code = builder.code;
        this.refreshToken = builder.refreshToken;
        this.sslSocketFactory = builder.sslSocketFactory;
        this.isHostnameVerification = builder.isHostnameVerification;
        this.authMethod = builder.authMethod;
        this.resources = builder.resources;
        this.customParams = builder.customParams;
        this.useSystemPropertiesForHttpClientConnections = builder.useSystemPropertiesForHttpClientConnections;
        this.clientAssertionSigningAlgorithm = builder.clientAssertionSigningAlgorithm;
        this.clientAssertionSigningKey = builder.clientAssertionSigningKey;
        List<NameValuePair> params = this.getBasicParams();
        this.mergeCustomParams(params, this.customParams);
        this.params = params;
    }

    @Sensitive
    private List<NameValuePair> getBasicParams() throws TokenRequestException {
        ArrayList<NameValuePair> params = new ArrayList<NameValuePair>();
        params.add((NameValuePair)new BasicNameValuePair("grant_type", this.grantType));
        if (this.resources != null) {
            params.add((NameValuePair)new BasicNameValuePair("resource", this.resources));
        }
        params.add((NameValuePair)new BasicNameValuePair("redirect_uri", this.redirectUri));
        if (this.code != null) {
            params.add((NameValuePair)new BasicNameValuePair("code", this.code));
        }
        if (this.refreshToken != null) {
            params.add((NameValuePair)new BasicNameValuePair("refresh_token", this.refreshToken));
        }
        if (this.authMethod.equals("post") || this.authMethod.equals("client_secret_post")) {
            params.add((NameValuePair)new BasicNameValuePair("client_id", this.clientId));
            params.add((NameValuePair)new BasicNameValuePair("client_secret", this.clientSecret));
        } else if (this.authMethod.equals("private_key_jwt")) {
            this.addPrivateKeyJwtParameters(params);
        }
        return params;
    }

    void addPrivateKeyJwtParameters(List<NameValuePair> params) throws TokenRequestException {
        if (!this.isRunningBetaMode()) {
            return;
        }
        params.add((NameValuePair)new BasicNameValuePair("client_assertion_type", "urn:ietf:params:oauth:client-assertion-type:jwt-bearer"));
        String clientAssertionJwt = this.buildClientAssertionJwt();
        params.add((NameValuePair)new BasicNameValuePair("client_assertion", clientAssertionJwt));
    }

    boolean isRunningBetaMode() {
        if (!ProductInfo.getBetaEdition()) {
            return false;
        }
        if (!issuedBetaMessage) {
            Tr.info((TraceComponent)tc, (String)("BETA: A beta method has been invoked for the class " + this.getClass().getName() + " for the first time."), (Object[])new Object[0]);
            issuedBetaMessage = !issuedBetaMessage;
        }
        return true;
    }

    /*
     * WARNING - void declaration
     */
    private String buildClientAssertionJwt() throws TokenRequestException {
        PrivateKeyJwtAuthMethod pkjAuthMethod = new PrivateKeyJwtAuthMethod(this.clientId, this.tokenEndpoint, this.clientAssertionSigningAlgorithm, this.clientAssertionSigningKey);
        try {
            return pkjAuthMethod.createPrivateKeyJwt();
        }
        catch (PrivateKeyJwtAuthException privateKeyJwtAuthException) {
            void e;
            FFDCFilter.processException((Throwable)privateKeyJwtAuthException, (String)"io.openliberty.security.oidcclientcore.token.TokenRequestor", (String)"136", (Object)this, (Object[])new Object[0]);
            throw new TokenRequestException(this.clientId, e.getMessage(), (Throwable)e);
        }
    }

    private void mergeCustomParams(@Sensitive List<NameValuePair> params, HashMap<String, String> customParams) {
        if (customParams == null || customParams.isEmpty()) {
            return;
        }
        for (Map.Entry<String, String> param : customParams.entrySet()) {
            if (param.getKey() == null || param.getValue() == null) continue;
            params.add((NameValuePair)new BasicNameValuePair(param.getKey(), param.getValue()));
        }
    }

    public TokenResponse requestTokens() throws Exception {
        Map<String, Object> tokenEndpointResponse = this.postToTokenEndpoint();
        String tokenEndpointEntity = this.oidcClientHttpUtil.extractEntityFromTokenResponse(tokenEndpointResponse);
        JSONObject json = JSONObject.parse((String)tokenEndpointEntity);
        return new TokenResponse(json);
    }

    private Map<String, Object> postToTokenEndpoint() throws Exception {
        return this.oidcClientHttpUtil.postToEndpoint(this.tokenEndpoint, this.params, this.clientId, this.clientSecret, null, this.sslSocketFactory, this.isHostnameVerification, this.authMethod, this.useSystemPropertiesForHttpClientConnections);
    }

    @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
    @InjectedFFDC
    @TraceOptions
    public static class Builder {
        private String grantType = "authorization_code";
        private final String tokenEndpoint;
        private final String clientId;
        @Sensitive
        private final String clientSecret;
        private final String redirectUri;
        private final String code;
        private String refreshToken = null;
        private SSLSocketFactory sslSocketFactory = null;
        private boolean isHostnameVerification = false;
        private String authMethod = "post";
        private String resources = null;
        private HashMap<String, String> customParams = null;
        private boolean useSystemPropertiesForHttpClientConnections = false;
        private String clientAssertionSigningAlgorithm = "RS256";
        @Sensitive
        private Key clientAssertionSigningKey = null;
        static final long serialVersionUID = -895182449422819369L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        public Builder(String tokenEndpoint, String clientId, @Sensitive String clientSecret, String redirectUri, String code) {
            this.tokenEndpoint = tokenEndpoint;
            this.clientId = clientId;
            this.clientSecret = clientSecret;
            this.redirectUri = redirectUri;
            this.code = code;
        }

        public Builder sslSocketFactory(SSLSocketFactory sslSocketFactory) {
            this.sslSocketFactory = sslSocketFactory;
            return this;
        }

        public Builder isHostnameVerification(boolean isHostnameVerification) {
            this.isHostnameVerification = isHostnameVerification;
            return this;
        }

        public Builder authMethod(String authMethod) {
            this.authMethod = authMethod;
            return this;
        }

        public Builder grantType(String grantType) {
            this.grantType = grantType;
            return this;
        }

        public Builder refreshToken(String refreshToken) {
            this.refreshToken = refreshToken;
            return this;
        }

        public Builder resources(String resources) {
            this.resources = resources;
            return this;
        }

        public Builder customParams(HashMap<String, String> customParams) {
            this.customParams = customParams;
            return this;
        }

        public Builder useSystemPropertiesForHttpClientConnections(boolean useSystemPropertiesForHttpClientConnections) {
            this.useSystemPropertiesForHttpClientConnections = useSystemPropertiesForHttpClientConnections;
            return this;
        }

        public Builder clientAssertionSigningAlgorithm(String clientAssertionSigningAlgorithm) {
            this.clientAssertionSigningAlgorithm = clientAssertionSigningAlgorithm;
            return this;
        }

        public Builder clientAssertionSigningKey(@Sensitive Key clientAssertionSigningKey) {
            this.clientAssertionSigningKey = clientAssertionSigningKey;
            return this;
        }

        public TokenRequestor build() throws TokenRequestException {
            return new TokenRequestor(this);
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register((String)"io.openliberty.security.oidcclientcore.token.TokenRequestor$Builder", Builder.class, (String)"OpenIdConnect", (String)"io.openliberty.security.oidcclientcore.internal.resources.OidcClientCoreMessages");
        }
    }
}

