/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.plugins.validation;

import com.fasterxml.classmate.Filter;
import com.fasterxml.classmate.MemberResolver;
import com.fasterxml.classmate.ResolvedType;
import com.fasterxml.classmate.ResolvedTypeWithMembers;
import com.fasterxml.classmate.TypeResolver;
import com.fasterxml.classmate.members.RawMethod;
import com.fasterxml.classmate.members.ResolvedMethod;
import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import jakarta.enterprise.context.ApplicationScoped;
import jakarta.validation.Constraint;
import jakarta.validation.ConstraintDeclarationException;
import jakarta.validation.ConstraintDefinitionException;
import jakarta.validation.ConstraintViolation;
import jakarta.validation.ConstraintViolationException;
import jakarta.validation.GroupDefinitionException;
import jakarta.validation.MessageInterpolator;
import jakarta.validation.ValidationException;
import jakarta.validation.Validator;
import jakarta.validation.ValidatorFactory;
import jakarta.validation.executable.ExecutableType;
import jakarta.validation.executable.ValidateOnExecution;
import jakarta.ws.rs.core.MediaType;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.GenericDeclaration;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import org.jboss.logging.Logger;
import org.jboss.resteasy.api.validation.ConstraintType;
import org.jboss.resteasy.api.validation.ResteasyConstraintViolation;
import org.jboss.resteasy.api.validation.ResteasyViolationException;
import org.jboss.resteasy.cdi.CdiInjectorFactory;
import org.jboss.resteasy.cdi.ResteasyCdiExtension;
import org.jboss.resteasy.core.ResteasyContext;
import org.jboss.resteasy.plugins.validation.ConstraintTypeUtilImpl;
import org.jboss.resteasy.plugins.validation.ResteasyViolationExceptionImpl;
import org.jboss.resteasy.plugins.validation.SimpleViolationsContainer;
import org.jboss.resteasy.plugins.validation.i18n.LogMessages;
import org.jboss.resteasy.plugins.validation.i18n.Messages;
import org.jboss.resteasy.specimpl.BuiltResponse;
import org.jboss.resteasy.spi.HttpRequest;
import org.jboss.resteasy.spi.InjectorFactory;
import org.jboss.resteasy.spi.ResteasyConfiguration;
import org.jboss.resteasy.spi.validation.GeneralValidatorCDI;
import org.jboss.resteasy.util.GetRestful;

@TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@TraceOptions
public class GeneralValidatorImpl
implements GeneralValidatorCDI {
    public static final String SUPPRESS_VIOLATION_PATH = "resteasy.validation.suppress.path";
    private static final Logger log;
    private TypeResolver typeResolver = new TypeResolver();
    private ValidatorFactory validatorFactory;
    private boolean isExecutableValidationEnabled;
    private ExecutableType[] defaultValidatedExecutableTypes;
    private boolean suppressPath;
    private boolean cdiActive;
    private static ConstraintTypeUtilImpl util;
    static final long serialVersionUID = -5049629556761332986L;
    private static final /* synthetic */ TraceComponent $$$tc$$$;

    public GeneralValidatorImpl(ValidatorFactory validatorFactory, boolean isExecutableValidationEnabled, Set<ExecutableType> defaultValidatedExecutableTypes) {
        String s;
        this.validatorFactory = validatorFactory;
        this.isExecutableValidationEnabled = isExecutableValidationEnabled;
        this.defaultValidatedExecutableTypes = defaultValidatedExecutableTypes.toArray(new ExecutableType[0]);
        try {
            this.cdiActive = ResteasyCdiExtension.isCDIActive();
            LogMessages.LOGGER.debug(Messages.MESSAGES.resteasyCdiExtensionOnClasspath());
        }
        catch (Throwable t) {
            LogMessages.LOGGER.debug(Messages.MESSAGES.resteasyCdiExtensionNotOnClasspath());
        }
        ResteasyConfiguration context = (ResteasyConfiguration)ResteasyContext.getContextData(ResteasyConfiguration.class);
        if (context != null && (s = context.getParameter(SUPPRESS_VIOLATION_PATH)) != null) {
            this.suppressPath = Boolean.parseBoolean(s);
        }
    }

    public void validate(HttpRequest request, Object object, Class<?> ... groups) {
        Validator validator = this.getValidator(request);
        Set cvs = null;
        SimpleViolationsContainer violationsContainer = this.getViolationsContainer(request, object);
        if (GeneralValidatorImpl.alreadyFoundClassOrPropertyConstraint(violationsContainer)) {
            return;
        }
        try {
            cvs = validator.validate(object, (Class[])groups);
        }
        catch (Exception e) {
            violationsContainer.setException(e);
            violationsContainer.setFieldsValidated(true);
            throw this.toValidationException(e, violationsContainer);
        }
        violationsContainer.addViolations(cvs);
        violationsContainer.setFieldsValidated(true);
    }

    private ValidationException toValidationException(Exception exception, SimpleViolationsContainer simpleViolationsContainer) {
        if (exception instanceof ConstraintDeclarationException || exception instanceof ConstraintDefinitionException || exception instanceof GroupDefinitionException) {
            return (ValidationException)exception;
        }
        return new ResteasyViolationExceptionImpl(simpleViolationsContainer);
    }

    public void checkViolations(HttpRequest request) {
        SimpleViolationsContainer violationsContainer = this.getViolationsContainer(request, null);
        Object target = violationsContainer.getTarget();
        if (target != null && violationsContainer.isFieldsValidated() && violationsContainer != null && violationsContainer.size() > 0) {
            ResteasyViolationExceptionImpl ViolationException = new ResteasyViolationExceptionImpl(violationsContainer, (List<MediaType>)request.getHttpHeaders().getAcceptableMediaTypes());
            log.warn((Object)ViolationException.getLocalizedMessage());
            throw ViolationException;
        }
    }

    public void checkViolationsfromCDI(HttpRequest request) {
        if (request == null) {
            return;
        }
        SimpleViolationsContainer violationsContainer = (SimpleViolationsContainer)SimpleViolationsContainer.class.cast(request.getAttribute(SimpleViolationsContainer.class.getName()));
        if (violationsContainer != null && violationsContainer.size() > 0) {
            ResteasyViolationExceptionImpl ViolationException = new ResteasyViolationExceptionImpl(violationsContainer, (List<MediaType>)request.getHttpHeaders().getAcceptableMediaTypes());
            log.warn((Object)ViolationException.getLocalizedMessage());
            throw ViolationException;
        }
    }

    public void validateAllParameters(HttpRequest request, Object object, Method method, Object[] parameterValues, Class<?> ... groups) {
        if (method.getParameterCount() == 0) {
            this.checkViolations(request);
            return;
        }
        Validator validator = this.getValidator(request);
        SimpleViolationsContainer violationsContainer = this.getViolationsContainer(request, object);
        Set cvs = null;
        try {
            cvs = validator.forExecutables().validateParameters(object, method, parameterValues, (Class[])groups);
        }
        catch (Exception e) {
            violationsContainer.setException(e);
            throw this.toValidationException(e, violationsContainer);
        }
        violationsContainer.addViolations(cvs);
        if ((violationsContainer.isFieldsValidated() || !GetRestful.isRootResource(object.getClass()) || GetRestful.isSubResourceClass(object.getClass()) || this.hasApplicationScope(object)) && violationsContainer.size() > 0) {
            ResteasyViolationExceptionImpl ViolationException = new ResteasyViolationExceptionImpl(violationsContainer, (List<MediaType>)request.getHttpHeaders().getAcceptableMediaTypes());
            log.warn((Object)ViolationException.getLocalizedMessage());
            throw ViolationException;
        }
    }

    public void validateReturnValue(HttpRequest request, Object object, Method method, Object returnValue, Class<?> ... groups) {
        Validator validator = this.getValidator(request);
        SimpleViolationsContainer violationsContainer = this.getViolationsContainer(request, object);
        Set cvs = null;
        Object myReturnValue = returnValue;
        if (returnValue instanceof BuiltResponse) {
            BuiltResponse builtResponse = (BuiltResponse)returnValue;
            myReturnValue = builtResponse.getEntity();
        }
        try {
            cvs = validator.forExecutables().validateReturnValue(object, method, myReturnValue, (Class[])groups);
        }
        catch (Exception e) {
            violationsContainer.setException(e);
            throw this.toValidationException(e, violationsContainer);
        }
        violationsContainer.addViolations(cvs);
        if (violationsContainer.size() > 0) {
            ResteasyViolationExceptionImpl ViolationException = new ResteasyViolationExceptionImpl(violationsContainer, (List<MediaType>)request.getHttpHeaders().getAcceptableMediaTypes());
            log.warn((Object)ViolationException.getLocalizedMessage());
            throw ViolationException;
        }
    }

    public boolean isValidatable(Class<?> clazz) {
        return !this.cdiActive || GeneralValidatorImpl.hasEJBScope(clazz) && GeneralValidatorImpl.hasNoClassOrFieldOrPropertyConstraints(clazz);
    }

    public boolean isValidatable(Class<?> clazz, InjectorFactory injectorFactory) {
        try {
            if (this.cdiActive && injectorFactory instanceof CdiInjectorFactory && (!GeneralValidatorImpl.hasEJBScope(clazz) || !GeneralValidatorImpl.hasNoClassOrFieldOrPropertyConstraints(clazz))) {
                return false;
            }
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
            // empty catch block
        }
        return true;
    }

    public boolean isValidatableFromCDI(Class<?> clazz) {
        return true;
    }

    public boolean isMethodValidatable(Method m) {
        ValidateOnExecution voe;
        if (!this.isExecutableValidationEnabled) {
            return false;
        }
        ExecutableType[] types = null;
        List<ExecutableType[]> typesList = this.getExecutableTypesOnMethodInHierarchy(m);
        if (typesList.size() > 1) {
            throw new ValidationException(Messages.MESSAGES.validateOnExceptionOnMultipleMethod());
        }
        types = typesList.size() == 1 ? typesList.get(0) : ((voe = m.getDeclaringClass().getAnnotation(ValidateOnExecution.class)) == null ? this.defaultValidatedExecutableTypes : (voe.type().length > 0 ? voe.type() : this.defaultValidatedExecutableTypes));
        boolean isGetterMethod = GeneralValidatorImpl.isGetter(m);
        block6: for (int i = 0; i < types.length; ++i) {
            switch (types[i]) {
                case IMPLICIT: 
                case ALL: {
                    return true;
                }
                case NONE: {
                    continue block6;
                }
                case NON_GETTER_METHODS: {
                    if (isGetterMethod) continue block6;
                    return true;
                }
                case GETTER_METHODS: {
                    if (!isGetterMethod) continue block6;
                    return true;
                }
            }
        }
        return false;
    }

    protected List<ExecutableType[]> getExecutableTypesOnMethodInHierarchy(Method method) {
        ArrayList<ExecutableType[]> typesList = new ArrayList<ExecutableType[]>();
        for (Class<?> clazz = method.getDeclaringClass(); clazz != null; clazz = clazz.getSuperclass()) {
            ExecutableType[] types;
            Method superMethod = this.getSuperMethod(method, clazz);
            if (superMethod != null && (types = GeneralValidatorImpl.getExecutableTypesOnMethod(superMethod)) != null) {
                typesList.add(types);
            }
            typesList.addAll(this.getExecutableTypesOnMethodInInterfaces(clazz, method));
        }
        return typesList;
    }

    protected List<ExecutableType[]> getExecutableTypesOnMethodInInterfaces(Class<?> clazz, Method method) {
        ArrayList<ExecutableType[]> typesList = new ArrayList<ExecutableType[]>();
        Class<?>[] interfaces = clazz.getInterfaces();
        for (int i = 0; i < interfaces.length; ++i) {
            List<ExecutableType[]> superList;
            ExecutableType[] types;
            Method interfaceMethod = this.getSuperMethod(method, interfaces[i]);
            if (interfaceMethod != null && (types = GeneralValidatorImpl.getExecutableTypesOnMethod(interfaceMethod)) != null) {
                typesList.add(types);
            }
            if ((superList = this.getExecutableTypesOnMethodInInterfaces(interfaces[i], method)).size() <= 0) continue;
            typesList.addAll(superList);
        }
        return typesList;
    }

    protected static ExecutableType[] getExecutableTypesOnMethod(Method method) {
        ValidateOnExecution voe = method.getAnnotation(ValidateOnExecution.class);
        if (voe == null || voe.type().length == 0) {
            return null;
        }
        ExecutableType[] types = voe.type();
        if (types == null || types.length == 0) {
            return null;
        }
        return types;
    }

    protected static boolean isGetter(Method m) {
        String name = m.getName();
        Class<?> returnType = m.getReturnType();
        if (returnType.equals(Void.class)) {
            return false;
        }
        if (m.getParameterCount() > 0) {
            return false;
        }
        if (name.startsWith("get")) {
            return true;
        }
        return name.startsWith("is") && returnType.equals(Boolean.TYPE);
    }

    protected static String convertArrayToString(Object o) {
        String result = null;
        if (o instanceof Object[]) {
            Object[] array = (Object[])Object[].class.cast(o);
            StringBuffer sb = new StringBuffer("[").append(GeneralValidatorImpl.convertArrayToString(array[0]));
            for (int i = 1; i < array.length; ++i) {
                sb.append(", ").append(GeneralValidatorImpl.convertArrayToString(array[i]));
            }
            sb.append("]");
            result = sb.toString();
        } else {
            result = o == null ? "" : o.toString();
        }
        return result;
    }

    protected Method getSuperMethod(Method method, final Class<?> clazz) {
        Method[] methods = new Method[]{};
        try {
            methods = System.getSecurityManager() == null ? clazz.getDeclaredMethods() : AccessController.doPrivileged(new PrivilegedExceptionAction<Method[]>(){
                static final long serialVersionUID = -5329819082711006465L;
                private static final /* synthetic */ TraceComponent $$$tc$$$;

                @Override
                public Method[] run() throws Exception {
                    return clazz.getDeclaredMethods();
                }

                @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
                static {
                    $$$tc$$$ = Tr.register((String)"org.jboss.resteasy.plugins.validation.GeneralValidatorImpl$1", 1.class, null, null);
                }
            });
        }
        catch (PrivilegedActionException privilegedActionException) {
            // empty catch block
        }
        for (int i = 0; i < methods.length; ++i) {
            if (!this.overrides(method, methods[i])) continue;
            return methods[i];
        }
        return null;
    }

    protected boolean overrides(Method subTypeMethod, Method superTypeMethod) {
        if (subTypeMethod == null || superTypeMethod == null) {
            throw new RuntimeException(Messages.MESSAGES.expectTwoNonNullMethods());
        }
        if (!subTypeMethod.getName().equals(superTypeMethod.getName())) {
            return false;
        }
        if (subTypeMethod.getParameterCount() != superTypeMethod.getParameterCount()) {
            return false;
        }
        if (!superTypeMethod.getDeclaringClass().isAssignableFrom(subTypeMethod.getDeclaringClass())) {
            return false;
        }
        return this.parametersResolveToSameTypes(subTypeMethod, superTypeMethod);
    }

    protected boolean parametersResolveToSameTypes(Method subTypeMethod, Method superTypeMethod) {
        if (subTypeMethod.getParameterCount() == 0) {
            return true;
        }
        ResolvedType resolvedSubType = this.typeResolver.resolve(subTypeMethod.getDeclaringClass(), new Type[0]);
        MemberResolver memberResolver = new MemberResolver(this.typeResolver);
        memberResolver.setMethodFilter((Filter)new SimpleMethodFilter(subTypeMethod, superTypeMethod));
        final ResolvedTypeWithMembers typeWithMembers = memberResolver.resolve(resolvedSubType, null, null);
        ResolvedMethod[] resolvedMethods = new ResolvedMethod[]{};
        try {
            resolvedMethods = System.getSecurityManager() == null ? typeWithMembers.getMemberMethods() : AccessController.doPrivileged(new PrivilegedExceptionAction<ResolvedMethod[]>(){
                static final long serialVersionUID = -7197525295365438028L;
                private static final /* synthetic */ TraceComponent $$$tc$$$;

                @Override
                public ResolvedMethod[] run() throws Exception {
                    return typeWithMembers.getMemberMethods();
                }

                @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
                static {
                    $$$tc$$$ = Tr.register((String)"org.jboss.resteasy.plugins.validation.GeneralValidatorImpl$2", 2.class, null, null);
                }
            });
        }
        catch (PrivilegedActionException privilegedActionException) {
            // empty catch block
        }
        if (resolvedMethods.length == 1) {
            return true;
        }
        for (int i = 0; i < resolvedMethods[0].getArgumentCount(); ++i) {
            if (resolvedMethods[0].getArgumentType(i).equals((Object)resolvedMethods[1].getArgumentType(i))) continue;
            return false;
        }
        return true;
    }

    public void checkForConstraintViolations(HttpRequest request, Exception e) {
        Throwable t;
        for (t = e; t != null && !(t instanceof ConstraintViolationException); t = t.getCause()) {
        }
        if (t instanceof ResteasyViolationException) {
            throw (ResteasyViolationException)ResteasyViolationException.class.cast(t);
        }
        if (t instanceof ConstraintViolationException) {
            SimpleViolationsContainer violationsContainer = this.getViolationsContainer(request, null);
            ConstraintViolationException cve = (ConstraintViolationException)ConstraintViolationException.class.cast(t);
            Set cvs = cve.getConstraintViolations();
            violationsContainer.addViolations(cvs);
            if (violationsContainer.size() > 0) {
                ResteasyViolationExceptionImpl ViolationException = new ResteasyViolationExceptionImpl(violationsContainer, (List<MediaType>)request.getHttpHeaders().getAcceptableMediaTypes());
                log.warn((Object)ViolationException.getLocalizedMessage());
                throw ViolationException;
            }
        }
    }

    protected Validator getValidator(HttpRequest request) {
        Validator v = (Validator)Validator.class.cast(request.getAttribute(Validator.class.getName()));
        if (v == null) {
            Locale locale = this.getLocale(request);
            if (locale == null) {
                v = this.validatorFactory.getValidator();
            } else {
                LocaleSpecificMessageInterpolator interpolator = new LocaleSpecificMessageInterpolator(this.validatorFactory.getMessageInterpolator(), locale);
                v = this.validatorFactory.usingContext().messageInterpolator((MessageInterpolator)interpolator).getValidator();
            }
            request.setAttribute(Validator.class.getName(), (Object)v);
        }
        return v;
    }

    protected SimpleViolationsContainer getViolationsContainer(HttpRequest request, Object target) {
        if (request == null) {
            return new SimpleViolationsContainer(target);
        }
        SimpleViolationsContainer violationsContainer = (SimpleViolationsContainer)SimpleViolationsContainer.class.cast(request.getAttribute(SimpleViolationsContainer.class.getName()));
        if (violationsContainer == null) {
            violationsContainer = new SimpleViolationsContainer(target);
            request.setAttribute(SimpleViolationsContainer.class.getName(), (Object)violationsContainer);
        }
        return violationsContainer;
    }

    private Locale getLocale(HttpRequest request) {
        if (request == null) {
            return null;
        }
        List locales = request.getHttpHeaders().getAcceptableLanguages();
        Locale locale = locales == null || locales.isEmpty() ? null : (Locale)locales.get(0);
        return locale;
    }

    ResteasyConstraintViolation createResteasyConstraintViolation(ConstraintViolation<?> cv, ConstraintType.Type ct) {
        String path = this.suppressPath ? "*" : cv.getPropertyPath().toString();
        ResteasyConstraintViolation rcv = new ResteasyConstraintViolation(ct, path, cv.getMessage(), cv.getInvalidValue() == null ? "null" : cv.getInvalidValue().toString());
        return rcv;
    }

    private boolean hasApplicationScope(Object o) {
        Class<?> clazz = o.getClass();
        return clazz.getAnnotation(ApplicationScoped.class) != null;
    }

    private static boolean hasNoClassOrFieldOrPropertyConstraints(Class<?> clazz) {
        return !GeneralValidatorImpl.hasClassConstraint(clazz) && !GeneralValidatorImpl.hasFieldConstraint(clazz) && !GeneralValidatorImpl.hasPropertyConstraint(clazz);
    }

    private static boolean hasPropertyConstraint(Class<?> clazz) {
        for (Method method : clazz.getDeclaredMethods()) {
            if (!GeneralValidatorImpl.isGetter(method)) continue;
            for (Annotation annotation : method.getAnnotations()) {
                if (!GeneralValidatorImpl.isConstraintAnnotation(annotation.annotationType())) continue;
                return true;
            }
        }
        for (GenericDeclaration genericDeclaration : clazz.getInterfaces()) {
            if (!GeneralValidatorImpl.hasPropertyConstraint(genericDeclaration)) continue;
            return true;
        }
        Class<?> superClass = clazz.getSuperclass();
        if (superClass != null && !superClass.equals(Object.class)) {
            return GeneralValidatorImpl.hasPropertyConstraint(superClass);
        }
        return false;
    }

    private static boolean hasFieldConstraint(Class<?> clazz) {
        for (Field field : clazz.getDeclaredFields()) {
            for (Annotation annotation : field.getAnnotations()) {
                if (!GeneralValidatorImpl.isConstraintAnnotation(annotation.annotationType())) continue;
                return true;
            }
        }
        Class<?> superClass = clazz.getSuperclass();
        if (superClass != null && !superClass.equals(Object.class)) {
            return GeneralValidatorImpl.hasFieldConstraint(superClass);
        }
        return false;
    }

    private static boolean hasClassConstraint(Class<?> clazz) {
        if (GeneralValidatorImpl.classHasConstraintAnnotation(clazz)) {
            return true;
        }
        for (Class<?> intf : clazz.getInterfaces()) {
            if (!GeneralValidatorImpl.classHasConstraintAnnotation(intf)) continue;
            return true;
        }
        Class<?> superClass = clazz.getSuperclass();
        if (superClass != Object.class && superClass != null) {
            return GeneralValidatorImpl.hasClassConstraint(superClass);
        }
        return false;
    }

    private static boolean classHasConstraintAnnotation(Class<?> clazz) {
        for (Annotation annotation : clazz.getAnnotations()) {
            if (!GeneralValidatorImpl.isConstraintAnnotation(annotation.annotationType())) continue;
            return true;
        }
        return false;
    }

    private static boolean isConstraintAnnotation(Class<?> clazz) {
        return clazz.isAnnotation() && clazz.getAnnotation(Constraint.class) != null;
    }

    private static boolean hasEJBScope(Class<?> clazz) {
        return GeneralValidatorImpl.classHasAnnotations(clazz, new String[]{"jakarta.ejb.Stateless", "jakarta.ejb.Stateful", "jakarta.ejb.Singleton"});
    }

    private static boolean classHasAnnotations(Class<?> clazz, String[] names) {
        for (String name : names) {
            if (GeneralValidatorImpl.isAnnotationPresent(clazz, name)) {
                return true;
            }
            for (Class<?> intf : clazz.getInterfaces()) {
                if (!GeneralValidatorImpl.isAnnotationPresent(intf, name)) continue;
                return true;
            }
        }
        Class<?> superClass = clazz.getSuperclass();
        if (superClass != Object.class && superClass != null) {
            return GeneralValidatorImpl.classHasAnnotations(superClass, names);
        }
        return false;
    }

    private static boolean isAnnotationPresent(Class<?> clazz, String name) {
        for (Annotation annotation : clazz.getAnnotations()) {
            if (!annotation.annotationType().getName().equals(name)) continue;
            return true;
        }
        return false;
    }

    private static boolean alreadyFoundClassOrPropertyConstraint(SimpleViolationsContainer container) {
        Set set = container.getViolations();
        if (set.isEmpty()) {
            return false;
        }
        Iterator it = set.iterator();
        ConstraintViolation cv = (ConstraintViolation)it.next();
        while (it.hasNext()) {
            ConstraintType.Type type = util.getConstraintType(cv);
            if (ConstraintType.Type.CLASS.equals((Object)type) || ConstraintType.Type.PROPERTY.equals((Object)type)) {
                return true;
            }
            cv = (ConstraintViolation)it.next();
        }
        return false;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
    static {
        $$$tc$$$ = Tr.register((String)"org.jboss.resteasy.plugins.validation.GeneralValidatorImpl", GeneralValidatorImpl.class, null, null);
        log = Logger.getLogger((String)GeneralValidatorImpl.class.getName());
        util = new ConstraintTypeUtilImpl();
    }

    @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
    @TraceOptions
    protected static class LocaleSpecificMessageInterpolator
    implements MessageInterpolator {
        private final MessageInterpolator interpolator;
        private final Locale locale;
        static final long serialVersionUID = -7348504953898664372L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        public LocaleSpecificMessageInterpolator(MessageInterpolator interpolator, Locale locale) {
            this.interpolator = interpolator;
            this.locale = locale;
        }

        public String interpolate(String messageTemplate, MessageInterpolator.Context context) {
            return this.interpolator.interpolate(messageTemplate, context, this.locale);
        }

        public String interpolate(String messageTemplate, MessageInterpolator.Context context, Locale locale) {
            return this.interpolator.interpolate(messageTemplate, context, locale);
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register((String)"org.jboss.resteasy.plugins.validation.GeneralValidatorImpl$LocaleSpecificMessageInterpolator", LocaleSpecificMessageInterpolator.class, null, null);
        }
    }

    @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
    @TraceOptions
    protected static class SimpleMethodFilter
    implements Filter<RawMethod> {
        private final Method method1;
        private final Method method2;
        static final long serialVersionUID = -8406849721268108554L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        private SimpleMethodFilter(Method method1, Method method2) {
            this.method1 = method1;
            this.method2 = method2;
        }

        public boolean include(RawMethod element) {
            return element.getRawMember().equals(this.method1) || element.getRawMember().equals(this.method2);
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register((String)"org.jboss.resteasy.plugins.validation.GeneralValidatorImpl$SimpleMethodFilter", SimpleMethodFilter.class, null, null);
        }
    }
}

