/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.annocache.targets.internal;

import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.Trivial;
import com.ibm.ws.annocache.jandex.internal.SparseClassInfo;
import com.ibm.ws.annocache.jandex.internal.SparseDotName;
import com.ibm.ws.annocache.service.internal.AnnotationCacheServiceImpl_Logging;
import com.ibm.ws.annocache.targets.internal.TargetsTableAnnotationsImpl;
import com.ibm.ws.annocache.targets.internal.TargetsTableClassesImpl;
import com.ibm.ws.annocache.targets.internal.TargetsTableImpl;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.wsspi.annocache.targets.AnnotationTargets_Targets;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

@TraceObjectField(fieldName="jandexLogger", fieldDesc="Ljava/util/logging/Logger;")
@InjectedFFDC
public class TargetsVisitorSparseJandexConverterImpl {
    protected static final Logger jandexLogger = AnnotationCacheServiceImpl_Logging.ANNO_JANDEX_LOGGER;
    public static final String CLASS_NAME = TargetsVisitorSparseJandexConverterImpl.class.getSimpleName();
    public static final String PACKAGE_INFO_CLASS_NAME = "package-info";
    protected final String hashText;
    protected final TargetsTableImpl targetsTable;
    protected final TargetsTableClassesImpl classesTable;
    protected final TargetsTableAnnotationsImpl annotationsTable;
    static final long serialVersionUID = 9152764441080799053L;

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public static boolean isPackageName(String name) {
        if (jandexLogger != null && jandexLogger.isLoggable(Level.FINER)) {
            jandexLogger.entering("com.ibm.ws.annocache.targets.internal.TargetsVisitorSparseJandexConverterImpl", "isPackageName", new Object[]{name});
        }
        boolean bl = name.endsWith(PACKAGE_INFO_CLASS_NAME);
        if (jandexLogger != null && jandexLogger.isLoggable(Level.FINER)) {
            bl = bl;
            jandexLogger.exiting("com.ibm.ws.annocache.targets.internal.TargetsVisitorSparseJandexConverterImpl", "isPackageName", bl);
        }
        return bl;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public static String stripPackageNameFromClassName(String className) {
        if (jandexLogger != null && jandexLogger.isLoggable(Level.FINER)) {
            jandexLogger.entering("com.ibm.ws.annocache.targets.internal.TargetsVisitorSparseJandexConverterImpl", "stripPackageNameFromClassName", new Object[]{className});
        }
        String string = className.substring(0, className.length() - (PACKAGE_INFO_CLASS_NAME.length() + 1));
        if (jandexLogger != null && jandexLogger.isLoggable(Level.FINER)) {
            string = string;
            jandexLogger.exiting("com.ibm.ws.annocache.targets.internal.TargetsVisitorSparseJandexConverterImpl", "stripPackageNameFromClassName", string);
        }
        return string;
    }

    @Trivial
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public String getHashText() {
        return this.hashText;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public TargetsVisitorSparseJandexConverterImpl(TargetsTableImpl targetsTable) {
        if (jandexLogger != null && jandexLogger.isLoggable(Level.FINER)) {
            jandexLogger.entering("com.ibm.ws.annocache.targets.internal.TargetsVisitorSparseJandexConverterImpl", "<init>", new Object[]{targetsTable});
        }
        this.targetsTable = targetsTable;
        this.classesTable = targetsTable.getClassTable();
        this.annotationsTable = targetsTable.getAnnotationTable();
        this.hashText = CLASS_NAME + "@" + Integer.toHexString(this.hashCode());
        if (jandexLogger != null && jandexLogger.isLoggable(Level.FINER)) {
            jandexLogger.exiting("com.ibm.ws.annocache.targets.internal.TargetsVisitorSparseJandexConverterImpl", "<init>", this);
        }
    }

    @Trivial
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public TargetsTableImpl getTargetsTable() {
        return this.targetsTable;
    }

    @Trivial
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public TargetsTableClassesImpl getClassesTable() {
        return this.classesTable;
    }

    @Trivial
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public TargetsTableAnnotationsImpl getAnnotationsTable() {
        return this.annotationsTable;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    protected String internClassName(String className) {
        if (jandexLogger != null && jandexLogger.isLoggable(Level.FINER)) {
            jandexLogger.entering("com.ibm.ws.annocache.targets.internal.TargetsVisitorSparseJandexConverterImpl", "internClassName", new Object[]{className});
        }
        String string = this.getTargetsTable().internClassName(className, true);
        if (jandexLogger != null && jandexLogger.isLoggable(Level.FINER)) {
            string = string;
            jandexLogger.exiting("com.ibm.ws.annocache.targets.internal.TargetsVisitorSparseJandexConverterImpl", "internClassName", string);
        }
        return string;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    protected String internClassName(SparseDotName name) {
        if (jandexLogger != null && jandexLogger.isLoggable(Level.FINER)) {
            jandexLogger.entering("com.ibm.ws.annocache.targets.internal.TargetsVisitorSparseJandexConverterImpl", "internClassName", new Object[]{name});
        }
        String string = this.internClassName(name.toString());
        if (jandexLogger != null && jandexLogger.isLoggable(Level.FINER)) {
            string = string;
            jandexLogger.exiting("com.ibm.ws.annocache.targets.internal.TargetsVisitorSparseJandexConverterImpl", "internClassName", string);
        }
        return string;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    protected String[] internClassNames(List<SparseDotName> dotNames) {
        if (jandexLogger != null && jandexLogger.isLoggable(Level.FINER)) {
            jandexLogger.entering("com.ibm.ws.annocache.targets.internal.TargetsVisitorSparseJandexConverterImpl", "internClassNames", new Object[]{dotNames});
        }
        int numNames = dotNames.size();
        String[] i_names = new String[numNames];
        for (int nameNo = 0; nameNo < numNames; ++nameNo) {
            i_names[nameNo] = this.internClassName(dotNames.get(nameNo));
        }
        String[] stringArray = i_names;
        if (jandexLogger != null && jandexLogger.isLoggable(Level.FINER)) {
            stringArray = stringArray;
            jandexLogger.exiting("com.ibm.ws.annocache.targets.internal.TargetsVisitorSparseJandexConverterImpl", "internClassNames", stringArray);
        }
        return stringArray;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    protected String[] internClassNames(SparseDotName[] dotNames) {
        if (jandexLogger != null && jandexLogger.isLoggable(Level.FINER)) {
            jandexLogger.entering("com.ibm.ws.annocache.targets.internal.TargetsVisitorSparseJandexConverterImpl", "internClassNames", new Object[]{dotNames});
        }
        int numNames = dotNames.length;
        String[] i_names = new String[numNames];
        for (int nameNo = 0; nameNo < numNames; ++nameNo) {
            i_names[nameNo] = this.internClassName(dotNames[nameNo]);
        }
        String[] stringArray = i_names;
        if (jandexLogger != null && jandexLogger.isLoggable(Level.FINER)) {
            stringArray = stringArray;
            jandexLogger.exiting("com.ibm.ws.annocache.targets.internal.TargetsVisitorSparseJandexConverterImpl", "internClassNames", stringArray);
        }
        return stringArray;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public boolean convertClassInfo(String classSourceName, Object classInfoObj) {
        String i_annotationClassName;
        String i_className;
        Object[] objectArray;
        if (jandexLogger != null && jandexLogger.isLoggable(Level.FINER)) {
            jandexLogger.entering("com.ibm.ws.annocache.targets.internal.TargetsVisitorSparseJandexConverterImpl", "convertClassInfo", new Object[]{classSourceName, classInfoObj});
        }
        String methodName = "convertClassInfo";
        SparseClassInfo classInfo = (SparseClassInfo)classInfoObj;
        SparseDotName classDotName = classInfo.name();
        String className = classDotName.toString();
        if (jandexLogger.isLoggable(Level.FINER)) {
            Object[] objectArray2 = new Object[4];
            objectArray2[0] = this.getHashText();
            objectArray2[1] = className;
            objectArray2[2] = null;
            objectArray = objectArray2;
            objectArray2[3] = null;
        } else {
            objectArray = null;
        }
        Object[] logParms = objectArray;
        short modifiers = classInfo.flags();
        if (TargetsVisitorSparseJandexConverterImpl.isPackageName(className)) {
            String i_packageName;
            String packageName = TargetsVisitorSparseJandexConverterImpl.stripPackageNameFromClassName(className);
            if (logParms != null) {
                logParms[1] = packageName;
                logParms[2] = (int)modifiers;
                jandexLogger.logp(Level.FINER, CLASS_NAME, methodName, "[ {0} ] Package [ {1} ] Modifiers [ {2} ]", logParms);
            }
            if (!this.classesTable.jandex_i_addPackage(i_packageName = this.internClassName(packageName))) {
                jandexLogger.logp(Level.WARNING, CLASS_NAME, methodName, "ANNO_TARGETS_DUPLICATE_PACKAGE", new Object[]{this.getHashText(), i_packageName});
                boolean bl = false;
                if (jandexLogger != null && jandexLogger.isLoggable(Level.FINER)) {
                    bl = bl;
                    jandexLogger.exiting("com.ibm.ws.annocache.targets.internal.TargetsVisitorSparseJandexConverterImpl", "convertClassInfo", bl);
                }
                return bl;
            }
            this.classesTable.jandex_i_setModifiers(i_packageName, modifiers);
            for (SparseDotName packageAnno : classInfo.classAnnotations()) {
                String i_annotationClassName2 = this.internClassName(packageAnno.toString());
                this.annotationsTable.jandex_i_recordAnnotation(i_packageName, AnnotationTargets_Targets.AnnotationCategory.PACKAGE, i_annotationClassName2);
                if (logParms == null) continue;
                logParms[2] = i_annotationClassName2;
                jandexLogger.logp(Level.FINER, CLASS_NAME, methodName, "[ {0} ] Package [ {1} ] Annotation [ {2} ]", logParms);
            }
            boolean bl = true;
            if (jandexLogger != null && jandexLogger.isLoggable(Level.FINER)) {
                bl = bl;
                jandexLogger.exiting("com.ibm.ws.annocache.targets.internal.TargetsVisitorSparseJandexConverterImpl", "convertClassInfo", bl);
            }
            return bl;
        }
        SparseDotName superClassDotName = classInfo.superName();
        SparseDotName[] interfaceDotNames = classInfo.interfaceNames();
        if (logParms != null) {
            logParms[2] = (int)modifiers;
            jandexLogger.logp(Level.FINER, CLASS_NAME, methodName, "[ {0} ] Class [ {1} ] Modifiers [ {2} ]", logParms);
            logParms[2] = superClassDotName;
            jandexLogger.logp(Level.FINER, CLASS_NAME, methodName, "[ {0} ] Class [ {1} ] Superclass [ {1} ]", logParms);
            logParms[2] = interfaceDotNames;
            jandexLogger.logp(Level.FINER, CLASS_NAME, methodName, "[ {0} ] Class [ {1} ] Interfaces [ {1} ]", logParms);
        }
        if (!this.classesTable.jandex_i_addClass(i_className = this.internClassName(className))) {
            jandexLogger.logp(Level.WARNING, CLASS_NAME, methodName, "ANNO_TARGETS_DUPLICATE_CLASS", new Object[]{this.getHashText(), i_className});
            boolean bl = false;
            if (jandexLogger != null && jandexLogger.isLoggable(Level.FINER)) {
                bl = bl;
                jandexLogger.exiting("com.ibm.ws.annocache.targets.internal.TargetsVisitorSparseJandexConverterImpl", "convertClassInfo", bl);
            }
            return bl;
        }
        this.classesTable.jandex_i_setModifiers(i_className, modifiers);
        if (superClassDotName != null) {
            String superClassName = superClassDotName.toString();
            String i_superclassName = this.internClassName(superClassName);
            this.classesTable.jandex_i_setSuperclassName(i_className, i_superclassName);
        }
        if (interfaceDotNames != null && interfaceDotNames.length > 0) {
            String[] i_interfaceNames = this.internClassNames(interfaceDotNames);
            this.classesTable.jandex_i_setInterfaceNames(i_className, i_interfaceNames);
        }
        for (SparseDotName classAnno : classInfo.classAnnotations()) {
            i_annotationClassName = this.internClassName(classAnno.toString());
            this.annotationsTable.jandex_i_recordAnnotation(i_className, AnnotationTargets_Targets.AnnotationCategory.CLASS, i_annotationClassName);
            if (logParms == null) continue;
            logParms[2] = i_annotationClassName;
            jandexLogger.logp(Level.FINER, CLASS_NAME, methodName, "[ {0} ] Class annotation [ {1} ]", logParms);
        }
        for (SparseDotName fieldAnno : classInfo.fieldAnnotations()) {
            i_annotationClassName = this.internClassName(fieldAnno.toString());
            this.annotationsTable.jandex_i_recordAnnotation(i_className, AnnotationTargets_Targets.AnnotationCategory.FIELD, i_annotationClassName);
            if (logParms == null) continue;
            logParms[2] = i_annotationClassName;
            jandexLogger.logp(Level.FINER, CLASS_NAME, methodName, "[ {0} ] Field annotation [ {1} ] [ {2} ]", logParms);
        }
        for (SparseDotName methodAnno : classInfo.methodAnnotations()) {
            i_annotationClassName = this.internClassName(methodAnno.toString());
            this.annotationsTable.jandex_i_recordAnnotation(i_className, AnnotationTargets_Targets.AnnotationCategory.METHOD, i_annotationClassName);
            if (logParms == null) continue;
            logParms[2] = i_annotationClassName;
            jandexLogger.logp(Level.FINER, CLASS_NAME, methodName, "[ {0} ] Method annotation [ {1} ] [ {2}", logParms);
        }
        boolean bl = true;
        if (jandexLogger != null && jandexLogger.isLoggable(Level.FINER)) {
            bl = bl;
            jandexLogger.exiting("com.ibm.ws.annocache.targets.internal.TargetsVisitorSparseJandexConverterImpl", "convertClassInfo", bl);
        }
        return bl;
    }
}

