/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wsoc.util;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.Sensitive;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.common.encoder.Base64Coder;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.wsoc.WsocBufferException;
import com.ibm.wsspi.bytebuffer.WsByteBuffer;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CodingErrorAction;
import java.nio.charset.StandardCharsets;
import java.security.AccessController;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Arrays;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class Utils {
    public static final Charset UTF8_CHARSET = StandardCharsets.UTF_8;
    private static final TraceComponent tc = Tr.register(Utils.class, (String)"websockets", (String)"com.ibm.ws.wsoc.internal.resources.WebSockets");
    static final long serialVersionUID = -3190721889906032901L;

    public static int longToInt(long inLong) {
        if (inLong < Integer.MIN_VALUE) {
            return Integer.MIN_VALUE;
        }
        if (inLong > Integer.MAX_VALUE) {
            return Integer.MAX_VALUE;
        }
        return (int)inLong;
    }

    public static short byteArrayToShort(byte[] ba) throws WsocBufferException {
        short num = 0;
        if (ba == null || ba.length == 0) {
            IllegalArgumentException x = new IllegalArgumentException("Array of no size passed in");
            throw new WsocBufferException(x);
        }
        num = ba.length >= 2 ? (short)(ba[0] << 8 + ba[1]) : (short)ba[0];
        return num;
    }

    public static char byteArrayToChar(byte[] ba) throws WsocBufferException {
        short num = 0;
        num = Utils.byteArrayToShort(ba);
        char c = (char)num;
        return c;
    }

    public static void printOutBuffers(WsByteBuffer[] bufs) {
        int j = 0;
        int maxToPrint = 20;
        for (int i = 0; i < bufs.length && j < maxToPrint; ++i) {
            WsByteBuffer buf = bufs[i];
            if (buf == null) continue;
            int oldPos = buf.position();
            while (buf.position() < buf.limit() && j < maxToPrint) {
                byte b = buf.get();
                ++j;
            }
            buf.position(oldPos);
        }
    }

    public static void printOutBuffer(WsByteBuffer buf) {
        int maxToPrint = 20;
        if (buf != null) {
            int oldPos = buf.position();
            for (int j = 0; buf.position() < buf.limit() && j < maxToPrint; ++j) {
                byte b = buf.get();
            }
            buf.position(oldPos);
        }
    }

    public static void getAllInterfaces(Class<?> classObject, ArrayList<Type> interfaces) {
        Class<?> superClass;
        Type[] superInterfaces = classObject.getGenericInterfaces();
        interfaces.addAll(Arrays.asList(superInterfaces));
        Type tgs = classObject.getGenericSuperclass();
        if (tgs != null && tgs instanceof ParameterizedType) {
            interfaces.add(tgs);
        }
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("updated interfaces to: " + interfaces), (Object[])new Object[0]);
        }
        if ((superClass = classObject.getSuperclass()) != null) {
            Utils.getAllInterfaces(superClass, interfaces);
        }
    }

    public static Class<?> getCodingClass(Type t) {
        ParameterizedType pt;
        Type[] types;
        Class<?> clazz = null;
        if (t instanceof ParameterizedType && (types = (pt = (ParameterizedType)t).getActualTypeArguments()).length > 0) {
            Type t2 = pt.getActualTypeArguments()[0];
            clazz = Utils.getClassByType(t2);
        }
        return clazz;
    }

    public static Class<?> getClassByType(Type t) {
        ParameterizedType pp;
        Type tp;
        Class clazz = null;
        if (t instanceof Class) {
            clazz = (Class)t;
        } else if (t instanceof ParameterizedType && (tp = (pp = (ParameterizedType)t).getRawType()) instanceof Class) {
            clazz = (Class)tp;
        }
        return clazz;
    }

    public static void maskPayload(@Sensitive int maskNumber, WsByteBuffer[] frameBuffers, int count) {
        byte[] maskArray = new byte[]{(byte)(maskNumber >> 24 & 0xFF), (byte)(maskNumber >> 16 & 0xFF), (byte)(maskNumber >> 8 & 0xFF), (byte)(maskNumber & 0xFF)};
        Utils.maskPayload(maskArray, frameBuffers, count);
    }

    public static void maskPayload(@Sensitive byte[] maskArray, WsByteBuffer[] frameBuffers, int count) {
        int resume = 0;
        for (int i = 0; i < count; ++i) {
            WsByteBuffer buf = frameBuffers[i];
            int position = buf.position();
            int limit = buf.limit();
            if (limit - position <= 0) continue;
            if (buf.hasArray()) {
                byte[] ba = buf.array();
                int arrayPosition = position + buf.arrayOffset();
                int arrayLimit = limit + buf.arrayOffset();
                resume = Utils.maskArray(ba, arrayPosition, arrayLimit - 1, resume, maskArray);
                continue;
            }
            int size = buf.remaining();
            byte[] ba = new byte[size];
            int oldPosition = buf.position();
            buf.get(ba, 0, size);
            buf.position(oldPosition);
            resume = Utils.maskArray(ba, 0, size - 1, resume, maskArray);
            buf.put(ba, 0, size);
            buf.position(oldPosition);
        }
    }

    @Sensitive
    public static int maskArray(@Sensitive byte[] ba, int start, int end, int resume, @Sensitive byte[] masks) {
        int i = start;
        int index0 = (0 + resume) % 4;
        int index1 = (1 + resume) % 4;
        int index2 = (2 + resume) % 4;
        int index3 = (3 + resume) % 4;
        while (end - i >= 3) {
            ba[i] = (byte)(ba[i] ^ masks[index0]);
            ba[++i] = (byte)(ba[i] ^ masks[index1]);
            ba[++i] = (byte)(ba[i] ^ masks[index2]);
            ba[++i] = (byte)(ba[i] ^ masks[index3]);
            ++i;
        }
        if (i <= end) {
            ba[i] = (byte)(ba[i] ^ masks[index0]);
            ++resume;
            if (++i <= end) {
                ba[i] = (byte)(ba[i] ^ masks[index1]);
                ++resume;
                if (++i <= end) {
                    ba[i] = (byte)(ba[i] ^ masks[index2]);
                    ++resume;
                }
            }
        }
        return resume % 4;
    }

    @Sensitive
    public static String makeAcceptResponseHeaderValue(String key) throws NoSuchAlgorithmException, UnsupportedEncodingException {
        String inputKey = key + "258EAFA5-E914-47DA-95CA-C5AB0DC85B11";
        MessageDigest md = MessageDigest.getInstance("SHA-1");
        byte[] arrayKey = inputKey.getBytes(StandardCharsets.ISO_8859_1);
        md.update(arrayKey, 0, arrayKey.length);
        byte[] sha1hash = md.digest();
        return Base64Coder.encode((byte[])sha1hash);
    }

    @Sensitive
    public static String uTF8byteArrayToString(byte[] data) throws CharacterCodingException {
        CharsetDecoder d = UTF8_CHARSET.newDecoder();
        d.onMalformedInput(CodingErrorAction.REPORT);
        d.onUnmappableCharacter(CodingErrorAction.REPORT);
        return d.decode(ByteBuffer.wrap(data)).toString();
    }

    public static String truncateCloseReason(String reasonPhrase) {
        byte[] reasonBytes;
        int len;
        if (reasonPhrase != null && (len = (reasonBytes = reasonPhrase.getBytes(UTF8_CHARSET)).length) > 120) {
            String updatedPhrase;
            reasonPhrase = updatedPhrase = Utils.cutStringByByteSize(reasonPhrase, 120);
        }
        return reasonPhrase;
    }

    public static String cutStringByByteSize(String s, int len) {
        CharsetDecoder cd = UTF8_CHARSET.newDecoder();
        cd.onMalformedInput(CodingErrorAction.IGNORE);
        byte[] bytez = s.getBytes(UTF8_CHARSET);
        if (len > bytez.length) {
            len = bytez.length;
        }
        ByteBuffer bb = ByteBuffer.wrap(bytez, 0, len);
        CharBuffer cb = CharBuffer.allocate(len);
        cd.decode(bb, cb, true);
        cd.flush(cb);
        return new String(cb.array(), 0, cb.position());
    }

    public static ClassLoader getContextClassloaderPrivileged() {
        final Thread tr = Thread.currentThread();
        return AccessController.doPrivileged(new PrivilegedAction<ClassLoader>(){
            static final long serialVersionUID = 8074124170905371314L;
            private static final /* synthetic */ TraceComponent $$$tc$$$;

            @Override
            public ClassLoader run() {
                return tr.getContextClassLoader();
            }

            @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
            static {
                $$$tc$$$ = Tr.register((String)"com.ibm.ws.wsoc.util.Utils$1", 1.class, (String)"websockets", (String)"com.ibm.ws.wsoc.internal.resources.WebSockets");
            }
        });
    }
}

