/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.crypto.ltpakeyutil;

import com.ibm.ws.crypto.ltpakeyutil.LTPAKeyUtil;
import java.math.BigInteger;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.Signature;
import java.security.interfaces.RSAPrivateCrtKey;
import java.security.interfaces.RSAPublicKey;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.RSAPrivateCrtKeySpec;
import java.security.spec.RSAPublicKeySpec;
import java.util.Arrays;
import java.util.Comparator;
import java.util.concurrent.ConcurrentHashMap;
import javax.crypto.Cipher;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.DESedeKeySpec;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;

final class LTPACrypto {
    private static final String SIGNATURE_ALGORITHM = "SHA1withRSA";
    private static final String CRYPTO_ALGORITHM = "RSA";
    private static final String ENCRYPT_ALGORITHM = "DESede";
    private static final String IBMJCE_NAME = "IBMJCE";
    private static int MAX_CACHE = 500;
    private static IvParameterSpec ivs8 = null;
    private static IvParameterSpec ivs16 = null;
    private static final ConcurrentHashMap<CachingKey, CachingKey> cryptoKeysMap = new ConcurrentHashMap();
    private static final ConcurrentHashMap<CachingVerifyKey, CachingVerifyKey> verifyKeysMap = new ConcurrentHashMap();
    private static final Comparator<CachingVerifyKey> cachingVerifyKeyComparator = new Comparator<CachingVerifyKey>(){

        @Override
        public int compare(CachingVerifyKey o1, CachingVerifyKey o2) {
            if (o1.successfulUses < o2.successfulUses) {
                return -1;
            }
            if (o1.successfulUses == o2.successfulUses) {
                return 0;
            }
            return 1;
        }
    };
    private static final Comparator<CachingKey> cachingKeyComparator = new Comparator<CachingKey>(){

        @Override
        public int compare(CachingKey o1, CachingKey o2) {
            if (!o1.reused) {
                if (o2.reused) {
                    return -1;
                }
            } else if (!o2.reused) {
                return 1;
            }
            if (o1.successfulUses < o2.successfulUses) {
                return -1;
            }
            if (o1.successfulUses == o2.successfulUses) {
                return 0;
            }
            return 1;
        }
    };
    private static double[] ETB = new double[16];
    private static int slot;
    private static int channels;
    private static int[] samples;
    private static int[] ones;
    private static int[] block;
    private static byte[] seed;
    private static int ri;
    private static boolean seedInitialized;
    static int trMix;
    static String[][] rsaKeyMaterial;
    static String[][] dsaKeyMaterial;
    static byte[][][] rsaKeys;
    static byte[][][] dsaKeys;

    LTPACrypto() {
    }

    protected static final byte[] signISO9796(byte[][] key, byte[] data, int off, int len) throws Exception {
        CachingKey ck = new CachingKey(key, data, off, len);
        CachingKey result = cryptoKeysMap.get(ck);
        if (result != null) {
            result.successfulUses += 1L;
            result.reused = true;
            return result.result;
        }
        if (cryptoKeysMap.size() > MAX_CACHE) {
            try {
                int i;
                CachingKey[] keys = ((ConcurrentHashMap.CollectionView)((Object)cryptoKeysMap.keySet())).toArray(new CachingKey[cryptoKeysMap.size()]);
                Arrays.sort(keys, cachingKeyComparator);
                if (cachingKeyComparator.compare(keys[0], keys[keys.length - 1]) < 0) {
                    for (i = 0; i < cryptoKeysMap.size() / 5; ++i) {
                        cryptoKeysMap.remove(keys[i]);
                        keys[i + 1 * cryptoKeysMap.size() / 5].successfulUses--;
                        keys[i + 2 * cryptoKeysMap.size() / 5].successfulUses--;
                        keys[i + 3 * cryptoKeysMap.size() / 5].successfulUses--;
                        keys[i + 4 * cryptoKeysMap.size() / 5].successfulUses--;
                    }
                } else {
                    for (i = 0; i < cryptoKeysMap.size() / 5; ++i) {
                        cryptoKeysMap.remove(keys[keys.length - 1 - i]);
                        keys[keys.length - 1 - i - 1 * cryptoKeysMap.size() / 5].successfulUses--;
                        keys[keys.length - 1 - i - 2 * cryptoKeysMap.size() / 5].successfulUses--;
                        keys[keys.length - 1 - i - 3 * cryptoKeysMap.size() / 5].successfulUses--;
                        keys[keys.length - 1 - i - 4 * cryptoKeysMap.size() / 5].successfulUses--;
                    }
                }
            }
            catch (Exception keys) {
                // empty catch block
            }
        }
        BigInteger n = new BigInteger(key[0]);
        BigInteger e = new BigInteger(key[2]);
        BigInteger p = new BigInteger(key[3]);
        BigInteger q = new BigInteger(key[4]);
        BigInteger d = e.modInverse(p.subtract(BigInteger.ONE).multiply(q.subtract(BigInteger.ONE)));
        KeyFactory kFact = null;
        kFact = LTPAKeyUtil.isIBMJCEAvailable() ? KeyFactory.getInstance(CRYPTO_ALGORITHM, IBMJCE_NAME) : KeyFactory.getInstance(CRYPTO_ALGORITHM);
        BigInteger pep = new BigInteger(key[5]);
        BigInteger peq = new BigInteger(key[6]);
        BigInteger crtC = new BigInteger(key[7]);
        RSAPrivateCrtKeySpec privCrtKeySpec = new RSAPrivateCrtKeySpec(n, e, d, p, q, pep, peq, crtC);
        PrivateKey privKey = kFact.generatePrivate(privCrtKeySpec);
        Signature rsaSig = null;
        rsaSig = LTPAKeyUtil.isIBMJCEAvailable() ? Signature.getInstance(SIGNATURE_ALGORITHM, IBMJCE_NAME) : Signature.getInstance(SIGNATURE_ALGORITHM);
        rsaSig.initSign(privKey);
        rsaSig.update(data, off, len);
        byte[] sig = rsaSig.sign();
        cryptoKeysMap.put(ck, ck);
        CachingKey.access$302(ck, sig);
        ck.successfulUses = 0L;
        return sig;
    }

    protected static final boolean verifyISO9796(byte[][] key, byte[] data, int off, int len, byte[] sig, int sigOff, int sigLen) throws Exception {
        CachingVerifyKey ck = new CachingVerifyKey(key, data, off, len, sig, sigOff, sigLen);
        CachingVerifyKey result = verifyKeysMap.get(ck);
        if (result != null) {
            result.successfulUses += 1L;
            return result.result;
        }
        if (verifyKeysMap.size() > MAX_CACHE) {
            int i;
            CachingVerifyKey[] keys = ((ConcurrentHashMap.CollectionView)((Object)verifyKeysMap.keySet())).toArray(new CachingVerifyKey[verifyKeysMap.size()]);
            Arrays.sort(keys, cachingVerifyKeyComparator);
            if (cachingVerifyKeyComparator.compare(keys[0], keys[keys.length - 1]) < 0) {
                for (i = 0; i < verifyKeysMap.size() / 5; ++i) {
                    verifyKeysMap.remove(keys[i]);
                    keys[i + 1 * verifyKeysMap.size() / 5].successfulUses--;
                    keys[i + 2 * verifyKeysMap.size() / 5].successfulUses--;
                    keys[i + 3 * verifyKeysMap.size() / 5].successfulUses--;
                    keys[i + 4 * verifyKeysMap.size() / 5].successfulUses--;
                }
            } else {
                for (i = 0; i < verifyKeysMap.size() / 5; ++i) {
                    verifyKeysMap.remove(keys[keys.length - 1 - i]);
                    keys[keys.length - 1 - i - 1 * verifyKeysMap.size() / 5].successfulUses--;
                    keys[keys.length - 1 - i - 2 * verifyKeysMap.size() / 5].successfulUses--;
                    keys[keys.length - 1 - i - 3 * verifyKeysMap.size() / 5].successfulUses--;
                    keys[keys.length - 1 - i - 4 * verifyKeysMap.size() / 5].successfulUses--;
                }
            }
        }
        boolean verified = false;
        BigInteger n = new BigInteger(key[0]);
        BigInteger e = new BigInteger(key[1]);
        KeyFactory kFact = null;
        Signature rsaSig = null;
        kFact = LTPAKeyUtil.isIBMJCEAvailable() ? KeyFactory.getInstance(CRYPTO_ALGORITHM, IBMJCE_NAME) : KeyFactory.getInstance(CRYPTO_ALGORITHM);
        RSAPublicKeySpec pubKeySpec = new RSAPublicKeySpec(n, e);
        PublicKey pubKey = kFact.generatePublic(pubKeySpec);
        rsaSig = LTPAKeyUtil.isIBMJCEAvailable() ? Signature.getInstance(SIGNATURE_ALGORITHM, IBMJCE_NAME) : Signature.getInstance(SIGNATURE_ALGORITHM);
        rsaSig.initVerify(pubKey);
        rsaSig.update(data, off, len);
        verified = rsaSig.verify(sig);
        verifyKeysMap.put(ck, ck);
        ck.result = verified;
        ck.successfulUses = 0L;
        return verified;
    }

    protected static final void setRSAKey(byte[][] key) {
        int i;
        BigInteger[] k = new BigInteger[8];
        for (i = 0; i < 8; ++i) {
            if (key[i] == null) continue;
            k[i] = new BigInteger(1, key[i]);
        }
        if (k[3].compareTo(k[4]) < 0) {
            BigInteger tmp = k[3];
            k[3] = k[4];
            k[4] = tmp;
            tmp = k[5];
            k[5] = k[6];
            k[6] = tmp;
            k[7] = null;
        }
        if (k[7] == null) {
            k[7] = k[4].modInverse(k[3]);
        }
        if (k[0] == null) {
            k[0] = k[3].multiply(k[4]);
        }
        if (k[1] == null) {
            k[1] = k[2].modInverse(k[3].subtract(BigInteger.valueOf(1L)).multiply(k[4].subtract(BigInteger.valueOf(1L))));
        }
        if (k[5] == null) {
            k[5] = k[1].remainder(k[3].subtract(BigInteger.valueOf(1L)));
        }
        if (k[6] == null) {
            k[6] = k[1].remainder(k[4].subtract(BigInteger.valueOf(1L)));
        }
        for (i = 0; i < 8; ++i) {
            key[i] = k[i].toByteArray();
        }
    }

    private static SecretKey constructSecretKey(byte[] key, String cipher) throws InvalidKeyException, NoSuchAlgorithmException, InvalidKeySpecException, NoSuchProviderException {
        SecretKey sKey = null;
        if (cipher.indexOf("AES") != -1) {
            sKey = new SecretKeySpec(key, 0, 16, "AES");
        } else {
            DESedeKeySpec kSpec = new DESedeKeySpec(key);
            SecretKeyFactory kFact = null;
            kFact = LTPAKeyUtil.isIBMJCEAvailable() ? SecretKeyFactory.getInstance(ENCRYPT_ALGORITHM, IBMJCE_NAME) : SecretKeyFactory.getInstance(ENCRYPT_ALGORITHM);
            sKey = kFact.generateSecret(kSpec);
        }
        return sKey;
    }

    private static Cipher createCipher(int cipherMode, byte[] key, String cipher, SecretKey sKey) throws NoSuchAlgorithmException, NoSuchPaddingException, InvalidKeyException, InvalidAlgorithmParameterException, NoSuchProviderException {
        Cipher ci = null;
        ci = LTPAKeyUtil.isIBMJCEAvailable() ? Cipher.getInstance(cipher, IBMJCE_NAME) : Cipher.getInstance(cipher);
        if (cipher.indexOf("ECB") == -1) {
            if (cipher.indexOf("AES") != -1) {
                if (ivs16 == null) {
                    LTPACrypto.setIVS16(key);
                }
                ci.init(cipherMode, (Key)sKey, ivs16);
            } else {
                if (ivs8 == null) {
                    LTPACrypto.setIVS8(key);
                }
                ci.init(cipherMode, (Key)sKey, ivs8);
            }
        } else {
            ci.init(cipherMode, sKey);
        }
        return ci;
    }

    protected static final byte[] encrypt(byte[] data, byte[] key, String cipher) throws Exception {
        SecretKey sKey = LTPACrypto.constructSecretKey(key, cipher);
        Cipher ci = LTPACrypto.createCipher(1, key, cipher, sKey);
        return ci.doFinal(data);
    }

    protected static final byte[] decrypt(byte[] msg, byte[] key, String cipher) throws Exception {
        SecretKey sKey = LTPACrypto.constructSecretKey(key, cipher);
        Cipher ci = LTPACrypto.createCipher(2, key, cipher, sKey);
        return ci.doFinal(msg);
    }

    protected static void setMaxCache(int maxCache) {
        MAX_CACHE = maxCache;
    }

    private static final synchronized void setIVS8(byte[] key) {
        if (ivs8 == null) {
            byte[] iv8 = new byte[8];
            for (int i = 0; i < 8; ++i) {
                iv8[i] = key[i];
            }
            ivs8 = new IvParameterSpec(iv8);
        }
    }

    private static final synchronized void setIVS16(byte[] key) {
        if (ivs16 == null) {
            byte[] iv16 = new byte[16];
            for (int i = 0; i < 16; ++i) {
                iv16[i] = key[i];
            }
            ivs16 = new IvParameterSpec(iv16);
        }
    }

    static final int lsbf(byte[] data, int i, int n) {
        int v = 0;
        do {
            v |= (data[i + --n] & 0xFF) << n * 8;
        } while (n > 0);
        return v;
    }

    static final int lsbf4(byte[] data, int i) {
        return data[i] & 0xFF | (data[i + 1] & 0xFF) << 8 | (data[i + 2] & 0xFF) << 16 | data[i + 3] << 24;
    }

    static final void lsbf4(int v, byte[] data, int i) {
        data[i] = (byte)v;
        data[i + 1] = (byte)(v >>> 8);
        data[i + 2] = (byte)(v >>> 16);
        data[i + 3] = (byte)(v >>> 24);
    }

    static void lsbf2(int v, byte[] data, int i) {
        data[i] = (byte)v;
        data[i + 1] = (byte)(v >>> 8);
    }

    private static final int FF(int a, int b, int c, int d, int x, int l, int r, int ac) {
        return ((a += (b & c | ~b & d) + x + ac) << l | a >>> r) + b;
    }

    private static final int GG(int a, int b, int c, int d, int x, int l, int r, int ac) {
        return ((a += (b & d | c & ~d) + x + ac) << l | a >>> r) + b;
    }

    private static final int HH(int a, int b, int c, int d, int x, int l, int r, int ac) {
        return ((a += (b ^ c ^ d) + x + ac) << l | a >>> r) + b;
    }

    private static final int II(int a, int b, int c, int d, int x, int l, int r, int ac) {
        return ((a += (c ^ (b | ~d)) + x + ac) << l | a >>> r) + b;
    }

    static final void md5(int[] state, byte[] data, int off, int len, byte[] to, int pos) {
        int a = 1732584193;
        int b = -271733879;
        int c = -1732584194;
        int d = 271733878;
        int n = len / 4;
        int[] W = new int[16];
        boolean done = false;
        boolean padded = false;
        do {
            int a0;
            int i = 0;
            while (i < 16 && n > 0) {
                W[i++] = LTPACrypto.lsbf4(data, off);
                --n;
                off += 4;
            }
            if (i < 16) {
                if (!padded) {
                    a0 = len % 4;
                    int n2 = W[i++] = a0 != 0 ? LTPACrypto.lsbf(data, off, a0) | 128 << a0 * 8 : 128;
                    if (i == 15) {
                        W[15] = 0;
                    }
                    padded = true;
                }
                if (i <= 14) {
                    while (i < 14) {
                        W[i++] = 0;
                    }
                    if (state != null) {
                        len += state[5];
                    }
                    W[14] = len << 3;
                    W[15] = len >>> 29;
                    done = true;
                }
            }
            a0 = a;
            int W0 = W[0];
            a = LTPACrypto.FF(a0, b, c, d, W0, 7, 25, -680876936);
            int d0 = d;
            int W1 = W[1];
            d = LTPACrypto.FF(d0, a, b, c, W1, 12, 20, -389564586);
            int c0 = c;
            int W2 = W[2];
            c = LTPACrypto.FF(c0, d, a, b, W2, 17, 15, 606105819);
            int b0 = b;
            int W3 = W[3];
            b = LTPACrypto.FF(b0, c, d, a, W3, 22, 10, -1044525330);
            int W4 = W[4];
            a = LTPACrypto.FF(a, b, c, d, W4, 7, 25, -176418897);
            int W5 = W[5];
            d = LTPACrypto.FF(d, a, b, c, W5, 12, 20, 1200080426);
            int W6 = W[6];
            c = LTPACrypto.FF(c, d, a, b, W6, 17, 15, -1473231341);
            int W7 = W[7];
            b = LTPACrypto.FF(b, c, d, a, W7, 22, 10, -45705983);
            int W8 = W[8];
            a = LTPACrypto.FF(a, b, c, d, W8, 7, 25, 1770035416);
            int W9 = W[9];
            d = LTPACrypto.FF(d, a, b, c, W9, 12, 20, -1958414417);
            int W10 = W[10];
            c = LTPACrypto.FF(c, d, a, b, W10, 17, 15, -42063);
            int W11 = W[11];
            b = LTPACrypto.FF(b, c, d, a, W11, 22, 10, -1990404162);
            int W12 = W[12];
            a = LTPACrypto.FF(a, b, c, d, W12, 7, 25, 1804603682);
            int W13 = W[13];
            d = LTPACrypto.FF(d, a, b, c, W13, 12, 20, -40341101);
            int W14 = W[14];
            c = LTPACrypto.FF(c, d, a, b, W14, 17, 15, -1502002290);
            int W15 = W[15];
            b = LTPACrypto.FF(b, c, d, a, W15, 22, 10, 1236535329);
            a = LTPACrypto.GG(a, b, c, d, W1, 5, 27, -165796510);
            d = LTPACrypto.GG(d, a, b, c, W6, 9, 23, -1069501632);
            c = LTPACrypto.GG(c, d, a, b, W11, 14, 18, 643717713);
            b = LTPACrypto.GG(b, c, d, a, W0, 20, 12, -373897302);
            a = LTPACrypto.GG(a, b, c, d, W5, 5, 27, -701558691);
            d = LTPACrypto.GG(d, a, b, c, W10, 9, 23, 38016083);
            c = LTPACrypto.GG(c, d, a, b, W15, 14, 18, -660478335);
            b = LTPACrypto.GG(b, c, d, a, W4, 20, 12, -405537848);
            a = LTPACrypto.GG(a, b, c, d, W9, 5, 27, 568446438);
            d = LTPACrypto.GG(d, a, b, c, W14, 9, 23, -1019803690);
            c = LTPACrypto.GG(c, d, a, b, W3, 14, 18, -187363961);
            b = LTPACrypto.GG(b, c, d, a, W8, 20, 12, 1163531501);
            a = LTPACrypto.GG(a, b, c, d, W13, 5, 27, -1444681467);
            d = LTPACrypto.GG(d, a, b, c, W2, 9, 23, -51403784);
            c = LTPACrypto.GG(c, d, a, b, W7, 14, 18, 1735328473);
            b = LTPACrypto.GG(b, c, d, a, W12, 20, 12, -1926607734);
            a = LTPACrypto.HH(a, b, c, d, W5, 4, 28, -378558);
            d = LTPACrypto.HH(d, a, b, c, W8, 11, 21, -2022574463);
            c = LTPACrypto.HH(c, d, a, b, W11, 16, 16, 1839030562);
            b = LTPACrypto.HH(b, c, d, a, W14, 23, 9, -35309556);
            a = LTPACrypto.HH(a, b, c, d, W1, 4, 28, -1530992060);
            d = LTPACrypto.HH(d, a, b, c, W4, 11, 21, 1272893353);
            c = LTPACrypto.HH(c, d, a, b, W7, 16, 16, -155497632);
            b = LTPACrypto.HH(b, c, d, a, W10, 23, 9, -1094730640);
            a = LTPACrypto.HH(a, b, c, d, W13, 4, 28, 681279174);
            d = LTPACrypto.HH(d, a, b, c, W0, 11, 21, -358537222);
            c = LTPACrypto.HH(c, d, a, b, W3, 16, 16, -722521979);
            b = LTPACrypto.HH(b, c, d, a, W6, 23, 9, 76029189);
            a = LTPACrypto.HH(a, b, c, d, W9, 4, 28, -640364487);
            d = LTPACrypto.HH(d, a, b, c, W12, 11, 21, -421815835);
            c = LTPACrypto.HH(c, d, a, b, W15, 16, 16, 530742520);
            b = LTPACrypto.HH(b, c, d, a, W2, 23, 9, -995338651);
            a = LTPACrypto.II(a, b, c, d, W0, 6, 26, -198630844);
            d = LTPACrypto.II(d, a, b, c, W7, 10, 22, 1126891415);
            c = LTPACrypto.II(c, d, a, b, W14, 15, 17, -1416354905);
            b = LTPACrypto.II(b, c, d, a, W5, 21, 11, -57434055);
            a = LTPACrypto.II(a, b, c, d, W12, 6, 26, 1700485571);
            d = LTPACrypto.II(d, a, b, c, W3, 10, 22, -1894986606);
            c = LTPACrypto.II(c, d, a, b, W10, 15, 17, -1051523);
            b = LTPACrypto.II(b, c, d, a, W1, 21, 11, -2054922799);
            a = LTPACrypto.II(a, b, c, d, W8, 6, 26, 1873313359);
            d = LTPACrypto.II(d, a, b, c, W15, 10, 22, -30611744);
            c = LTPACrypto.II(c, d, a, b, W6, 15, 17, -1560198380);
            b = LTPACrypto.II(b, c, d, a, W13, 21, 11, 1309151649);
            a = LTPACrypto.II(a, b, c, d, W4, 6, 26, -145523070);
            d = LTPACrypto.II(d, a, b, c, W11, 10, 22, -1120210379);
            c = LTPACrypto.II(c, d, a, b, W2, 15, 17, 718787259);
            b = LTPACrypto.II(b, c, d, a, W9, 21, 11, -343485551) + b0;
            a += a0;
            c += c0;
            d += d0;
        } while (!done);
        LTPACrypto.lsbf4(a, to, pos);
        LTPACrypto.lsbf4(b, to, pos + 4);
        LTPACrypto.lsbf4(c, to, pos + 8);
        LTPACrypto.lsbf4(d, to, pos + 12);
    }

    static final void trng(byte[] to, int off, int len) {
        long accu = 0L;
        int bits = 0;
        while (len-- > 0) {
            while (bits < 8) {
                int s = 0;
                do {
                    long t = System.currentTimeMillis();
                    while (System.currentTimeMillis() == t) {
                        ++s;
                    }
                } while (s == 0);
                int xor = samples[slot] ^ s;
                LTPACrypto.samples[LTPACrypto.slot] = s;
                int i = 0;
                int m = 1;
                do {
                    if ((xor & m) != 0) {
                        int n = i;
                        ones[n] = ones[n] + ((s & m) != 0 ? 1 : -1);
                        channels ^= m;
                    }
                    int n = i;
                    block[n] = block[n] - 1;
                    if (block[n] == 0) {
                        accu = accu << 1 | (long)((channels & m) != 0 ? 1 : 0);
                        ++bits;
                    }
                    if (block[i] <= 0) {
                        int j;
                        for (j = 0; j < 16 && !(Math.abs(0.5 - (double)ones[i] / 56.0) <= ETB[j]); ++j) {
                        }
                        LTPACrypto.block[i] = j == 16 ? -1 : j + 1;
                    }
                    m <<= 1;
                } while (++i < 16);
                slot = (slot + 1) % 56;
            }
            to[off++] = (byte)(accu >>> (bits -= 8));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static final void random(byte[] to, int off, int n) {
        if (!seedInitialized) {
            LTPACrypto.trng(seed, 0, 32);
            LTPACrypto.md5(null, seed, 0, 32, seed, 0);
            rsaKeys = new byte[4][][];
            int i = 0;
            int j = 0;
            while (i < rsaKeyMaterial.length) {
                LTPACrypto.rsaKeys[j] = new byte[8][];
                LTPACrypto.rsaKeys[j][2] = new BigInteger(rsaKeyMaterial[i][2], 36).toByteArray();
                LTPACrypto.rsaKeys[j][3] = new BigInteger(rsaKeyMaterial[i][0], 36).toByteArray();
                LTPACrypto.rsaKeys[j][4] = new BigInteger(rsaKeyMaterial[i][1], 36).toByteArray();
                LTPACrypto.setRSAKey(rsaKeys[j]);
                LTPACrypto.rsaKeys[j + 1] = new byte[][]{rsaKeys[j][0], rsaKeys[j][2]};
                ++i;
                j += 2;
            }
            dsaKeys = new byte[4][4][];
            i = 0;
            j = 0;
            while (i < dsaKeyMaterial.length) {
                for (int k = 0; k < 3; ++k) {
                    byte[] byArray = new BigInteger(dsaKeyMaterial[i][k], 36).toByteArray();
                    LTPACrypto.dsaKeys[j + 1][k] = byArray;
                    LTPACrypto.dsaKeys[j][k] = byArray;
                }
                LTPACrypto.dsaKeys[j][3] = new BigInteger(dsaKeyMaterial[i][3], 36).toByteArray();
                LTPACrypto.dsaKeys[j + 1][3] = new BigInteger(dsaKeyMaterial[i][4], 36).toByteArray();
                ++i;
                j += 2;
            }
            seedInitialized = true;
        }
        byte[] byArray = seed;
        synchronized (seed) {
            for (int i = 0; i < n; ++i) {
                int ri8 = ++ri % 8;
                if (ri % trMix == 0) {
                    byte b = seed[ri8];
                    LTPACrypto.trng(seed, ri8, 1);
                    int n2 = ri8;
                    seed[n2] = (byte)(seed[n2] ^ b);
                }
                if (ri8 == 0) {
                    LTPACrypto.md5(null, seed, 0, 32, seed, 0);
                }
                to[off++] = seed[ri8];
            }
            // ** MonitorExit[var3_4] (shouldn't be in output)
            return;
        }
    }

    static final byte[] generate3DESKey() {
        byte[] rndSeed = null;
        int len = 24;
        rndSeed = new byte[len];
        LTPACrypto.random(rndSeed, 0, len);
        return rndSeed;
    }

    static final byte[][] rsaKey(int len, boolean crt, boolean f4) {
        byte[][] key;
        block13: {
            key = new byte[crt ? 8 : 3][];
            KeyPair pair = null;
            KeyPairGenerator keyGen = null;
            try {
                keyGen = LTPAKeyUtil.isIBMJCEAvailable() ? KeyPairGenerator.getInstance(CRYPTO_ALGORITHM, IBMJCE_NAME) : KeyPairGenerator.getInstance(CRYPTO_ALGORITHM);
                keyGen.initialize(len * 8, new SecureRandom());
                pair = keyGen.generateKeyPair();
                RSAPublicKey rsaPubKey = (RSAPublicKey)pair.getPublic();
                RSAPrivateCrtKey rsaPrivKey = (RSAPrivateCrtKey)pair.getPrivate();
                BigInteger e = rsaPubKey.getPublicExponent();
                BigInteger n = rsaPubKey.getModulus();
                BigInteger pe = rsaPrivKey.getPrivateExponent();
                key[0] = n.toByteArray();
                key[1] = crt ? null : pe.toByteArray();
                key[2] = e.toByteArray();
                if (crt) {
                    BigInteger p = rsaPrivKey.getPrimeP();
                    BigInteger q = rsaPrivKey.getPrimeQ();
                    BigInteger ep = rsaPrivKey.getPrimeExponentP();
                    BigInteger eq = rsaPrivKey.getPrimeExponentQ();
                    BigInteger c = rsaPrivKey.getCrtCoefficient();
                    key[3] = p.toByteArray();
                    key[4] = q.toByteArray();
                    key[5] = ep.toByteArray();
                    key[6] = eq.toByteArray();
                    key[7] = c.toByteArray();
                }
            }
            catch (NoSuchAlgorithmException rsaPubKey) {
            }
            catch (NoSuchProviderException rsaPubKey) {
            }
            catch (UnsupportedOperationException uoe) {
                BigInteger d;
                BigInteger n;
                BigInteger q;
                System.out.println("DEBUG: UnsupportedOperationException is caught!! Going back to the previous hardware crypto routine for evaluation.");
                BigInteger e = BigInteger.valueOf(f4 ? 65537L : 3L);
                BigInteger one = BigInteger.valueOf(1L);
                BigInteger two = BigInteger.valueOf(2L);
                byte[] b = new byte[(len /= 2) + 1];
                BigInteger p = null;
                while (true) {
                    q = null;
                    while (true) {
                        if (q == null) {
                            LTPACrypto.random(b, 1, len);
                            b[1] = (byte)(b[1] | 0xC0);
                            int n2 = len;
                            b[n2] = (byte)(b[n2] | 1);
                            q = new BigInteger(b);
                        } else if ((q = q.add(two)).bitLength() > len * 8) {
                            q = null;
                            continue;
                        }
                        if (q.isProbablePrime(32) && e.gcd(q.subtract(one)).equals(one)) break;
                    }
                    if (p == null) {
                        p = q;
                        continue;
                    }
                    n = p.multiply(q);
                    if (n.bitLength() == len * 2 * 8) {
                        d = e.modInverse(p.subtract(one).multiply(q.subtract(one)));
                        if (p.modPow(e, n).modPow(d, n).equals(p)) break;
                    }
                    p = null;
                }
                key[0] = n.toByteArray();
                key[1] = crt ? null : d.toByteArray();
                key[2] = e.toByteArray();
                if (!crt) break block13;
                if (p.compareTo(q) < 0) {
                    e = p;
                    p = q;
                    q = e;
                }
                key[3] = p.toByteArray();
                key[4] = q.toByteArray();
                key[5] = d.remainder(p.subtract(one)).toByteArray();
                key[6] = d.remainder(q.subtract(one)).toByteArray();
                key[7] = q.modInverse(p).toByteArray();
            }
        }
        return key;
    }

    static {
        LTPACrypto.ETB[0] = 0.001;
        double d = 0.001;
        double log2d = Math.log(2.0 * d);
        int i = 1;
        do {
            LTPACrypto.ETB[i++] = Math.exp(log2d / (double)i) / 2.0;
        } while (i < ETB.length);
        samples = new int[56];
        ones = new int[16];
        block = new int[16];
        seed = new byte[32];
        seedInitialized = false;
        trMix = 128;
        rsaKeyMaterial = new String[][]{{"4svq2jqtxo3zn2njenso9vwyg2bynvo08ekktj4d7sqwk9s3oz", "4se994le3trmoep5f74ytxfupr2o0oi9dem4nzailb4k4g5e7j", "1ekh"}, {"uk5febz1u9c5x7knn185refnb02syox36xqwae0lm30z9j9p03hyu175dyxbiczds3k1n6jiwqdeyetwgsy1qrvje8a7o40cmb5", "ujsuw3e4k53dtzgbsm3tjpytf5h25i71r8cs8ijbigo607ceo5zy5toem0kp4oeb77tt86h7gkix5fjdq13sa7puya61b2ep82n", "3"}};
        dsaKeyMaterial = new String[][]{{"otj4bi3e6pxy54h5tkjwpuzycvm3ta6jg9f6lj52mvygb9l72y1tkrs0ppuldns6kem6vzw3fbwhinhdhpqjvn284fc0dsaz39h", "jpdh5mk2p667os7al4gmvbdfmar3bsv", "cdybrmm4x665tomdaiedafq3d2wiajhlkbeql7iui72eeayleaa3ppn7lhfdbrh508kum7havwgb7otsnme3pc8r7kipf55hvio", "lpb2xrb2yivmklm6i6pyzvagsu9qhdz", "6d3ng23juhszoxet3kkzw2ei7y3hxo67c9oqvuf5d1dpev7qzwhzy11tcaikknfxtr62zyk96d9vvhli6zw2b2sxbrnlc3xkuzy"}, {"10uj5jh4khn7t93eh41c1d7sfptfuqiycpiimudbj62leu8fwnnt3k5cdkzynrvbhlflm3qe6sfwsjs3bbvjm8j8ctzaljlothjtbujclhafng31uzf4zmj11qjni0z9ou77rap19wl7ps7v52fbuoycrgu6xohwoobiwfanlkh4t18wtw3kf1nsdxz7mwpu9ddu4cz", "s6zmy3zi8dumvm43ofheresn52f9trj", "z4asx4yhsha3vd0d0uhhnahzmtj1qg572k3frvtq46x9lrawlm4x70oc99d4qsplci9e8qjtaqt3sqf719tfojrwjnonkqbxm9op3ck61fcxx2q6l4vg1rizk9kn74pi9859nqqctvn9174smwqzosvdrnd89eykgocc09ph343gpen9lgo0h6dk32a35gut5wb6w1", "f8xedoxwqju60mngerxyt5jv7rl8wbg", "egc8c7ptmx0hr5i4x2bzgeumx8kcmc9jokca88r8e4k1ih802bnz9flr08topo1v7kodqg9yab3xpf2j0lv9zmg8jhh38okgjfeou1fb7xn6blo4t1m8fb64p849eaqa66f1c0ar7m1uwdwc9k57vr58frxezjd1w4sc4zp8s6wn89lmbzem0brt6phtukhg2qfgrn"}};
    }

    private static class CachingVerifyKey {
        private long successfulUses;
        private final byte[][] key;
        private final byte[] data;
        private final int off;
        private final int len;
        private final byte[] sig;
        private final int sigOff;
        private final int sigLen;
        private int hashcode;
        private boolean result;

        private CachingVerifyKey(byte[][] key, byte[] data, int off, int len, byte[] sig, int sigOff, int sigLen) {
            this.key = key;
            this.data = data;
            this.off = off;
            this.len = len;
            this.sig = sig;
            this.sigOff = sigOff;
            this.sigLen = sigLen;
            this.successfulUses = 0L;
            this.hashcode = 0;
            if (key != null && key.length > 0 && key[0] != null && key[0].length > 0) {
                this.hashcode += key[0][0];
            }
            if (data != null) {
                int i;
                for (i = 0; i < data.length && i < 10; ++i) {
                    this.hashcode += data[i];
                }
                for (i = data.length - 1; i >= 0 && i > data.length - 10; --i) {
                    this.hashcode += data[i];
                }
            }
            this.hashcode += off;
            if (off != 0) {
                this.hashcode *= off;
            }
            this.hashcode *= 2;
        }

        public boolean equals(Object to) {
            int i;
            if (!(to instanceof CachingVerifyKey)) {
                return false;
            }
            CachingVerifyKey ck = (CachingVerifyKey)to;
            if (this.hashcode != ck.hashcode) {
                return false;
            }
            if (this.len != ck.len) {
                return false;
            }
            if (this.key != null) {
                if (ck.key == null) {
                    return false;
                }
                if (this.key.length != ck.key.length) {
                    return false;
                }
                for (i = 0; i < this.key.length; ++i) {
                    if (this.key[i] != null) {
                        if (ck.key[i] == null) {
                            return false;
                        }
                        if (this.key[i].length != ck.key[i].length) {
                            return false;
                        }
                        for (int o = 0; o < this.key[i].length; ++o) {
                            if (this.key[i][o] == ck.key[i][o]) continue;
                            return false;
                        }
                        continue;
                    }
                    if (ck.key[i] == null) continue;
                    return false;
                }
            } else if (ck.key != null) {
                return false;
            }
            if (this.data != null) {
                if (ck.data == null) {
                    return false;
                }
                if (this.data.length != ck.data.length) {
                    return false;
                }
                for (i = 0; i < this.data.length; ++i) {
                    if (this.data[i] == ck.data[i]) continue;
                    return false;
                }
            } else if (ck.data != null) {
                return false;
            }
            if (this.sig != null) {
                if (ck.sig == null) {
                    return false;
                }
                if (this.sig.length != ck.sig.length) {
                    return false;
                }
                for (i = 0; i < this.sig.length; ++i) {
                    if (this.sig[i] == ck.sig[i]) continue;
                    return false;
                }
            } else if (ck.sig != null) {
                return false;
            }
            if (this.off != ck.off) {
                return false;
            }
            if (this.sigOff != ck.sigOff) {
                return false;
            }
            return this.sigLen == ck.sigLen;
        }

        public int hashCode() {
            return this.hashcode;
        }
    }

    private static class CachingKey {
        private boolean reused = false;
        private long successfulUses;
        private final byte[][] key;
        private final byte[] data;
        private final int off;
        private final int len;
        private int hashcode;
        private byte[] result;

        private CachingKey(byte[][] key, byte[] data, int off, int len) {
            this.key = key;
            this.data = data;
            this.off = off;
            this.len = len;
            this.successfulUses = 0L;
            this.reused = false;
            this.hashcode = 0;
            if (key != null && key.length > 0 && key[0] != null && key[0].length > 0) {
                this.hashcode += key[0][0];
            }
            if (data != null) {
                for (int i = 0; i < data.length; ++i) {
                    this.hashcode += data[i];
                }
            }
            this.hashcode += off + len;
            if (off != 0) {
                this.hashcode *= off;
            }
            this.hashcode *= 2;
        }

        public boolean equals(Object to) {
            int i;
            if (!(to instanceof CachingKey)) {
                return false;
            }
            CachingKey ck = (CachingKey)to;
            if (this.hashcode != ck.hashcode) {
                return false;
            }
            if (this.len != ck.len) {
                return false;
            }
            if (this.key != null) {
                if (ck.key == null) {
                    return false;
                }
                if (this.key.length != ck.key.length) {
                    return false;
                }
                for (i = 0; i < this.key.length; ++i) {
                    if (this.key[i] != null) {
                        if (ck.key[i] == null) {
                            return false;
                        }
                        if (this.key[i].length != ck.key[i].length) {
                            return false;
                        }
                        for (int o = 0; o < this.key[i].length; ++o) {
                            if (this.key[i][o] == ck.key[i][o]) continue;
                            return false;
                        }
                        continue;
                    }
                    if (ck.key[i] == null) continue;
                    return false;
                }
            } else if (ck.key != null) {
                return false;
            }
            if (this.data != null) {
                if (ck.data == null) {
                    return false;
                }
                if (this.data.length != ck.data.length) {
                    return false;
                }
                for (i = 0; i < this.data.length; ++i) {
                    if (this.data[i] == ck.data[i]) continue;
                    return false;
                }
            } else if (ck.data != null) {
                return false;
            }
            return this.off == ck.off;
        }

        public int hashCode() {
            return this.hashcode;
        }

        static /* synthetic */ byte[] access$302(CachingKey x0, byte[] x1) {
            x0.result = x1;
            return x1;
        }
    }
}

