/*
 * Decompiled with CFR 0.152.
 */
package io.openliberty.microprofile.config.internal.extension;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.websphere.ras.annotation.Trivial;
import com.ibm.ws.ffdc.annotation.FFDCIgnore;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import io.openliberty.checkpoint.spi.CheckpointPhase;
import io.openliberty.microprofile.config.internal.extension.ConfigSourceWrapper;
import io.openliberty.microprofile.config.internal.extension.OLSmallRyeConfigExtension;
import io.openliberty.microprofile.config.internal.serverxml.AppPropertyConfigSource;
import io.openliberty.microprofile.config.internal.serverxml.ServerXMLDefaultVariableConfigSource;
import io.openliberty.microprofile.config.internal.serverxml.ServerXMLVariableConfigSource;
import io.smallrye.config.EnvConfigSource;
import io.smallrye.config.SmallRyeConfig;
import io.smallrye.config.SmallRyeConfigBuilder;
import java.security.AccessController;
import java.util.List;
import java.util.ListIterator;
import org.eclipse.microprofile.config.spi.ConfigSource;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class OLSmallRyeConfigBuilder
extends SmallRyeConfigBuilder {
    private static final TraceComponent tc = Tr.register(OLSmallRyeConfigBuilder.class, (String[])new String[]{"APPCONFIG", "checkpoint"}, (String)"io.openliberty.io.smallrye.config.resources.SmallryeConfigMessages", (String)"io.openliberty.microprofile.config.internal.extension.OLSmallRyeConfigBuilder");
    static final long serialVersionUID = -7271352535960418103L;

    @Override
    protected List<ConfigSource> getDefaultSources() {
        List<ConfigSource> defaultSources = super.getDefaultSources();
        ListIterator<ConfigSource> iSources = defaultSources.listIterator();
        while (iSources.hasNext()) {
            ConfigSource source = iSources.next();
            if (!(source instanceof EnvConfigSource)) continue;
            iSources.set(new EnvConfigSource(AccessController.doPrivileged(System::getenv), source.getOrdinal()));
        }
        defaultSources.add((ConfigSource)new AppPropertyConfigSource());
        defaultSources.add((ConfigSource)new ServerXMLVariableConfigSource());
        defaultSources.add((ConfigSource)new ServerXMLDefaultVariableConfigSource());
        CheckpointPhase phase = CheckpointPhase.getPhase();
        if (!phase.restored()) {
            ListIterator<ConfigSource> iSources2 = defaultSources.listIterator();
            while (iSources2.hasNext()) {
                ConfigSource source = iSources2.next();
                iSources2.set(new ConfigSourceWrapper(source, phase));
            }
        }
        return defaultSources;
    }

    @Override
    @Trivial
    @FFDCIgnore(value={Throwable.class})
    public SmallRyeConfig build() {
        try (OLSmallRyeConfigExtension.UnpauseRecording unpauseRecording = OLSmallRyeConfigExtension.pauseRecordingReads();){
            SmallRyeConfig smallRyeConfig = this.doBuild();
            return smallRyeConfig;
        }
    }

    private SmallRyeConfig doBuild() {
        SmallRyeConfig config = super.build();
        if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
            String profileName = config.getRawValue("smallrye.config.profile");
            Tr.event((Object)this, (TraceComponent)tc, (String)("Config created with profile: " + profileName), (Object[])new Object[]{config});
        }
        return config;
    }
}

