/*
 * Decompiled with CFR 0.152.
 */
package io.openliberty.microprofile.config.internal.extension;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.websphere.ras.annotation.Trivial;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import io.openliberty.checkpoint.spi.CheckpointHook;
import io.openliberty.checkpoint.spi.CheckpointPhase;
import io.openliberty.microprofile.config.internal.extension.OLSmallRyeConfigExtension;
import java.util.AbstractMap;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Supplier;
import org.eclipse.microprofile.config.spi.ConfigSource;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class ConfigSourceWrapper
implements ConfigSource {
    private static final TraceComponent tc = Tr.register(ConfigSourceWrapper.class, (String[])new String[]{"APPCONFIG", "checkpoint"}, (String)"io.openliberty.io.smallrye.config.resources.SmallryeConfigMessages", (String)"io.openliberty.microprofile.config.internal.extension.ConfigSourceWrapper");
    private final ConfigSource source;
    private final Map<String, String> propertiesAccessedOnCheckpoint;
    private final CheckpointPhase phase;
    private final AtomicBoolean hookAdded = new AtomicBoolean();
    static final long serialVersionUID = 5544862358707005776L;

    public ConfigSourceWrapper(ConfigSource source, CheckpointPhase phase) {
        this.source = source;
        this.propertiesAccessedOnCheckpoint = new HashMap<String, String>();
        this.phase = phase;
    }

    public String getName() {
        return this.source.getName();
    }

    public Map<String, String> getProperties() {
        if (!this.phase.restored()) {
            return new RecordingConfigMap(this.source.getProperties());
        }
        return this.source.getProperties();
    }

    public Set<String> getPropertyNames() {
        return this.source.getPropertyNames();
    }

    public String getValue(String propertyName) {
        String propertyValue = this.source.getValue(propertyName);
        this.recordConfigRead(propertyName, propertyValue);
        return propertyValue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void recordConfigRead(String propertyName, String propertyValue) {
        if (OLSmallRyeConfigExtension.isRecording()) {
            Map<String, String> map = this.propertiesAccessedOnCheckpoint;
            synchronized (map) {
                this.propertiesAccessedOnCheckpoint.putIfAbsent(propertyName, propertyValue);
            }
            if (this.hookAdded.compareAndSet(false, true)) {
                this.phase.addMultiThreadedHook(new CheckpointHook(){
                    static final long serialVersionUID = -2229045778280582123L;
                    private static final /* synthetic */ TraceComponent $$$tc$$$;

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public void restore() {
                        Map map = ConfigSourceWrapper.this.propertiesAccessedOnCheckpoint;
                        synchronized (map) {
                            ConfigSourceWrapper.debug(tc, () -> "Config Source: " + ConfigSourceWrapper.this.source.getName());
                            ConfigSourceWrapper.debug(tc, () -> "Properties accessed on checkpoint: " + ConfigSourceWrapper.this.propertiesAccessedOnCheckpoint);
                            for (Map.Entry entry : ConfigSourceWrapper.this.propertiesAccessedOnCheckpoint.entrySet()) {
                                String currentPropertyValue;
                                String propertyKey = (String)entry.getKey();
                                String propertyValue = (String)entry.getValue();
                                if (Objects.equals(propertyValue, currentPropertyValue = ConfigSourceWrapper.this.source.getValue(propertyKey))) continue;
                                ConfigSourceWrapper.debug(tc, () -> "Configuration property " + propertyKey + " value at checkpoint = " + propertyValue + " and value at restore = " + currentPropertyValue);
                                Tr.warning((TraceComponent)tc, (String)"WARNING_UPDATED_CONFIG_PROPERTY_NOT_USED_CWWKC0651", (Object[])new Object[]{entry.getKey()});
                            }
                            ConfigSourceWrapper.this.propertiesAccessedOnCheckpoint.clear();
                        }
                    }

                    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
                    static {
                        $$$tc$$$ = Tr.register(1.class, (String[])new String[]{"APPCONFIG", "checkpoint"}, (String)"io.openliberty.io.smallrye.config.resources.SmallryeConfigMessages", (String)"io.openliberty.microprofile.config.internal.extension.ConfigSourceWrapper$1");
                    }
                });
            }
        }
    }

    @Trivial
    static void debug(TraceComponent trace, Supplier<String> message) {
        if (TraceComponent.isAnyTracingEnabled() && trace.isDebugEnabled()) {
            Tr.debug((TraceComponent)trace, (String)message.get(), (Object[])new Object[0]);
        }
    }

    @Trivial
    class RecordingConfigMap
    extends AbstractMap<String, String> {
        private final Map<String, String> properties;

        RecordingConfigMap(Map<String, String> properties) {
            this.properties = properties;
        }

        @Override
        public Set<Map.Entry<String, String>> entrySet() {
            HashSet<Map.Entry<String, String>> entries = new HashSet<Map.Entry<String, String>>();
            Set<Map.Entry<String, String>> original = this.properties.entrySet();
            for (Map.Entry<String, String> entry : original) {
                entries.add(new RecordingConfigMapEntry(entry.getKey(), entry.getValue()));
            }
            return entries;
        }

        @Override
        public String get(Object key) {
            String value = this.properties.get(key);
            ConfigSourceWrapper.this.recordConfigRead(String.valueOf(key), value);
            return value;
        }

        @Override
        public String toString() {
            return this.properties.toString();
        }
    }

    @Trivial
    class RecordingConfigMapEntry
    extends AbstractMap.SimpleEntry<String, String> {
        private static final long serialVersionUID = 1L;

        public RecordingConfigMapEntry(String key, String value) {
            super(key, value);
        }

        @Override
        public String getValue() {
            String value = (String)super.getValue();
            ConfigSourceWrapper.this.recordConfigRead((String)this.getKey(), value);
            return value;
        }
    }
}

