/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.core.registry;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import jakarta.ws.rs.BadRequestException;
import jakarta.ws.rs.core.PathSegment;
import java.util.regex.Matcher;
import org.jboss.resteasy.core.ResourceLocatorInvoker;
import org.jboss.resteasy.core.ResourceMethodInvoker;
import org.jboss.resteasy.core.registry.Expression;
import org.jboss.resteasy.core.registry.SegmentNode;
import org.jboss.resteasy.resteasy_jaxrs.i18n.Messages;
import org.jboss.resteasy.specimpl.ResteasyUriInfo;
import org.jboss.resteasy.spi.HttpRequest;
import org.jboss.resteasy.spi.ResourceInvoker;

@TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@TraceOptions
public class MethodExpression
extends Expression {
    protected SegmentNode parent;
    protected ResourceInvoker invoker;
    static final long serialVersionUID = -4150047814598740955L;
    private static final /* synthetic */ TraceComponent $$$tc$$$;

    @Override
    public int compareTo(Expression expression) {
        int s = super.compareTo(expression);
        if (s != 0) {
            return s;
        }
        MethodExpression me = (MethodExpression)expression;
        if (this.invoker.getClass().equals(me.invoker.getClass())) {
            return 0;
        }
        if (this.invoker instanceof ResourceMethodInvoker) {
            return -1;
        }
        return 1;
    }

    public MethodExpression(SegmentNode parent, String segment, ResourceInvoker invoker) {
        this(parent, segment, invoker, null);
    }

    public MethodExpression(SegmentNode parent, String segment, ResourceInvoker invoker, String additionalRegex) {
        super(segment, additionalRegex);
        this.parent = parent;
        this.invoker = invoker;
    }

    public void populatePathParams(HttpRequest request, Matcher matcher, String path) {
        ResteasyUriInfo uriInfo = (ResteasyUriInfo)request.getUri();
        for (Expression.Group group : this.groups) {
            int i;
            String value = matcher.group(group.group);
            uriInfo.addEncodedPathParameter(group.name, value);
            int index = matcher.start(group.group);
            int start = 0;
            if (path.charAt(0) == '/') {
                ++start;
            }
            int segmentIndex = 0;
            if (start < path.length()) {
                int count = 0;
                for (i = start; i < index && i < path.length(); ++i) {
                    if (path.charAt(i) != '/') continue;
                    ++count;
                }
                segmentIndex = count;
            }
            int numSegments = 1;
            for (i = 0; i < value.length(); ++i) {
                if (value.charAt(i) != '/') continue;
                ++numSegments;
            }
            if (segmentIndex + numSegments > request.getUri().getPathSegments().size()) {
                throw new BadRequestException(Messages.MESSAGES.numberOfMatchedSegments());
            }
            PathSegment[] encodedSegments = new PathSegment[numSegments];
            PathSegment[] decodedSegments = new PathSegment[numSegments];
            for (int i2 = 0; i2 < numSegments; ++i2) {
                decodedSegments[i2] = (PathSegment)request.getUri().getPathSegments().get(segmentIndex + i2);
                encodedSegments[i2] = (PathSegment)request.getUri().getPathSegments(false).get(segmentIndex + i2);
            }
            uriInfo.getEncodedPathParameterPathSegments().add((Object)group.name, (Object)encodedSegments);
            uriInfo.getPathParameterPathSegments().add((Object)group.name, (Object)decodedSegments);
        }
    }

    public boolean isLocator() {
        return this.invoker instanceof ResourceLocatorInvoker;
    }

    public ResourceInvoker getInvoker() {
        return this.invoker;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
    static {
        $$$tc$$$ = Tr.register((String)"org.jboss.resteasy.core.registry.MethodExpression", MethodExpression.class, null, null);
    }
}

