/*
 * Decompiled with CFR 0.152.
 */
package io.openliberty.restfulws.mpmetrics;

import com.ibm.websphere.csi.J2EEName;
import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.runtime.metadata.ComponentMetaData;
import com.ibm.ws.runtime.metadata.ModuleMetaData;
import com.ibm.ws.threadContext.ComponentMetaDataAccessorImpl;
import io.openliberty.microprofile.metrics.internal.monitor.computed.internal.ComputedMonitorMetricsHandler;
import io.openliberty.restfulws.mpmetrics.MetricsRestfulWsEMCallbackImpl;
import io.openliberty.restfulws.mpmetrics.MonitorAppStateListener;
import io.openliberty.restfulws.mpmetrics.RestMonitorKeyCache;
import jakarta.annotation.PostConstruct;
import jakarta.annotation.PreDestroy;
import jakarta.ws.rs.container.ContainerRequestContext;
import jakarta.ws.rs.container.ContainerRequestFilter;
import jakarta.ws.rs.container.ContainerResponseContext;
import jakarta.ws.rs.container.ContainerResponseFilter;
import jakarta.ws.rs.container.ResourceInfo;
import jakarta.ws.rs.core.Context;
import jakarta.ws.rs.ext.Provider;
import java.io.IOException;
import java.lang.reflect.Method;
import java.time.Duration;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.eclipse.microprofile.config.ConfigProvider;
import org.eclipse.microprofile.metrics.Metadata;
import org.eclipse.microprofile.metrics.MetricID;
import org.eclipse.microprofile.metrics.MetricRegistry;
import org.eclipse.microprofile.metrics.Tag;
import org.eclipse.microprofile.metrics.Timer;

@Provider
@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class RestfulWsMonitorFilter
implements ContainerRequestFilter,
ContainerResponseFilter {
    private static final TraceComponent tc = Tr.register(RestfulWsMonitorFilter.class, (String)"METRICS", (String)"com.ibm.ws.microprofile.metrics.monitor.resources.MonitorMetrics");
    static final String REST_REQUEST_DESCRIPTION = "The number of invocations and total response time of this RESTful resource method since the start of the server. The metric will not record the elapsed time nor count of a REST request if it resulted in an unmapped exception. Also tracks the highest recorded time duration within the previous completed full minute and lowest recorded time duration within the previous completed full minute.";
    @Context
    ResourceInfo resourceInfo;
    static final ConcurrentHashMap<String, RestMetricInfo> appMetricInfos = new ConcurrentHashMap();
    static final ConcurrentHashMap<String, Timer> timerMap = new ConcurrentHashMap();
    static final Set<RestfulWsMonitorFilter> instances = Collections.newSetFromMap(new ConcurrentHashMap());
    private static final RestMonitorKeyCache monitorKeyCache = new RestMonitorKeyCache();
    private static final String TIMER_CONTEXT = "TIMER_CONTEXT";
    static final long serialVersionUID = -306801061545521977L;

    @PostConstruct
    public void postConstruct() {
        instances.add(this);
    }

    @PreDestroy
    public void preDestroy() {
        instances.remove(this);
    }

    public void filter(ContainerRequestContext reqCtx) throws IOException {
        Class resourceClass = this.resourceInfo.getResourceClass();
        if (resourceClass != null) {
            Method resourceMethod = this.resourceInfo.getResourceMethod();
            Object key = monitorKeyCache.getMonitorKey(resourceClass, resourceMethod);
            if (key == null) {
                String className = resourceClass.getName();
                Object methodName = resourceMethod.getName();
                Class<?>[] parameterClasses = resourceMethod.getParameterTypes();
                int i = 0;
                String fullMethodName = resourceClass.getName() + "/" + resourceMethod.getName() + "(";
                for (Class<?> p : parameterClasses) {
                    String parameter = p.getCanonicalName();
                    if (i > 0) {
                        methodName = (String)methodName + "_" + parameter;
                        fullMethodName = fullMethodName + "_" + parameter;
                    } else {
                        methodName = (String)methodName + "_" + parameter;
                        fullMethodName = fullMethodName + parameter;
                    }
                    ++i;
                }
                fullMethodName = fullMethodName + ")";
                ComponentMetaData cmd = ComponentMetaDataAccessorImpl.getComponentMetaDataAccessor().getComponentMetaData();
                String appName = this.getAppName(cmd);
                String modName = this.getModName(cmd);
                String keyPrefix = this.createKeyPrefix(appName, modName);
                key = keyPrefix + "/" + fullMethodName;
                this.addKeyToMetricInfo(appName, (String)key);
                Timer restTimer = timerMap.get(key);
                if (restTimer == null) {
                    MetricRegistry baseMetricRegistry = MonitorAppStateListener.sharedMetricRegistries.getOrCreate("base");
                    Metadata metricMetadata = Metadata.builder().withName("REST.request").withDescription(REST_REQUEST_DESCRIPTION).build();
                    Tag classTag = new Tag("class", className);
                    Tag methodTag = new Tag("method", (String)methodName);
                    restTimer = baseMetricRegistry.timer(metricMetadata, new Tag[]{classTag, methodTag});
                    MetricID metricID = new MetricID("REST.request", new Tag[]{classTag, methodTag});
                    MonitorAppStateListener.sharedMetricRegistries.associateMetricIDToApplication(metricID, keyPrefix, baseMetricRegistry);
                    timerMap.put((String)key, restTimer);
                    MetricsRestfulWsEMCallbackImpl.registerOrRetrieveRESTUnmappedExceptionMetric(className, (String)methodName, appName);
                    ComputedMonitorMetricsHandler cmmh = MonitorAppStateListener.monitorMetricsHandler.getComputedMonitorMetricsHandler();
                    String mpAppNameConfigValue = this.resolveMPAppNameFromMPConfig();
                    cmmh.createRESTComputedMetrics("RESTStats", metricID, appName, mpAppNameConfigValue);
                }
                monitorKeyCache.putMonitorKey(resourceClass, resourceMethod, (String)key);
            }
            reqCtx.setProperty(TIMER_CONTEXT, (Object)new TimerContext((String)key, System.nanoTime()));
        }
    }

    public void filter(ContainerRequestContext reqCtx, ContainerResponseContext respCtx) throws IOException {
        String metricsHeader;
        TimerContext timerContext = (TimerContext)reqCtx.getProperty(TIMER_CONTEXT);
        if (timerContext == null) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("ContainerRequestContext.filter() has not been invoked for " + reqCtx.getUriInfo().getPath()), (Object[])new Object[0]);
            }
            return;
        }
        long elapsedTime = System.nanoTime() - timerContext.startTime;
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("Elapsed time for " + timerContext.timerKey + " is " + elapsedTime + " ns"), (Object[])new Object[0]);
        }
        if ((metricsHeader = respCtx.getHeaderString("io.openliberty.restfulws.mpmetrics.MetricsRestfulWsEMCallbackImpl.Exception")) == null) {
            Timer restTimer = timerMap.get(timerContext.timerKey);
            restTimer.update(Duration.ofNanos(elapsedTime));
        }
    }

    private String getModName(ComponentMetaData cmd) {
        ModuleMetaData mmd;
        String modName = null;
        if (cmd != null && (mmd = cmd.getModuleMetaData()) != null) {
            modName = mmd.getName();
        }
        return modName;
    }

    private String getAppName(ComponentMetaData cmd) {
        J2EEName j2name;
        String appName = null;
        if (cmd != null && (j2name = cmd.getJ2EEName()) != null) {
            appName = j2name.getApplication();
        }
        return appName;
    }

    private String createKeyPrefix(String appName, String modName) {
        if (RestfulWsMonitorFilter.getMetricInfo((String)appName).isEar) {
            return appName + "/" + modName;
        }
        return modName;
    }

    static RestMetricInfo getMetricInfo(String appName) {
        RestMetricInfo rMetricInfo = appMetricInfos.get(appName);
        if (rMetricInfo == null) {
            rMetricInfo = new RestMetricInfo();
            appMetricInfos.put(appName, rMetricInfo);
        }
        return rMetricInfo;
    }

    private void addKeyToMetricInfo(String appName, String key) {
        RestMetricInfo rMetricInfo = appMetricInfos.get(appName);
        if (rMetricInfo != null) {
            rMetricInfo.setKey(key);
        }
    }

    static void cleanApplication(String appName) {
        RestMetricInfo rMetricInfo = appMetricInfos.get(appName);
        if (rMetricInfo != null) {
            HashSet<String> keys = rMetricInfo.getKeys();
            if (!keys.isEmpty()) {
                Iterator<String> keyIterator = keys.iterator();
                String key = null;
                while (keyIterator.hasNext()) {
                    key = keyIterator.next();
                    timerMap.remove(key);
                }
            }
            appMetricInfos.remove(appName);
        }
    }

    protected String resolveMPAppNameFromMPConfig() {
        Optional applicationName = null;
        String mpAppName = null;
        applicationName = ConfigProvider.getConfig().getOptionalValue("mp.metrics.appName", String.class);
        if (applicationName.isPresent() && !((String)applicationName.get()).isEmpty()) {
            mpAppName = (String)applicationName.get();
        } else {
            applicationName = ConfigProvider.getConfig().getOptionalValue("mp.metrics.defaultAppName", String.class);
            if (applicationName.isPresent() && !((String)applicationName.get()).isEmpty()) {
                mpAppName = (String)applicationName.get();
            }
        }
        return mpAppName;
    }

    @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
    @InjectedFFDC
    @TraceOptions
    private static class TimerContext {
        final String timerKey;
        final long startTime;
        static final long serialVersionUID = -4919652896083361245L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        TimerContext(String timerKey, long startTime) {
            this.timerKey = timerKey;
            this.startTime = startTime;
        }

        public String toString() {
            return "TimerContext [timerKey=" + this.timerKey + ", startTime=" + this.startTime + "]";
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register((String)"io.openliberty.restfulws.mpmetrics.RestfulWsMonitorFilter$TimerContext", TimerContext.class, (String)"METRICS", (String)"com.ibm.ws.microprofile.metrics.monitor.resources.MonitorMetrics");
        }
    }

    @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
    @InjectedFFDC
    @TraceOptions
    static class RestMetricInfo {
        boolean isEar = false;
        HashSet<String> keys = new HashSet();
        static final long serialVersionUID = -590447193672676934L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        RestMetricInfo() {
        }

        void setIsEar() {
            this.isEar = true;
        }

        void setKey(String key) {
            this.keys.add(key);
        }

        HashSet<String> getKeys() {
            return this.keys;
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register((String)"io.openliberty.restfulws.mpmetrics.RestfulWsMonitorFilter$RestMetricInfo", RestMetricInfo.class, (String)"METRICS", (String)"com.ibm.ws.microprofile.metrics.monitor.resources.MonitorMetrics");
        }
    }
}

