/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.asm;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.persistence.asm.ASMFactory;
import org.eclipse.persistence.asm.AnnotationVisitor;
import org.eclipse.persistence.asm.ClassReader;
import org.eclipse.persistence.asm.ClassVisitor;
import org.eclipse.persistence.asm.FieldVisitor;
import org.eclipse.persistence.asm.MethodVisitor;
import org.eclipse.persistence.asm.internal.Util;

public abstract class ClassWriter
extends ClassVisitor {
    private static final String ASM_CLASSWRITER_ECLIPSELINK = "org.eclipse.persistence.internal.libraries.asm.ClassWriter";
    private static final String ASM_CLASSWRITER_OW2 = "org.objectweb.asm.ClassWriter";
    private static final Map<String, String> ASM_CLASSWRITER_MAP = new HashMap<String, String>();
    public static final int COMPUTE_FRAMES;
    private ClassWriter cw;
    protected ClassWriter customClassWriter;

    public ClassWriter() {
    }

    public ClassWriter(int flags) {
        this(null, flags);
    }

    public ClassWriter(ClassReader classReader, int flags) {
        super(ASMFactory.ASM_API_SELECTED);
        this.cw = ASMFactory.createClassWriter(flags);
    }

    public void setCustomClassWriter(ClassWriter classWriter) {
        this.customClassWriter = classWriter;
    }

    public void setCustomClassWriterInImpl(ClassWriter classWriter) {
        this.cw.setCustomClassWriter(classWriter);
    }

    public ClassWriter getInternal() {
        return this.cw;
    }

    private static int valueInt(String fieldName) {
        return (Integer)Util.getFieldValue(ASM_CLASSWRITER_MAP, fieldName, Integer.TYPE);
    }

    public abstract String getCommonSuperClass(String var1, String var2);

    public void visit(int access, String name, String signature, String superName, String[] interfaces) {
        this.cw.visit(access, name, signature, superName, interfaces);
    }

    @Override
    public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
        this.cw.visit(version, access, name, signature, superName, interfaces);
    }

    @Override
    public AnnotationVisitor visitAnnotation(String descriptor, boolean visible) {
        return this.cw.visitAnnotation(descriptor, visible);
    }

    @Override
    public AnnotationVisitor visitAnnotationSuper(String descriptor, boolean visible) {
        return this.cw.visitAnnotationSuper(descriptor, visible);
    }

    @Override
    public FieldVisitor visitField(int access, String name, String descriptor, String signature, Object value) {
        return this.cw.visitField(access, name, descriptor, signature, value);
    }

    @Override
    public FieldVisitor visitFieldSuper(int access, String name, String descriptor, String signature, Object value) {
        return this.cw.visitFieldSuper(access, name, descriptor, signature, value);
    }

    @Override
    public MethodVisitor visitMethod(int access, String name, String descriptor, String signature, String[] exceptions) {
        return this.cw.visitMethod(access, name, descriptor, signature, exceptions);
    }

    @Override
    public MethodVisitor visitMethodSuper(int access, String name, String descriptor, String signature, String[] exceptions) {
        return this.cw.visitMethodSuper(access, name, descriptor, signature, exceptions);
    }

    @Override
    public void visitEnd() {
        this.cw.visitEnd();
    }

    public byte[] toByteArray() {
        return this.cw.toByteArray();
    }

    public byte[] toByteArraySuper() {
        return this.cw.toByteArraySuper();
    }

    @Override
    public abstract <T> T unwrap();

    static {
        ASM_CLASSWRITER_MAP.put("ow2", ASM_CLASSWRITER_OW2);
        ASM_CLASSWRITER_MAP.put("eclipselink", ASM_CLASSWRITER_ECLIPSELINK);
        COMPUTE_FRAMES = ClassWriter.valueInt("COMPUTE_FRAMES");
    }
}

