/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.classloading.internal;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.websphere.ras.annotation.Trivial;
import com.ibm.ws.classloading.configuration.GlobalClassloadingConfiguration;
import com.ibm.ws.classloading.internal.LibertyLoader;
import com.ibm.ws.classloading.internal.NativeLibrary;
import com.ibm.ws.classloading.internal.NativeLibraryAdapter;
import com.ibm.ws.classloading.internal.Util;
import com.ibm.ws.classloading.internal.util.ClassRedefiner;
import com.ibm.ws.classloading.internal.util.Keyed;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ffdc.annotation.FFDCIgnore;
import com.ibm.ws.kernel.boot.classloader.ClassLoaderHook;
import com.ibm.ws.kernel.feature.ServerStarted;
import com.ibm.ws.kernel.security.thread.ThreadIdentityManager;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.util.CacheHashMap;
import com.ibm.wsspi.adaptable.module.Container;
import com.ibm.wsspi.adaptable.module.Entry;
import com.ibm.wsspi.adaptable.module.Notifier;
import com.ibm.wsspi.adaptable.module.UnableToAdaptException;
import com.ibm.wsspi.artifact.ArtifactContainer;
import com.ibm.wsspi.artifact.ArtifactEntry;
import com.ibm.wsspi.artifact.factory.ArtifactContainerFactory;
import com.ibm.wsspi.classloading.ClassLoaderIdentity;
import com.ibm.wsspi.kernel.service.utils.CompositeEnumeration;
import com.ibm.wsspi.kernel.service.utils.PathUtils;
import io.openliberty.checkpoint.spi.CheckpointPhase;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.lang.instrument.ClassDefinition;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.function.Supplier;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import java.util.zip.ZipFile;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.FrameworkUtil;
import org.osgi.framework.ServiceReference;
import org.osgi.util.tracker.ServiceTracker;
import org.osgi.util.tracker.ServiceTrackerCustomizer;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
abstract class ContainerClassLoader
extends LibertyLoader
implements Keyed<ClassLoaderIdentity> {
    static final CheckpointPhase checkpointPhase = CheckpointPhase.getPhase();
    static final TraceComponent tc;
    private volatile SmartClassPath smartClassPath;
    private final List<UniversalContainer> nativeLibraryContainers = new ArrayList<UniversalContainer>();
    private final ClassRedefiner redefiner;
    final String jarProtocol;
    protected static final ExecutorService mapCreationQueue;
    static final long serialVersionUID = 251246017270836472L;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Trivial
    private static byte[] getBytes(InputStream stream, int knownSize) throws IOException {
        int read;
        if (knownSize == -1) {
            ByteArrayOutputStream byteOut = new ByteArrayOutputStream();
            try {
                int read2;
                byte[] bytes = new byte[1024];
                while (0 <= (read2 = stream.read(bytes))) {
                    byteOut.write(bytes, 0, read2);
                }
                byte[] byArray = byteOut.toByteArray();
                return byArray;
            }
            finally {
                Util.tryToClose(byteOut);
            }
        }
        byte[] bytes = new byte[knownSize];
        int offset = 0;
        while (knownSize > 0 && (read = stream.read(bytes, offset, knownSize)) > 0) {
            offset += read;
            knownSize -= read;
        }
        byte[] byArray = bytes;
        return byArray;
        finally {
            Util.tryToClose(stream);
        }
    }

    static URL getSharedClassCacheURL(URL resourceURL, String resourceName) {
        URL sharedClassCacheURL;
        if (resourceURL == null) {
            sharedClassCacheURL = null;
        } else {
            String protocol = resourceURL.getProtocol();
            if ("jar".equals(protocol) || "wsjar".equals(protocol)) {
                String path = resourceURL.getPath();
                if (path.endsWith(resourceName)) {
                    if ((path = path.substring(0, path.length() - resourceName.length())).endsWith(".jar!/") || path.endsWith(".zip!/")) {
                        path = path.substring(0, path.length() - 2);
                    } else if (path.endsWith("!/")) {
                        path = path + "l";
                    }
                }
                try {
                    sharedClassCacheURL = new URL(path);
                }
                catch (MalformedURLException malformedURLException) {
                    FFDCFilter.processException((Throwable)malformedURLException, (String)"com.ibm.ws.classloading.internal.ContainerClassLoader", (String)"273", null, (Object[])new Object[]{resourceURL, resourceName});
                    sharedClassCacheURL = null;
                }
            } else if (!"file".equals(protocol)) {
                sharedClassCacheURL = null;
            } else {
                String externalForm = resourceURL.toExternalForm();
                if (externalForm.endsWith(resourceName)) {
                    try {
                        sharedClassCacheURL = new URL(externalForm.substring(0, externalForm.length() - resourceName.length()));
                    }
                    catch (MalformedURLException e) {
                        FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.classloading.internal.ContainerClassLoader", (String)"283", null, (Object[])new Object[]{resourceURL, resourceName});
                        sharedClassCacheURL = null;
                    }
                } else {
                    sharedClassCacheURL = null;
                }
            }
        }
        return sharedClassCacheURL;
    }

    static byte[] getClassBytesFromHook(UniversalContainer.UniversalResource resource, String className, String resourceName, ClassLoaderHook hook) {
        URL resourceURL;
        URL sharedClassCacheURL;
        byte[] bytes = null;
        if (hook != null && (sharedClassCacheURL = ContainerClassLoader.getSharedClassCacheURL(resourceURL = resource.getResourceURL("jar"), resourceName)) != null) {
            bytes = hook.loadClass(sharedClassCacheURL, className);
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                if (bytes != null) {
                    Tr.debug((TraceComponent)tc, (String)"Found class in shared class cache", (Object[])new Object[]{className, sharedClassCacheURL});
                } else {
                    Tr.debug((TraceComponent)tc, (String)"Did not find class in shared class cache", (Object[])new Object[]{className, sharedClassCacheURL});
                }
            }
        }
        return bytes;
    }

    static <E extends Throwable> void sneakyThrow(Throwable e) throws E {
        throw e;
    }

    public ContainerClassLoader(List<Container> classpath, ClassLoader parent, ClassRedefiner redefiner, GlobalClassloadingConfiguration config) {
        super(parent);
        this.jarProtocol = config.useJarUrls() ? "jar:" : "wsjar:";
        JarCacheDisabler.disableJarCaching();
        this.smartClassPath = new UnreadSmartClassPath();
        if (classpath != null) {
            for (Container c : classpath) {
                this.smartClassPath.addContainer(c);
            }
        }
        this.redefiner = redefiner;
    }

    @Override
    public URL findResource(String name) {
        URL url = super.findResource(name);
        if (url != null) {
            return url;
        }
        url = this.smartClassPath.getResourceURL(name, this.jarProtocol);
        if (url == null && !name.endsWith("/") && (url = super.findResource(name)) != null) {
            url = ContainerClassLoader.stripTrailingSlash(url);
        }
        return url;
    }

    public CompositeEnumeration<URL> findResources(String name) throws IOException {
        CompositeEnumeration enumerations = new CompositeEnumeration(super.findResources(name));
        Collection<URL> urls = this.smartClassPath.getResourceURLs(name, this.jarProtocol);
        if (!name.endsWith("/")) {
            enumerations.add(super.findResources(name + "/"));
            HashMap<String, URL> resourceMap = new HashMap<String, URL>();
            URL url = null;
            while (enumerations.hasMoreElements()) {
                url = ContainerClassLoader.stripTrailingSlash((URL)enumerations.nextElement());
                resourceMap.put(url.toExternalForm(), url);
            }
            enumerations = new CompositeEnumeration(Collections.enumeration(resourceMap.values()));
        }
        enumerations.add(Collections.enumeration(urls));
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            int i = 0;
            StringBuilder sb = new StringBuilder();
            ArrayList<URL> urlList = new ArrayList<URL>();
            while (enumerations.hasMoreElements()) {
                URL url = (URL)enumerations.nextElement();
                urlList.add(url);
                sb.append("\n  ").append(url);
                ++i;
            }
            sb.append("\n  ").append("Total elements: ").append(i);
            enumerations = new CompositeEnumeration(Collections.enumeration(urlList));
            Tr.debug((TraceComponent)tc, (String)sb.toString(), (Object[])new Object[0]);
        }
        return enumerations;
    }

    @Override
    protected String findLibrary(String libName) {
        String mappedName = System.mapLibraryName(libName);
        for (UniversalContainer uc : this.nativeLibraryContainers) {
            String path;
            UniversalContainer.UniversalResource ur = uc.getResource(mappedName);
            if (ur == null || (path = ur.getNativeLibraryPath()) == null) continue;
            return path;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ByteResourceInformation findClassBytes(String className, String resourceName, ClassLoaderHook hook) throws IOException {
        Object token = ThreadIdentityManager.runAsServer();
        try {
            ByteResourceInformation byteResourceInformation = this.smartClassPath.getByteResourceInformation(className, resourceName, hook);
            return byteResourceInformation;
        }
        finally {
            ThreadIdentityManager.reset((Object)token);
        }
    }

    protected void addToClassPath(Iterable<ArtifactContainer> artifacts) {
        for (ArtifactContainer art : artifacts) {
            this.smartClassPath.addArtifactContainer(art);
        }
    }

    @FFDCIgnore(value={NullPointerException.class})
    protected void addLibraryFile(File f) {
        block7: {
            ArtifactContainerFactory acf;
            if (!f.exists()) {
                if (tc.isWarningEnabled()) {
                    Tr.warning((TraceComponent)tc, (String)"cls.library.archive", (Object[])new Object[]{f, new FileNotFoundException(f.getName())});
                }
                return;
            }
            if (!f.isDirectory() && !this.isArchive(f)) {
                return;
            }
            BundleContext bc = FrameworkUtil.getBundle(ContainerClassLoader.class).getBundleContext();
            ServiceReference acfsr = bc.getServiceReference(ArtifactContainerFactory.class);
            if (acfsr != null && (acf = (ArtifactContainerFactory)bc.getService(acfsr)) != null) {
                try {
                    ArtifactContainer ac = acf.getContainer(bc.getBundle().getDataFile(""), (Object)f);
                    this.smartClassPath.addArtifactContainer(ac);
                }
                catch (NullPointerException e) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)"Exception while adding files to classpath", (Object[])new Object[]{e});
                    }
                    if (!tc.isInfoEnabled()) break block7;
                    Tr.info((TraceComponent)tc, (String)"cls.library.file.forbidden", (Object[])new Object[]{f});
                }
            }
        }
    }

    protected void addNativeLibraryContainer(Container container) {
        this.nativeLibraryContainers.add(new ContainerUniversalContainer(container));
    }

    @FFDCIgnore(value={PrivilegedActionException.class})
    private boolean isArchive(File f) {
        final File target = f;
        try {
            AccessController.doPrivileged(new PrivilegedExceptionAction<Void>(){
                static final long serialVersionUID = 8308255063509451161L;
                private static final /* synthetic */ TraceComponent $$$tc$$$;

                @Override
                public Void run() throws IOException {
                    new ZipFile(target).close();
                    return null;
                }

                @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
                static {
                    $$$tc$$$ = Tr.register((String)"com.ibm.ws.classloading.internal.ContainerClassLoader$3", 3.class, (String)"ClassLoadingService", (String)"com.ibm.ws.classloading.internal.resources.ClassLoadingServiceMessages");
                }
            });
        }
        catch (PrivilegedActionException e) {
            Exception innerException = e.getException();
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("The following file can not be added to the classpath " + f + " due to error "), (Object[])new Object[]{innerException});
            }
            return false;
        }
        return true;
    }

    protected void lazyInit() {
    }

    private static URL stripTrailingSlash(URL url) {
        String externalForm = url.toExternalForm();
        if (externalForm.endsWith("/")) {
            externalForm = externalForm.substring(0, externalForm.length() - 1);
            try {
                url = new URL(externalForm);
            }
            catch (MalformedURLException malformedURLException) {
                FFDCFilter.processException((Throwable)malformedURLException, (String)"com.ibm.ws.classloading.internal.ContainerClassLoader", (String)"1741", null, (Object[])new Object[]{url});
            }
        }
        return url;
    }

    /*
     * WARNING - void declaration
     */
    public boolean redefineClasses(Notifier.Notification notification) {
        boolean success;
        if (notification.getPaths().isEmpty()) {
            return true;
        }
        Container container = notification.getContainer();
        if (!this.smartClassPath.containsContainer(container)) {
            success = true;
        } else {
            ArrayList<String> classFilePaths = new ArrayList<String>();
            for (String path : notification.getPaths()) {
                if (!path.endsWith(".class")) continue;
                classFilePaths.add(path);
            }
            if (classFilePaths.isEmpty()) {
                return true;
            }
            if (this.redefiner != null && this.redefiner.canRedefine()) {
                success = true;
                HashSet<ClassDefinition> classesToRedefine = new HashSet<ClassDefinition>();
                for (String path : classFilePaths) {
                    String className = ContainerClassLoader.convertToClassName(path);
                    Class<?> clazz = this.findLoadedClass(className);
                    if (clazz != null && clazz.getClassLoader() == this) {
                        try {
                            InputStream is = (InputStream)container.getEntry(path).adapt(InputStream.class);
                            byte[] classBytes = ContainerClassLoader.loadBytes(is);
                            ClassDefinition def = new ClassDefinition(clazz, classBytes);
                            classesToRedefine.add(def);
                            continue;
                        }
                        catch (Exception is) {
                            void e;
                            FFDCFilter.processException((Throwable)is, (String)"com.ibm.ws.classloading.internal.ContainerClassLoader", (String)"1810", (Object)this, (Object[])new Object[]{notification});
                            FFDCFilter.processException((Throwable)e, (String)(this.getClass().getName() + ".redefineClasses"), (String)"1557", (Object)this, (Object[])new Object[]{className, notification.getContainer(), path});
                            success = false;
                            break;
                        }
                    }
                    if (clazz != null) continue;
                    return false;
                }
                if (success && !classesToRedefine.isEmpty()) {
                    success = this.redefiner.redefineClasses(classesToRedefine);
                }
            } else {
                success = false;
            }
        }
        return success;
    }

    private static String convertToClassName(String fileName) {
        String className = fileName.replace(".class", "");
        className = className.replace("WEB-INF/classes/", "");
        className = className.replace('/', '.');
        if ((className = className.replace('\\', '.')).startsWith(".")) {
            className = className.substring(1);
        }
        return className;
    }

    @FFDCIgnore(value={PrivilegedActionException.class})
    private static byte[] loadBytes(final InputStream is) throws IOException {
        try {
            return AccessController.doPrivileged(new PrivilegedExceptionAction<byte[]>(){
                static final long serialVersionUID = 3670361014069677938L;
                private static final /* synthetic */ TraceComponent $$$tc$$$;

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                @Trivial
                public byte[] run() throws IOException {
                    byte[] buf = new byte[2048];
                    ByteArrayOutputStream baos = new ByteArrayOutputStream();
                    try {
                        int bytesRead = is.read(buf);
                        while (bytesRead > -1) {
                            baos.write(buf, 0, bytesRead);
                            bytesRead = is.read(buf);
                        }
                    }
                    finally {
                        if (is != null) {
                            is.close();
                        }
                    }
                    return baos.toByteArray();
                }

                @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
                static {
                    $$$tc$$$ = Tr.register((String)"com.ibm.ws.classloading.internal.ContainerClassLoader$4", 4.class, (String)"ClassLoadingService", (String)"com.ibm.ws.classloading.internal.resources.ClassLoadingServiceMessages");
                }
            });
        }
        catch (PrivilegedActionException ex) {
            Throwable cause = ex.getCause();
            if (cause instanceof IOException) {
                throw (IOException)cause;
            }
            throw new RuntimeException(cause);
        }
    }

    Collection<Collection<URL>> getClassPath() {
        return this.smartClassPath.getClassPath();
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
    static {
        ClassLoader.registerAsParallelCapable();
        tc = Tr.register(ContainerClassLoader.class, (String)"ClassLoadingService", (String)"com.ibm.ws.classloading.internal.resources.ClassLoadingServiceMessages");
        mapCreationQueue = Executors.newSingleThreadExecutor(new ThreadFactory(){
            static final long serialVersionUID = -5799275501645335577L;
            private static final /* synthetic */ TraceComponent $$$tc$$$;

            @Override
            public Thread newThread(Runnable r) {
                Thread t = new Thread(r);
                t.setDaemon(true);
                t.setName("ClassloaderMapProcessing" + t.getName());
                return t;
            }

            @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
            static {
                $$$tc$$$ = Tr.register((String)"com.ibm.ws.classloading.internal.ContainerClassLoader$1", 1.class, (String)"ClassLoadingService", (String)"com.ibm.ws.classloading.internal.resources.ClassLoadingServiceMessages");
            }
        });
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"CCL: blocking the new map building thread", (Object[])new Object[0]);
        }
        mapCreationQueue.submit(new Runnable(){
            static final long serialVersionUID = 6253493480160996126L;
            private static final /* synthetic */ TraceComponent $$$tc$$$;

            @Override
            public void run() {
                block4: {
                    BundleContext bc;
                    Bundle b = FrameworkUtil.getBundle(ContainerClassLoader.class);
                    if (b != null && (bc = b.getBundleContext()) != null) {
                        ServiceTracker st = new ServiceTracker(bc, ServerStarted.class, (ServiceTrackerCustomizer)new ServiceTrackerCustomizer<ServerStarted, ServerStarted>(){
                            static final long serialVersionUID = -6003806214263243709L;
                            private static final /* synthetic */ TraceComponent $$$tc$$$;

                            public ServerStarted addingService(ServiceReference<ServerStarted> arg0) {
                                return null;
                            }

                            public void modifiedService(ServiceReference<ServerStarted> arg0, ServerStarted arg1) {
                            }

                            public void removedService(ServiceReference<ServerStarted> arg0, ServerStarted arg1) {
                            }

                            @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
                            static {
                                $$$tc$$$ = Tr.register((String)"com.ibm.ws.classloading.internal.ContainerClassLoader$2$1", 1.class, (String)"ClassLoadingService", (String)"com.ibm.ws.classloading.internal.resources.ClassLoadingServiceMessages");
                            }
                        });
                        try {
                            st.waitForService(120000L);
                            if (tc.isDebugEnabled()) {
                                Tr.debug((TraceComponent)tc, (String)"CCL: map building thread unblocked due to server start notify", (Object[])new Object[0]);
                            }
                        }
                        catch (InterruptedException interruptedException) {
                            FFDCFilter.processException((Throwable)interruptedException, (String)"com.ibm.ws.classloading.internal.ContainerClassLoader$2", (String)"1021", (Object)this, (Object[])new Object[0]);
                            if (!tc.isDebugEnabled()) break block4;
                            Tr.debug((TraceComponent)tc, (String)"CCL: map building thread unblocked due to interrupt", (Object[])new Object[0]);
                        }
                    }
                }
            }

            @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
            static {
                $$$tc$$$ = Tr.register((String)"com.ibm.ws.classloading.internal.ContainerClassLoader$2", 2.class, (String)"ClassLoadingService", (String)"com.ibm.ws.classloading.internal.resources.ClassLoadingServiceMessages");
            }
        });
    }

    private static interface SmartClassPath {
        public void addContainer(Container var1);

        public void addArtifactContainer(ArtifactContainer var1);

        public ByteResourceInformation getByteResourceInformation(String var1, String var2, ClassLoaderHook var3) throws IOException;

        public URL getResourceURL(String var1, String var2);

        public Collection<URL> getResourceURLs(String var1, String var2);

        public boolean containsContainer(Container var1);

        public Collection<Collection<URL>> getClassPath();
    }

    private static interface UniversalContainer {
        public UniversalResource getResource(String var1);

        public void updatePackageMap(Map<Integer, List<UniversalContainer>> var1);

        public Collection<URL> getContainerURLs();

        public void definePackage(String var1, LibertyLoader var2, URL var3);

        public static interface UniversalResource {
            public URL getResourceURL(String var1);

            public ByteResourceInformation getByteResourceInformation(String var1, ClassLoaderHook var2) throws IOException;

            public String getNativeLibraryPath();
        }
    }

    @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
    @InjectedFFDC
    @TraceOptions
    private static class JarCacheDisabler {
        static final long serialVersionUID = -3816849760898710298L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        private JarCacheDisabler() {
        }

        public static void disableJarCaching() {
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register((String)"com.ibm.ws.classloading.internal.ContainerClassLoader$JarCacheDisabler", JarCacheDisabler.class, (String)"ClassLoadingService", (String)"com.ibm.ws.classloading.internal.resources.ClassLoadingServiceMessages");
            try {
                URLConnection connection = new URL("jar:file://something.jar!/").openConnection();
                connection.setDefaultUseCaches(false);
            }
            catch (MalformedURLException connection) {
                FFDCFilter.processException((Throwable)connection, (String)"com.ibm.ws.classloading.internal.ContainerClassLoader$JarCacheDisabler", (String)"100", null, (Object[])new Object[0]);
                Tr.warning((TraceComponent)tc, (String)"WARN_JARS_STILL_CACHED", (Object[])new Object[0]);
            }
            catch (IOException e) {
                FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.classloading.internal.ContainerClassLoader$JarCacheDisabler", (String)"102", null, (Object[])new Object[0]);
                Tr.warning((TraceComponent)tc, (String)"WARN_JARS_STILL_CACHED", (Object[])new Object[0]);
            }
        }
    }

    @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
    @InjectedFFDC
    @TraceOptions
    private class UnreadSmartClassPath
    implements SmartClassPath {
        SmartClassPathImpl delegate = new SmartClassPathImpl();
        static final long serialVersionUID = 3470871228674917801L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        UnreadSmartClassPath() {
        }

        @Override
        public void addContainer(Container container) {
            this.delegate.addContainer(container);
        }

        @Override
        public void addArtifactContainer(ArtifactContainer container) {
            this.delegate.addArtifactContainer(container);
        }

        @Override
        public synchronized ByteResourceInformation getByteResourceInformation(String className, String path, ClassLoaderHook hook) throws IOException {
            this.unwrap();
            return this.delegate.getByteResourceInformation(className, path, hook);
        }

        @Override
        public synchronized URL getResourceURL(String path, String jarProtocol) {
            this.unwrap();
            return this.delegate.getResourceURL(path, jarProtocol);
        }

        @Override
        public synchronized Collection<URL> getResourceURLs(String path, String jarProtocol) {
            this.unwrap();
            return this.delegate.getResourceURLs(path, jarProtocol);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void unwrap() {
            String methodName = "UnreadSmartClassPath.unwrap(): ";
            if (ContainerClassLoader.this.smartClassPath == this.delegate) {
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"UnreadSmartClassPath.unwrap(): Another thread has snuck in and performed the lazy initialisation already", (Object[])new Object[0]);
                }
                return;
            }
            UnreadSmartClassPath unreadSmartClassPath = this;
            synchronized (unreadSmartClassPath) {
                if (ContainerClassLoader.this.smartClassPath == this) {
                    try {
                        if (tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)tc, (String)"UnreadSmartClassPath.unwrap(): First read operation on class loader: perform lazy initialisation", (Object[])new Object[0]);
                        }
                        ContainerClassLoader.this.lazyInit();
                    }
                    finally {
                        ContainerClassLoader.this.smartClassPath = this.delegate;
                    }
                }
            }
        }

        @Trivial
        public String toString() {
            return this.delegate.toString();
        }

        @Override
        public boolean containsContainer(Container container) {
            return this.delegate.containsContainer(container);
        }

        @Override
        public Collection<Collection<URL>> getClassPath() {
            return this.delegate.getClassPath();
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register((String)"com.ibm.ws.classloading.internal.ContainerClassLoader$UnreadSmartClassPath", UnreadSmartClassPath.class, (String)"ClassLoadingService", (String)"com.ibm.ws.classloading.internal.resources.ClassLoadingServiceMessages");
        }
    }

    @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
    @InjectedFFDC
    @TraceOptions
    static final class ByteResourceInformation {
        private final byte[] bytes;
        private final URL resourceEntry;
        private final UniversalContainer resourceContainer;
        private final String resourcePath;
        private final boolean fromClassCache;
        private final Supplier<byte[]> actualBytes;
        static final long serialVersionUID = -7689653998909800981L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        ByteResourceInformation(byte[] bytes, URL resourceUrl, UniversalContainer root, String resourcePath, boolean fromClassCache, Supplier<byte[]> actualBytes) {
            this.bytes = bytes;
            this.resourceEntry = resourceUrl;
            this.resourceContainer = root;
            this.resourcePath = resourcePath;
            this.fromClassCache = fromClassCache;
            this.actualBytes = actualBytes;
        }

        public byte[] getBytes() {
            return this.bytes;
        }

        void definePackage(String packageName, LibertyLoader loader) {
            this.resourceContainer.definePackage(packageName, loader, this.resourceEntry);
        }

        public URL getResourceUrl() {
            return this.resourceEntry;
        }

        public String getResourcePath() {
            return this.resourcePath;
        }

        public boolean foundInClassCache() {
            return this.fromClassCache;
        }

        public byte[] getActualBytes() throws IOException {
            return this.actualBytes.get();
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register((String)"com.ibm.ws.classloading.internal.ContainerClassLoader$ByteResourceInformation", ByteResourceInformation.class, (String)"ClassLoadingService", (String)"com.ibm.ws.classloading.internal.resources.ClassLoadingServiceMessages");
        }
    }

    @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
    @InjectedFFDC
    @TraceOptions
    private static class ContainerUniversalContainer
    extends AbstractUniversalContainer<Entry> {
        private final Container container;
        private final boolean isRoot;
        private String debugString;
        static final long serialVersionUID = -4841009705512892163L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        public ContainerUniversalContainer(Container container) {
            this.container = container;
            this.isRoot = container.isRoot();
            if (!checkpointPhase.restored()) {
                this.getManifestMainAttributes();
            }
        }

        @Override
        public UniversalContainer.UniversalResource getResource(String path) {
            if (!this.isRoot) {
                if (!PathUtils.isNormalizedPathAbsolute((String)(path = PathUtils.normalize((String)path)))) {
                    return null;
                }
                if (path.startsWith("/")) {
                    path = path.substring(1);
                }
            }
            if (path.length() == 0 || path.equals("/")) {
                return new ContainerUniversalResource(this.container);
            }
            Entry e = this.container.getEntry(path);
            if (e != null) {
                return new EntryUniversalResource(this, e, path);
            }
            return null;
        }

        private void processContainer(Container c, Map<Integer, List<UniversalContainer>> map, int chop) {
            for (Entry e : c) {
                try {
                    Container child = (Container)e.adapt(Container.class);
                    if (child == null || child.isRoot()) continue;
                    Integer key = child.getPath().substring(chop).hashCode();
                    List<UniversalContainer> listForThisPath = map.get(key);
                    if (listForThisPath == null) {
                        listForThisPath = new ArrayList<UniversalContainer>();
                        map.put(key, listForThisPath);
                    }
                    if (!listForThisPath.contains(this)) {
                        listForThisPath.add(this);
                        if (tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)tc, (String)("CCL: {" + listForThisPath.size() + "} [" + this.hashCode() + "] adding : [" + key + "] " + child.getPath().substring(chop)), (Object[])new Object[0]);
                        }
                    }
                    this.processContainer(child, map, chop);
                }
                catch (UnableToAdaptException unableToAdaptException) {
                    FFDCFilter.processException((Throwable)unableToAdaptException, (String)"com.ibm.ws.classloading.internal.ContainerClassLoader$ContainerUniversalContainer", (String)"680", (Object)this, (Object[])new Object[]{c, map, chop});
                }
            }
        }

        @Override
        public synchronized void updatePackageMap(Map<Integer, List<UniversalContainer>> map) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("CCL: updating map for adaptable container with path " + this.container.getPath()), (Object[])new Object[0]);
            }
            int chop = 1;
            if (!"/".equals(this.container.getPath())) {
                chop = this.container.getPath().length() + 1;
            }
            this.processContainer(this.container, map, chop);
        }

        @Override
        public Collection<URL> getContainerURLs() {
            return this.container == null ? null : this.container.getURLs();
        }

        public String toString() {
            if (this.debugString == null) {
                String physicalPath = this.container.getPhysicalPath();
                if (physicalPath == null) {
                    physicalPath = this.container.getPath();
                }
                this.debugString = physicalPath;
            }
            return this.debugString;
        }

        @Override
        Entry getEntry(String path) {
            return this.container.getEntry(path);
        }

        @Override
        InputStream getInputStream(Entry e) throws IOException {
            try {
                return (InputStream)e.adapt(InputStream.class);
            }
            catch (UnableToAdaptException unableToAdaptException) {
                FFDCFilter.processException((Throwable)unableToAdaptException, (String)"com.ibm.ws.classloading.internal.ContainerClassLoader$ContainerUniversalContainer", (String)"725", (Object)this, (Object[])new Object[]{e});
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"UnableToAdaptException thrown opening resource {0}", (Object[])new Object[]{e.getResource()});
                }
                return null;
            }
        }

        @Override
        URL getResourceURL(Entry e) {
            return e.getResource();
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register((String)"com.ibm.ws.classloading.internal.ContainerClassLoader$ContainerUniversalContainer", ContainerUniversalContainer.class, (String)"ClassLoadingService", (String)"com.ibm.ws.classloading.internal.resources.ClassLoadingServiceMessages");
        }
    }

    @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
    @InjectedFFDC
    @TraceOptions
    private static class SmartClassPathImpl
    implements SmartClassPath {
        final ReentrantReadWriteLock rwLock = new ReentrantReadWriteLock(true);
        final AtomicInteger outstandingContainers = new AtomicInteger(0);
        static final boolean usePackageMap;
        static final Integer maxLastNotFound;
        static final Integer maxLastFound;
        static final Integer maxLastReallyNotFound;
        static final boolean propsInUse;
        final List<UniversalContainer> classPath = new CopyOnWriteArrayList<UniversalContainer>();
        final int MAX_LASTNOTFOUND = maxLastNotFound;
        final List<Set<String>> lastNotFound = new CopyOnWriteArrayList<Set<String>>();
        final int MAX_LASTFOUND = maxLastFound;
        final Map<String, URL> lastFoundURL = Collections.synchronizedMap(new CacheHashMap(this.MAX_LASTFOUND));
        final int MAX_LASTREALLYNOTFOUND = maxLastReallyNotFound;
        final Map<String, Object> lastReallyNotFoundURL = Collections.synchronizedMap(new CacheHashMap(this.MAX_LASTREALLYNOTFOUND));
        final Map<Integer, List<UniversalContainer>> packageMap = usePackageMap ? new HashMap() : null;
        final Set<Container> containers = Collections.newSetFromMap(new WeakHashMap());
        static final long serialVersionUID = 1586111247084489525L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        private SmartClassPathImpl() {
        }

        private synchronized void addUniversalContainers(final UniversalContainer uc) {
            if (tc.isDebugEnabled()) {
                if (uc instanceof ArtifactContainerUniversalContainer) {
                    Tr.debug((TraceComponent)tc, (String)("CCL: " + this.hashCode() + " cpelt idx " + this.classPath.size() + "wraps " + ((ArtifactContainerUniversalContainer)uc).container), (Object[])new Object[0]);
                    Tr.debug((TraceComponent)tc, (String)("CCL: " + this.hashCode() + " cpelt idx " + this.classPath.size() + " ART url " + ((ArtifactContainerUniversalContainer)uc).container.getPhysicalPath()), (Object[])new Object[0]);
                } else {
                    Tr.debug((TraceComponent)tc, (String)("CCL: " + this.hashCode() + " cpelt idx " + this.classPath.size() + " wraps " + ((ContainerUniversalContainer)uc).container), (Object[])new Object[0]);
                    Tr.debug((TraceComponent)tc, (String)("CCL: " + this.hashCode() + " cpelt idx " + this.classPath.size() + " CON url " + ((ContainerUniversalContainer)uc).container.getPhysicalPath()), (Object[])new Object[0]);
                }
            }
            if (usePackageMap) {
                this.outstandingContainers.incrementAndGet();
                mapCreationQueue.submit(new Runnable(){
                    static final long serialVersionUID = -2946150208078364083L;
                    private static final /* synthetic */ TraceComponent $$$tc$$$;

                    @Override
                    public void run() {
                        if (tc.isDebugEnabled()) {
                            if (uc instanceof ArtifactContainerUniversalContainer) {
                                Tr.debug((TraceComponent)tc, (String)("CCL: " + this.hashCode() + " building package map for " + ((ArtifactContainerUniversalContainer)uc).container.getPhysicalPath()), (Object[])new Object[0]);
                            } else {
                                Tr.debug((TraceComponent)tc, (String)("CCL: " + this.hashCode() + " building package map for " + ((ContainerUniversalContainer)uc).container.getPhysicalPath()), (Object[])new Object[0]);
                            }
                        }
                        ReentrantReadWriteLock.WriteLock write = rwLock.writeLock();
                        write.lock();
                        try {
                            uc.updatePackageMap(packageMap);
                            outstandingContainers.decrementAndGet();
                        }
                        finally {
                            write.unlock();
                        }
                        if (tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)tc, (String)("CCL: " + this.hashCode() + " done building package map."), (Object[])new Object[0]);
                        }
                    }

                    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
                    static {
                        $$$tc$$$ = Tr.register((String)"com.ibm.ws.classloading.internal.ContainerClassLoader$SmartClassPathImpl$1", 1.class, (String)"ClassLoadingService", (String)"com.ibm.ws.classloading.internal.resources.ClassLoadingServiceMessages");
                    }
                });
            }
            this.classPath.add(uc);
            this.lastNotFound.add(Collections.synchronizedSet(new LinkedHashSet()));
        }

        @Override
        public void addContainer(Container container) {
            this.containers.add(container);
            this.addUniversalContainers(new ContainerUniversalContainer(container));
        }

        @Override
        public void addArtifactContainer(ArtifactContainer container) {
            this.addUniversalContainers(new ArtifactContainerUniversalContainer(container));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private List<UniversalContainer> getUniversalContainersForPath(String path, List<UniversalContainer> classpath) {
            if (this.outstandingContainers.get() > 0) {
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("CCL: request for " + path + " made to use map while map update pending, reverting request to full classpath"), (Object[])new Object[0]);
                }
                return classpath;
            }
            int startidx = (path = PathUtils.normalizeUnixStylePath((String)path)).startsWith("/") ? 1 : 0;
            int slashidx = path.lastIndexOf(47);
            if (slashidx > 0) {
                List<UniversalContainer> containersForKey;
                Integer key = path.substring(startidx, slashidx).hashCode();
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("CCL: checking map using key {" + key + "} for path '" + path.substring(0, slashidx) + "'    :    origpath: '" + path + "'"), (Object[])new Object[0]);
                }
                ReentrantReadWriteLock.ReadLock read = this.rwLock.readLock();
                read.lock();
                try {
                    containersForKey = this.packageMap.get(key);
                }
                finally {
                    read.unlock();
                }
                if (containersForKey != null) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("CCL: got hit for key, returning container set with " + containersForKey.size() + " containers."), (Object[])new Object[0]);
                    }
                    return containersForKey;
                }
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"CCL: key was unknown, returning empty set. ", (Object[])new Object[0]);
                }
                return Collections.emptyList();
            }
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("CCL: request for a root level resource... : '" + path + "' returning original set with " + classpath.size()), (Object[])new Object[0]);
            }
            return classpath;
        }

        @Override
        public ByteResourceInformation getByteResourceInformation(String className, String path, ClassLoaderHook hook) throws IOException {
            int idx = 0;
            List<UniversalContainer> locationsToCheck = this.classPath;
            if (usePackageMap) {
                locationsToCheck = this.getUniversalContainersForPath(path, locationsToCheck);
            }
            for (UniversalContainer uc : locationsToCheck) {
                Set<String> lastNotFoundForThisContainer = this.lastNotFound.get(idx);
                if (usePackageMap || this.pathNotInlastNotFound(path, lastNotFoundForThisContainer)) {
                    UniversalContainer.UniversalResource ur = uc.getResource(path);
                    if (ur != null) {
                        ByteResourceInformation is = ur.getByteResourceInformation(className, hook);
                        if (is != null) {
                            return is;
                        }
                    } else if (!usePackageMap && lastNotFoundForThisContainer != null) {
                        this.addPath(lastNotFoundForThisContainer, path);
                    }
                }
                ++idx;
            }
            return null;
        }

        @Override
        public URL getResourceURL(String path, String jarProtocol) {
            URL cached = this.lastFoundURL.get(path);
            if (cached != null) {
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("CCL: [" + this.hashCode() + "]  getResourceURL : '" + path + "' lastFound hit."), (Object[])new Object[0]);
                }
                return cached;
            }
            if (this.lastReallyNotFoundURL.containsKey(path)) {
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("CCL: [" + this.hashCode() + "]  getResourceURL : '" + path + "' lastReallyNotFound hit."), (Object[])new Object[0]);
                }
                return null;
            }
            List<UniversalContainer> locationsToCheck = this.classPath;
            if (usePackageMap) {
                locationsToCheck = this.getUniversalContainersForPath(path, locationsToCheck);
            }
            int idx = 0;
            int skipped = 0;
            for (UniversalContainer uc : locationsToCheck) {
                Set<String> lastNotFoundForThisContainer = this.lastNotFound.get(idx);
                if (usePackageMap || this.pathNotInlastNotFound(path, lastNotFoundForThisContainer)) {
                    UniversalContainer.UniversalResource ur = uc.getResource(path);
                    if (ur != null) {
                        URL url = ur.getResourceURL(jarProtocol);
                        if (url != null) {
                            if (tc.isDebugEnabled()) {
                                Tr.debug((TraceComponent)tc, (String)("CCL: [" + this.hashCode() + "]  getResourceURL : '" + path + "' found at classpath index " + idx + " local not found caches allowed us to skip " + skipped + " locations. Found cache is now.. " + this.lastFoundURL.size() + " and path was known to cache? " + this.lastFoundURL.containsKey(path)), (Object[])new Object[0]);
                            }
                            this.lastFoundURL.put(path, url);
                            return url;
                        }
                    } else if (!usePackageMap && lastNotFoundForThisContainer != null) {
                        this.addPath(lastNotFoundForThisContainer, path);
                    }
                } else {
                    ++skipped;
                }
                ++idx;
            }
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("CCL: [" + this.hashCode() + "]  getResourceURL : '" + path + "' really not found. Cache size is now.. " + this.lastReallyNotFoundURL.size() + " path already known to cache? " + this.lastReallyNotFoundURL.containsKey(path)), (Object[])new Object[0]);
            }
            this.lastReallyNotFoundURL.put(path, null);
            return null;
        }

        @Override
        public Collection<URL> getResourceURLs(String path, String jarProtocol) {
            ArrayList<URL> urls = new ArrayList<URL>();
            if (this.lastReallyNotFoundURL.containsKey(path)) {
                return urls;
            }
            List<UniversalContainer> locationsToCheck = this.classPath;
            if (usePackageMap) {
                locationsToCheck = this.getUniversalContainersForPath(path, locationsToCheck);
            }
            int idx = 0;
            for (UniversalContainer uc : locationsToCheck) {
                Set<String> lastNotFoundForThisContainer = this.lastNotFound.get(idx);
                if (usePackageMap || this.pathNotInlastNotFound(path, lastNotFoundForThisContainer)) {
                    UniversalContainer.UniversalResource ur = uc.getResource(path);
                    if (ur != null) {
                        URL url = ur.getResourceURL(jarProtocol);
                        if (url != null) {
                            urls.add(url);
                        }
                    } else if (!usePackageMap && lastNotFoundForThisContainer != null) {
                        this.addPath(lastNotFoundForThisContainer, path);
                    }
                }
                ++idx;
            }
            if (urls.isEmpty()) {
                this.lastReallyNotFoundURL.put(path, null);
            }
            return urls;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void addPath(Set<String> lastNotFoundForThisContainer, String path) {
            Set<String> set = lastNotFoundForThisContainer;
            synchronized (set) {
                if (lastNotFoundForThisContainer.size() >= this.MAX_LASTNOTFOUND) {
                    Iterator<String> i = lastNotFoundForThisContainer.iterator();
                    i.next();
                    i.remove();
                }
                lastNotFoundForThisContainer.add(path);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private boolean pathNotInlastNotFound(String path, Set<String> lastNotFoundForThisContainer) {
            boolean pathFound = false;
            if (lastNotFoundForThisContainer != null) {
                Set<String> set = lastNotFoundForThisContainer;
                synchronized (set) {
                    pathFound = lastNotFoundForThisContainer.contains(path);
                }
            }
            return !pathFound;
        }

        @Trivial
        public String toString() {
            return String.valueOf(this.classPath);
        }

        @Override
        public boolean containsContainer(Container container) {
            return this.containers.contains(container);
        }

        @Override
        public Collection<Collection<URL>> getClassPath() {
            ArrayList<Collection<URL>> containerURLs = new ArrayList<Collection<URL>>();
            for (UniversalContainer uc : this.classPath) {
                containerURLs.add(uc.getContainerURLs());
            }
            return containerURLs;
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register((String)"com.ibm.ws.classloading.internal.ContainerClassLoader$SmartClassPathImpl", SmartClassPathImpl.class, (String)"ClassLoadingService", (String)"com.ibm.ws.classloading.internal.resources.ClassLoadingServiceMessages");
            usePackageMap = !Boolean.getBoolean("com.ibm.ws.classloading.container.disableMap");
            maxLastNotFound = Integer.getInteger("com.ibm.ws.classloading.container.lastNotFound", 250);
            maxLastFound = Integer.getInteger("com.ibm.ws.classloading.container.lastFound", 900);
            maxLastReallyNotFound = Integer.getInteger("com.ibm.ws.classloading.container.lastReallyNotFound", 900);
            boolean bl = propsInUse = !usePackageMap || System.getProperty("com.ibm.ws.classloading.container.lastNotFound") != null || System.getProperty("com.ibm.ws.classloading.container.lastFound") != null || System.getProperty("com.ibm.ws.classloading.container.lastReallyNotFound") != null;
            if (propsInUse && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("CCL: custom cache properties in use : lastNotFound=" + maxLastNotFound + " lastFound=" + maxLastFound + " lastReallyNotFound=" + maxLastReallyNotFound), (Object[])new Object[0]);
                if (usePackageMap) {
                    Tr.debug((TraceComponent)tc, (String)"CCL: experimental package map engaged.. utoh!", (Object[])new Object[0]);
                }
            }
        }
    }

    @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
    @InjectedFFDC
    @TraceOptions
    private static class ArtifactContainerUniversalResource
    implements UniversalContainer.UniversalResource {
        private final ArtifactContainer container;
        static final long serialVersionUID = 4616666204979329747L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        public ArtifactContainerUniversalResource(ArtifactContainer c) {
            this.container = c;
        }

        @Override
        public URL getResourceURL(String jarProtocol) {
            Collection urls = this.container.getURLs();
            if (urls.isEmpty()) {
                return null;
            }
            return (URL)urls.iterator().next();
        }

        @Override
        public ByteResourceInformation getByteResourceInformation(String className, ClassLoaderHook hook) throws IOException {
            return null;
        }

        @Override
        public String getNativeLibraryPath() {
            return null;
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register((String)"com.ibm.ws.classloading.internal.ContainerClassLoader$ArtifactContainerUniversalResource", ArtifactContainerUniversalResource.class, (String)"ClassLoadingService", (String)"com.ibm.ws.classloading.internal.resources.ClassLoadingServiceMessages");
        }
    }

    @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
    @InjectedFFDC
    @TraceOptions
    private static class ArtifactContainerUniversalContainer
    extends AbstractUniversalContainer<ArtifactEntry> {
        final ArtifactContainer container;
        final boolean isRoot;
        static final long serialVersionUID = -1029854646163540326L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        public ArtifactContainerUniversalContainer(ArtifactContainer container) {
            this.container = container;
            this.isRoot = container.isRoot();
            if (!checkpointPhase.restored()) {
                this.getManifestMainAttributes();
            }
        }

        @Override
        public UniversalContainer.UniversalResource getResource(String path) {
            if (!this.isRoot) {
                if (!PathUtils.isNormalizedPathAbsolute((String)(path = PathUtils.normalize((String)path)))) {
                    return null;
                }
                if (path.startsWith("/")) {
                    path = path.substring(1);
                }
            }
            if (path.length() == 0 || path.equals("/")) {
                return new ArtifactContainerUniversalResource(this.container);
            }
            try {
                ArtifactEntry e = this.container.getEntry(path);
                if (e != null) {
                    return new ArtifactEntryUniversalResource(this, e, path);
                }
                return null;
            }
            catch (IllegalArgumentException e) {
                FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.classloading.internal.ContainerClassLoader$ArtifactContainerUniversalContainer", (String)"864", (Object)this, (Object[])new Object[]{path});
                return null;
            }
        }

        private void processContainer(ArtifactContainer c, Map<Integer, List<UniversalContainer>> map, int chop) {
            for (ArtifactEntry e : c) {
                ArtifactContainer child = e.convertToContainer(true);
                if (child == null) continue;
                Integer key = child.getPath().substring(chop).hashCode();
                List<UniversalContainer> listForThisPath = map.get(key);
                if (listForThisPath == null) {
                    listForThisPath = new ArrayList<UniversalContainer>();
                    map.put(key, listForThisPath);
                }
                if (!listForThisPath.contains(this)) {
                    listForThisPath.add(this);
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("CCL: {" + listForThisPath.size() + "} [" + this.hashCode() + "] adding : [" + key + "] " + child.getPath().substring(chop)), (Object[])new Object[0]);
                    }
                }
                this.processContainer(child, map, chop);
            }
        }

        @Override
        public synchronized void updatePackageMap(Map<Integer, List<UniversalContainer>> map) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("CCL: updating map for artifact container with path " + this.container.getPath()), (Object[])new Object[0]);
            }
            int chop = 1;
            if (!"/".equals(this.container.getPath())) {
                chop = this.container.getPath().length() + 1;
            }
            this.processContainer(this.container, map, chop);
        }

        @Override
        public Collection<URL> getContainerURLs() {
            return this.container == null ? null : this.container.getURLs();
        }

        @Override
        ArtifactEntry getEntry(String path) {
            return this.container.getEntry(path);
        }

        @Override
        InputStream getInputStream(ArtifactEntry e) throws IOException {
            return e.getInputStream();
        }

        @Override
        URL getResourceURL(ArtifactEntry e) {
            return e.getResource();
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register((String)"com.ibm.ws.classloading.internal.ContainerClassLoader$ArtifactContainerUniversalContainer", ArtifactContainerUniversalContainer.class, (String)"ClassLoadingService", (String)"com.ibm.ws.classloading.internal.resources.ClassLoadingServiceMessages");
        }
    }

    @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
    @InjectedFFDC
    @TraceOptions
    private static class ArtifactEntryUniversalResource
    implements UniversalContainer.UniversalResource {
        final UniversalContainer container;
        final ArtifactEntry entry;
        final String resourceName;
        static final long serialVersionUID = 2539570230624884334L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        public ArtifactEntryUniversalResource(UniversalContainer container, ArtifactEntry entry, String resourceName) {
            this.container = container;
            this.entry = entry;
            this.resourceName = resourceName;
        }

        @Override
        public URL getResourceURL(String jarProtocol) {
            boolean pSlash;
            URL url = this.entry.getResource();
            if (url == null) {
                return null;
            }
            boolean uSlash = url.getPath().endsWith("/");
            if (uSlash == (pSlash = this.resourceName.endsWith("/"))) {
                return url;
            }
            if (uSlash) {
                return ContainerClassLoader.stripTrailingSlash(url);
            }
            return null;
        }

        @Override
        public ByteResourceInformation getByteResourceInformation(String className, ClassLoaderHook hook) throws IOException {
            boolean foundInClassCache;
            byte[] bytes = ContainerClassLoader.getClassBytesFromHook(this, className, this.resourceName, hook);
            boolean bl = foundInClassCache = bytes != null;
            if (!foundInClassCache) {
                bytes = this.getActualBytes();
            }
            return new ByteResourceInformation(bytes, this.entry.getResource(), this.container, this.resourceName, foundInClassCache, this::getActualBytes);
        }

        /*
         * WARNING - void declaration
         */
        byte[] getActualBytes() {
            try {
                InputStream is = this.entry.getInputStream();
                return ContainerClassLoader.getBytes(is, (int)this.entry.getSize());
            }
            catch (IOException is) {
                void e;
                FFDCFilter.processException((Throwable)is, (String)"com.ibm.ws.classloading.internal.ContainerClassLoader$ArtifactEntryUniversalResource", (String)"796", (Object)this, (Object[])new Object[0]);
                ContainerClassLoader.sneakyThrow((Throwable)e);
                return null;
            }
        }

        @Override
        public String getNativeLibraryPath() {
            try {
                File f = NativeLibraryAdapter.getFileForLibraryEntry(this.entry);
                if (f != null) {
                    return f.getPath();
                }
            }
            catch (IOException iOException) {
                FFDCFilter.processException((Throwable)iOException, (String)"com.ibm.ws.classloading.internal.ContainerClassLoader$ArtifactEntryUniversalResource", (String)"807", (Object)this, (Object[])new Object[0]);
            }
            return null;
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register((String)"com.ibm.ws.classloading.internal.ContainerClassLoader$ArtifactEntryUniversalResource", ArtifactEntryUniversalResource.class, (String)"ClassLoadingService", (String)"com.ibm.ws.classloading.internal.resources.ClassLoadingServiceMessages");
        }
    }

    @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
    @InjectedFFDC
    @TraceOptions
    private static abstract class AbstractUniversalContainer<E>
    implements UniversalContainer {
        private static final Map<Attributes.Name, String> NULL_MAIN_ATTRIBUTES;
        private static final Map<Attributes.Name, Attributes.Name> packageAttributes;
        private volatile Map<Attributes.Name, String> manifestMainAttributes = null;
        private volatile Map<String, Map<Attributes.Name, String>> manifestEntryAttributes = null;
        static final long serialVersionUID = 8060824927513251581L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        private AbstractUniversalContainer() {
        }

        @Override
        @FFDCIgnore(value={IllegalArgumentException.class})
        public final void definePackage(String packageName, LibertyLoader loader, URL sealBase) {
            Map<Attributes.Name, String> mainAttributes = this.getManifestMainAttributes();
            try {
                if (mainAttributes == NULL_MAIN_ATTRIBUTES && this.manifestEntryAttributes == null) {
                    loader.definePackage(packageName, null, null, null, null, null, null, null);
                } else {
                    String unixName;
                    Map<Attributes.Name, String> entryAttributes;
                    String specTitle = null;
                    String specVersion = null;
                    String specVendor = null;
                    String implTitle = null;
                    String implVersion = null;
                    String implVendor = null;
                    String sealedString = null;
                    if (this.manifestEntryAttributes != null && (entryAttributes = this.manifestEntryAttributes.get(unixName = packageName.replaceAll("\\.", "/") + "/")) != null) {
                        specTitle = entryAttributes.get(Attributes.Name.SPECIFICATION_TITLE);
                        specVersion = entryAttributes.get(Attributes.Name.SPECIFICATION_VERSION);
                        specVendor = entryAttributes.get(Attributes.Name.SPECIFICATION_VENDOR);
                        implTitle = entryAttributes.get(Attributes.Name.IMPLEMENTATION_TITLE);
                        implVersion = entryAttributes.get(Attributes.Name.IMPLEMENTATION_VERSION);
                        implVendor = entryAttributes.get(Attributes.Name.IMPLEMENTATION_VENDOR);
                        sealedString = entryAttributes.get(Attributes.Name.SEALED);
                    }
                    if (mainAttributes != NULL_MAIN_ATTRIBUTES) {
                        if (specTitle == null) {
                            specTitle = mainAttributes.get(Attributes.Name.SPECIFICATION_TITLE);
                        }
                        if (specVersion == null) {
                            specVersion = mainAttributes.get(Attributes.Name.SPECIFICATION_VERSION);
                        }
                        if (specVendor == null) {
                            specVendor = mainAttributes.get(Attributes.Name.SPECIFICATION_VENDOR);
                        }
                        if (implTitle == null) {
                            implTitle = mainAttributes.get(Attributes.Name.IMPLEMENTATION_TITLE);
                        }
                        if (implVersion == null) {
                            implVersion = mainAttributes.get(Attributes.Name.IMPLEMENTATION_VERSION);
                        }
                        if (implVendor == null) {
                            implVendor = mainAttributes.get(Attributes.Name.IMPLEMENTATION_VENDOR);
                        }
                        if (sealedString == null) {
                            sealedString = mainAttributes.get(Attributes.Name.SEALED);
                        }
                    }
                    if (sealedString == null || !sealedString.equalsIgnoreCase("true")) {
                        sealBase = null;
                    }
                    loader.definePackage(packageName, specTitle, specVersion, specVendor, implTitle, implVersion, implVendor, sealBase);
                }
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @FFDCIgnore(value={IOException.class})
        Map<Attributes.Name, String> getManifestMainAttributes() {
            if (this.manifestMainAttributes == null) {
                AbstractUniversalContainer abstractUniversalContainer = this;
                synchronized (abstractUniversalContainer) {
                    if (this.manifestMainAttributes == null) {
                        E e = this.getEntry("META-INF/MANIFEST.MF");
                        if (e != null) {
                            InputStream manifestStream = null;
                            try {
                                manifestStream = this.getInputStream(e);
                                if (manifestStream != null) {
                                    Attributes mainAttributes;
                                    Manifest manifest = new Manifest(manifestStream);
                                    Map<String, Attributes> manifestEntries = manifest.getEntries();
                                    if (!manifestEntries.isEmpty()) {
                                        this.manifestEntryAttributes = AbstractUniversalContainer.filterEntryAttributes(manifestEntries);
                                    }
                                    if (!(mainAttributes = manifest.getMainAttributes()).isEmpty()) {
                                        this.manifestMainAttributes = AbstractUniversalContainer.filterAttributes(mainAttributes);
                                    }
                                }
                            }
                            catch (IOException e2) {
                                if (tc.isDebugEnabled()) {
                                    Tr.debug((TraceComponent)tc, (String)"IOException thrown opening resource {0}", (Object[])new Object[]{this.getResourceURL(e)});
                                }
                            }
                            finally {
                                Util.tryToClose(manifestStream);
                            }
                        }
                        if (this.manifestMainAttributes == null) {
                            this.manifestMainAttributes = NULL_MAIN_ATTRIBUTES;
                        }
                    }
                }
            }
            return this.manifestMainAttributes;
        }

        private static Map<String, Map<Attributes.Name, String>> filterEntryAttributes(Map<String, Attributes> manifestEntries) throws IOException {
            HashMap<String, Map<Attributes.Name, String>> entries = null;
            for (Map.Entry<String, Attributes> entry : manifestEntries.entrySet()) {
                Map<Attributes.Name, String> newAttributes;
                Attributes attributes;
                String key = entry.getKey();
                if (key == null || !key.endsWith("/") || (attributes = entry.getValue()).isEmpty() || (newAttributes = AbstractUniversalContainer.filterAttributes(attributes)) == null) continue;
                if (entries == null) {
                    entries = new HashMap<String, Map<Attributes.Name, String>>(7);
                }
                entries.put(key, newAttributes);
            }
            return entries;
        }

        private static Map<Attributes.Name, String> filterAttributes(Attributes attributes) {
            HashMap<Attributes.Name, String> newAttributes = null;
            for (Map.Entry<Object, Object> entry : attributes.entrySet()) {
                Attributes.Name validName;
                Object key = entry.getKey();
                if (!(key instanceof Attributes.Name) || (validName = packageAttributes.get(key)) == null) continue;
                if (newAttributes == null) {
                    newAttributes = new HashMap<Attributes.Name, String>(7);
                }
                newAttributes.put(validName, (String)entry.getValue());
            }
            return newAttributes;
        }

        abstract E getEntry(String var1);

        abstract InputStream getInputStream(E var1) throws IOException;

        abstract URL getResourceURL(E var1);

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register((String)"com.ibm.ws.classloading.internal.ContainerClassLoader$AbstractUniversalContainer", AbstractUniversalContainer.class, (String)"ClassLoadingService", (String)"com.ibm.ws.classloading.internal.resources.ClassLoadingServiceMessages");
            NULL_MAIN_ATTRIBUTES = Collections.emptyMap();
            HashMap<Attributes.Name, Attributes.Name> packageAttrs = new HashMap<Attributes.Name, Attributes.Name>();
            packageAttrs.put(Attributes.Name.SPECIFICATION_TITLE, Attributes.Name.SPECIFICATION_TITLE);
            packageAttrs.put(Attributes.Name.SPECIFICATION_VERSION, Attributes.Name.SPECIFICATION_VERSION);
            packageAttrs.put(Attributes.Name.SPECIFICATION_VENDOR, Attributes.Name.SPECIFICATION_VENDOR);
            packageAttrs.put(Attributes.Name.IMPLEMENTATION_TITLE, Attributes.Name.IMPLEMENTATION_TITLE);
            packageAttrs.put(Attributes.Name.IMPLEMENTATION_VERSION, Attributes.Name.IMPLEMENTATION_VERSION);
            packageAttrs.put(Attributes.Name.IMPLEMENTATION_VENDOR, Attributes.Name.IMPLEMENTATION_VENDOR);
            packageAttrs.put(Attributes.Name.SEALED, Attributes.Name.SEALED);
            packageAttributes = Collections.unmodifiableMap(packageAttrs);
        }
    }

    @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
    @InjectedFFDC
    @TraceOptions
    private static class ContainerUniversalResource
    implements UniversalContainer.UniversalResource {
        private final Container container;
        static final long serialVersionUID = 8132742274105626553L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        public ContainerUniversalResource(Container c) {
            this.container = c;
        }

        @Override
        public URL getResourceURL(String jarProtocol) {
            Collection urls = this.container.getURLs();
            if (urls.isEmpty()) {
                return null;
            }
            URL result = (URL)urls.iterator().next();
            if ("file".equals(result.getProtocol()) && !result.getPath().endsWith("/")) {
                try {
                    return new URL(jarProtocol + result.toExternalForm() + "!/");
                }
                catch (MalformedURLException malformedURLException) {
                    FFDCFilter.processException((Throwable)malformedURLException, (String)"com.ibm.ws.classloading.internal.ContainerClassLoader$ContainerUniversalResource", (String)"416", (Object)this, (Object[])new Object[]{jarProtocol});
                    return result;
                }
            }
            return result;
        }

        @Override
        public ByteResourceInformation getByteResourceInformation(String className, ClassLoaderHook hook) throws IOException {
            return null;
        }

        @Override
        public String getNativeLibraryPath() {
            return null;
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register((String)"com.ibm.ws.classloading.internal.ContainerClassLoader$ContainerUniversalResource", ContainerUniversalResource.class, (String)"ClassLoadingService", (String)"com.ibm.ws.classloading.internal.resources.ClassLoadingServiceMessages");
        }
    }

    @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
    @InjectedFFDC
    @TraceOptions
    private static class EntryUniversalResource
    implements UniversalContainer.UniversalResource {
        final UniversalContainer container;
        final Entry entry;
        final String resourceName;
        static final long serialVersionUID = 117201147045833776L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        public EntryUniversalResource(UniversalContainer container, Entry entry, String resourceName) {
            this.container = container;
            this.entry = entry;
            this.resourceName = resourceName;
        }

        @Override
        public URL getResourceURL(String jarProtocol) {
            boolean pSlash;
            URL url = this.entry.getResource();
            if (url == null) {
                return null;
            }
            boolean uSlash = url.getPath().endsWith("/");
            if (uSlash == (pSlash = this.resourceName.endsWith("/"))) {
                return url;
            }
            if (uSlash) {
                return ContainerClassLoader.stripTrailingSlash(url);
            }
            return null;
        }

        @Override
        public ByteResourceInformation getByteResourceInformation(String className, ClassLoaderHook hook) throws IOException {
            boolean foundInClassCache;
            byte[] bytes = ContainerClassLoader.getClassBytesFromHook(this, className, this.resourceName, hook);
            boolean bl = foundInClassCache = bytes != null;
            if (!foundInClassCache) {
                bytes = this.getActualBytes();
            }
            return new ByteResourceInformation(bytes, this.entry.getResource(), this.container, this.resourceName, foundInClassCache, this::getActualBytes);
        }

        /*
         * WARNING - void declaration
         */
        private byte[] getActualBytes() {
            try {
                try {
                    InputStream is = (InputStream)this.entry.adapt(InputStream.class);
                    return ContainerClassLoader.getBytes(is, (int)this.entry.getSize());
                }
                catch (UnableToAdaptException is) {
                    void e;
                    FFDCFilter.processException((Throwable)is, (String)"com.ibm.ws.classloading.internal.ContainerClassLoader$EntryUniversalResource", (String)"375", (Object)this, (Object[])new Object[0]);
                    throw new IOException((Throwable)e);
                }
            }
            catch (IOException e) {
                FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.classloading.internal.ContainerClassLoader$EntryUniversalResource", (String)"378", (Object)this, (Object[])new Object[0]);
                ContainerClassLoader.sneakyThrow(e);
                return null;
            }
        }

        @Override
        public String getNativeLibraryPath() {
            try {
                NativeLibrary nl = (NativeLibrary)this.entry.adapt(NativeLibrary.class);
                if (nl != null) {
                    return nl.getLibraryFile().getPath();
                }
            }
            catch (UnableToAdaptException unableToAdaptException) {
                FFDCFilter.processException((Throwable)unableToAdaptException, (String)"com.ibm.ws.classloading.internal.ContainerClassLoader$EntryUniversalResource", (String)"390", (Object)this, (Object[])new Object[0]);
            }
            return null;
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register((String)"com.ibm.ws.classloading.internal.ContainerClassLoader$EntryUniversalResource", EntryUniversalResource.class, (String)"ClassLoadingService", (String)"com.ibm.ws.classloading.internal.resources.ClassLoadingServiceMessages");
        }
    }
}

