/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.app.manager.module.internal;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.app.manager.module.DeployedAppInfo;
import com.ibm.ws.app.manager.module.DeployedAppServices;
import com.ibm.ws.app.manager.module.DeployedModuleInfo;
import com.ibm.ws.app.manager.module.internal.ClientModuleInfoImpl;
import com.ibm.ws.app.manager.module.internal.ConnectorModuleInfoImpl;
import com.ibm.ws.app.manager.module.internal.DeployedModuleInfoImpl;
import com.ibm.ws.app.manager.module.internal.EJBModuleInfoImpl;
import com.ibm.ws.app.manager.module.internal.ExtendedModuleInfoImpl;
import com.ibm.ws.app.manager.module.internal.ModuleClassLoaderFactory;
import com.ibm.ws.app.manager.module.internal.ModuleHandler;
import com.ibm.ws.app.manager.module.internal.ModuleInfoUtils;
import com.ibm.ws.app.manager.module.internal.WebModuleInfoImpl;
import com.ibm.ws.container.service.app.deploy.ApplicationInfo;
import com.ibm.ws.container.service.app.deploy.ContainerInfo;
import com.ibm.ws.container.service.app.deploy.ManifestClassPathUtils;
import com.ibm.ws.container.service.app.deploy.ModuleClassesContainerInfo;
import com.ibm.ws.container.service.app.deploy.NestedConfigHelper;
import com.ibm.ws.container.service.app.deploy.extended.AltDDEntryGetter;
import com.ibm.ws.container.service.app.deploy.extended.ApplicationInfoFactory;
import com.ibm.ws.container.service.app.deploy.extended.ExtendedApplicationInfo;
import com.ibm.ws.container.service.app.deploy.extended.ExtendedModuleInfo;
import com.ibm.ws.container.service.app.deploy.extended.ModuleContainerInfo;
import com.ibm.ws.container.service.metadata.MetaDataException;
import com.ibm.ws.container.service.metadata.MetaDataService;
import com.ibm.ws.container.service.metadata.extended.ModuleMetaDataExtender;
import com.ibm.ws.container.service.metadata.extended.NestedModuleMetaDataFactory;
import com.ibm.ws.container.service.state.StateChangeService;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.javaee.dd.client.ApplicationClient;
import com.ibm.ws.javaee.dd.common.ModuleDeploymentDescriptor;
import com.ibm.ws.javaee.dd.connector.Connector;
import com.ibm.ws.javaee.dd.ejb.EJBJar;
import com.ibm.ws.javaee.dd.web.WebApp;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.runtime.metadata.ModuleMetaData;
import com.ibm.ws.threadContext.ModuleMetaDataAccessorImpl;
import com.ibm.ws.threading.FutureMonitor;
import com.ibm.ws.threading.listeners.CompletionListener;
import com.ibm.wsspi.adaptable.module.Container;
import com.ibm.wsspi.adaptable.module.Entry;
import com.ibm.wsspi.adaptable.module.NonPersistentCache;
import com.ibm.wsspi.adaptable.module.UnableToAdaptException;
import java.net.URL;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Dictionary;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Future;
import org.osgi.framework.BundleContext;
import org.osgi.framework.FrameworkUtil;
import org.osgi.framework.ServiceRegistration;

@TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public abstract class SimpleDeployedAppInfoBase
implements DeployedAppInfo {
    public ExtendedApplicationInfo appInfo;
    private ServiceRegistration<ApplicationInfo> appInfoRegistration;
    public final List<DeployedModuleInfoImpl> modulesDeployed = new ArrayList<DeployedModuleInfoImpl>();
    public boolean starting = false;
    public boolean started = false;
    protected final DeployedAppServices deployedAppServices;
    protected final FutureMonitor futureMonitor;
    protected final ApplicationInfoFactory appInfoFactory;
    protected final MetaDataService metaDataService;
    protected final StateChangeService stateChangeService;
    protected final ModuleClassesInfoProvider moduleClassesInfo;
    protected final List<ModuleContainerInfoBase> moduleContainerInfos = new ArrayList<ModuleContainerInfoBase>();
    protected final Map<ExtendedModuleInfo, ModuleHandler> activeModuleHandlers = new IdentityHashMap<ExtendedModuleInfo, ModuleHandler>(4);
    static final long serialVersionUID = -2685719801501752993L;
    private static final /* synthetic */ TraceComponent $$$tc$$$;

    protected SimpleDeployedAppInfoBase(DeployedAppServices deployedAppServices) throws UnableToAdaptException {
        this.deployedAppServices = deployedAppServices;
        this.futureMonitor = deployedAppServices.getFutureMonitor();
        this.appInfoFactory = deployedAppServices.getApplicationInfoFactory();
        this.metaDataService = deployedAppServices.getMetaDataService();
        this.stateChangeService = deployedAppServices.getStateChangeService();
        this.moduleClassesInfo = new ModuleClassesInfoProvider();
    }

    public void addDeployedModule(DeployedModuleInfoImpl deployedMod, List<ExtendedModuleInfo> nestedModules) {
        this.activeModuleHandlers.remove(deployedMod.getModuleInfo());
        this.modulesDeployed.add(0, deployedMod);
        if (nestedModules != null) {
            for (ExtendedModuleInfo nestedModule : nestedModules) {
                ModuleHandler moduleHandler = this.activeModuleHandlers.remove(nestedModule);
                if (moduleHandler == null) continue;
                DeployedModuleInfoImpl nestedDeployedMod = new DeployedModuleInfoImpl(moduleHandler, nestedModule);
                deployedMod.addNestedModule(nestedDeployedMod);
            }
        }
    }

    protected void registerApplicationMBean() {
    }

    protected void deregisterApplicationMBean() {
    }

    @Override
    public void moduleMetaDataCreated(ExtendedModuleInfo moduleInfo, ModuleHandler moduleHandler, ModuleMetaData mmd) {
        this.activeModuleHandlers.put(moduleInfo, moduleHandler);
    }

    @Override
    public DeployedModuleInfo getDeployedModule(ExtendedModuleInfo moduleInfo) {
        List<DeployedModuleInfoImpl> deployedModules = this.modulesDeployed;
        for (DeployedModuleInfoImpl deployedModule : deployedModules) {
            if (deployedModule.getModuleInfo() != moduleInfo) continue;
            return deployedModule;
        }
        return null;
    }

    public boolean installApp(Future<Boolean> result) {
        if (!this.preDeployApp(result)) {
            return false;
        }
        if (!this.deployModules(result)) {
            return false;
        }
        return this.postDeployApp(result);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public boolean preDeployApp(Future<Boolean> result) {
        try {
            this.metaDataService.fireApplicationMetaDataCreated(this.appInfo.getMetaData(), this.appInfo.getContainer());
        }
        catch (Throwable throwable) {
            void ex;
            FFDCFilter.processException((Throwable)throwable, (String)"com.ibm.ws.app.manager.module.internal.SimpleDeployedAppInfoBase", (String)"525", (Object)this, (Object[])new Object[]{result});
            this.uninstallApp();
            this.futureMonitor.setResult(result, (Throwable)ex);
            return false;
        }
        HashMap<URL, ModuleMetaData> mmds = new HashMap<URL, ModuleMetaData>();
        for (ModuleContainerInfoBase modInfo : this.moduleContainerInfos) {
            try {
                ModuleMetaData mmd = modInfo.createModuleMetaData((ApplicationInfo)this.appInfo, this);
                URL location = (URL)modInfo.getContainer().getURLs().iterator().next();
                mmds.put(location, mmd);
            }
            catch (Throwable mmd) {
                void ex;
                FFDCFilter.processException((Throwable)mmd, (String)"com.ibm.ws.app.manager.module.internal.SimpleDeployedAppInfoBase", (String)"537", (Object)this, (Object[])new Object[]{result});
                this.uninstallApp();
                this.futureMonitor.setResult(result, (Throwable)ex);
                return false;
            }
        }
        this.registerApplicationMBean();
        this.starting = true;
        try {
            ModuleMetaDataAccessorImpl.getModuleMetaDataAccessor().beginContext(mmds);
            this.stateChangeService.fireApplicationStarting((ApplicationInfo)this.appInfo);
        }
        catch (Throwable throwable) {
            void ex;
            FFDCFilter.processException((Throwable)throwable, (String)"com.ibm.ws.app.manager.module.internal.SimpleDeployedAppInfoBase", (String)"550", (Object)this, (Object[])new Object[]{result});
            this.uninstallApp();
            this.futureMonitor.setResult(result, (Throwable)ex);
            boolean bl = false;
            return bl;
        }
        finally {
            ModuleMetaDataAccessorImpl.getModuleMetaDataAccessor().endContext();
        }
        return true;
    }

    /*
     * WARNING - void declaration
     */
    public boolean postDeployApp(Future<Boolean> result) {
        this.started = true;
        try {
            final Hashtable<String, Object> props = new Hashtable<String, Object>();
            NestedConfigHelper config = this.appInfo.getConfigHelper();
            if (config != null) {
                props.put("service.pid", config.get("service.pid"));
                Object value = config.get("id");
                if (null != value) {
                    props.put("id", value);
                }
                if (null != (value = config.get("location"))) {
                    props.put("location", value);
                }
                if (null != (value = config.get("type"))) {
                    props.put("type", value);
                }
                this.appInfoRegistration = AccessController.doPrivileged(new PrivilegedAction<ServiceRegistration<ApplicationInfo>>(){
                    static final long serialVersionUID = -9074580803578842653L;
                    private static final /* synthetic */ TraceComponent $$$tc$$$;

                    @Override
                    public ServiceRegistration<ApplicationInfo> run() {
                        BundleContext bundleContext = FrameworkUtil.getBundle(SimpleDeployedAppInfoBase.class).getBundleContext();
                        return bundleContext.registerService(ApplicationInfo.class, (Object)SimpleDeployedAppInfoBase.this.appInfo, (Dictionary)props);
                    }

                    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
                    static {
                        $$$tc$$$ = Tr.register(1.class, (String[])new String[]{"applications", "app.manager"}, null, (String)"com.ibm.ws.app.manager.module.internal.SimpleDeployedAppInfoBase$1");
                    }
                });
            }
            this.stateChangeService.fireApplicationStarted((ApplicationInfo)this.appInfo);
        }
        catch (Throwable props) {
            void ex;
            FFDCFilter.processException((Throwable)props, (String)"com.ibm.ws.app.manager.module.internal.SimpleDeployedAppInfoBase", (String)"586", (Object)this, (Object[])new Object[]{result});
            this.uninstallApp();
            this.futureMonitor.setResult(result, (Throwable)ex);
            return false;
        }
        return true;
    }

    private boolean deployModules(Future<Boolean> result) {
        DeployModulesListener listener = new DeployModulesListener(result);
        for (ModuleContainerInfoBase modInfo : this.moduleContainerInfos) {
            DeployedModuleInfoImpl deployedMod = (DeployedModuleInfoImpl)this.getDeployedModule(modInfo.moduleInfo);
            this.futureMonitor.onCompletion(deployedMod.installModule(this, this.futureMonitor, modInfo.getType()), (CompletionListener)listener);
            if (listener.isFailed()) {
                this.uninstallApp();
                return false;
            }
            if (modInfo.nestedModules == null) continue;
            for (DeployedModuleInfoImpl nestedMod : modInfo.nestedModules) {
                nestedMod.installModule(this, null, null);
            }
        }
        return true;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public boolean uninstallApp() {
        boolean success = true;
        if (this.started) {
            try {
                this.stateChangeService.fireApplicationStopping((ApplicationInfo)this.appInfo);
            }
            catch (Throwable throwable) {
                void t;
                FFDCFilter.processException((Throwable)throwable, (String)"com.ibm.ws.app.manager.module.internal.SimpleDeployedAppInfoBase", (String)"651", (Object)this, (Object[])new Object[0]);
                FFDCFilter.processException((Throwable)t, (String)this.getClass().getName(), (String)"fireApplicationStopping", (Object)this);
                success = false;
            }
        }
        if (this.appInfoRegistration != null) {
            try {
                AccessController.doPrivileged(new PrivilegedAction<Void>(){
                    static final long serialVersionUID = -1188943148712704802L;
                    private static final /* synthetic */ TraceComponent $$$tc$$$;

                    @Override
                    public Void run() {
                        SimpleDeployedAppInfoBase.this.appInfoRegistration.unregister();
                        return null;
                    }

                    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
                    static {
                        $$$tc$$$ = Tr.register(2.class, (String[])new String[]{"applications", "app.manager"}, null, (String)"com.ibm.ws.app.manager.module.internal.SimpleDeployedAppInfoBase$2");
                    }
                });
            }
            catch (Throwable t) {
                FFDCFilter.processException((Throwable)t, (String)"com.ibm.ws.app.manager.module.internal.SimpleDeployedAppInfoBase", (String)"665", (Object)this, (Object[])new Object[0]);
                success = false;
            }
            this.appInfoRegistration = null;
        }
        List<DeployedModuleInfoImpl> deployedModules = this.modulesDeployed;
        for (DeployedModuleInfoImpl deployedModule : deployedModules) {
            if (deployedModule.getNestedModules() != null) {
                for (DeployedModuleInfoImpl nestedMod : deployedModule.getNestedModules()) {
                    nestedMod.uninstallModule();
                }
            }
            success = deployedModule.uninstallModule();
        }
        if (this.starting) {
            try {
                this.stateChangeService.fireApplicationStopped((ApplicationInfo)this.appInfo);
            }
            catch (Throwable throwable) {
                void t;
                FFDCFilter.processException((Throwable)throwable, (String)"com.ibm.ws.app.manager.module.internal.SimpleDeployedAppInfoBase", (String)"683", (Object)this, (Object[])new Object[0]);
                FFDCFilter.processException((Throwable)t, (String)this.getClass().getName(), (String)"fireApplicationStopped", (Object)this);
                success = false;
            }
        }
        this.deregisterApplicationMBean();
        if (this.appInfo != null) {
            try {
                this.metaDataService.fireApplicationMetaDataDestroyed(this.appInfo.getMetaData());
            }
            catch (Throwable t) {
                FFDCFilter.processException((Throwable)t, (String)"com.ibm.ws.app.manager.module.internal.SimpleDeployedAppInfoBase", (String)"694", (Object)this, (Object[])new Object[0]);
                FFDCFilter.processException((Throwable)t, (String)this.getClass().getName(), (String)"fireApplicationMetaDataDestroyed", (Object)this);
                success = false;
            }
            try {
                this.appInfoFactory.destroyApplicationInfo((ApplicationInfo)this.appInfo);
            }
            catch (Throwable t) {
                FFDCFilter.processException((Throwable)t, (String)"com.ibm.ws.app.manager.module.internal.SimpleDeployedAppInfoBase", (String)"701", (Object)this, (Object[])new Object[0]);
                FFDCFilter.processException((Throwable)t, (String)this.getClass().getName(), (String)"destroyApplicationInfo", (Object)this);
                success = false;
            }
        }
        return success;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
    static {
        $$$tc$$$ = Tr.register(SimpleDeployedAppInfoBase.class, (String[])new String[]{"applications", "app.manager"}, null, (String)"com.ibm.ws.app.manager.module.internal.SimpleDeployedAppInfoBase");
    }

    @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
    @InjectedFFDC
    @TraceOptions
    protected static final class ModuleClassesInfoProvider {
        private final Map<String, List<ContainerInfo>> entryContainerInfosMap = new HashMap<String, List<ContainerInfo>>();
        static final long serialVersionUID = -70332790531324534L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        protected ModuleClassesInfoProvider() {
        }

        public List<ContainerInfo> getClassesContainers(Container moduleContainer) throws UnableToAdaptException {
            Entry moduleEntry = (Entry)moduleContainer.adapt(Entry.class);
            if (moduleEntry == null) {
                return Collections.emptyList();
            }
            String entryIdentity = ManifestClassPathUtils.createEntryIdentity((Entry)moduleEntry);
            List<ContainerInfo> containerInfos = this.entryContainerInfosMap.get(entryIdentity);
            if (containerInfos == null) {
                HashSet resolved = new HashSet();
                containerInfos = new ArrayList<ContainerInfo>();
                ManifestClassPathUtils.processMFClasspath((Entry)moduleEntry, containerInfos, resolved);
                this.entryContainerInfosMap.put(entryIdentity, containerInfos);
            }
            return containerInfos;
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register(ModuleClassesInfoProvider.class, (String[])new String[]{"applications", "app.manager"}, null, (String)"com.ibm.ws.app.manager.module.internal.SimpleDeployedAppInfoBase$ModuleClassesInfoProvider");
        }
    }

    @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
    @InjectedFFDC
    @TraceOptions
    protected static abstract class ModuleContainerInfoBase
    extends ExtendedContainerInfo
    implements ModuleClassesContainerInfo,
    ModuleContainerInfo {
        public final ModuleHandler moduleHandler;
        public final List<ModuleMetaDataExtender> moduleMetaDataExtenders;
        public final List<NestedModuleMetaDataFactory> nestedModuleMetaDataFactories;
        public List<DeployedModuleInfoImpl> nestedModules;
        public String moduleName;
        public final ModuleDeploymentDescriptor moduleDD;
        public ExtendedModuleInfo moduleInfo;
        static final long serialVersionUID = 5122721995888983779L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        public abstract ExtendedModuleInfoImpl createModuleInfoImpl(ApplicationInfo var1, ModuleClassLoaderFactory var2) throws MetaDataException;

        public ModuleContainerInfoBase(ModuleHandler moduleHandler, List<ModuleMetaDataExtender> moduleMetaDataExtenders, List<NestedModuleMetaDataFactory> nestedModuleMetaDataFactories, Container moduleContainer, Entry altDDEntry, String moduleURI, ContainerInfo.Type moduleContainerType, ModuleClassLoaderFactory moduleClassLoaderFactory, ModuleClassesInfoProvider moduleClassesInfo, Class<? extends ModuleDeploymentDescriptor> moduleDDClass) throws UnableToAdaptException {
            super(moduleContainerType, moduleURI, moduleContainer, moduleClassLoaderFactory, altDDEntry);
            this.moduleHandler = moduleHandler;
            this.moduleMetaDataExtenders = moduleMetaDataExtenders;
            this.nestedModuleMetaDataFactories = nestedModuleMetaDataFactories;
            this.moduleDD = (ModuleDeploymentDescriptor)moduleContainer.adapt(moduleDDClass);
            this.moduleName = ModuleInfoUtils.getModuleName(this.moduleDD, moduleURI);
            this.classesContainerInfo.add(this);
            if (moduleClassesInfo != null) {
                this.classesContainerInfo.addAll(moduleClassesInfo.getClassesContainers(moduleContainer));
            }
        }

        public ModuleMetaData createModuleMetaData(ApplicationInfo appInfo, SimpleDeployedAppInfoBase deployedApp) throws MetaDataException {
            ModuleClassLoaderFactory classLoaderFactory = this.moduleClassLoaderFactory;
            if (classLoaderFactory == null) {
                classLoaderFactory = (ModuleClassLoaderFactory)((Object)deployedApp);
            }
            ExtendedModuleInfoImpl moduleInfoImpl = this.createModuleInfoImpl(appInfo, classLoaderFactory);
            this.moduleInfo = moduleInfoImpl;
            if (this.moduleInfo == null || this.moduleHandler == null) {
                return null;
            }
            ModuleMetaData mmd = this.moduleHandler.createModuleMetaData(this.moduleInfo, deployedApp);
            if (mmd != null) {
                moduleInfoImpl.setMetaData(mmd);
                for (NestedModuleMetaDataFactory nestedModuleMetaDataFactory : this.nestedModuleMetaDataFactories) {
                    nestedModuleMetaDataFactory.createdNestedModuleMetaData(this.moduleInfo);
                }
                ArrayList<ExtendedModuleInfo> nestedModules = null;
                for (ModuleMetaDataExtender moduleMetaDataExtender : this.moduleMetaDataExtenders) {
                    ExtendedModuleInfo nestedModule = moduleMetaDataExtender.extendModuleMetaData(this.moduleInfo);
                    if (nestedModule == null) continue;
                    if (nestedModules == null) {
                        nestedModules = new ArrayList<ExtendedModuleInfo>(2);
                    }
                    nestedModules.add(nestedModule);
                }
                DeployedModuleInfoImpl deployedModuleInfoImpl = new DeployedModuleInfoImpl(this.moduleHandler, this.moduleInfo);
                deployedApp.addDeployedModule(deployedModuleInfoImpl, nestedModules);
                this.nestedModules = deployedModuleInfoImpl.getNestedModules();
            }
            return mmd;
        }

        public String getModuleURI() {
            return this.getName();
        }

        public void setModuleName(String newModuleName) {
            this.moduleName = newModuleName;
        }

        public ClassLoader getClassLoader() {
            return this.moduleInfo.getClassLoader();
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register(ModuleContainerInfoBase.class, (String[])new String[]{"applications", "app.manager"}, null, (String)"com.ibm.ws.app.manager.module.internal.SimpleDeployedAppInfoBase$ModuleContainerInfoBase");
        }
    }

    @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
    @InjectedFFDC
    @TraceOptions
    private class DeployModulesListener
    implements CompletionListener<Boolean> {
        private final Future<Boolean> aggregateResultFuture;
        private int remaining;
        private volatile boolean aggregateResult;
        static final long serialVersionUID = -4237906293595167147L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        DeployModulesListener(Future<Boolean> aggregateResultFuture) {
            this.remaining = SimpleDeployedAppInfoBase.this.moduleContainerInfos.size();
            this.aggregateResult = true;
            this.aggregateResultFuture = aggregateResultFuture;
        }

        public synchronized void successfulCompletion(Future<Boolean> future, Boolean result) {
            this.aggregateResult &= result.booleanValue();
            if (--this.remaining == 0) {
                SimpleDeployedAppInfoBase.this.futureMonitor.setResult(this.aggregateResultFuture, (Object)this.aggregateResult);
                if (this.isFailed()) {
                    SimpleDeployedAppInfoBase.this.uninstallApp();
                }
            }
        }

        public synchronized void failedCompletion(Future<Boolean> future, Throwable t) {
            SimpleDeployedAppInfoBase.this.futureMonitor.setResult(this.aggregateResultFuture, t);
            this.aggregateResult = false;
        }

        public boolean isFailed() {
            return !this.aggregateResult;
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register(DeployModulesListener.class, (String[])new String[]{"applications", "app.manager"}, null, (String)"com.ibm.ws.app.manager.module.internal.SimpleDeployedAppInfoBase$DeployModulesListener");
        }
    }

    @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
    @InjectedFFDC
    @TraceOptions
    protected static final class WebModuleContainerInfo
    extends ModuleContainerInfoBase {
        public String contextRoot;
        public String defaultContextRoot;
        static final long serialVersionUID = 4617657913043497664L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        public WebModuleContainerInfo(ModuleHandler moduleHandler, List<ModuleMetaDataExtender> moduleMetaDataExtenders, List<NestedModuleMetaDataFactory> nestedModuleMetaDataFactories, Container moduleContainer, Entry altDDEntry, String moduleURI, ModuleClassesInfoProvider moduleClassesInfo, String contextRoot) throws UnableToAdaptException {
            this(moduleHandler, moduleMetaDataExtenders, nestedModuleMetaDataFactories, moduleContainer, altDDEntry, moduleURI, null, moduleClassesInfo, contextRoot);
        }

        public WebModuleContainerInfo(ModuleHandler moduleHandler, List<ModuleMetaDataExtender> moduleMetaDataExtenders, List<NestedModuleMetaDataFactory> nestedModuleMetaDataFactories, Container moduleContainer, Entry altDDEntry, String moduleURI, ModuleClassLoaderFactory moduleClassLoaderFactory, ModuleClassesInfoProvider moduleClassesInfo, String contextRoot) throws UnableToAdaptException {
            super(moduleHandler, moduleMetaDataExtenders, nestedModuleMetaDataFactories, moduleContainer, altDDEntry, moduleURI, ContainerInfo.Type.WEB_MODULE, moduleClassLoaderFactory, moduleClassesInfo, WebApp.class);
            this.getWebModuleClassesInfo(moduleContainer);
            this.contextRoot = contextRoot;
            this.defaultContextRoot = this.moduleName;
        }

        @Override
        public void setModuleName(String newModuleName) {
            super.setModuleName(newModuleName);
            this.defaultContextRoot = newModuleName;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public ExtendedModuleInfoImpl createModuleInfoImpl(ApplicationInfo appInfo, ModuleClassLoaderFactory classLoaderFactory) throws MetaDataException {
            try {
                WebModuleInfoImpl webModuleInfo = new WebModuleInfoImpl(appInfo, this.moduleName, this.name, this.contextRoot, this.container, this.altDDEntry, this.classesContainerInfo, classLoaderFactory);
                webModuleInfo.setDefaultContextRoot(this.defaultContextRoot);
                return webModuleInfo;
            }
            catch (UnableToAdaptException webModuleInfo) {
                void e;
                FFDCFilter.processException((Throwable)webModuleInfo, (String)"com.ibm.ws.app.manager.module.internal.SimpleDeployedAppInfoBase$WebModuleContainerInfo", (String)"374", (Object)this, (Object[])new Object[]{appInfo, classLoaderFactory});
                FFDCFilter.processException((Throwable)e, (String)this.getClass().getName(), (String)"createModuleInfo", (Object)this);
                return null;
            }
        }

        private void getWebModuleClassesInfo(Container moduleContainer) throws UnableToAdaptException {
            Container libContainer;
            Entry libEntry;
            Container classesContainer;
            ArrayList resolved = new ArrayList();
            Entry classesEntry = moduleContainer.getEntry("WEB-INF/classes");
            if (classesEntry != null && (classesContainer = (Container)classesEntry.adapt(Container.class)) != null) {
                ContainerInfo containerInfo = new ContainerInfo(){
                    static final long serialVersionUID = 7799089642659979422L;
                    private static final /* synthetic */ TraceComponent $$$tc$$$;

                    public ContainerInfo.Type getType() {
                        return ContainerInfo.Type.WEB_INF_CLASSES;
                    }

                    public String getName() {
                        return "WEB-INF/classes";
                    }

                    public Container getContainer() {
                        return classesContainer;
                    }

                    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
                    static {
                        $$$tc$$$ = Tr.register(1.class, (String[])new String[]{"applications", "app.manager"}, null, (String)"com.ibm.ws.app.manager.module.internal.SimpleDeployedAppInfoBase$WebModuleContainerInfo$1");
                    }
                };
                this.classesContainerInfo.add(containerInfo);
            }
            if ((libEntry = moduleContainer.getEntry("WEB-INF/lib")) != null && (libContainer = (Container)libEntry.adapt(Container.class)) != null) {
                for (Entry entry : libContainer) {
                    if (!entry.getName().toLowerCase().endsWith(".jar")) continue;
                    final String jarEntryName = entry.getName();
                    final Container jarContainer = (Container)entry.adapt(Container.class);
                    if (jarContainer == null) continue;
                    ContainerInfo containerInfo = new ContainerInfo(){
                        static final long serialVersionUID = 7721559457291290747L;
                        private static final /* synthetic */ TraceComponent $$$tc$$$;

                        public ContainerInfo.Type getType() {
                            return ContainerInfo.Type.WEB_INF_LIB;
                        }

                        public String getName() {
                            return "WEB-INF/lib/" + jarEntryName;
                        }

                        public Container getContainer() {
                            return jarContainer;
                        }

                        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
                        static {
                            $$$tc$$$ = Tr.register(2.class, (String[])new String[]{"applications", "app.manager"}, null, (String)"com.ibm.ws.app.manager.module.internal.SimpleDeployedAppInfoBase$WebModuleContainerInfo$2");
                        }
                    };
                    this.classesContainerInfo.add(containerInfo);
                    ManifestClassPathUtils.addCompleteJarEntryUrls((List)this.classesContainerInfo, (Entry)entry, resolved);
                }
            }
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register(WebModuleContainerInfo.class, (String[])new String[]{"applications", "app.manager"}, null, (String)"com.ibm.ws.app.manager.module.internal.SimpleDeployedAppInfoBase$WebModuleContainerInfo");
        }
    }

    @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
    @InjectedFFDC
    @TraceOptions
    protected static final class ClientModuleContainerInfo
    extends ModuleContainerInfoBase {
        final String mainClassName;
        static final long serialVersionUID = 4154739533238173565L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        public ClientModuleContainerInfo(ModuleHandler moduleHandler, List<ModuleMetaDataExtender> moduleMetaDataExtenders, List<NestedModuleMetaDataFactory> nestedModuleMetaDataFactories, Container moduleContainer, Entry altDDEntry, String moduleURI, ModuleClassLoaderFactory moduleClassLoaderFactory, ModuleClassesInfoProvider moduleClassesInfo, String mainClass) throws UnableToAdaptException {
            super(moduleHandler, moduleMetaDataExtenders, nestedModuleMetaDataFactories, moduleContainer, altDDEntry, moduleURI, ContainerInfo.Type.CLIENT_MODULE, moduleClassLoaderFactory, moduleClassesInfo, ApplicationClient.class);
            this.mainClassName = mainClass;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public ExtendedModuleInfoImpl createModuleInfoImpl(ApplicationInfo appInfo, ModuleClassLoaderFactory classLoaderFactory) throws MetaDataException {
            try {
                return new ClientModuleInfoImpl(appInfo, this.moduleName, this.name, this.container, this.altDDEntry, this.classesContainerInfo, this.mainClassName, classLoaderFactory);
            }
            catch (UnableToAdaptException unableToAdaptException) {
                void e;
                FFDCFilter.processException((Throwable)unableToAdaptException, (String)"com.ibm.ws.app.manager.module.internal.SimpleDeployedAppInfoBase$ClientModuleContainerInfo", (String)"325", (Object)this, (Object[])new Object[]{appInfo, classLoaderFactory});
                FFDCFilter.processException((Throwable)e, (String)this.getClass().getName(), (String)"createModuleInfo", (Object)this);
                return null;
            }
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register(ClientModuleContainerInfo.class, (String[])new String[]{"applications", "app.manager"}, null, (String)"com.ibm.ws.app.manager.module.internal.SimpleDeployedAppInfoBase$ClientModuleContainerInfo");
        }
    }

    @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
    @InjectedFFDC
    @TraceOptions
    protected static final class EJBModuleContainerInfo
    extends ModuleContainerInfoBase {
        static final long serialVersionUID = -6984099940248139064L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        public EJBModuleContainerInfo(ModuleHandler moduleHandler, List<ModuleMetaDataExtender> moduleMetaDataExtenders, List<NestedModuleMetaDataFactory> nestedModuleMetaDataFactories, Container moduleContainer, Entry altDDEntry, String moduleURI, ModuleClassLoaderFactory moduleClassLoaderFactory, ModuleClassesInfoProvider moduleClassesInfo) throws UnableToAdaptException {
            super(moduleHandler, moduleMetaDataExtenders, nestedModuleMetaDataFactories, moduleContainer, altDDEntry, moduleURI, ContainerInfo.Type.EJB_MODULE, moduleClassLoaderFactory, moduleClassesInfo, EJBJar.class);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public ExtendedModuleInfoImpl createModuleInfoImpl(ApplicationInfo appInfo, ModuleClassLoaderFactory classLoaderFactory) throws MetaDataException {
            try {
                return new EJBModuleInfoImpl(appInfo, this.moduleName, this.name, this.container, this.altDDEntry, this.classesContainerInfo, classLoaderFactory);
            }
            catch (UnableToAdaptException unableToAdaptException) {
                void e;
                FFDCFilter.processException((Throwable)unableToAdaptException, (String)"com.ibm.ws.app.manager.module.internal.SimpleDeployedAppInfoBase$EJBModuleContainerInfo", (String)"301", (Object)this, (Object[])new Object[]{appInfo, classLoaderFactory});
                FFDCFilter.processException((Throwable)e, (String)this.getClass().getName(), (String)"createModuleInfo", (Object)this);
                return null;
            }
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register(EJBModuleContainerInfo.class, (String[])new String[]{"applications", "app.manager"}, null, (String)"com.ibm.ws.app.manager.module.internal.SimpleDeployedAppInfoBase$EJBModuleContainerInfo");
        }
    }

    @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
    @InjectedFFDC
    @TraceOptions
    protected static final class ConnectorModuleContainerInfo
    extends ModuleContainerInfoBase {
        static final long serialVersionUID = -9210202298744996774L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        public ConnectorModuleContainerInfo(ModuleHandler moduleHandler, List<ModuleMetaDataExtender> moduleMetaDataExtenders, List<NestedModuleMetaDataFactory> nestedModuleMetaDataFactories, Container moduleContainer, Entry altDDEntry, String moduleURI, ModuleClassLoaderFactory moduleClassLoaderFactory, ModuleClassesInfoProvider moduleClassesInfo) throws UnableToAdaptException {
            super(moduleHandler, moduleMetaDataExtenders, nestedModuleMetaDataFactories, moduleContainer, altDDEntry, moduleURI, ContainerInfo.Type.RAR_MODULE, moduleClassLoaderFactory, moduleClassesInfo, Connector.class);
            this.getConnectorModuleClassesInfo(moduleContainer);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public ExtendedModuleInfoImpl createModuleInfoImpl(ApplicationInfo appInfo, ModuleClassLoaderFactory classLoaderFactory) throws MetaDataException {
            try {
                return new ConnectorModuleInfoImpl(appInfo, this.moduleName, this.name, this.container, this.altDDEntry, this.classesContainerInfo, classLoaderFactory);
            }
            catch (UnableToAdaptException unableToAdaptException) {
                void e;
                FFDCFilter.processException((Throwable)unableToAdaptException, (String)"com.ibm.ws.app.manager.module.internal.SimpleDeployedAppInfoBase$ConnectorModuleContainerInfo", (String)"245", (Object)this, (Object[])new Object[]{appInfo, classLoaderFactory});
                FFDCFilter.processException((Throwable)e, (String)this.getClass().getName(), (String)"createModuleInfo", (Object)this);
                return null;
            }
        }

        private void getConnectorModuleClassesInfo(Container moduleContainer) throws UnableToAdaptException {
            for (Entry entry : moduleContainer) {
                this.getEntryClassesInfo(entry);
            }
        }

        private void getEntryClassesInfo(Entry entry) throws UnableToAdaptException {
            if (entry.getName().toLowerCase().endsWith(".jar")) {
                final String jarEntryName = entry.getName();
                final Container jarContainer = (Container)entry.adapt(Container.class);
                ContainerInfo containerInfo = new ContainerInfo(){
                    static final long serialVersionUID = 7757684124372247255L;
                    private static final /* synthetic */ TraceComponent $$$tc$$$;

                    public ContainerInfo.Type getType() {
                        return ContainerInfo.Type.JAR_MODULE;
                    }

                    public String getName() {
                        return jarEntryName;
                    }

                    public Container getContainer() {
                        return jarContainer;
                    }

                    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
                    static {
                        $$$tc$$$ = Tr.register(1.class, (String[])new String[]{"applications", "app.manager"}, null, (String)"com.ibm.ws.app.manager.module.internal.SimpleDeployedAppInfoBase$ConnectorModuleContainerInfo$1");
                    }
                };
                this.classesContainerInfo.add(containerInfo);
                HashSet resolved = new HashSet();
                ManifestClassPathUtils.addCompleteJarEntryUrls((List)this.classesContainerInfo, (Entry)entry, resolved);
                for (Entry childEntry : jarContainer) {
                    this.getEntryClassesInfo(childEntry);
                }
            }
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register(ConnectorModuleContainerInfo.class, (String[])new String[]{"applications", "app.manager"}, null, (String)"com.ibm.ws.app.manager.module.internal.SimpleDeployedAppInfoBase$ConnectorModuleContainerInfo");
        }
    }

    @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
    @InjectedFFDC
    @TraceOptions
    protected static class ExtendedContainerInfo
    implements ContainerInfo {
        protected final ContainerInfo.Type type;
        protected final String name;
        protected final Container container;
        protected final ModuleClassLoaderFactory moduleClassLoaderFactory;
        protected final Entry altDDEntry;
        protected final List<ContainerInfo> classesContainerInfo = new ArrayList<ContainerInfo>();
        static final long serialVersionUID = 4636874131959542427L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        protected ExtendedContainerInfo(ContainerInfo.Type type, String name, Container container, ModuleClassLoaderFactory moduleClassLoaderFactory, Entry altDDEntry) {
            this.type = type;
            this.name = name;
            this.container = container;
            this.moduleClassLoaderFactory = moduleClassLoaderFactory;
            this.altDDEntry = altDDEntry;
            if (altDDEntry != null) {
                try {
                    NonPersistentCache cache = (NonPersistentCache)container.adapt(NonPersistentCache.class);
                    cache.addToCache(AltDDEntryGetter.class, (Object)new AltDDEntryGetter(){
                        static final long serialVersionUID = 3619126260756783675L;
                        private static final /* synthetic */ TraceComponent $$$tc$$$;

                        public Entry getAltDDEntry(ContainerInfo.Type type) {
                            if (type == type) {
                                return altDDEntry;
                            }
                            return null;
                        }

                        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
                        static {
                            $$$tc$$$ = Tr.register(1.class, (String[])new String[]{"applications", "app.manager"}, null, (String)"com.ibm.ws.app.manager.module.internal.SimpleDeployedAppInfoBase$ExtendedContainerInfo$1");
                        }
                    });
                }
                catch (UnableToAdaptException unableToAdaptException) {
                    FFDCFilter.processException((Throwable)unableToAdaptException, (String)"com.ibm.ws.app.manager.module.internal.SimpleDeployedAppInfoBase$ExtendedContainerInfo", (String)"115", (Object)this, (Object[])new Object[]{type, name, container, moduleClassLoaderFactory, altDDEntry});
                }
            }
        }

        public ContainerInfo.Type getType() {
            return this.type;
        }

        public String getName() {
            return this.name;
        }

        public Container getContainer() {
            return this.container;
        }

        public List<ContainerInfo> getClassesContainerInfo() {
            return this.classesContainerInfo;
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register(ExtendedContainerInfo.class, (String[])new String[]{"applications", "app.manager"}, null, (String)"com.ibm.ws.app.manager.module.internal.SimpleDeployedAppInfoBase$ExtendedContainerInfo");
        }
    }
}

