/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.token.ltpa.internal;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.Sensitive;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.ws.config.xml.nester.Nester;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.security.filemonitor.FileBasedActionable;
import com.ibm.ws.security.filemonitor.LTPAFileMonitor;
import com.ibm.ws.security.token.ltpa.LTPAConfiguration;
import com.ibm.ws.security.token.ltpa.LTPAKeyInfoManager;
import com.ibm.ws.security.token.ltpa.internal.LTPAKeyCreateTask;
import com.ibm.ws.security.token.ltpa.internal.LTPAKeysChangeNotifier;
import com.ibm.wsspi.kernel.filemonitor.FileMonitor;
import com.ibm.wsspi.kernel.service.location.WsLocationAdmin;
import com.ibm.wsspi.kernel.service.location.WsResource;
import com.ibm.wsspi.kernel.service.utils.AtomicServiceReference;
import com.ibm.wsspi.kernel.service.utils.SerializableProtectedString;
import com.ibm.wsspi.security.ltpa.TokenFactory;
import io.openliberty.checkpoint.spi.CheckpointHook;
import io.openliberty.checkpoint.spi.CheckpointPhase;
import java.io.File;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.time.ZoneOffset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.component.ComponentContext;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
public class LTPAConfigurationImpl
implements LTPAConfiguration,
FileBasedActionable {
    private static final TraceComponent tc = Tr.register(LTPAConfigurationImpl.class, (String)"Token", (String)"com.ibm.ws.security.token.ltpa.internal.resources.LTPAMessages");
    static final String KEY_LOCATION_SERVICE = "locationService";
    static final String KEY_EXECUTOR_SERVICE = "executorService";
    static final String KEY_CHANGE_SERVICE = "ltpaKeysChangeNotifier";
    static final String DEFAULT_CONFIG_LOCATION = "${server.config.dir}/resources/security/ltpa.keys";
    static final String DEFAULT_CONFIG_DIRECTORY = "${server.config.dir}/resources/security/";
    static final String DEFAULT_OUTPUT_LOCATION = "${server.output.dir}/resources/security/ltpa.keys";
    static final String KEY_AUTH_FILTER_REF = "authFilterRef";
    static final String KEY_EXP_DIFF_ALLOWED = "expirationDifferenceAllowed";
    protected static final String KEY_SERVICE_PID = "service.pid";
    private final AtomicServiceReference<WsLocationAdmin> locationService = new AtomicServiceReference("locationService");
    private final AtomicServiceReference<ExecutorService> executorService = new AtomicServiceReference("executorService");
    private final AtomicServiceReference<LTPAKeysChangeNotifier> ltpaKeysChangeNotifierService = new AtomicServiceReference("ltpaKeysChangeNotifier");
    private ServiceRegistration<LTPAConfiguration> registration = null;
    private volatile ComponentContext cc = null;
    private LTPAKeyCreateTask createTask;
    private TokenFactory factory;
    private LTPAKeyInfoManager ltpaKeyInfoManager;
    private String primaryKeyImportFile;
    private String primaryKeyImportDir;
    @Sensitive
    private String primaryKeyPassword;
    private long keyTokenExpiration;
    private long monitorInterval;
    private LTPAFileMonitor ltpaFileMonitor;
    private ServiceRegistration<FileMonitor> ltpaFileMonitorRegistration;
    private final ReentrantReadWriteLock reentrantReadWriteLock = new ReentrantReadWriteLock();
    private final ReentrantReadWriteLock.WriteLock writeLock = this.reentrantReadWriteLock.writeLock();
    private final ReentrantReadWriteLock.ReadLock readLock = this.reentrantReadWriteLock.readLock();
    private String authFilterRef;
    private long expirationDifferenceAllowed;
    private boolean monitorValidationKeysDir;
    private String updateTrigger;
    private final List<Properties> validationKeys = new ArrayList<Properties>();
    private List<Properties> configValidationKeys = null;
    private List<Properties> nonConfigValidationKeys = null;
    private final Collection<File> currentlyDeletedFiles = new HashSet<File>();
    private static final Collection<File> allKeysFiles = new HashSet<File>();
    boolean isValidationKeysFileConfigured = false;
    static final long serialVersionUID = -3777286165045727241L;

    protected void setExecutorService(ServiceReference<ExecutorService> ref) {
        this.executorService.setReference(ref);
    }

    protected void unsetExecutorService(ServiceReference<ExecutorService> ref) {
        this.executorService.unsetReference(ref);
    }

    protected void setLocationService(ServiceReference<WsLocationAdmin> reference) {
        this.locationService.setReference(reference);
    }

    protected void unsetLocationService(ServiceReference<WsLocationAdmin> reference) {
        this.locationService.unsetReference(reference);
    }

    protected void setLtpaKeysChangeNotifier(ServiceReference<LTPAKeysChangeNotifier> ref) {
        this.ltpaKeysChangeNotifierService.setReference(ref);
    }

    protected void unsetLtpaKeysChangeNotifier(ServiceReference<LTPAKeysChangeNotifier> ref) {
        this.ltpaKeysChangeNotifierService.unsetReference(ref);
    }

    protected void activate(ComponentContext context, Map<String, Object> props) {
        this.cc = context;
        this.locationService.activate(context);
        this.executorService.activate(context);
        this.ltpaKeysChangeNotifierService.activate(context);
        this.loadConfig(props);
        this.setupRuntimeLTPAInfrastructure();
        this.debugLTPAConfig();
    }

    protected void modified(Map<String, Object> props) {
        String oldKeyImportFile = this.primaryKeyImportFile;
        Long oldKeyTokenExpiration = this.keyTokenExpiration;
        Long oldMonitorInterval = this.monitorInterval;
        Long oldExpirationDifferenceAllowed = this.expirationDifferenceAllowed;
        boolean oldMonitorValidationKeysDir = this.monitorValidationKeysDir;
        String oldUpdateTrigger = this.updateTrigger;
        ArrayList<Properties> oldValidationKeys = new ArrayList<Properties>();
        oldValidationKeys.addAll(this.validationKeys);
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("oldValidationKeys: " + this.maskKeysPasswords(oldValidationKeys)), (Object[])new Object[0]);
        }
        this.loadConfig(props);
        if (this.isKeysConfigChanged(oldKeyImportFile, oldKeyTokenExpiration, oldExpirationDifferenceAllowed, oldMonitorValidationKeysDir, oldUpdateTrigger, oldValidationKeys)) {
            this.unsetFileMonitorRegistration();
            Tr.audit((TraceComponent)tc, (String)"LTPA_KEYS_TO_LOAD", (Object[])new Object[]{this.primaryKeyImportFile});
            this.setupRuntimeLTPAInfrastructure();
        } else if (this.isMonitorIntervalChanged(oldMonitorInterval)) {
            this.unsetFileMonitorRegistration();
            this.optionallyCreateFileMonitor();
        }
        this.debugLTPAConfig();
    }

    @Sensitive
    private void loadConfig(Map<String, Object> props) {
        this.primaryKeyImportFile = (String)props.get("keysFileName");
        SerializableProtectedString sps = (SerializableProtectedString)props.get("keysPassword");
        this.primaryKeyPassword = sps == null ? null : new String(sps.getChars());
        this.keyTokenExpiration = (Long)props.get("expiration");
        this.monitorInterval = (Long)props.get("monitorInterval");
        this.authFilterRef = (String)props.get(KEY_AUTH_FILTER_REF);
        this.expirationDifferenceAllowed = (Long)props.get(KEY_EXP_DIFF_ALLOWED);
        this.monitorValidationKeysDir = (Boolean)props.get("monitorValidationKeysDir");
        this.updateTrigger = (String)props.get("updateTrigger");
        Map validationKeysElements = Nester.nest(props, (String[])new String[]{"validationKeys"});
        if (!validationKeysElements.isEmpty()) {
            this.isValidationKeysFileConfigured = !((List)validationKeysElements.get("validationKeys")).isEmpty();
        }
        this.resolveActualPrimaryKeysFileLocation();
        this.configValidationKeys = this.isValidationKeysFileConfigured ? this.getConfigValidationKeys(validationKeysElements, "validationKeys", "fileName", "password", "validUntilDate") : null;
        if (this.updateTrigger.equalsIgnoreCase("disabled")) {
            if (this.monitorValidationKeysDir) {
                Tr.warning((TraceComponent)tc, (String)"LTPA_UPDATE_TRIGGER_DISABLED_AND_MONITOR_VALIDATION_KEYS_DIR_TRUE", (Object[])new Object[]{this.monitorValidationKeysDir});
            }
            if (this.monitorInterval > 0L) {
                Tr.warning((TraceComponent)tc, (String)"LTPA_UPDATE_TRIGGER_DISABLED_AND_MONITOR_INTERVAL_GREATER_THAN_ZERO", (Object[])new Object[]{this.monitorInterval});
            }
        } else if (this.updateTrigger.equalsIgnoreCase("polled")) {
            if (this.monitorValidationKeysDir && this.monitorInterval <= 0L) {
                Tr.warning((TraceComponent)tc, (String)"LTPA_UPDATE_TRIGGER_POLLED_MONITOR_VALIDATION_KEYS_DIR_TRUE_AND_MONITOR_INTERVAL_NOT_ENABLED", (Object[])new Object[]{this.monitorInterval});
            } else if (!this.monitorValidationKeysDir) {
                this.nonConfigValidationKeys = null;
            }
        }
        this.combineValidationKeys();
    }

    private void debugLTPAConfig() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("primaryKeyImportFile: " + this.primaryKeyImportFile), (Object[])new Object[0]);
            Tr.debug((TraceComponent)tc, (String)("keyTokenExpiration: " + this.keyTokenExpiration), (Object[])new Object[0]);
            Tr.debug((TraceComponent)tc, (String)("monitorInterval: " + this.monitorInterval), (Object[])new Object[0]);
            Tr.debug((TraceComponent)tc, (String)("authFilterRef: " + this.authFilterRef), (Object[])new Object[0]);
            Tr.debug((TraceComponent)tc, (String)("monitorValidationKeysDir: " + this.monitorValidationKeysDir), (Object[])new Object[0]);
            Tr.debug((TraceComponent)tc, (String)("updateTrigger: " + this.updateTrigger), (Object[])new Object[0]);
            Tr.debug((TraceComponent)tc, (String)("validationKeys: " + (this.validationKeys == null ? "Null" : this.maskKeysPasswords(this.validationKeys))), (Object[])new Object[0]);
        }
    }

    private void combineValidationKeys() {
        if (this.validationKeys != null) {
            this.validationKeys.clear();
        }
        if (this.configValidationKeys != null) {
            this.validationKeys.addAll(this.configValidationKeys);
        }
        if (this.nonConfigValidationKeys != null) {
            this.validationKeys.addAll(this.nonConfigValidationKeys);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("configured ValidationKeys: " + this.maskKeysPasswords(this.configValidationKeys)), (Object[])new Object[0]);
            Tr.debug((TraceComponent)tc, (String)("non-configured ValidationKeys: " + this.maskKeysPasswords(this.nonConfigValidationKeys)), (Object[])new Object[0]);
            Tr.debug((TraceComponent)tc, (String)("combined ValidationKeys: " + this.maskKeysPasswords(this.validationKeys)), (Object[])new Object[0]);
        }
    }

    private List<Properties> maskKeysPasswords(@Sensitive List<Properties> originalList) {
        if (originalList == null) {
            return null;
        }
        ArrayList<Properties> maskedList = new ArrayList<Properties>();
        for (Properties props : originalList) {
            Properties tempProps = new Properties();
            tempProps.putAll((Map<?, ?>)props);
            if (tempProps.getProperty("password") == null) {
                tempProps.setProperty("password", "*null*");
            } else {
                tempProps.setProperty("password", "*not null*");
            }
            maskedList.add(tempProps);
        }
        return maskedList;
    }

    @Sensitive
    private List<Properties> getNonConfiguredValidationKeys() {
        ArrayList<Properties> validationKeysInDirectory = new ArrayList<Properties>();
        Iterator<File> keysFiles = allKeysFiles.iterator();
        if (keysFiles != null) {
            while (keysFiles.hasNext()) {
                File keyFile = keysFiles.next();
                String fileName = keyFile.getName();
                String fullFileName = null;
                if (this.primaryKeyImportDir == null) {
                    Tr.debug((TraceComponent)tc, (String)"primaryKeyImportDir is null. Validation keys will not be loaded.", (Object[])new Object[0]);
                    return validationKeysInDirectory;
                }
                fullFileName = this.primaryKeyImportDir.concat(fileName);
                if (this.primaryKeyImportFile.equals(fullFileName) || this.isConfiguredValidationKeys(fullFileName)) continue;
                Properties properties = new Properties();
                properties.setProperty("fileName", fullFileName);
                properties.setProperty("password", this.primaryKeyPassword);
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("Non-configured validationKeys file name: " + fullFileName), (Object[])new Object[0]);
                }
                validationKeysInDirectory.add(properties);
            }
        }
        return validationKeysInDirectory;
    }

    private boolean isConfiguredValidationKeys(String fn) {
        if (this.configValidationKeys != null) {
            for (Properties vKeys : this.configValidationKeys) {
                if (!vKeys.getProperty("fileName").equals(fn)) continue;
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    private void resolveActualPrimaryKeysFileLocation() {
        WsResource keysFileInServerConfig2;
        if (this.isInDefaultOutputLocation() && (keysFileInServerConfig2 = ((WsLocationAdmin)this.locationService.getServiceWithException()).resolveResource(DEFAULT_CONFIG_LOCATION)) != null && keysFileInServerConfig2.exists()) {
            String expandedKeysFileInServerConfig;
            this.primaryKeyImportFile = expandedKeysFileInServerConfig = ((WsLocationAdmin)this.locationService.getServiceWithException()).resolveString(DEFAULT_CONFIG_LOCATION);
        }
        if (this.monitorValidationKeysDir || this.isValidationKeysFileConfigured) {
            try {
                this.primaryKeyImportDir = new File(this.primaryKeyImportFile).getCanonicalFile().getParent() + File.separator;
                Tr.debug((TraceComponent)tc, (String)("primaryKeyImportDir: " + this.primaryKeyImportDir), (Object[])new Object[0]);
            }
            catch (IOException keysFileInServerConfig2) {
                void e;
                FFDCFilter.processException((Throwable)keysFileInServerConfig2, (String)"com.ibm.ws.security.token.ltpa.internal.LTPAConfigurationImpl", (String)"375", (Object)this, (Object[])new Object[0]);
                Tr.debug((TraceComponent)tc, (String)"An exception occurred in resolveActualPrimaryKeysFileLocation method", (Object[])new Object[]{e});
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("primaryKeyImportDir: " + this.primaryKeyImportDir), (Object[])new Object[0]);
            Tr.debug((TraceComponent)tc, (String)("primaryKeyImportFile: " + this.primaryKeyImportFile), (Object[])new Object[0]);
        }
    }

    protected boolean isInDefaultOutputLocation() {
        String expandedKeysFileInServerOutput = ((WsLocationAdmin)this.locationService.getServiceWithException()).resolveString(DEFAULT_OUTPUT_LOCATION);
        return this.primaryKeyImportFile.equals(expandedKeysFileInServerOutput);
    }

    private void setupRuntimeLTPAInfrastructure() {
        this.optionallyCreateFileMonitor();
        this.createTask = new LTPAKeyCreateTask((WsLocationAdmin)this.locationService.getService(), this);
        this.submitTaskToCreateLTPAKeys();
    }

    private void optionallyCreateFileMonitor() {
        if (this.updateTrigger.equalsIgnoreCase("polled")) {
            if (this.monitorInterval > 0L || this.monitorValidationKeysDir) {
                this.createFileMonitor();
            }
        } else if (this.updateTrigger.equalsIgnoreCase("mbean")) {
            this.createFileMonitor();
        }
    }

    /*
     * WARNING - void declaration
     */
    private void createFileMonitor() {
        block5: {
            try {
                this.ltpaFileMonitor = new LTPAFileMonitor((FileBasedActionable)this);
                if (this.primaryKeyImportDir != null) {
                    this.setFileMonitorRegistration((ServiceRegistration<FileMonitor>)this.ltpaFileMonitor.monitorFiles(null, Arrays.asList(this.primaryKeyImportDir), Arrays.asList(this.primaryKeyImportFile), this.monitorInterval, this.updateTrigger));
                } else {
                    if (this.monitorValidationKeysDir && this.primaryKeyImportDir == null) {
                        Tr.debug((TraceComponent)tc, (String)"Since primaryKeyImportDir is null, monitor the primaryKeyImportFile, and not the directory.", (Object[])new Object[0]);
                    }
                    this.setFileMonitorRegistration((ServiceRegistration<FileMonitor>)this.ltpaFileMonitor.monitorFiles(null, null, Arrays.asList(this.primaryKeyImportFile), this.monitorInterval, this.updateTrigger));
                }
            }
            catch (Exception exception) {
                void e;
                FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.security.token.ltpa.internal.LTPAConfigurationImpl", (String)"431", (Object)this, (Object[])new Object[0]);
                if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) break block5;
                Tr.debug((TraceComponent)tc, (String)"Exception creating the LTPA file monitor.", (Object[])new Object[]{e});
            }
        }
    }

    public void performFileBasedAction(Collection<File> createdFiles, Collection<File> modifiedFiles, Collection<File> deletedFiles) {
        Collection<File> allFiles = this.getAllFiles(createdFiles, modifiedFiles, deletedFiles);
        this.processAllKeysFiles(createdFiles, modifiedFiles, deletedFiles);
        this.processValidationKeys();
        if (this.noValidationKeys()) {
            if (!deletedFiles.isEmpty()) {
                this.currentlyDeletedFiles.addAll(deletedFiles);
            }
            if (!this.isActionNeeded(createdFiles, modifiedFiles).booleanValue()) {
                return;
            }
        }
        Tr.audit((TraceComponent)tc, (String)"LTPA_KEYS_TO_LOAD", (Object[])new Object[]{this.printLTPAKeys(allFiles)});
        this.submitTaskToCreateLTPAKeys();
    }

    public void performFileBasedAction(Collection<File> baselineFiles) {
        if (!baselineFiles.isEmpty()) {
            HashSet<File> emptyCollection = new HashSet<File>();
            this.processAllKeysFiles(baselineFiles, emptyCollection, emptyCollection);
            this.processValidationKeys();
        }
    }

    private void processValidationKeys() {
        if (this.updateTrigger != null && this.monitorValidationKeysDir) {
            this.validationKeys.clear();
            this.nonConfigValidationKeys = this.getNonConfiguredValidationKeys();
            this.combineValidationKeys();
        }
    }

    private Boolean isActionNeeded(Collection<File> createdFiles, Collection<File> modifiedFiles) {
        boolean actionNeeded = false;
        for (File createdFile : createdFiles) {
            if (!this.currentlyDeletedFiles.contains(createdFile)) continue;
            this.currentlyDeletedFiles.remove(createdFile);
            actionNeeded = true;
        }
        if (!modifiedFiles.isEmpty()) {
            actionNeeded = true;
        }
        return actionNeeded;
    }

    boolean noValidationKeys() {
        return this.validationKeys == null || this.validationKeys.isEmpty();
    }

    private synchronized Collection<File> processAllKeysFiles(Collection<File> createdFiles, Collection<File> modifiedFiles, Collection<File> deletedFiles) {
        allKeysFiles.addAll(createdFiles);
        allKeysFiles.addAll(modifiedFiles);
        allKeysFiles.removeAll(deletedFiles);
        return allKeysFiles;
    }

    private Collection<File> getAllFiles(Collection<File> createdFiles, Collection<File> modifiedFiles, Collection<File> deletedFiles) {
        HashSet<File> allFiles = new HashSet<File>();
        if (!createdFiles.isEmpty()) {
            allFiles.addAll(createdFiles);
        }
        if (!modifiedFiles.isEmpty()) {
            allFiles.addAll(modifiedFiles);
        }
        if (!deletedFiles.isEmpty()) {
            allFiles.addAll(deletedFiles);
        }
        return allFiles;
    }

    private String printLTPAKeys(Collection<File> files) {
        StringBuffer strBuff = new StringBuffer();
        strBuff.append("(");
        for (File file : files) {
            strBuff.append(file);
            strBuff.append(", ");
        }
        int currentIndex = strBuff.lastIndexOf(",");
        strBuff.delete(currentIndex, currentIndex + 2);
        strBuff.append(")");
        return strBuff.toString();
    }

    private void submitTaskToCreateLTPAKeys() {
        CheckpointHook hook;
        CheckpointPhase checkpointPhase = CheckpointPhase.getPhase();
        if (checkpointPhase != CheckpointPhase.INACTIVE && checkpointPhase.addMultiThreadedHook(hook = new CheckpointHook(){
            static final long serialVersionUID = -3427890626690699476L;
            private static final /* synthetic */ TraceComponent $$$tc$$$;

            public void restore() {
                ((ExecutorService)LTPAConfigurationImpl.this.executorService.getService()).execute(LTPAConfigurationImpl.this.createTask);
            }

            @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
            static {
                $$$tc$$$ = Tr.register((String)"com.ibm.ws.security.token.ltpa.internal.LTPAConfigurationImpl$1", 1.class, (String)"Token", (String)"com.ibm.ws.security.token.ltpa.internal.resources.LTPAMessages");
            }
        })) {
            return;
        }
        ((ExecutorService)this.executorService.getService()).execute(this.createTask);
    }

    private boolean isKeysConfigChanged(String oldKeyImportFile, Long oldKeyTokenExpiration, Long oldExpirationDifferenceAllowed, boolean oldMonitorValidationKeysDir, String oldUpdateTrigger, @Sensitive List<Properties> oldValidationKeys) {
        return !oldKeyImportFile.equals(this.primaryKeyImportFile) || oldKeyTokenExpiration != this.keyTokenExpiration || oldExpirationDifferenceAllowed != this.expirationDifferenceAllowed || oldMonitorValidationKeysDir != this.monitorValidationKeysDir || oldUpdateTrigger != this.updateTrigger || this.isValidationKeysConfigured(oldValidationKeys);
    }

    private boolean isValidationKeysConfigured(@Sensitive List<Properties> oldValidationKeys) {
        return oldValidationKeys != null && !oldValidationKeys.isEmpty() || this.validationKeys != null && !this.validationKeys.isEmpty();
    }

    private boolean isMonitorIntervalChanged(Long oldMonitorInterval) {
        return oldMonitorInterval != this.monitorInterval;
    }

    protected void deactivate(ComponentContext context) {
        this.cc = null;
        if (this.registration != null) {
            this.registration.unregister();
            this.registration = null;
        }
        this.unsetFileMonitorRegistration();
        this.executorService.deactivate(context);
        this.locationService.deactivate(context);
        this.ltpaKeysChangeNotifierService.deactivate(context);
    }

    protected void unsetFileMonitorRegistration() {
        if (this.ltpaFileMonitorRegistration != null) {
            this.ltpaFileMonitorRegistration.unregister();
            this.ltpaFileMonitorRegistration = null;
        }
    }

    protected void setFileMonitorRegistration(ServiceRegistration<FileMonitor> ltpaFileMonitorRegistration) {
        this.ltpaFileMonitorRegistration = ltpaFileMonitorRegistration;
    }

    public BundleContext getBundleContext() {
        if (this.cc != null) {
            return this.cc.getBundleContext();
        }
        return null;
    }

    void setRegistration(ServiceRegistration<LTPAConfiguration> registration) {
        this.registration = registration;
    }

    void setTokenFactory(TokenFactory factory) {
        this.writeLock.lock();
        try {
            this.factory = factory;
        }
        finally {
            this.writeLock.unlock();
        }
    }

    @Override
    public TokenFactory getTokenFactory() {
        this.readLock.lock();
        try {
            TokenFactory tokenFactory = this.factory;
            return tokenFactory;
        }
        finally {
            this.readLock.unlock();
        }
    }

    void setLTPAKeyInfoManager(LTPAKeyInfoManager ltpaKeyInfoManager) {
        this.ltpaKeyInfoManager = ltpaKeyInfoManager;
    }

    @Override
    public LTPAKeyInfoManager getLTPAKeyInfoManager() {
        return this.ltpaKeyInfoManager;
    }

    @Override
    public String getPrimaryKeyFile() {
        return this.primaryKeyImportFile;
    }

    @Override
    @Sensitive
    public String getPrimaryKeyPassword() {
        return this.primaryKeyPassword;
    }

    @Override
    public long getTokenExpiration() {
        return this.keyTokenExpiration;
    }

    @Override
    public String getAuthFilterRef() {
        return this.authFilterRef;
    }

    @Override
    public long getExpirationDifferenceAllowed() {
        return this.expirationDifferenceAllowed;
    }

    protected void configReady() {
        LTPAKeysChangeNotifier notifier = this.getLTPAKeysChangeNotifier();
        if (notifier != null) {
            notifier.notifyListeners();
        }
    }

    protected LTPAKeysChangeNotifier getLTPAKeysChangeNotifier() {
        return (LTPAKeysChangeNotifier)((Object)this.ltpaKeysChangeNotifierService.getService());
    }

    @Override
    public long getMonitorInterval() {
        return this.monitorInterval;
    }

    @Override
    public boolean getMonitorValidationKeysDir() {
        return this.monitorValidationKeysDir;
    }

    @Override
    public String getUpdateTrigger() {
        return this.updateTrigger;
    }

    @Override
    @Sensitive
    public List<Properties> getValidationKeys() {
        return this.validationKeys;
    }

    @Sensitive
    public List<Properties> getConfigValidationKeys(Map<String, List<Map<String, Object>>> listOfNestedElements, String elementName, String ... attrKeys) {
        ArrayList<Properties> listOfValidationKeysProps = new ArrayList<Properties>();
        List<Map<String, Object>> listOfElementMaps = listOfNestedElements.get(elementName);
        if (listOfElementMaps != null && !listOfElementMaps.isEmpty()) {
            for (Map<String, Object> elementProps : listOfElementMaps) {
                Properties properties = this.getValidationKeysProps(elementProps, elementName, attrKeys);
                if (properties == null || properties.isEmpty()) continue;
                listOfValidationKeysProps.add(properties);
            }
        }
        return listOfValidationKeysProps;
    }

    @Sensitive
    private Properties getValidationKeysProps(Map<String, Object> configProps, String elementName, String ... attrKeys) {
        Properties properties = new Properties();
        if (this.primaryKeyImportDir == null) {
            Tr.debug((TraceComponent)tc, (String)"primaryKeyImportDir is null. Validation keys will not be loaded.", (Object[])new Object[0]);
            return properties;
        }
        for (String attrKey : attrKeys) {
            SerializableProtectedString sps;
            String value = null;
            value = attrKey.equals("password") ? ((sps = (SerializableProtectedString)configProps.get("password")) == null ? null : new String(sps.getChars())) : (String)configProps.get(attrKey);
            if (value == null || value.length() <= 0) continue;
            value = value.trim();
            if (attrKey.equals("fileName")) {
                value = this.primaryKeyImportDir.concat(value);
            }
            properties.put(attrKey, value);
        }
        if (properties.isEmpty() || properties.get("fileName") == null || properties.get("password") == null) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.error((TraceComponent)tc, (String)"LTPA_VALIDATION_KEYS_MISSING_ATTR", (Object[])new Object[]{elementName, this.printAttrKeys(attrKeys)});
            }
            return null;
        }
        if (this.isValidUntilDateExpired(configProps)) {
            return null;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("Configured validationKeys file name: " + properties.get("fileName")), (Object[])new Object[0]);
        }
        return properties;
    }

    private boolean isValidUntilDateExpired(Map<String, Object> configProps) {
        String validUntilDate = (String)configProps.get("validUntilDate");
        if (validUntilDate == null) {
            return false;
        }
        OffsetDateTime noUserAfterDateOdt = null;
        try {
            noUserAfterDateOdt = OffsetDateTime.parse(validUntilDate);
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.security.token.ltpa.internal.LTPAConfigurationImpl", (String)"899", (Object)this, (Object[])new Object[]{configProps});
            Tr.error((TraceComponent)tc, (String)"LTPA_VALIDATION_KEYS_VALID_UNTIL_DATE_INVALID_FORMAT", (Object[])new Object[]{validUntilDate, configProps.get("fileName")});
            return true;
        }
        ZoneOffset zone = noUserAfterDateOdt.getOffset();
        OffsetDateTime currentDateTime = OffsetDateTime.now(zone);
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("validUntilDate: " + noUserAfterDateOdt), (Object[])new Object[0]);
            Tr.debug((TraceComponent)tc, (String)("current date: " + currentDateTime), (Object[])new Object[0]);
        }
        if (noUserAfterDateOdt.isBefore(currentDateTime)) {
            Tr.warning((TraceComponent)tc, (String)"LTPA_VALIDATION_KEYS_VALID_UNTIL_DATE_IS_IN_THE_PAST", (Object[])new Object[]{validUntilDate, configProps.get("fileName")});
            return true;
        }
        return false;
    }

    private String printAttrKeys(String ... attrKeys) {
        StringBuffer strBuff = new StringBuffer();
        strBuff.append("(");
        for (String attrKey : attrKeys) {
            strBuff.append(attrKey);
            strBuff.append(", ");
        }
        int currentIndex = strBuff.lastIndexOf(",");
        strBuff.delete(currentIndex, currentIndex + 2);
        strBuff.append(")");
        return strBuff.toString();
    }
}

