/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ejs.j2c;

import com.ibm.ejs.j2c.J2CUtilityClass;
import com.ibm.ejs.j2c.MCWrapper;
import com.ibm.ejs.j2c.RRSNoTransactionWrapper;
import com.ibm.tx.jta.OnePhaseXAResource;
import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.ws.LocalTransaction.LocalTransactionCoordinator;
import com.ibm.ws.Transaction.UOWCoordinator;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.j2c.TranWrapper;
import com.ibm.ws.tx.embeddable.EmbeddableWebSphereTransactionManager;
import com.ibm.ws.uow.embeddable.SynchronizationRegistryUOWScope;
import jakarta.resource.ResourceException;
import jakarta.resource.spi.LocalTransaction;
import jakarta.transaction.Synchronization;
import javax.transaction.xa.XAException;
import javax.transaction.xa.XAResource;
import javax.transaction.xa.Xid;

class LocalTransactionWrapper
implements OnePhaseXAResource,
Synchronization,
TranWrapper {
    private final MCWrapper mcWrapper;
    private LocalTransaction localTransaction;
    private XAResource rrsXAResource = null;
    private boolean enlisted = false;
    private boolean registeredForSync = false;
    private boolean hasRollbackOccured = false;
    private static final TraceComponent tc = Tr.register(LocalTransactionWrapper.class, (String)"WAS.j2c", (String)"com.ibm.ws.j2c.resources.J2CAMessages");
    private String _hexString = "";
    private boolean _rrsTransactional = false;

    protected LocalTransactionWrapper(MCWrapper mcWrapper) {
        this.mcWrapper = mcWrapper;
        this._hexString = Integer.toHexString(this.hashCode());
    }

    protected void initialize() throws ResourceException {
        if (this.localTransaction == null) {
            try {
                this.localTransaction = this.mcWrapper.getManagedConnection().getLocalTransaction();
            }
            catch (ResourceException e) {
                FFDCFilter.processException((Throwable)e, (String)"com.ibm.ejs.j2c.LocalTransactionWrapper.initialize", (String)"100", (Object)this);
                Tr.error((TraceComponent)tc, (String)"FAILED_TO_OBTAIN_LOCALTRAN_J2CA0077", (Object[])new Object[]{e, this.mcWrapper.gConfigProps.cfName});
                throw e;
            }
            catch (Exception e) {
                FFDCFilter.processException((Throwable)e, (String)"com.ibm.ejs.j2c.LocalTransactionWrapper.initialize", (String)"105", (Object)this);
                String pmiName = null;
                if (this.mcWrapper != null) {
                    pmiName = this.mcWrapper.gConfigProps.cfName;
                }
                Tr.error((TraceComponent)tc, (String)"FAILED_TO_OBTAIN_LOCALTRAN_J2CA0077", (Object[])new Object[]{e, pmiName});
                ResourceException re = new ResourceException("initialize: caught Exception");
                re.initCause((Throwable)e);
                throw re;
            }
        }
    }

    public String getResourceName() {
        String nameString = null;
        nameString = this.mcWrapper.gConfigProps.getXpathId();
        return nameString;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void commit(Xid xid, boolean onePhase) throws XAException {
        block17: {
            if (tc.isEntryEnabled()) {
                Tr.entry((Object)this, (TraceComponent)tc, (String)"commit", (Object[])new Object[0]);
            }
            if (!onePhase) {
                String xPath = null;
                if (this.mcWrapper != null) {
                    xPath = this.mcWrapper.gConfigProps.getXpathId();
                }
                Tr.error((TraceComponent)tc, (String)"XA_OP_NOT_SUPPORTED_J2CA0016", (Object[])new Object[]{"commit", xid, xPath});
                XAException x = new XAException(-6);
                if (!tc.isEntryEnabled()) throw x;
                Tr.exit((Object)this, (TraceComponent)tc, (String)"commit", (Object)x);
                throw x;
            }
            boolean exceptionCaught = false;
            try {
                this.localTransaction.commit();
            }
            catch (Exception e) {
                try {
                    FFDCFilter.processException((Throwable)e, (String)"com.ibm.ejs.j2c.LocalTransactionWrapper.commit", (String)"164", (Object)this);
                    if (!this.mcWrapper.shouldBeDestroyed()) {
                        this.mcWrapper.markTransactionError();
                        Tr.error((TraceComponent)tc, (String)"XA_END_EXCP_J2CA0024", (Object[])new Object[]{"commit", xid, e, "XAException", this.mcWrapper.gConfigProps.getXpathId()});
                    }
                    exceptionCaught = true;
                    XAException xae = new XAException(8);
                    xae.initCause(e);
                    if (!tc.isEntryEnabled()) throw xae;
                    Tr.exit((Object)this, (TraceComponent)tc, (String)"commit", (Object)xae);
                    throw xae;
                }
                catch (Throwable throwable) {
                    try {
                        if (this.registeredForSync) throw throwable;
                        if (tc.isDebugEnabled()) {
                            Tr.debug((Object)this, (TraceComponent)tc, (String)"commit: calling afterCompletionCode() for cleanup", (Object[])new Object[0]);
                        }
                        this.afterCompletion(0);
                        throw throwable;
                    }
                    catch (Exception e2) {
                        if (tc.isDebugEnabled()) {
                            Tr.debug((Object)this, (TraceComponent)tc, (String)"commit: caught exception in finally block: ", (Object[])new Object[]{e2});
                        }
                        if (exceptionCaught) throw throwable;
                        XAException xae = new XAException(-7);
                        xae.initCause(e2);
                        if (!tc.isEntryEnabled()) throw xae;
                        Tr.exit((Object)this, (TraceComponent)tc, (String)"commit", (Object)xae);
                        throw xae;
                    }
                }
            }
            try {
                if (!this.registeredForSync) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug((Object)this, (TraceComponent)tc, (String)"commit: calling afterCompletionCode() for cleanup", (Object[])new Object[0]);
                    }
                    this.afterCompletion(0);
                }
            }
            catch (Exception e) {
                if (tc.isDebugEnabled()) {
                    Tr.debug((Object)this, (TraceComponent)tc, (String)"commit: caught exception in finally block: ", (Object[])new Object[]{e});
                }
                if (exceptionCaught) break block17;
                XAException xae = new XAException(-7);
                xae.initCause(e);
                if (!tc.isEntryEnabled()) throw xae;
                Tr.exit((Object)this, (TraceComponent)tc, (String)"commit", (Object)xae);
                throw xae;
            }
        }
        if (!tc.isEntryEnabled()) return;
        Tr.exit((Object)this, (TraceComponent)tc, (String)"commit");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void rollback(Xid xid) throws XAException {
        block17: {
            if (tc.isEntryEnabled()) {
                Tr.entry((Object)this, (TraceComponent)tc, (String)"rollback", (Object[])new Object[0]);
            }
            if (this.getMcWrapper().isMCAborted()) {
                Tr.exit((TraceComponent)tc, (String)"Connection was aborted. Exiting rollback.");
                return;
            }
            this.hasRollbackOccured = true;
            boolean exceptionCaught = false;
            try {
                this.localTransaction.rollback();
            }
            catch (Exception e) {
                try {
                    if (!this.mcWrapper.isMCAborted()) {
                        FFDCFilter.processException((Throwable)e, (String)this.getClass().getName(), (String)"198", (Object)this);
                    }
                    if (!this.mcWrapper.shouldBeDestroyed()) {
                        this.mcWrapper.markTransactionError();
                        Tr.error((TraceComponent)tc, (String)"XA_END_EXCP_J2CA0024", (Object[])new Object[]{"rollback", xid, e, "XAException", this.mcWrapper.gConfigProps.getXpathId()});
                    }
                    exceptionCaught = true;
                    XAException xae = new XAException(-7);
                    xae.initCause(e);
                    if (!tc.isEntryEnabled()) throw xae;
                    Tr.exit((Object)this, (TraceComponent)tc, (String)"rollback", (Object)e);
                    throw xae;
                }
                catch (Throwable throwable) {
                    try {
                        if (this.registeredForSync) throw throwable;
                        if (tc.isDebugEnabled()) {
                            Tr.debug((Object)this, (TraceComponent)tc, (String)"rollback: calling afterCompletionCode() for cleanup", (Object[])new Object[0]);
                        }
                        this.afterCompletion(0);
                        throw throwable;
                    }
                    catch (Exception e2) {
                        if (tc.isDebugEnabled()) {
                            Tr.debug((Object)this, (TraceComponent)tc, (String)"rollback: caught exception in finally block: ", (Object[])new Object[]{e2});
                        }
                        if (exceptionCaught) throw throwable;
                        XAException xae = new XAException(-7);
                        xae.initCause(e2);
                        throw xae;
                    }
                }
            }
            try {
                if (!this.registeredForSync) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug((Object)this, (TraceComponent)tc, (String)"rollback: calling afterCompletionCode() for cleanup", (Object[])new Object[0]);
                    }
                    this.afterCompletion(0);
                }
            }
            catch (Exception e) {
                if (tc.isDebugEnabled()) {
                    Tr.debug((Object)this, (TraceComponent)tc, (String)"rollback: caught exception in finally block: ", (Object[])new Object[]{e});
                }
                if (exceptionCaught) break block17;
                XAException xae = new XAException(-7);
                xae.initCause(e);
                throw xae;
            }
        }
        if (!tc.isEntryEnabled()) return;
        Tr.exit((Object)this, (TraceComponent)tc, (String)"rollback");
    }

    @Override
    public void delist() throws ResourceException {
        block14: {
            if (tc.isEntryEnabled()) {
                Tr.entry((Object)this, (TraceComponent)tc, (String)"delist", (Object[])new Object[0]);
            }
            try {
                UOWCoordinator uowCoord = this.mcWrapper.getUOWCoordinator();
                if (tc.isDebugEnabled()) {
                    Tr.debug((Object)this, (TraceComponent)tc, (String)("delisting LocalTranWrapper :" + Integer.toHexString(this.hashCode()) + " with coordinator :" + uowCoord), (Object[])new Object[0]);
                }
                if (uowCoord == null || uowCoord.isGlobal() || ((LocalTransactionCoordinator)uowCoord).isContainerResolved()) break block14;
                if (tc.isDebugEnabled()) {
                    Tr.debug((Object)this, (TraceComponent)tc, (String)("calling delistFromCleanup(OnePhaseXAResource)" + Integer.toHexString(this.hashCode())), (Object[])new Object[0]);
                }
                ((LocalTransactionCoordinator)uowCoord).delistFromCleanup((OnePhaseXAResource)this);
                if (this._rrsTransactional && this.enlisted) {
                    this.mcWrapper.delistRRSXAResource(this.rrsXAResource);
                    this.rrsXAResource = null;
                }
                this.enlisted = false;
                try {
                    if (!this.registeredForSync) {
                        if (tc.isDebugEnabled()) {
                            Tr.debug((Object)this, (TraceComponent)tc, (String)"delist: calling afterCompletionCode() for cleanup", (Object[])new Object[0]);
                        }
                        this.afterCompletion(0);
                    }
                }
                catch (Exception e) {
                    if (tc.isEntryEnabled()) {
                        Tr.exit((Object)this, (TraceComponent)tc, (String)"delist", (Object)e);
                    }
                    throw e;
                }
            }
            catch (Exception e) {
                FFDCFilter.processException((Throwable)e, (String)"com.ibm.ejs.j2c.LocalTransactionWrapper.delist", (String)"280", (Object)this);
                String pmiName = null;
                if (this.mcWrapper != null) {
                    pmiName = this.mcWrapper.gConfigProps.cfName;
                }
                Tr.error((TraceComponent)tc, (String)"DELIST_RESOURCE_EXCP_J2CA0031", (Object[])new Object[]{"delist", e, "Exception", pmiName});
                ResourceException re = new ResourceException("delist: caught Exception");
                re.initCause((Throwable)e);
                if (tc.isEntryEnabled()) {
                    Tr.exit((Object)this, (TraceComponent)tc, (String)"delist", (Object)e);
                }
                throw re;
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((Object)this, (TraceComponent)tc, (String)"delist");
        }
    }

    public void end(Xid xid, int flags) throws XAException {
        if (tc.isEntryEnabled()) {
            Tr.entry((Object)this, (TraceComponent)tc, (String)"end", (Object[])new Object[]{xid});
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((Object)this, (TraceComponent)tc, (String)"end");
        }
    }

    @Override
    public void enlist() throws ResourceException {
        if (tc.isEntryEnabled()) {
            Tr.entry((Object)this, (TraceComponent)tc, (String)"enlist", (Object[])new Object[]{this.mcWrapper.getUOWCoordinator()});
        }
        if (this.hasRollbackOccured) {
            if (tc.isEntryEnabled()) {
                Tr.exit((Object)this, (TraceComponent)tc, (String)"enlist", (Object)"It is NOT valid to continue working under a transaction that has already rolledback");
            }
            throw new ResourceException("Attempt to continue working after transaction rolledback !");
        }
        if (this.enlisted) {
            if (tc.isEntryEnabled()) {
                Tr.exit((Object)this, (TraceComponent)tc, (String)"enlist", (Object)"already enlisted");
            }
            return;
        }
        UOWCoordinator uowCoord = this.mcWrapper.getUOWCoordinator();
        if (uowCoord != null) {
            if (uowCoord.isGlobal()) {
                EmbeddableWebSphereTransactionManager tranMgr = this.mcWrapper.pm.connectorSvc.transactionManager;
                try {
                    if (this._rrsTransactional) {
                        int branchCoupling = this.mcWrapper.getCm().getResourceRefInfo().getBranchCoupling();
                        int startFlag = 0;
                        if (branchCoupling != -1 && (startFlag = this.mcWrapper.getCm().supportsBranchCoupling(branchCoupling, this.mcWrapper.get_managedConnectionFactory())) == -1) {
                            throw new ResourceException("Branch coupling attribute not implemented for this resource");
                        }
                        this.mcWrapper.enlistRRSXAResource(this.mcWrapper.getRecoveryToken(), startFlag);
                    }
                    boolean rc = false;
                    rc = tranMgr.enlistOnePhase(uowCoord, (OnePhaseXAResource)this);
                    if (!rc) {
                        Tr.error((TraceComponent)tc, (String)"BAD_RETURN_VALUE_FROM_ENLIST_J2CA0087", (Object[])new Object[]{this, this.mcWrapper.gConfigProps.cfName});
                        ResourceException x = new ResourceException("Error on enlistOnePhase");
                        if (tc.isEntryEnabled()) {
                            Tr.exit((Object)this, (TraceComponent)tc, (String)"enlist", (Object)((Object)x));
                        }
                        throw x;
                    }
                    this.mcWrapper.markLocalTransactionWrapperInUse();
                    this.enlisted = true;
                }
                catch (ResourceException e) {
                    block29: {
                        FFDCFilter.processException((Throwable)e, (String)"com.ibm.ejs.j2c.LocalTransactionWrapper.enlist", (String)"344", (Object)this);
                        Tr.error((TraceComponent)tc, (String)"ENLIST_RESOURCE_EXCP_J2CA0030", (Object[])new Object[]{"enlist", e, "Exception", this.mcWrapper.gConfigProps.cfName});
                        this.mcWrapper.markTransactionError();
                        try {
                            tranMgr.getTransaction().setRollbackOnly();
                        }
                        catch (Exception ex) {
                            FFDCFilter.processException((Throwable)ex, (String)"com.ibm.ejs.j2c.LocalTransactionWrapper.enlist", (String)"445", (Object)this);
                            if (!tc.isEventEnabled()) break block29;
                            Tr.event((Object)this, (TraceComponent)tc, (String)("Caught Exception while trying to mark transaction RollbackOnly - Exception:" + ex), (Object[])new Object[0]);
                        }
                    }
                    if (tc.isEntryEnabled()) {
                        Tr.exit((Object)this, (TraceComponent)tc, (String)"enlist", (Object)((Object)e));
                    }
                    throw e;
                }
                catch (Exception e) {
                    block30: {
                        FFDCFilter.processException((Throwable)e, (String)"com.ibm.ejs.j2c.LocalTransactionWrapper.enlist", (String)"459", (Object)this, (Object[])new Object[]{this.mcWrapper});
                        Tr.error((TraceComponent)tc, (String)"ENLIST_RESOURCE_EXCP_J2CA0030", (Object[])new Object[]{"enlist", e, "Exception", this.mcWrapper.gConfigProps.cfName});
                        this.mcWrapper.markTransactionError();
                        try {
                            tranMgr.getTransaction().setRollbackOnly();
                        }
                        catch (Exception ex) {
                            FFDCFilter.processException((Throwable)ex, (String)"com.ibm.ejs.j2c.LocalTransactionWrapper.enlist", (String)"477", (Object)this);
                            if (!tc.isEventEnabled()) break block30;
                            Tr.event((Object)this, (TraceComponent)tc, (String)("Caught Exception while trying to mark transaction RollbackOnly - Exception:" + ex), (Object[])new Object[0]);
                        }
                    }
                    ResourceException re = new ResourceException("enlist: caught Exception");
                    re.initCause((Throwable)e);
                    if (tc.isEntryEnabled()) {
                        Tr.exit((Object)this, (TraceComponent)tc, (String)"enlist", (Object)((Object)re));
                    }
                    throw re;
                }
                if (tc.isEntryEnabled()) {
                    Tr.exit((Object)this, (TraceComponent)tc, (String)"enlist");
                }
                return;
            }
            try {
                if (this._rrsTransactional) {
                    int dummyInt = -1;
                    this.rrsXAResource = this.mcWrapper.enlistRRSXAResource(dummyInt, dummyInt);
                }
                if (((LocalTransactionCoordinator)uowCoord).isContainerResolved()) {
                    ((LocalTransactionCoordinator)uowCoord).enlist((OnePhaseXAResource)this);
                } else {
                    ((LocalTransactionCoordinator)uowCoord).enlistForCleanup((OnePhaseXAResource)this);
                }
                this.mcWrapper.markLocalTransactionWrapperInUse();
                this.enlisted = true;
            }
            catch (Exception e) {
                FFDCFilter.processException((Throwable)e, (String)"com.ibm.ejs.j2c.LocalTransactionWrapper.enlist", (String)"405", (Object)this);
                this.mcWrapper.markTransactionError();
                this.mcWrapper.releaseToPoolManager();
                Tr.error((TraceComponent)tc, (String)"ENLIST_RESOURCE_EXCP_J2CA0030", (Object[])new Object[]{"enlist", e, "Exception", this.mcWrapper.gConfigProps.cfName});
                ResourceException re = new ResourceException("enlist: caught Exception");
                re.initCause((Throwable)e);
                if (tc.isEntryEnabled()) {
                    Tr.exit((Object)this, (TraceComponent)tc, (String)"enlist", (Object)e);
                }
                throw re;
            }
            if (tc.isEntryEnabled()) {
                Tr.exit((Object)this, (TraceComponent)tc, (String)"enlist", (Object)"Local Tran");
            }
            return;
        }
        Tr.error((TraceComponent)tc, (String)"NO_VALID_TRANSACTION_CONTEXT_J2CA0040", (Object[])new Object[]{"enlist", null, this.mcWrapper.gConfigProps.cfName});
        ResourceException x = new ResourceException("INTERNAL ERROR: No valid transaction context present");
        if (tc.isEntryEnabled()) {
            Tr.exit((Object)this, (TraceComponent)tc, (String)"enlist", (Object)((Object)x));
        }
        throw x;
    }

    public void forget(Xid xid) throws XAException {
        if (tc.isEntryEnabled()) {
            Tr.entry((Object)this, (TraceComponent)tc, (String)"forget", (Object[])new Object[0]);
        }
        String xPath = null;
        if (this.mcWrapper != null) {
            xPath = this.mcWrapper.gConfigProps.getXpathId();
        }
        Tr.error((TraceComponent)tc, (String)"XA_OP_NOT_SUPPORTED_J2CA0016", (Object[])new Object[]{"forget", xid, xPath});
        if (tc.isEntryEnabled()) {
            Tr.exit((Object)this, (TraceComponent)tc, (String)"forget");
        }
        throw new XAException(-6);
    }

    public boolean isSameRM(XAResource xares) throws XAException {
        if (tc.isEntryEnabled()) {
            Tr.entry((Object)this, (TraceComponent)tc, (String)"isSameRM", (Object[])new Object[0]);
        }
        String pmiName = null;
        if (this.mcWrapper != null) {
            pmiName = this.mcWrapper.gConfigProps.cfName;
        }
        Tr.error((TraceComponent)tc, (String)"XA_OPERATION_NOT_SUPPORTED_J2CA0023", (Object[])new Object[]{"isSameRM", pmiName});
        if (tc.isEntryEnabled()) {
            Tr.exit((Object)this, (TraceComponent)tc, (String)"isSameRM");
        }
        return false;
    }

    public int prepare(Xid xid) throws XAException {
        if (tc.isEntryEnabled()) {
            Tr.entry((Object)this, (TraceComponent)tc, (String)"prepare", (Object[])new Object[0]);
        }
        if (!this.mcWrapper.isStale()) {
            Tr.error((TraceComponent)tc, (String)"XA_OPERATION_NOT_SUPPORTED_J2CA0023", (Object[])new Object[]{"prepare", this.mcWrapper.gConfigProps.cfName});
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((Object)this, (TraceComponent)tc, (String)"prepare");
        }
        throw new XAException(-6);
    }

    public Xid[] recover(int flags) throws XAException {
        if (tc.isEntryEnabled()) {
            Tr.entry((Object)this, (TraceComponent)tc, (String)"recover", (Object[])new Object[0]);
        }
        String pmiName = null;
        if (this.mcWrapper != null) {
            pmiName = this.mcWrapper.gConfigProps.cfName;
        }
        Tr.error((TraceComponent)tc, (String)"XA_OPERATION_NOT_SUPPORTED_J2CA0023", (Object[])new Object[]{"recover", pmiName});
        if (tc.isEntryEnabled()) {
            Tr.exit((Object)this, (TraceComponent)tc, (String)"recover");
        }
        throw new XAException(-6);
    }

    public void start(Xid xid, int flag) throws XAException {
        if (tc.isEntryEnabled()) {
            Tr.entry((Object)this, (TraceComponent)tc, (String)"start", (Object[])new Object[0]);
        }
        try {
            this.localTransaction.begin();
        }
        catch (Exception e) {
            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ejs.j2c.LocalTransactionWrapper.start", (String)"464", (Object)this);
            if (!this.mcWrapper.shouldBeDestroyed()) {
                this.mcWrapper.markTransactionError();
                Tr.error((TraceComponent)tc, (String)"XA_END_EXCP_J2CA0024", (Object[])new Object[]{"start", "begin", e, "XAException", this.mcWrapper.gConfigProps.getXpathId()});
            }
            XAException xae = new XAException(-7);
            xae.initCause(e);
            if (tc.isEntryEnabled()) {
                Tr.exit((Object)this, (TraceComponent)tc, (String)"start", (Object)e);
            }
            throw xae;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((Object)this, (TraceComponent)tc, (String)"start");
        }
    }

    public int getTransactionTimeout() throws XAException {
        if (tc.isEntryEnabled()) {
            Tr.entry((Object)this, (TraceComponent)tc, (String)"getTransactionTimeout", (Object[])new Object[0]);
        }
        String pmiName = null;
        if (this.mcWrapper != null) {
            pmiName = this.mcWrapper.gConfigProps.cfName;
        }
        Tr.error((TraceComponent)tc, (String)"XA_OPERATION_NOT_SUPPORTED_J2CA0023", (Object[])new Object[]{"getTransactonTimeout", pmiName});
        if (tc.isEntryEnabled()) {
            Tr.exit((Object)this, (TraceComponent)tc, (String)"getTransactionTimeout");
        }
        return -1;
    }

    public boolean setTransactionTimeout(int seconds) throws XAException {
        if (tc.isEntryEnabled()) {
            Tr.entry((Object)this, (TraceComponent)tc, (String)"setTransactionTimeout", (Object[])new Object[0]);
        }
        String pmiName = null;
        if (this.mcWrapper != null) {
            pmiName = this.mcWrapper.gConfigProps.cfName;
        }
        Tr.error((TraceComponent)tc, (String)"XA_OPERATION_NOT_SUPPORTED_J2CA0023", (Object[])new Object[]{"setTransactionTimeout", pmiName});
        if (tc.isEntryEnabled()) {
            Tr.exit((Object)this, (TraceComponent)tc, (String)"setTransactionTimeout");
        }
        return false;
    }

    public void cleanup() {
        this.enlisted = false;
    }

    public void releaseResources() {
        this.localTransaction = null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean addSync() throws ResourceException {
        block19: {
            if (tc.isEntryEnabled()) {
                Tr.entry((Object)this, (TraceComponent)tc, (String)"addSync", (Object[])new Object[0]);
            }
            try {
                UOWCoordinator uowCoord = this.mcWrapper.getUOWCoordinator();
                if (uowCoord == null) {
                    Tr.error((TraceComponent)tc, (String)"NO_VALID_TRANSACTION_CONTEXT_J2CA0040", (Object[])new Object[]{"addSync", null, this.mcWrapper.gConfigProps.cfName});
                    throw new ResourceException("INTERNAL ERROR: No valid transaction context present");
                }
                if (uowCoord.isGlobal()) {
                    if (this.mcWrapper.isConnectionSynchronizationProvider()) {
                        throw new UnsupportedOperationException("com.ibm.ws.Transaction.SynchronizationProvider");
                    }
                    if (this.mcWrapper.isEnlistmentDisabled()) {
                        if (tc.isDebugEnabled()) {
                            Tr.debug((Object)this, (TraceComponent)tc, (String)"Managed connection isEnlistmentDisabled is true.", (Object[])new Object[0]);
                            Tr.debug((Object)this, (TraceComponent)tc, (String)"Returning without registering.", (Object[])new Object[0]);
                        }
                        if (tc.isEntryEnabled()) {
                            Tr.exit((Object)this, (TraceComponent)tc, (String)"addSync", (Object)false);
                        }
                        return false;
                    }
                    EmbeddableWebSphereTransactionManager tranMgr = this.mcWrapper.pm.connectorSvc.transactionManager;
                    tranMgr.registerSynchronization(uowCoord, (Synchronization)this);
                    this.mcWrapper.markLocalTransactionWrapperInUse();
                    this.registeredForSync = true;
                    break block19;
                }
                boolean shareable = this.mcWrapper.getConnectionManager().shareable();
                if (!shareable && !J2CUtilityClass.isContainerAtBoundary(this.mcWrapper.pm.connectorSvc.transactionManager)) {
                    if (this.isRRSTransactional()) {
                        ((SynchronizationRegistryUOWScope)uowCoord).registerInterposedSynchronization((Synchronization)new RRSNoTransactionWrapper());
                        break block19;
                    } else {
                        if (tc.isEntryEnabled()) {
                            Tr.exit((Object)this, (TraceComponent)tc, (String)"addSync", (Object)"returning without registering");
                        }
                        return false;
                    }
                }
                if (this.mcWrapper.isConnectionSynchronizationProvider()) {
                    throw new UnsupportedOperationException("com.ibm.ws.Transaction.SynchronizationProvider");
                }
                if (this.mcWrapper.isEnlistmentDisabled()) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug((Object)this, (TraceComponent)tc, (String)"Managed connection isEnlistmentDisabled is true.", (Object[])new Object[0]);
                        Tr.debug((Object)this, (TraceComponent)tc, (String)"Returning without registering.", (Object[])new Object[0]);
                    }
                    if (tc.isEntryEnabled()) {
                        Tr.exit((Object)this, (TraceComponent)tc, (String)"addSync", (Object)false);
                    }
                    return false;
                }
                ((SynchronizationRegistryUOWScope)uowCoord).registerInterposedSynchronization((Synchronization)this);
                this.mcWrapper.markLocalTransactionWrapperInUse();
                this.registeredForSync = true;
            }
            catch (ResourceException e) {
                FFDCFilter.processException((Throwable)e, (String)"com.ibm.ejs.j2c.LocalTransactionWrapper.addSync", (String)"594", (Object)this);
                Tr.error((TraceComponent)tc, (String)"REGISTER_WITH_SYNCHRONIZATION_EXCP_J2CA0026", (Object[])new Object[]{"addSync", e, "Exception"});
                throw e;
            }
            catch (Exception e) {
                FFDCFilter.processException((Throwable)e, (String)"com.ibm.ejs.j2c.LocalTransactionWrapper.addSync", (String)"605", (Object)this);
                Tr.error((TraceComponent)tc, (String)"REGISTER_WITH_SYNCHRONIZATION_EXCP_J2CA0026", (Object[])new Object[]{"addSync", e, "Exception"});
                ResourceException re = new ResourceException("addSync: caught Exception");
                re.initCause((Throwable)e);
                throw re;
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((Object)this, (TraceComponent)tc, (String)"addSync", (Object)this.registeredForSync);
        }
        return this.registeredForSync;
    }

    public void afterCompletion(int status) {
        boolean shareable;
        if (tc.isEntryEnabled()) {
            Tr.entry((Object)this, (TraceComponent)tc, (String)"afterCompletion", (Object[])new Object[0]);
        }
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("Using transaction wrapper@" + Integer.toHexString(this.hashCode())), (Object[])new Object[0]);
        }
        if (this.mcWrapper.isMCAborted()) {
            Tr.exit((TraceComponent)tc, (String)"Connection was aborted. Exiting afterCompletion.");
            return;
        }
        this.registeredForSync = false;
        this.hasRollbackOccured = false;
        this.mcWrapper.transactionComplete();
        if (tc.isDebugEnabled() && this.mcWrapper.getHandleCount() != 0) {
            Tr.debug((Object)this, (TraceComponent)tc, (String)("Information:  handle not closed at end of UOW. Connection from pool " + this.mcWrapper.gConfigProps.getXpathId()), (Object[])new Object[0]);
        }
        if ((shareable = this.mcWrapper.getConnectionManager().shareable()) || !shareable && this.mcWrapper.getHandleCount() == 0 || this.mcWrapper.isStale()) {
            if (tc.isDebugEnabled()) {
                Tr.debug((Object)this, (TraceComponent)tc, (String)("Releasing the connection to the pool. shareable = " + shareable + "  handleCount = " + this.mcWrapper.getHandleCount() + "  isStale = " + this.mcWrapper.isStale()), (Object[])new Object[0]);
            }
            try {
                this.mcWrapper.releaseToPoolManager();
            }
            catch (Exception e) {
                FFDCFilter.processException((Throwable)e, (String)"com.ibm.ejs.j2c.LocalTransactionWrapper.afterCompletion", (String)"711", (Object)this);
                if (tc.isDebugEnabled()) {
                    Tr.debug((Object)this, (TraceComponent)tc, (String)("afterCompletionCode for datasource " + this.mcWrapper.gConfigProps.cfName + ":  caught Exception"), (Object[])new Object[]{e});
                }
            }
        } else {
            this.mcWrapper.setUOWCoordinator(null);
            this.enlisted = false;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((Object)this, (TraceComponent)tc, (String)"afterCompletion");
        }
    }

    public void beforeCompletion() {
        if (tc.isEntryEnabled()) {
            Tr.entry((Object)this, (TraceComponent)tc, (String)"beforeCompletion", (Object[])new Object[0]);
            Tr.exit((Object)this, (TraceComponent)tc, (String)"beforeCompletion");
        }
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append("LocalTransactionWrapper@:");
        buf.append(this._hexString);
        buf.append("  localTransaction:");
        buf.append(this.localTransaction);
        buf.append("  enlisted:");
        buf.append(this.enlisted);
        buf.append("Has Tran Rolled Back = ");
        buf.append(this.hasRollbackOccured);
        buf.append("  registeredForSync");
        buf.append(this.registeredForSync);
        buf.append("mcWrapper.hashcode()");
        buf.append(this.mcWrapper.hashCode());
        return buf.toString();
    }

    public MCWrapper getMcWrapper() {
        return this.mcWrapper;
    }

    @Override
    public boolean isRRSTransactional() {
        return this._rrsTransactional;
    }

    protected void setRRSTransactional(boolean rrsTransactional) {
        this._rrsTransactional = rrsTransactional;
    }

    public boolean isEnlisted() {
        return this.enlisted;
    }

    public boolean isRegisteredForSync() {
        return this.registeredForSync;
    }
}

