/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.transaction.services;

import com.ibm.tx.config.ConfigurationProvider;
import com.ibm.tx.config.RuntimeMetaDataProvider;
import com.ibm.tx.jta.config.DefaultConfigurationProvider;
import com.ibm.tx.jta.embeddable.TransactionSettingsProvider;
import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.ManualTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.websphere.ras.annotation.Trivial;
import com.ibm.ws.Transaction.JTA.Util;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.kernel.launch.service.ForcedServerStop;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.transaction.services.LibertyRuntimeMetaDataProvider;
import com.ibm.ws.transaction.services.TMRecoveryService;
import com.ibm.ws.transaction.services.TransactionManagerService;
import com.ibm.wsspi.kernel.service.location.WsLocationAdmin;
import com.ibm.wsspi.kernel.service.location.WsResource;
import com.ibm.wsspi.kernel.service.utils.AtomicServiceReference;
import com.ibm.wsspi.kernel.service.utils.ConcurrentServiceReferenceSet;
import com.ibm.wsspi.resource.ResourceFactory;
import io.openliberty.checkpoint.spi.CheckpointPhase;
import java.io.File;
import java.security.AccessController;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.locks.Condition;
import java.util.logging.Level;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleException;
import org.osgi.framework.ServiceReference;
import org.osgi.service.component.ComponentContext;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class JTMConfigurationProvider
extends DefaultConfigurationProvider
implements ConfigurationProvider {
    private static final TraceComponent tc = Tr.register(JTMConfigurationProvider.class, (String)"transaction", (String)"com.ibm.ws.transaction.services.TransactionMessages");
    private WsLocationAdmin locationService;
    private RuntimeMetaDataProvider _runtimeMetaDataProvider;
    private volatile Map<String, Object> _props;
    ComponentContext _cc;
    private static String logDir;
    private static final String defaultLogDir = "$(server.output.dir)/tranlog";
    private boolean activateHasBeenCalled;
    private boolean _dataSourceFactorySet;
    private static boolean _frameworkShutting;
    private final ConcurrentServiceReferenceSet<TransactionSettingsProvider> _transactionSettingsProviders = new ConcurrentServiceReferenceSet("transactionSettingsProvider");
    private static final AtomicServiceReference<ResourceFactory> dataSourceFactoryRef;
    private static final int HEURISTIC_RETRY_INTERVAL_DEFAULT = 60;
    private static boolean _isSQLRecoveryLog;
    private ResourceFactory _theDataSourceFactory;
    private String _recoveryIdentity;
    private String _recoveryGroup;
    private TransactionManagerService tmsRef;
    private byte[] _applId;
    private boolean _setRetriableSqlcodes;
    private boolean _setNonRetriableSqlcodes;
    List<Integer> retriableSqlCodeList;
    List<Integer> nonRetriableSqlCodeList;
    private boolean _recoveryIDisSanitary;
    private volatile ServiceReference<Condition> _runningCondition = null;
    static final long serialVersionUID = -4186280861825206284L;

    @Trivial
    public JTMConfigurationProvider() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void activate(ComponentContext cc) {
        Object key;
        this._runtimeMetaDataProvider = new LibertyRuntimeMetaDataProvider(this);
        this.activateHasBeenCalled = true;
        this._transactionSettingsProviders.activate(cc);
        this._cc = cc;
        String _prevLogDir = logDir;
        if (this.checkpointRestoreBeforeRunningCondition()) {
            logDir = null;
        }
        Dictionary props = cc.getProperties();
        Map properties = new HashMap();
        Enumeration keys = props.keys();
        while (keys.hasMoreElements()) {
            key = (String)keys.nextElement();
            properties.put((String)key, props.get(key));
        }
        properties = Collections.unmodifiableMap(properties);
        key = this;
        synchronized (key) {
            this._props = properties;
        }
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("activate  properties set to " + this._props), (Object[])new Object[0]);
        }
        this.checkDataSourceRef();
        if (_isSQLRecoveryLog) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"activate  working with Tran Log in an RDBMS", (Object[])new Object[0]);
            }
            ServiceReference serviceRef = dataSourceFactoryRef.getReference();
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("pre-activate  datasourceFactory ref " + dataSourceFactoryRef + ", underlying reference: " + serviceRef), (Object[])new Object[0]);
            }
            dataSourceFactoryRef.activate(this._cc);
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("post-activate  datasourceFactory ref " + dataSourceFactoryRef), (Object[])new Object[0]);
            }
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("retrieved datasourceFactory service ref " + serviceRef), (Object[])new Object[0]);
            }
            if (serviceRef != null && this.isStartupEnabled()) {
                this.tmsRef.doStartup(this, _isSQLRecoveryLog);
            }
        } else {
            this.getTransactionLogDirectory();
            if (this.checkpointRestoreBeforeRunningCondition() && !logDir.equals(_prevLogDir) && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("logDir changed in checkpoint restore. Ignore previous logDir " + _prevLogDir), (Object[])new Object[0]);
            }
            if (this.isStartupEnabled()) {
                this.tmsRef.doStartup(this, _isSQLRecoveryLog);
            }
        }
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("activate  retrieved datasourceFactory is " + this._theDataSourceFactory), (Object[])new Object[0]);
        }
        this._setRetriableSqlcodes = false;
        this._setNonRetriableSqlcodes = false;
    }

    private boolean isStartupEnabled() {
        if (this._cc == null || this.tmsRef == null) {
            return false;
        }
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("Checkpoint phase: " + CheckpointPhase.getPhase() + ", restored: " + CheckpointPhase.getPhase().restored()), (Object[])new Object[0]);
        }
        return true;
    }

    protected void deactivate(int reason, ComponentContext cc, Map<String, Object> properties) {
        this._transactionSettingsProviders.deactivate(cc);
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"deactivate", (Object[])new Object[0]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void modified(Map<String, Object> newProperties) {
        Map<String, Object> newProps = Collections.unmodifiableMap(new HashMap<String, Object>(newProperties));
        JTMConfigurationProvider jTMConfigurationProvider = this;
        synchronized (jTMConfigurationProvider) {
            this._props = newProps;
        }
        this._setRetriableSqlcodes = false;
        this._setNonRetriableSqlcodes = false;
    }

    @Trivial
    protected synchronized void setLocationService(WsLocationAdmin locSvc) {
        this.locationService = locSvc;
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"setLocationService {0}", (Object[])new Object[]{locSvc});
        }
    }

    protected synchronized void unsetLocationService(WsLocationAdmin locSvc) {
        if (locSvc == this.locationService) {
            this.locationService = null;
        }
    }

    protected void setDataSourceFactory(ServiceReference<ResourceFactory> ref) {
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("pre-setReference  datasourceFactory ref " + dataSourceFactoryRef), (Object[])new Object[0]);
        }
        dataSourceFactoryRef.setReference(ref);
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("post-setReference  datasourceFactory ref " + dataSourceFactoryRef), (Object[])new Object[0]);
        }
        this._dataSourceFactorySet = true;
        if (!this.activateHasBeenCalled && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"setDataSourceFactory has been called before activate", (Object[])new Object[0]);
        }
        if (this._cc != null) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"setDataSourceFactory and activate have been called, initiate recovery", (Object[])new Object[0]);
            }
            if (this.isStartupEnabled()) {
                this.tmsRef.doStartup(this, _isSQLRecoveryLog);
            }
        }
    }

    @Trivial
    protected void unsetDataSourceFactory(ServiceReference<ResourceFactory> ref) {
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("unsetDataSourceFactory, ref " + ref), (Object[])new Object[0]);
        }
        if (this.tmsRef != null) {
            this.tmsRef.doShutdown(_isSQLRecoveryLog);
        }
        dataSourceFactoryRef.unsetReference(ref);
    }

    public ConcurrentServiceReferenceSet<TransactionSettingsProvider> getTransactionSettingsProviders() {
        return this._transactionSettingsProviders;
    }

    protected void setTransactionSettingsProvider(ServiceReference<TransactionSettingsProvider> ref) {
        this._transactionSettingsProviders.addReference(ref);
    }

    protected void unsetTransactionSettingsProvider(ServiceReference<TransactionSettingsProvider> ref) {
        this._transactionSettingsProviders.removeReference(ref);
    }

    @Trivial
    public int getClientInactivityTimeout() {
        Number num = (Number)this._props.get("clientInactivityTimeout");
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"getClientInactivityTimeout: {0}", (Object[])new Object[]{num});
        }
        return num.intValue();
    }

    @Trivial
    public int getHeuristicRetryInterval() {
        int wait;
        int interval = ((Number)this._props.get("heuristicRetryInterval")).intValue();
        if (interval == 60 && (wait = ((Number)this._props.get("heuristicRetryWait")).intValue()) != 60) {
            interval = wait;
        }
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"getHeuristicRetryInterval: {0}", (Object[])new Object[]{interval});
        }
        return interval;
    }

    @Trivial
    public int getHeuristicRetryLimit() {
        Number num = (Number)this._props.get("heuristicRetryLimit");
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"getHeuristicRetryLimit: {0}", (Object[])new Object[]{num});
        }
        return num.intValue();
    }

    @Trivial
    public int getMaximumTransactionTimeout() {
        Number num = (Number)this._props.get("propogatedOrBMTTranLifetimeTimeout");
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"getMaximumTransactionTimeout: {0}", (Object[])new Object[]{num});
        }
        return num.intValue();
    }

    @Trivial
    public int getTotalTransactionLifetimeTimeout() {
        Number num = (Number)this._props.get("totalTranLifetimeTimeout");
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"getTotalTransactionLifetimeTimeout: {0}", (Object[])new Object[]{num});
        }
        return num.intValue();
    }

    @Trivial
    public Level getTraceLevel() {
        return tc.getLoggerLevel();
    }

    @Trivial
    public String getTransactionLogDirectory() {
        if (logDir == null) {
            logDir = this.parseTransactionLogDirectory();
        }
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"getTransactionLogDirectory {0}", (Object[])new Object[]{logDir});
        }
        return logDir;
    }

    @Trivial
    public String getLeaseCheckStrategy() {
        return (String)this._props.get("leaseCheckStrategy");
    }

    @Trivial
    public String getBackendURL() {
        return (String)this._props.get("backendURL");
    }

    @Trivial
    public int getLeaseCheckInterval() {
        Number num = (Number)this._props.get("leaseCheckInterval");
        return num.intValue();
    }

    @Trivial
    public int getLeaseLength() {
        Number num = (Number)this._props.get("leaseLength");
        return num.intValue();
    }

    @Trivial
    public int getLeaseRenewalThreshold() {
        Number num = (Number)this._props.get("leaseRenewalThreshold");
        return num.intValue();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Trivial
    public String getServerName() {
        String serverName = "";
        JTMConfigurationProvider jTMConfigurationProvider = this;
        synchronized (jTMConfigurationProvider) {
            if (this.locationService != null) {
                serverName = this.locationService.getServerName();
            }
        }
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"getServerName {0}", (Object[])new Object[]{serverName});
        }
        return serverName;
    }

    public String getHeuristicCompletionDirectionAsString() {
        return (String)this._props.get("lpsHeuristicCompletion");
    }

    public int getHeuristicCompletionDirection() {
        String hcd = this.getHeuristicCompletionDirectionAsString();
        if ("COMMIT".equalsIgnoreCase(hcd)) {
            return 0;
        }
        if ("MANUAL".equalsIgnoreCase(hcd)) {
            return 2;
        }
        return 1;
    }

    @Trivial
    public int getTransactionLogSize() {
        return (Integer)this._props.get("transactionLogSize");
    }

    public int getDefaultMaximumShutdownDelay() {
        Number num = (Number)this._props.get("defaultMaxShutdownDelay");
        return num.intValue();
    }

    public boolean isLoggingForHeuristicReportingEnabled() {
        return (Boolean)this._props.get("enableLoggingForHeuristicReporting");
    }

    @Trivial
    public boolean isAcceptHeuristicHazard() {
        Boolean ahh = (Boolean)this._props.get("acceptHeuristicHazard");
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"isAcceptHeuristicHazard {0}", (Object[])new Object[]{ahh});
        }
        return ahh;
    }

    @Trivial
    public boolean isRecoverOnStartup() {
        Boolean isRoS = (Boolean)this._props.get("recoverOnStartup");
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"isRecoverOnStartup {0}", (Object[])new Object[]{isRoS});
        }
        if (isRoS.booleanValue()) {
            if (this.checkpointAtBeforeAppStart() && this.isSQLRecoveryLog()) {
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"Disable recoverOnStartup during checkpoint at beforeAppStart for SQL recovery log", (Object[])new Object[0]);
                }
                return false;
            }
            if (this.checkpointRestoreBeforeRunningCondition()) {
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"Disable recoverOnStartup during restore until config updates complete", (Object[])new Object[0]);
                }
                return false;
            }
        }
        return isRoS;
    }

    public boolean isShutdownOnLogFailure() {
        Boolean isSoLF = (Boolean)this._props.get("shutdownOnLogFailure");
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("isShutdownOnLogFailure set to " + isSoLF), (Object[])new Object[0]);
        }
        if (isSoLF.booleanValue() && this.checkpoint()) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Disable shutdownOnLogFailure during checkpoint", (Object[])new Object[0]);
            }
            return false;
        }
        return isSoLF;
    }

    @Trivial
    public boolean isOnePCOptimization() {
        Boolean is1PC = (Boolean)this._props.get("OnePCOptimization");
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"OnePCOptimization set to {0}", (Object[])new Object[]{is1PC});
        }
        return is1PC;
    }

    @Trivial
    public boolean isForcePrepare() {
        Boolean forcePrepare = (Boolean)this._props.get("forcePrepare");
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"forcePrepare set to {0}", (Object[])new Object[]{forcePrepare});
        }
        return forcePrepare;
    }

    @Trivial
    public boolean isWaitForRecovery() {
        Boolean isWfR = (Boolean)this._props.get("waitForRecovery");
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"isWaitForRecovery {0}", (Object[])new Object[]{isWfR});
        }
        return isWfR;
    }

    /*
     * WARNING - void declaration
     */
    public ResourceFactory getResourceFactory() {
        block3: {
            try {
                this._theDataSourceFactory = (ResourceFactory)dataSourceFactoryRef.getServiceWithException();
            }
            catch (Exception exception) {
                void ex;
                FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.transaction.services.JTMConfigurationProvider", (String)"542", (Object)((Object)this), (Object[])new Object[0]);
                if (!tc.isDebugEnabled()) break block3;
                Tr.debug((TraceComponent)tc, (String)("getResourceFactory returned exc - " + ex), (Object[])new Object[0]);
            }
        }
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("getResourceFactory has factory " + this._theDataSourceFactory), (Object[])new Object[0]);
        }
        return this._theDataSourceFactory;
    }

    @Trivial
    public RuntimeMetaDataProvider getRuntimeMetaDataProvider() {
        return this._runtimeMetaDataProvider;
    }

    @Trivial
    public String getRecoveryIdentity() {
        if (!this._recoveryIDisSanitary) {
            this._recoveryIdentity = (String)this._props.get("recoveryIdentity");
            if (this._recoveryIdentity != null) {
                this._recoveryIdentity = this._recoveryIdentity.replaceAll("\\W", "");
            }
            this._recoveryIDisSanitary = true;
        }
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"getRecoveryIdentity {0}", (Object[])new Object[]{this._recoveryIdentity});
        }
        return this._recoveryIdentity;
    }

    @Trivial
    public String getRecoveryGroup() {
        this._recoveryGroup = (String)this._props.get("recoveryGroup");
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"getRecoveryGroup {0}", (Object[])new Object[]{this._recoveryGroup});
        }
        return this._recoveryGroup;
    }

    public void setTMS(TransactionManagerService tms) {
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("setTMS " + tms), (Object[])new Object[0]);
        }
        this.tmsRef = tms;
    }

    public void setTMRecoveryService(TMRecoveryService tmrec) {
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("setTMRecoveryService " + tmrec), (Object[])new Object[0]);
        }
        if (this.tmsRef != null) {
            if (!_isSQLRecoveryLog) {
                if (this.isStartupEnabled()) {
                    this.tmsRef.doStartup(this, _isSQLRecoveryLog);
                }
            } else {
                ServiceReference serviceRef = dataSourceFactoryRef.getReference();
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("retrieved datasourceFactory service ref " + serviceRef), (Object[])new Object[0]);
                }
                if (this.isStartupEnabled() && serviceRef != null) {
                    this.tmsRef.doStartup(this, _isSQLRecoveryLog);
                }
            }
        } else if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"tmsref is null", (Object[])new Object[0]);
        }
    }

    protected void setRunningCondition(ServiceReference<Condition> runningCondition) {
        if (this.checkpointRestore()) {
            this._runningCondition = runningCondition;
            if (this.tmsRef != null) {
                this.tmsRef.doDeferredRecoveryAtRestore(this);
            }
        }
    }

    protected void unsetRunningCondition(ServiceReference<Condition> runningCondition) {
        if (CheckpointPhase.getPhase() != CheckpointPhase.INACTIVE) {
            this._runningCondition = null;
        }
    }

    @Trivial
    public boolean isSQLRecoveryLog() {
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"isSQLRecoveryLog {0}", (Object[])new Object[]{_isSQLRecoveryLog});
        }
        return _isSQLRecoveryLog;
    }

    @Trivial
    public boolean needToCoordinateServices() {
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"needToCoordinateServices", (Object[])new Object[0]);
        }
        return true;
    }

    private void checkDataSourceRef() {
        Object configuredDSR = this._props.get("dataSourceRef");
        if (configuredDSR == null) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"dataSourceRef is not specified, log to filesys", (Object[])new Object[0]);
            }
            _isSQLRecoveryLog = false;
        } else {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"dataSourceRef is specified, log to RDBMS", (Object[])new Object[0]);
            }
            String suffixStr = (String)this._props.get("transactionLogDBTableSuffix");
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("suffixStr is " + suffixStr + ", of length " + suffixStr.length()), (Object[])new Object[0]);
            }
            if (suffixStr != null && !suffixStr.trim().isEmpty()) {
                suffixStr = suffixStr.trim();
                logDir = "custom://com.ibm.rls.jdbc.SQLRecoveryLogFactory?datasource=Liberty,tablesuffix=" + suffixStr;
            } else {
                logDir = "custom://com.ibm.rls.jdbc.SQLRecoveryLogFactory?datasource=Liberty";
            }
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"logDir now set to ", (Object[])new Object[]{logDir});
            }
            _isSQLRecoveryLog = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @ManualTrace
    private String parseTransactionLogDirectory() {
        String configuredLogDir;
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"parseTransactionLogDirectory", (Object[])new Object[]{this._props});
        }
        if ((configuredLogDir = (String)this._props.get("transactionLogDirectory")) == null) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"using default log dir as config is null", (Object[])new Object[0]);
            }
            configuredLogDir = defaultLogDir;
        } else if (!configuredLogDir.endsWith("/")) {
            configuredLogDir = configuredLogDir + "/";
        }
        WsResource logDirResource = null;
        try {
            JTMConfigurationProvider jTMConfigurationProvider = this;
            synchronized (jTMConfigurationProvider) {
                logDirResource = this.locationService.resolveResource(configuredLogDir);
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            void e;
            FFDCFilter.processException((Throwable)illegalArgumentException, (String)"com.ibm.ws.transaction.services.JTMConfigurationProvider", (String)"743", (Object)((Object)this), (Object[])new Object[0]);
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("IllegalArgumentException from location service for dir string: " + configuredLogDir), (Object[])new Object[0]);
            }
            if (!configuredLogDir.equals(defaultLogDir)) {
                configuredLogDir = defaultLogDir;
                try {
                    JTMConfigurationProvider jTMConfigurationProvider = this;
                    synchronized (jTMConfigurationProvider) {
                        logDirResource = this.locationService.resolveResource(configuredLogDir);
                    }
                }
                catch (IllegalArgumentException illegalArgumentException2) {
                    FFDCFilter.processException((Throwable)illegalArgumentException2, (String)"com.ibm.ws.transaction.services.JTMConfigurationProvider", (String)"754", (Object)((Object)this), (Object[])new Object[0]);
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        void ex;
                        Tr.debug((TraceComponent)tc, (String)("Secondary IllegalArgumentException " + ex + " from location service for dir string: " + configuredLogDir), (Object[])new Object[0]);
                    }
                    if (tc.isEntryEnabled()) {
                        Tr.exit((TraceComponent)tc, (String)"parseTransactionLogDirectory", (Object)e);
                    }
                    throw e;
                }
            }
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"parseTransactionLogDirectory", (Object)e);
            }
            throw e;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("logDirResource: " + logDirResource), (Object[])new Object[0]);
        }
        logDir = logDirResource.asFile().getPath().replaceAll("\\\\", "/");
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"parseTransactionLogDirectory", (Object)logDir);
        }
        return logDir;
    }

    @Trivial
    public void setApplId(byte[] name) {
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"setApplId {0}", (Object[])new Object[]{Util.toHexString((byte[])name)});
        }
        this._applId = (byte[])name.clone();
    }

    @Trivial
    public byte[] getApplId() {
        byte[] result = this._applId;
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("getApplId - " + Util.toHexString((byte[])result)), (Object[])new Object[0]);
        }
        return result;
    }

    /*
     * WARNING - void declaration
     */
    @ManualTrace
    public void shutDownFramework() {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"shutDownFramework", (Object[])new Object[]{_frameworkShutting});
        }
        if (!_frameworkShutting) {
            try {
                Bundle bundle;
                if (this._cc != null && (bundle = this._cc.getBundleContext().getBundle("System Bundle")) != null) {
                    AccessController.doPrivileged(new PrivilegedExceptionAction<Void>(){
                        static final long serialVersionUID = -1421837604474617110L;
                        private static final /* synthetic */ TraceComponent $$$tc$$$;

                        /*
                         * WARNING - void declaration
                         */
                        @Override
                        public Void run() throws BundleException {
                            if (tc.isDebugEnabled()) {
                                Tr.debug((TraceComponent)tc, (String)"force quick shutdown", (Object[])new Object[0]);
                            }
                            bundle.getBundleContext().registerService(ForcedServerStop.class, (Object)new ForcedServerStop(), null);
                            try {
                                if (tc.isDebugEnabled()) {
                                    Tr.debug((TraceComponent)tc, (String)"stop bundle", (Object[])new Object[0]);
                                }
                                bundle.stop();
                            }
                            catch (BundleException bundleException) {
                                void bex;
                                FFDCFilter.processException((Throwable)bundleException, (String)"com.ibm.ws.transaction.services.JTMConfigurationProvider$1", (String)"825", (Object)this, (Object[])new Object[0]);
                                if (tc.isDebugEnabled()) {
                                    Tr.debug((TraceComponent)tc, (String)("caught bundlex - " + bex), (Object[])new Object[0]);
                                }
                                throw bex;
                            }
                            return null;
                        }

                        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
                        static {
                            $$$tc$$$ = Tr.register((String)"com.ibm.ws.transaction.services.JTMConfigurationProvider$1", 1.class, (String)"transaction", (String)"com.ibm.ws.transaction.services.TransactionMessages");
                        }
                    });
                }
                _frameworkShutting = true;
            }
            catch (Exception bundle) {
                FFDCFilter.processException((Throwable)bundle, (String)"com.ibm.ws.transaction.services.JTMConfigurationProvider", (String)"835", (Object)((Object)this), (Object[])new Object[0]);
                if (tc.isDebugEnabled()) {
                    void e;
                    Tr.debug((TraceComponent)tc, (String)"shutDownFramework", (Object[])new Object[]{e});
                }
            }
            finally {
                if (tc.isEntryEnabled()) {
                    Tr.exit((TraceComponent)tc, (String)"shutDownFramework");
                }
            }
        }
    }

    public boolean enableHADBPeerLocking() {
        return (Boolean)this._props.get("enableHADBPeerLocking");
    }

    public int getTimeBetweenHeartbeats() {
        Number num = (Number)this._props.get("timeBetweenHeartbeats");
        return num.intValue();
    }

    public int getPeerTimeBeforeStale() {
        Number num = (Number)this._props.get("peerTimeBeforeStale");
        return num.intValue();
    }

    public int getLightweightLogRetryInterval() {
        Number num = (Number)this._props.get("lightweightLogRetryInterval");
        return num.intValue();
    }

    public int getLightweightLogRetryLimit() {
        Number num = (Number)this._props.get("lightweightLogRetryLimit");
        return num.intValue();
    }

    public int getLogRetryInterval() {
        Number num = (Number)this._props.get("logRetryInterval");
        return num.intValue();
    }

    public int getLogRetryLimit() {
        Number num = (Number)this._props.get("logRetryLimit");
        return num.intValue();
    }

    @Trivial
    public boolean enableLogRetries() {
        Boolean elr = (Boolean)this._props.get("enableLogRetries");
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"enableLogRetries {0}", (Object[])new Object[]{elr});
        }
        return elr;
    }

    public List<Integer> getRetriableSqlCodes() {
        String sqlcodes = (String)this._props.get("retriableSqlCodes");
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("getRetriableSqlCodes " + sqlcodes), (Object[])new Object[0]);
        }
        if (!this._setRetriableSqlcodes) {
            this.retriableSqlCodeList = this.parseSqlCodes(sqlcodes);
            this._setRetriableSqlcodes = true;
        }
        return this.retriableSqlCodeList;
    }

    public List<Integer> getNonRetriableSqlCodes() {
        String sqlcodes = (String)this._props.get("nonRetriableSqlCodes");
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("getNonRetriableSqlCodes " + sqlcodes), (Object[])new Object[0]);
        }
        if (!this._setNonRetriableSqlcodes) {
            this.nonRetriableSqlCodeList = this.parseSqlCodes(sqlcodes);
            this._setNonRetriableSqlcodes = true;
        }
        return this.nonRetriableSqlCodeList;
    }

    private List<Integer> parseSqlCodes(String sqlCodesStr) {
        ArrayList<Integer> sqlCodeList = new ArrayList<Integer>();
        if (sqlCodesStr != null && !sqlCodesStr.trim().isEmpty()) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("There are sqlcodes to parse " + sqlCodesStr), (Object[])new Object[0]);
            }
            List<String> sqlCodeStringList = Arrays.asList(sqlCodesStr.split(","));
            for (String sqlcode : sqlCodeStringList) {
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("Isolated string sqlcode " + sqlcode), (Object[])new Object[0]);
                }
                int intSqlCode = 0;
                try {
                    intSqlCode = Integer.parseInt(sqlcode.trim());
                }
                catch (NumberFormatException numberFormatException) {
                    FFDCFilter.processException((Throwable)numberFormatException, (String)"com.ibm.ws.transaction.services.JTMConfigurationProvider", (String)"989", (Object)((Object)this), (Object[])new Object[]{sqlCodesStr});
                    Tr.audit((TraceComponent)tc, (String)("WTRN0107W: Malformed sqlcode " + sqlcode + " in configuration " + sqlCodesStr), (Object[])new Object[0]);
                }
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("Isolated integer sqlcode " + intSqlCode), (Object[])new Object[0]);
                }
                sqlCodeList.add(intSqlCode);
            }
        }
        return sqlCodeList;
    }

    @Trivial
    public boolean isDataSourceFactorySet() {
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"isDataSourceFactorySet {0}", (Object[])new Object[]{this._dataSourceFactorySet});
        }
        return this._dataSourceFactorySet;
    }

    protected boolean checkpoint() {
        return CheckpointPhase.getPhase() != CheckpointPhase.INACTIVE && !CheckpointPhase.getPhase().restored();
    }

    protected boolean checkpointAtBeforeAppStart() {
        return CheckpointPhase.getPhase() == CheckpointPhase.BEFORE_APP_START && !CheckpointPhase.getPhase().restored();
    }

    protected boolean checkpointAtAfterAppStart() {
        return CheckpointPhase.getPhase() == CheckpointPhase.AFTER_APP_START && !CheckpointPhase.getPhase().restored();
    }

    protected boolean checkpointRestore() {
        return CheckpointPhase.getPhase() != CheckpointPhase.INACTIVE && CheckpointPhase.getPhase().restored();
    }

    protected boolean checkpointRestoreBeforeRunningCondition() {
        return this.checkpointRestore() && this._runningCondition == null;
    }

    protected boolean recursiveDelete(File fileToRemove) {
        if (fileToRemove == null || !fileToRemove.exists()) {
            return true;
        }
        boolean success = true;
        if (fileToRemove.isDirectory()) {
            File[] files;
            for (File file : files = fileToRemove.listFiles()) {
                if (file.isDirectory()) {
                    success |= this.recursiveDelete(file);
                    continue;
                }
                success |= file.delete();
            }
            files = fileToRemove.listFiles();
            if (files.length == 0) {
                success |= fileToRemove.delete();
            }
        } else {
            success |= fileToRemove.delete();
        }
        return success;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
    static {
        dataSourceFactoryRef = new AtomicServiceReference("dataSourceFactory");
    }
}

