/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.util;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

@TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@TraceOptions
public class GroupParameterParser {
    private char[] chars = null;
    private int pos = 0;
    private int len = 0;
    private int i1 = 0;
    private int i2 = 0;
    private boolean lowerCaseNames = false;
    static final long serialVersionUID = 3548737873837656279L;
    private static final /* synthetic */ TraceComponent $$$tc$$$;

    private boolean hasChar() {
        return this.pos < this.len;
    }

    private String getToken(boolean quoted) {
        while (this.i1 < this.i2 && Character.isWhitespace(this.chars[this.i1])) {
            ++this.i1;
        }
        while (this.i2 > this.i1 && Character.isWhitespace(this.chars[this.i2 - 1])) {
            --this.i2;
        }
        if (quoted && this.i2 - this.i1 >= 2 && this.chars[this.i1] == '\"' && this.chars[this.i2 - 1] == '\"') {
            ++this.i1;
            --this.i2;
        }
        String result = null;
        if (this.i2 > this.i1) {
            result = new String(this.chars, this.i1, this.i2 - this.i1);
        }
        return result;
    }

    private boolean isOneOf(char ch, char[] charray) {
        boolean result = false;
        for (int i = 0; i < charray.length; ++i) {
            if (ch != charray[i]) continue;
            result = true;
            break;
        }
        return result;
    }

    private String parseToken(char[] terminators) {
        char ch;
        this.i1 = this.pos;
        this.i2 = this.pos;
        while (this.hasChar() && !this.isOneOf(ch = this.chars[this.pos], terminators)) {
            ++this.i2;
            ++this.pos;
        }
        return this.getToken(false);
    }

    private String parseQuotedToken(char[] terminators) {
        this.i1 = this.pos;
        this.i2 = this.pos;
        boolean quoted = false;
        boolean charEscaped = false;
        while (this.hasChar()) {
            char ch = this.chars[this.pos];
            if (!quoted && this.isOneOf(ch, terminators)) break;
            if (!charEscaped && ch == '\"') {
                quoted = !quoted;
            }
            charEscaped = !charEscaped && ch == '\\';
            ++this.i2;
            ++this.pos;
        }
        return this.getToken(true);
    }

    public boolean isLowerCaseNames() {
        return this.lowerCaseNames;
    }

    public void setLowerCaseNames(boolean b) {
        this.lowerCaseNames = b;
    }

    public List<Map<String, String>> parse(String str, char separator, char groupSeparator) {
        if (str == null) {
            return new ArrayList<Map<String, String>>();
        }
        return this.parse(str.toCharArray(), separator, groupSeparator);
    }

    public List<Map<String, String>> parse(char[] chars, char separator, char groupSeparator) {
        if (chars == null) {
            return new ArrayList<Map<String, String>>();
        }
        return this.parse(chars, 0, chars.length, separator, groupSeparator);
    }

    public List<Map<String, String>> parse(char[] chars, int offset, int length, char separator, char groupSeparator) {
        if (chars == null) {
            return new ArrayList<Map<String, String>>();
        }
        ArrayList<Map<String, String>> groups = new ArrayList<Map<String, String>>();
        HashMap<String, String> params = new HashMap<String, String>();
        groups.add(params);
        this.chars = chars;
        this.pos = offset;
        this.len = length;
        String paramName = null;
        String paramValue = null;
        while (this.hasChar()) {
            paramName = this.parseToken(new char[]{'=', separator, groupSeparator});
            paramValue = null;
            if (this.hasChar() && chars[this.pos] == '=') {
                ++this.pos;
                paramValue = this.parseQuotedToken(new char[]{separator, groupSeparator});
            }
            if (paramName != null && paramName.length() > 0) {
                if (this.lowerCaseNames) {
                    paramName = paramName.toLowerCase();
                }
                params.put(paramName, paramValue);
            }
            if (this.hasChar() && chars[this.pos] == separator) {
                ++this.pos;
                continue;
            }
            if (!this.hasChar() || chars[this.pos] != groupSeparator) continue;
            ++this.pos;
            params = new HashMap();
            groups.add(params);
        }
        return groups;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
    static {
        $$$tc$$$ = Tr.register((String)"org.jboss.resteasy.util.GroupParameterParser", GroupParameterParser.class, null, null);
    }
}

