/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.plugins.server.embedded;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import jakarta.ws.rs.ApplicationPath;
import jakarta.ws.rs.SeBootstrap;
import java.lang.annotation.Annotation;
import java.security.AccessController;
import java.util.Optional;
import org.jboss.resteasy.core.se.ConfigurationOption;
import org.jboss.resteasy.plugins.server.embedded.EmbeddedServer;
import org.jboss.resteasy.resteasy_jaxrs.i18n.LogMessages;
import org.jboss.resteasy.resteasy_jaxrs.i18n.Messages;
import org.jboss.resteasy.spi.PriorityServiceLoader;
import org.jboss.resteasy.spi.ResteasyDeployment;

@TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@TraceOptions
public class EmbeddedServers {
    static final long serialVersionUID = -3747852255340785818L;
    private static final /* synthetic */ TraceComponent $$$tc$$$;

    public static void validateDeployment(ResteasyDeployment deployment) {
        if (deployment == null) {
            throw Messages.MESSAGES.deploymentRequired();
        }
        if (deployment.getRegistry() == null) {
            deployment.start();
        }
    }

    public static String resolveContext(ResteasyDeployment deployment) {
        if (deployment.getApplication() != null) {
            return EmbeddedServers.resolveContext(deployment.getApplication().getClass());
        }
        if (deployment.getApplicationClass() != null) {
            try {
                Class<?> clazz = Class.forName(deployment.getApplicationClass());
                return EmbeddedServers.resolveContext(clazz);
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
        }
        return null;
    }

    public static String resolveContext(Class<?> type) {
        ApplicationPath applicationPath = EmbeddedServers.findAnnotation(ApplicationPath.class, type);
        return applicationPath == null ? null : applicationPath.value();
    }

    public static String checkContextPath(ResteasyDeployment deployment) {
        return EmbeddedServers.checkContextPath(EmbeddedServers.resolveContext(deployment));
    }

    public static String checkContextPath(String contextPath) {
        if (contextPath == null || contextPath.isBlank()) {
            return "/";
        }
        if (contextPath.charAt(0) != '/') {
            return "/" + contextPath;
        }
        return contextPath;
    }

    public static EmbeddedServer findServer() {
        return EmbeddedServers.findServer(null);
    }

    public static EmbeddedServer findServer(SeBootstrap.Configuration configuration) {
        if (configuration != null && configuration.hasProperty(ConfigurationOption.EMBEDDED_SERVER.key())) {
            Object instance = ConfigurationOption.EMBEDDED_SERVER.getValue(configuration);
            if (instance instanceof EmbeddedServer) {
                return (EmbeddedServer)instance;
            }
            LogMessages.LOGGER.invalidPropertyType(instance, ConfigurationOption.EMBEDDED_SERVER.key(), EmbeddedServer.class.getName());
        }
        Optional found = System.getSecurityManager() == null ? PriorityServiceLoader.load(EmbeddedServer.class).first() : AccessController.doPrivileged(() -> PriorityServiceLoader.load(EmbeddedServer.class).first());
        return (EmbeddedServer)found.orElseThrow(() -> Messages.MESSAGES.noImplementationFound(EmbeddedServer.class.getName()));
    }

    private static <T extends Annotation> T findAnnotation(Class<T> annotation, Class<?> type) {
        if (type == null) {
            return null;
        }
        T result = type.getAnnotation(annotation);
        if (result == null) {
            return EmbeddedServers.findAnnotation(annotation, type.getSuperclass());
        }
        return result;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
    static {
        $$$tc$$$ = Tr.register((String)"org.jboss.resteasy.plugins.server.embedded.EmbeddedServers", EmbeddedServers.class, null, null);
    }
}

