/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.install.internal;

import com.ibm.websphere.crypto.InvalidPasswordDecodingException;
import com.ibm.websphere.crypto.PasswordUtil;
import com.ibm.websphere.crypto.UnsupportedCryptoAlgorithmException;
import com.ibm.ws.install.InstallConstants;
import com.ibm.ws.install.InstallException;
import com.ibm.ws.install.RepositoryConfig;
import com.ibm.ws.install.RepositoryConfigUtils;
import com.ibm.ws.install.internal.AbstractDirector;
import com.ibm.ws.install.internal.EventManager;
import com.ibm.ws.install.internal.ExceptionUtils;
import com.ibm.ws.install.internal.InstallLogUtils;
import com.ibm.ws.install.internal.InstallUtils;
import com.ibm.ws.install.internal.Product;
import com.ibm.ws.install.internal.adaptor.FixAdaptor;
import com.ibm.ws.install.internal.asset.ESAAsset;
import com.ibm.ws.install.internal.asset.InstallAsset;
import com.ibm.ws.install.repository.download.RepositoryDownloadUtil;
import com.ibm.ws.install.repository.internal.RepositoryUtils;
import com.ibm.ws.kernel.boot.cmdline.Utils;
import com.ibm.ws.kernel.feature.provisioning.FeatureResource;
import com.ibm.ws.kernel.feature.provisioning.ProvisioningFeatureDefinition;
import com.ibm.ws.kernel.feature.provisioning.SubsystemContentType;
import com.ibm.ws.kernel.productinfo.ProductInfo;
import com.ibm.ws.repository.common.enums.ResourceType;
import com.ibm.ws.repository.common.enums.Visibility;
import com.ibm.ws.repository.connections.DirectoryRepositoryConnection;
import com.ibm.ws.repository.connections.RepositoryConnection;
import com.ibm.ws.repository.connections.RepositoryConnectionList;
import com.ibm.ws.repository.connections.RestRepositoryConnection;
import com.ibm.ws.repository.connections.RestRepositoryConnectionProxy;
import com.ibm.ws.repository.connections.ZipRepositoryConnection;
import com.ibm.ws.repository.connections.liberty.MainRepository;
import com.ibm.ws.repository.connections.liberty.ProductInfoProductDefinition;
import com.ibm.ws.repository.exceptions.RepositoryBackendException;
import com.ibm.ws.repository.exceptions.RepositoryBackendIOException;
import com.ibm.ws.repository.exceptions.RepositoryException;
import com.ibm.ws.repository.exceptions.RepositoryHttpException;
import com.ibm.ws.repository.exceptions.RepositoryResourceException;
import com.ibm.ws.repository.resolver.RepositoryResolutionException;
import com.ibm.ws.repository.resolver.RepositoryResolver;
import com.ibm.ws.repository.resources.AttachmentResource;
import com.ibm.ws.repository.resources.EsaResource;
import com.ibm.ws.repository.resources.RepositoryResource;
import com.ibm.ws.repository.resources.SampleResource;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.zip.ZipException;
import wlp.lib.extract.ReturnCode;
import wlp.lib.extract.SelfExtractor;

class ResolveDirector
extends AbstractDirector {
    private RepositoryConnectionList repositoryConnectionList = null;
    private RestRepositoryConnectionProxy proxy = null;
    private Properties repoProperties;
    private String userAgent;
    private String repositoryUrl;
    private Map<String, File> downloadCach = new HashMap<String, File>();
    private Map<String, ESAAsset> esaAssetCach = new HashMap<String, ESAAsset>();
    Map<String, List<List<RepositoryResource>>> installResources;
    ArrayList<InstallAsset> localInstallAssets;

    ResolveDirector(Product product, EventManager eventManager, Logger logger) {
        super(product, eventManager, logger);
        this.setUserAgent();
    }

    void checkResources() throws InstallException {
        if (this.installResources != null) {
            for (List<List<RepositoryResource>> targetList : this.installResources.values()) {
                for (List<RepositoryResource> mrList : targetList) {
                    for (RepositoryResource installResource : mrList) {
                        this.checkResource(installResource);
                    }
                }
            }
        }
    }

    void cleanUp() {
        this.repositoryConnectionList = null;
        this.proxy = null;
        this.installResources = null;
        this.downloadCach.clear();
        this.esaAssetCach.clear();
    }

    boolean defaultRepo() {
        return this.repoProperties == null || this.isFeatureManager();
    }

    Collection<ESAAsset> getAutoFeature(File fromDir, String toExtension) {
        File[] esaes;
        ArrayList<ESAAsset> autoFeatures = new ArrayList<ESAAsset>();
        FilenameFilter ff = new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return name.toLowerCase().endsWith(".esa");
            }
        };
        Set<String> installedFeatures = this.product.getInstalledFeatures();
        for (File esa : esaes = fromDir.listFiles(ff)) {
            ESAAsset esaAsset;
            if (!esa.isFile() || (esaAsset = this.createESAAsset(esa, toExtension)) == null || !esaAsset.isAutoFeature() || !esaAsset.installWhenSatisfied() || autoFeatures.contains(esaAsset)) continue;
            boolean installed = installedFeatures.contains(esaAsset.getProvideFeature());
            this.log(Level.FINEST, esaAsset.getProvideFeature() + " is auto feature and " + (installed ? "installed" : "not installed"));
            if (installed) continue;
            autoFeatures.add(esaAsset);
        }
        return autoFeatures;
    }

    Map<String, List<List<RepositoryResource>>> getInstallResources() {
        return this.installResources;
    }

    int getInstallResourcesSize() {
        int t = 0;
        if (this.installResources != null) {
            for (List<List<RepositoryResource>> targetList : this.installResources.values()) {
                for (List<RepositoryResource> mrList : targetList) {
                    t += mrList.size();
                }
            }
        }
        return t;
    }

    long getInstallResourcesMainAttachmentSize() {
        long size = 0L;
        if (this.installResources != null) {
            for (List<List<RepositoryResource>> targetList : this.installResources.values()) {
                for (List<RepositoryResource> mrList : targetList) {
                    for (RepositoryResource mr : mrList) {
                        AttachmentResource ar = null;
                        try {
                            ar = mr.getMainAttachment();
                        }
                        catch (Exception e) {
                            this.log(Level.FINEST, e.getLocalizedMessage(), e);
                        }
                        if (ar == null) continue;
                        size += ar.getSize();
                    }
                }
            }
        }
        return size;
    }

    List<InstallAsset> getLocalInstallAssets() {
        return this.localInstallAssets;
    }

    int getLocalInstallAssetsSize() {
        if (this.localInstallAssets != null) {
            return this.localInstallAssets.size();
        }
        return 0;
    }

    private RepositoryConnectionList getRepositoryConnectionList(Collection<String> featureNames) throws InstallException {
        List<RepositoryConfig> repositoryConfigs = RepositoryConfigUtils.getRepositoryConfigs(this.repoProperties);
        this.proxy = RepositoryConfigUtils.getProxyInfo(this.repoProperties);
        ArrayList<RestRepositoryConnection> loginEntries = new ArrayList<RestRepositoryConnection>(repositoryConfigs.size());
        boolean isOpenLiberty = false;
        try {
            for (ProductInfo productInfo : ProductInfo.getAllProductInfo().values()) {
                if (productInfo.getReplacedBy() != null || !productInfo.getId().equals("io.openliberty")) continue;
                isOpenLiberty = true;
            }
        }
        catch (Exception e) {
            throw ExceptionUtils.create(e);
        }
        for (RepositoryConfig rc : repositoryConfigs) {
            RestRepositoryConnection lie = null;
            String url = rc.getUrl();
            if (url != null && url.toLowerCase().startsWith("file:")) {
                try {
                    URL urlProcessed = new URL(url);
                    File repoDir = new File(urlProcessed.getPath());
                    if (repoDir.exists()) {
                        if (repoDir.isDirectory()) {
                            lie = new DirectoryRepositoryConnection(repoDir);
                            loginEntries.add(lie);
                            continue;
                        }
                        lie = new ZipRepositoryConnection(repoDir);
                        loginEntries.add(lie);
                        continue;
                    }
                    throw new IOException();
                }
                catch (Exception e) {
                    throw ExceptionUtils.create(RepositoryUtils.getMessage("ERROR_FILEPATH_NOT_EXISTS", url));
                }
            }
            if (rc.isLibertyRepository()) {
                try {
                    lie = MainRepository.createConnection((RestRepositoryConnectionProxy)this.proxy);
                }
                catch (RepositoryBackendIOException e) {
                    if (e instanceof RepositoryHttpException) {
                        if (((RepositoryHttpException)e).get_httpRespCode() == 407) {
                            throw ExceptionUtils.createByKey((Exception)((Object)e), "ERROR_TOOL_INCORRECT_PROXY_CREDENTIALS", new Object[0]);
                        }
                        throw ExceptionUtils.createByKey((Exception)((Object)e), "ERROR_FAILED_TO_CONNECT", new Object[0]);
                    }
                    throw ExceptionUtils.create((RepositoryException)((Object)e), featureNames, false, this.proxy, true, isOpenLiberty);
                }
            }
            String decodedPwd = rc.getUserPwd();
            if (decodedPwd != null && !decodedPwd.isEmpty()) {
                try {
                    decodedPwd = PasswordUtil.decode((String)rc.getUserPwd());
                }
                catch (InvalidPasswordDecodingException ipde) {
                    decodedPwd = rc.getUserPwd();
                }
                catch (UnsupportedCryptoAlgorithmException ucae) {
                    throw ExceptionUtils.createByKey((Exception)((Object)ucae), "ERROR_TOOL_PWD_CRYPTO_UNSUPPORTED", new Object[0]);
                }
            }
            lie = new RestRepositoryConnection(rc.getUser(), decodedPwd, rc.getApiKey(), rc.getUrl().toString());
            lie.setProxy(this.proxy);
            if (lie == null) continue;
            if (this.userAgent != null && !this.userAgent.isEmpty()) {
                lie.setUserAgent(this.userAgent);
            }
            loginEntries.add(lie);
        }
        this.repositoryConnectionList = new RepositoryConnectionList(loginEntries);
        return this.repositoryConnectionList;
    }

    RepositoryConnectionList getRepositoryConnectionList(Collection<String> featureNames, String userId, String password, String logLable) throws InstallException {
        if (this.repositoryConnectionList == null) {
            RestRepositoryConnection restConnection;
            if (!this.isFeatureManager() && this.repoProperties != null && !this.repoProperties.isEmpty()) {
                this.getRepositoryConnectionList(featureNames);
                InstallLogUtils.logLoginInfo(this.repositoryConnectionList, logLable);
                return this.repositoryConnectionList;
            }
            boolean isOpenLiberty = false;
            try {
                for (ProductInfo productInfo : ProductInfo.getAllProductInfo().values()) {
                    if (productInfo.getReplacedBy() != null || !productInfo.getId().equals("io.openliberty")) continue;
                    isOpenLiberty = true;
                }
            }
            catch (Exception e) {
                throw ExceptionUtils.create(e);
            }
            try {
                this.proxy = RepositoryConfigUtils.getProxyInfo(this.repoProperties);
                restConnection = MainRepository.createConnection((RestRepositoryConnectionProxy)this.proxy);
            }
            catch (RepositoryBackendIOException e) {
                if (e instanceof RepositoryHttpException) {
                    if (((RepositoryHttpException)e).get_httpRespCode() == 407) {
                        throw ExceptionUtils.createByKey((Exception)((Object)e), "ERROR_TOOL_INCORRECT_PROXY_CREDENTIALS", new Object[0]);
                    }
                    throw ExceptionUtils.createByKey((Exception)((Object)e), "ERROR_FAILED_TO_CONNECT", new Object[0]);
                }
                throw ExceptionUtils.create((RepositoryException)((Object)e), featureNames, false, this.proxy, true, isOpenLiberty);
            }
            if (userId != null) {
                restConnection.setUserId(userId);
            }
            if (password != null) {
                restConnection.setPassword(password);
            }
            if (this.repositoryUrl != null && !this.repositoryUrl.trim().isEmpty()) {
                restConnection.setRepositoryUrl(this.repositoryUrl);
            }
            if (this.userAgent != null && !this.userAgent.isEmpty()) {
                restConnection.setUserAgent(this.userAgent);
            }
            this.repositoryConnectionList = new RepositoryConnectionList((RepositoryConnection)restConnection);
            InstallLogUtils.logLoginInfo(this.repositoryConnectionList, logLable);
        }
        return this.repositoryConnectionList;
    }

    RestRepositoryConnectionProxy getProxy() {
        return this.proxy;
    }

    int getPublicInstallResourcesSize() {
        int t = 0;
        if (this.installResources != null) {
            for (List<List<RepositoryResource>> targetList : this.installResources.values()) {
                for (List<RepositoryResource> mrList : targetList) {
                    for (RepositoryResource mr : mrList) {
                        ResourceType type = mr.getType();
                        if (type.equals((Object)ResourceType.FEATURE)) {
                            Visibility v = ((EsaResource)mr).getVisibility();
                            if (!v.equals((Object)Visibility.PUBLIC) && !v.equals((Object)Visibility.INSTALL)) continue;
                            ++t;
                            continue;
                        }
                        if (!type.equals((Object)ResourceType.PRODUCTSAMPLE) && !type.equals((Object)ResourceType.OPENSOURCE)) continue;
                        ++t;
                    }
                }
            }
        }
        return t;
    }

    int getPublicLocalInstallAssetsSize() {
        int t = 0;
        if (this.localInstallAssets != null) {
            for (InstallAsset installAsset : this.localInstallAssets) {
                ESAAsset esaa;
                if (!installAsset.isFeature() || !(esaa = (ESAAsset)installAsset).isPublic()) continue;
                ++t;
            }
        }
        return t;
    }

    void resolve(Collection<String> assetIds, boolean download) throws InstallException {
        if (assetIds == null || assetIds.isEmpty()) {
            throw ExceptionUtils.createByKey("ERROR_ASSETS_LIST_INVALID", new Object[0]);
        }
        RepositoryConnectionList loginInfo = this.getRepositoryConnectionList(null, null, null, this.getClass().getCanonicalName() + ".resolve");
        this.installResources = this.resolveMap(assetIds, loginInfo, download);
        if (this.isEmpty(this.installResources)) {
            throw ExceptionUtils.createByKey(22, "ASSETS_ALREADY_INSTALLED", InstallUtils.getShortNames(this.product.getFeatureDefinitions(), assetIds).toString());
        }
    }

    void resolve(String feature, File esaFile, String toExtension) throws InstallException {
        HashSet<String> featureIds = new HashSet<String>(1);
        featureIds.add(feature);
        this.createESAAsset(esaFile, toExtension);
        File fromDir = esaFile.getAbsoluteFile().getParentFile();
        ArrayList<InstallAsset> installAssets = new ArrayList<InstallAsset>();
        ArrayList<String> unresolvedFeatures = new ArrayList<String>();
        Collection<ESAAsset> autoFeatures = this.getAutoFeature(fromDir, toExtension);
        this.resolve(featureIds, fromDir, toExtension, false, installAssets, unresolvedFeatures);
        if (!unresolvedFeatures.isEmpty()) {
            this.log(Level.FINEST, "Determined unresolved features: " + unresolvedFeatures.toString() + " from " + fromDir.getAbsolutePath());
            RepositoryConnectionList loginInfo = this.getRepositoryConnectionList(null, null, null, this.getClass().getCanonicalName() + ".resolve");
            this.installResources = this.resolveMap(unresolvedFeatures, loginInfo, false);
        }
        if (!installAssets.isEmpty()) {
            this.resolveAutoFeatures(autoFeatures, installAssets);
            this.localInstallAssets = installAssets;
        }
        if (this.localInstallAssets == null || this.localInstallAssets.isEmpty()) {
            throw ExceptionUtils.createByKey(22, "ALREADY_INSTALLED", InstallUtils.getFeatureListOutput(featureIds));
        }
    }

    List<List<RepositoryResource>> resolve(Collection<String> featureNames, InstallConstants.DownloadOption downloadOption, String userId, String password) throws InstallException {
        Collection installResources;
        ArrayList<String> featureNamesProcessed = new ArrayList<String>();
        for (String s : featureNames) {
            featureNamesProcessed.add(s.replaceAll("\\\\+$", ""));
        }
        HashSet<ProductInfoProductDefinition> productDefinitions = new HashSet<ProductInfoProductDefinition>();
        boolean isOpenLiberty = false;
        try {
            for (ProductInfo productInfo : ProductInfo.getAllProductInfo().values()) {
                productDefinitions.add(new ProductInfoProductDefinition(productInfo));
                if (productInfo.getReplacedBy() != null || !productInfo.getId().equals("io.openliberty")) continue;
                isOpenLiberty = true;
            }
        }
        catch (Exception e) {
            throw ExceptionUtils.create(e);
        }
        RepositoryConnectionList loginInfo = this.getRepositoryConnectionList(featureNamesProcessed, userId, password, this.getClass().getCanonicalName() + ".resolve");
        try {
            RepositoryResolver resolver;
            if (downloadOption == InstallConstants.DownloadOption.all || downloadOption == InstallConstants.DownloadOption.none) {
                resolver = new RepositoryResolver(productDefinitions, Collections.emptySet(), Collections.emptySet(), loginInfo);
                installResources = resolver.resolve(featureNamesProcessed);
            } else {
                Collection<String> featuresToInstall = this.getFeaturesToInstall(featureNamesProcessed, false);
                if (featuresToInstall.isEmpty()) {
                    return new ArrayList<List<RepositoryResource>>(0);
                }
                resolver = new RepositoryResolver(productDefinitions, this.product.getFeatureDefinitions().values(), FixAdaptor.getInstalledIFixes(this.product.getInstallDir()), loginInfo);
                installResources = resolver.resolve(featuresToInstall);
            }
        }
        catch (RepositoryResolutionException e) {
            throw ExceptionUtils.create(e, featureNamesProcessed, this.product.getInstallDir(), false, isOpenLiberty);
        }
        catch (RepositoryException e) {
            throw ExceptionUtils.create(e, featureNamesProcessed, false, this.proxy, this.defaultRepo(), isOpenLiberty);
        }
        ArrayList<List<RepositoryResource>> installResourcesCollection = new ArrayList<List<RepositoryResource>>(installResources.size());
        ArrayList<RepositoryResource> installResourcesSingleList = new ArrayList<RepositoryResource>();
        if (downloadOption == InstallConstants.DownloadOption.none) {
            for (List installResourcesList : installResources) {
                for (RepositoryResource installResource : installResourcesList) {
                    if (!(installResource instanceof EsaResource) && !(installResource instanceof SampleResource)) continue;
                    for (String featureName : featureNamesProcessed) {
                        String provideFeature = null;
                        String shortName = null;
                        if (installResource instanceof EsaResource) {
                            provideFeature = ((EsaResource)installResource).getProvideFeature();
                            shortName = ((EsaResource)installResource).getShortName();
                        } else if (installResource instanceof SampleResource) {
                            provideFeature = ((SampleResource)installResource).getName();
                            shortName = ((SampleResource)installResource).getShortName();
                        }
                        if ((provideFeature == null || !provideFeature.equals(featureName)) && (shortName == null || !shortName.equalsIgnoreCase(featureName)) || installResourcesSingleList.contains(installResource)) continue;
                        installResourcesSingleList.add(installResource);
                    }
                }
            }
            if (!installResourcesSingleList.isEmpty()) {
                installResourcesCollection.add(installResourcesSingleList);
            }
        } else {
            for (List installResourcesList : installResources) {
                ArrayList<RepositoryResource> mrList = new ArrayList<RepositoryResource>(installResourcesList.size());
                installResourcesCollection.add(mrList);
                for (RepositoryResource installResource : installResourcesList) {
                    if (installResourcesSingleList.contains(installResource) || downloadOption != InstallConstants.DownloadOption.all && this.product.isInstalled(installResource)) continue;
                    mrList.add(installResource);
                    installResourcesSingleList.add(installResource);
                }
            }
        }
        return installResourcesCollection;
    }

    private boolean mapContains(Map<String, List<List<RepositoryResource>>> installResourcesMap, RepositoryResource mr) {
        for (List<List<RepositoryResource>> targetList : installResourcesMap.values()) {
            for (List<RepositoryResource> mrList : targetList) {
                for (RepositoryResource m : mrList) {
                    if (!m.equals(mr)) continue;
                    return true;
                }
            }
        }
        return false;
    }

    private List<List<RepositoryResource>> removeDuplicated(Map<String, List<List<RepositoryResource>>> installResourcesMap, List<List<RepositoryResource>> resolved) {
        ArrayList<List<RepositoryResource>> newList = new ArrayList<List<RepositoryResource>>(resolved.size());
        for (List<RepositoryResource> mrList : resolved) {
            ArrayList<RepositoryResource> newMRList = new ArrayList<RepositoryResource>(mrList.size());
            for (RepositoryResource mr : mrList) {
                if (this.mapContains(installResourcesMap, mr)) continue;
                newMRList.add(mr);
            }
            if (newMRList.isEmpty()) continue;
            newList.add(newMRList);
        }
        return newList;
    }

    private void checkESAResources(List<List<RepositoryResource>> resolved) throws InstallException {
        for (List<RepositoryResource> mrList : resolved) {
            for (RepositoryResource mr : mrList) {
                ResourceType type = mr.getType();
                if (type.equals((Object)ResourceType.FEATURE)) {
                    Visibility v = ((EsaResource)mr).getVisibility();
                    if (!v.equals((Object)Visibility.INSTALL)) continue;
                    throw ExceptionUtils.createByKey("ERROR_NON_FEATURE_CANNOT_INSTALL_TO_EXTENSION", InstallUtils.getResourceId(mr));
                }
                throw ExceptionUtils.createByKey("ERROR_NON_FEATURE_CANNOT_INSTALL_TO_EXTENSION", InstallUtils.getResourceId(mr));
            }
        }
    }

    Map<String, List<List<RepositoryResource>>> resolveMap(Collection<String> featureNames, InstallConstants.DownloadOption downloadOption, String userId, String password) throws InstallException {
        List<List<RepositoryResource>> resolved;
        this.fireProgressEvent(8, 2, InstallLogUtils.Messages.INSTALL_KERNEL_MESSAGES.getLogMessage("STATE_RESOLVING", new Object[0]));
        HashMap<String, List<List<RepositoryResource>>> installResourcesMap = new HashMap<String, List<List<RepositoryResource>>>();
        Map<String, Collection<String>> assetsMap = InstallUtils.getAssetsMap(featureNames, true);
        Collection<String> dAssets = assetsMap.get("default");
        if (dAssets != null && !dAssets.isEmpty() && !this.isEmpty(resolved = this.resolve(dAssets, downloadOption, userId, password))) {
            installResourcesMap.put("default", resolved);
        }
        for (Map.Entry<String, Collection<String>> assetsEntry : assetsMap.entrySet()) {
            if (assetsEntry.getKey().equalsIgnoreCase("default")) continue;
            List<List<RepositoryResource>> resolved2 = this.resolve(assetsEntry.getValue(), downloadOption, userId, password);
            if (this.isEmpty(resolved2 = this.removeDuplicated(installResourcesMap, resolved2))) continue;
            installResourcesMap.put(assetsEntry.getKey(), resolved2);
        }
        return installResourcesMap;
    }

    String resolve(String esaLocation, String toExtension, Set<String> features, ArrayList<InstallAsset> installAssets, int progress, int interval) throws InstallException {
        InstallInformation installInformation = this.createInstallInformation(esaLocation, null, progress);
        return this.resolve(installInformation, toExtension, features, installAssets, progress, interval);
    }

    void resolve(Collection<String> featureIds, File fromDir, String toExtension, boolean offlineOnly, ArrayList<InstallAsset> installAssets, ArrayList<String> unresolvedFeatures) throws InstallException {
        Map<String, ProvisioningFeatureDefinition> installedFeatureDefs = this.product.getFeatureDefinitions();
        Set<String> installedFeatures = this.product.getInstalledFeatures();
        for (String f : featureIds) {
            if (this.containFeature(installedFeatureDefs, f) || installedFeatures.contains(f)) continue;
            this.resolve(f, fromDir, toExtension, offlineOnly, installedFeatures, this.esaAssetCach, installAssets, unresolvedFeatures);
        }
    }

    void resolveAutoFeatures(Collection<ESAAsset> autoFeatures, ArrayList<InstallAsset> installAssets) {
        HashSet<ProvisioningFeatureDefinition> featureDefinitionsToCheck = new HashSet<ProvisioningFeatureDefinition>(this.product.getAllFeatureDefinitions().values());
        for (InstallAsset a : installAssets) {
            if (!a.isFeature()) continue;
            ProvisioningFeatureDefinition pdf = ((ESAAsset)a).getProvisioningFeatureDefinition();
            featureDefinitionsToCheck.add(pdf);
        }
        this.resolveAutoFeature(autoFeatures, installAssets, featureDefinitionsToCheck);
    }

    List<List<RepositoryResource>> resolve(Collection<String> assetNames, RepositoryConnectionList loginInfo, boolean download, boolean installingFeature) throws InstallException {
        Collection installResources;
        boolean installingAsset = !installingFeature;
        ArrayList<String> assetNamesProcessed = new ArrayList<String>();
        for (String s : assetNames) {
            assetNamesProcessed.add(s.replaceAll("\\\\+$", ""));
        }
        HashSet<ProductInfoProductDefinition> productDefinitions = new HashSet<ProductInfoProductDefinition>();
        boolean isOpenLiberty = false;
        try {
            for (ProductInfo productInfo : ProductInfo.getAllProductInfo().values()) {
                productDefinitions.add(new ProductInfoProductDefinition(productInfo));
                if (productInfo.getReplacedBy() != null || !productInfo.getId().equals("io.openliberty")) continue;
                isOpenLiberty = true;
            }
        }
        catch (Exception e) {
            throw ExceptionUtils.create(e);
        }
        try {
            Map<String, ProvisioningFeatureDefinition> installedFeatureDefinitions = this.product.getFeatureDefinitions();
            Collection<ProvisioningFeatureDefinition> installedFeatures = download && System.getProperty("INTERNAL_DOWNLOAD_FROM_FOR_BUILD") == null ? Collections.emptySet() : installedFeatureDefinitions.values();
            Set installedIFixes = download ? Collections.emptySet() : FixAdaptor.getInstalledIFixes(this.product.getInstallDir());
            RepositoryResolver resolver = new RepositoryResolver(productDefinitions, installedFeatures, installedIFixes, loginInfo);
            if (InstallUtils.isServerXmlInstall()) {
                this.log(Level.FINE, "Calling resolveAsSet api");
                installResources = resolver.resolveAsSet(assetNamesProcessed);
                ResolveDirector.resolveAutoFeatures(installResources, new RepositoryResolver(productDefinitions, installedFeatures, installedIFixes, loginInfo));
            } else {
                Collection<String> assetsToInstall = this.getFeaturesToInstall(assetNamesProcessed, download);
                if (assetsToInstall.isEmpty()) {
                    return new ArrayList<List<RepositoryResource>>(0);
                }
                this.log(Level.FINE, "Using old resolve API");
                installResources = resolver.resolve(assetsToInstall);
            }
        }
        catch (RepositoryResolutionException e) {
            throw ExceptionUtils.create(e, assetNamesProcessed, this.product.getInstallDir(), installingAsset, isOpenLiberty);
        }
        catch (RepositoryException e) {
            throw ExceptionUtils.create(e, assetNamesProcessed, installingAsset, this.proxy, this.defaultRepo(), isOpenLiberty);
        }
        ArrayList<List<RepositoryResource>> installResourcesCollection = new ArrayList<List<RepositoryResource>>(installResources.size());
        ArrayList<RepositoryResource> installResourcesSingleList = new ArrayList<RepositoryResource>();
        for (List installResourcesList : installResources) {
            ArrayList<RepositoryResource> mrList = new ArrayList<RepositoryResource>(installResourcesList.size());
            installResourcesCollection.add(mrList);
            for (RepositoryResource installResource : installResourcesList) {
                if (installResourcesSingleList.contains(installResource) || !download && this.product.isInstalled(installResource)) continue;
                mrList.add(installResource);
                installResourcesSingleList.add(installResource);
            }
        }
        return installResourcesCollection;
    }

    static void resolveAutoFeatures(Collection<List<RepositoryResource>> installResources, RepositoryResolver resolver) throws RepositoryResolutionException {
        if (installResources.isEmpty()) {
            return;
        }
        HashSet<String> resolveAsSetFeatures = new HashSet<String>();
        for (List<RepositoryResource> resList : installResources) {
            for (RepositoryResource res : resList) {
                if (!res.getType().equals((Object)ResourceType.FEATURE)) continue;
                resolveAsSetFeatures.add(((EsaResource)res).getProvideFeature());
            }
        }
        if (!resolveAsSetFeatures.isEmpty()) {
            Collection resolvedResources = resolver.resolve(resolveAsSetFeatures);
            for (List resList : resolvedResources) {
                ArrayList autoFeatures = new ArrayList();
                for (RepositoryResource res : resList) {
                    EsaResource esa;
                    if (!res.getType().equals((Object)ResourceType.FEATURE) || !(esa = (EsaResource)res).getInstallPolicy().toString().equalsIgnoreCase("WHEN_SATISFIED")) continue;
                    autoFeatures.addAll(resList);
                }
                if (autoFeatures.isEmpty()) continue;
                installResources.add(autoFeatures);
            }
        }
    }

    Map<String, List<List<RepositoryResource>>> resolveMap(Collection<String> assetNames, RepositoryConnectionList loginInfo, boolean download) throws InstallException {
        List<List<RepositoryResource>> resolved;
        this.fireProgressEvent(8, 2, InstallLogUtils.Messages.INSTALL_KERNEL_MESSAGES.getLogMessage("STATE_PREPARING_ASSETS", new Object[0]));
        HashMap<String, List<List<RepositoryResource>>> installResourcesMap = new HashMap<String, List<List<RepositoryResource>>>();
        Map<String, Collection<String>> assetsMap = InstallUtils.getAssetsMap(assetNames, download);
        Collection<String> dAssets = assetsMap.get("default");
        if (dAssets != null && !dAssets.isEmpty() && !this.isEmpty(resolved = this.resolve(dAssets, loginInfo, download, false))) {
            installResourcesMap.put("default", resolved);
        }
        for (Map.Entry<String, Collection<String>> assetsEntry : assetsMap.entrySet()) {
            if (assetsEntry.getKey().equalsIgnoreCase("default")) continue;
            List<List<RepositoryResource>> resolved2 = this.resolve(assetsEntry.getValue(), loginInfo, download, false);
            if (!download) {
                this.checkESAResources(resolved2);
            }
            if (this.isEmpty(resolved2 = this.removeDuplicated(installResourcesMap, resolved2))) continue;
            installResourcesMap.put(assetsEntry.getKey(), resolved2);
        }
        return installResourcesMap;
    }

    boolean resolveExistingAssetsFromDirectoryRepo(Collection<String> featureNames, File repoDir, boolean isOverwrite) throws InstallException {
        ArrayList<String> existingAssets = new ArrayList<String>();
        for (List<List<RepositoryResource>> targetList : this.installResources.values()) {
            Iterator<List<RepositoryResource>> installResourcesListIterator = targetList.iterator();
            while (installResourcesListIterator.hasNext()) {
                List<RepositoryResource> installResourcesList = installResourcesListIterator.next();
                Iterator<RepositoryResource> resourcesIterator = installResourcesList.iterator();
                while (resourcesIterator.hasNext()) {
                    RepositoryResource installResource = resourcesIterator.next();
                    ResourceType resourceType = installResource.getType();
                    String assetName = "";
                    if (resourceType.equals((Object)ResourceType.FEATURE) || resourceType.equals((Object)ResourceType.ADDON)) {
                        assetName = ((EsaResource)installResource).getShortName();
                    } else {
                        SampleResource sr = (SampleResource)installResource;
                        assetName = sr.getName();
                    }
                    String mainAttachmentName = null;
                    String jsonFileName = null;
                    RepositoryConnection connection = installResource.getRepositoryConnection();
                    this.log(Level.FINEST, "resolveExistingAssetsFromDirectoryRepo " + installResource.getName() + " at " + connection.getRepositoryLocation());
                    if (connection instanceof DirectoryRepositoryConnection && isOverwrite && connection.getRepositoryLocation().equalsIgnoreCase(repoDir.getPath())) {
                        throw ExceptionUtils.createByKey(25, "ERROR_DOWNLOAD_TO_SOURCE_REPO", InstallUtils.getFeatureListOutput(featureNames), repoDir.getAbsolutePath());
                    }
                    try {
                        AttachmentResource mainAttachment = installResource.getMainAttachment();
                        if (mainAttachment != null) {
                            mainAttachmentName = mainAttachment.getName();
                            jsonFileName = mainAttachmentName + ".json";
                        }
                    }
                    catch (RepositoryBackendException e) {
                        this.log(Level.SEVERE, e.getLocalizedMessage(), (Exception)((Object)e));
                        throw ExceptionUtils.createByKey(25, "ERROR_FAILED_TO_DOWNLOAD_FEATURE", InstallUtils.getFeatureListOutput(featureNames), repoDir.getAbsolutePath());
                    }
                    catch (RepositoryResourceException e) {
                        this.log(Level.SEVERE, e.getLocalizedMessage(), (Exception)((Object)e));
                        throw ExceptionUtils.createByKey(25, "ERROR_FAILED_TO_DOWNLOAD_FEATURE", InstallUtils.getFeatureListOutput(featureNames), repoDir.getAbsolutePath());
                    }
                    if (mainAttachmentName == null || !InstallUtils.isResourceExistsInDirectory(installResource, repoDir, mainAttachmentName, jsonFileName)) continue;
                    if (RepositoryDownloadUtil.isPublicAsset(installResource.getType(), installResource)) {
                        existingAssets.add(assetName);
                    }
                    if (isOverwrite) continue;
                    resourcesIterator.remove();
                }
                if (installResourcesList.size() != 0) continue;
                installResourcesListIterator.remove();
            }
        }
        if (!existingAssets.isEmpty()) {
            String existingAssetsString = InstallUtils.getFeatureListOutput(existingAssets);
            if (isOverwrite) {
                if (existingAssets.size() <= 1) {
                    this.log(Level.INFO, InstallLogUtils.Messages.INSTALL_KERNEL_MESSAGES.getLogMessage("STATE_DOWNLOADING_REPLACE_ASSET", existingAssetsString));
                } else {
                    this.log(Level.INFO, InstallLogUtils.Messages.INSTALL_KERNEL_MESSAGES.getLogMessage("STATE_DOWNLOADING_REPLACE_ASSETS", existingAssetsString));
                }
            } else if (existingAssets.size() <= 1) {
                this.log(Level.INFO, InstallLogUtils.Messages.INSTALL_KERNEL_MESSAGES.getLogMessage("STATE_DOWNLOADING_IGNORE_ASSET", existingAssetsString));
            } else {
                this.log(Level.INFO, InstallLogUtils.Messages.INSTALL_KERNEL_MESSAGES.getLogMessage("STATE_DOWNLOADING_IGNORE_ASSETS", existingAssetsString));
            }
        }
        return !this.isEmpty(this.installResources);
    }

    void setRepositoryConnectionList(RepositoryConnectionList loginInfo) {
        this.repositoryConnectionList = loginInfo;
    }

    void setProxy(RestRepositoryConnectionProxy proxy) {
        this.proxy = proxy;
    }

    void setRepositoryProperties(Properties repoProperties) {
        this.repoProperties = repoProperties;
    }

    void setRepositoryUrl(String repositoryUrl) {
        this.repositoryUrl = repositoryUrl;
    }

    void setUserAgent(String kernelUser) {
        String productVersion = this.product.getProductVersion();
        String productEdition = this.product.getProductEdition();
        String installType = this.product.getProductInstallType();
        String user = kernelUser;
        String clientInfo = String.format("%s.%s", user, installType);
        this.userAgent = String.format("com.ibm.websphere.appserver/%s (%s; %s)", productVersion, productEdition, clientInfo);
    }

    private void checkResource(RepositoryResource installResource) throws InstallException {
        File serverDir;
        SampleResource sr;
        String serverName;
        if ((installResource.getType().equals((Object)ResourceType.PRODUCTSAMPLE) || installResource.getType().equals((Object)ResourceType.OPENSOURCE)) && (serverName = (sr = (SampleResource)installResource).getShortName()) != null && (serverDir = new File(Utils.getUserDir(), "servers/" + serverName)).exists()) {
            String msgId = installResource.getType().equals((Object)ResourceType.PRODUCTSAMPLE) ? "ERROR_SAMPLE_SERVER_ALREADY_INSTALLED" : "ERROR_OPENSOURCE_SERVER_ALREADY_INSTALLED";
            throw ExceptionUtils.createByKey(msgId, sr.getName(), serverName);
        }
        RepositoryConnection rc = installResource.getRepositoryConnection();
        if (rc instanceof DirectoryRepositoryConnection) {
            AttachmentResource ar = null;
            try {
                ar = installResource.getMainAttachment();
            }
            catch (RepositoryBackendException e) {
                this.log(Level.FINEST, "Failed to get main attachment", (Exception)((Object)e));
            }
            catch (RepositoryResourceException e) {
                this.log(Level.FINEST, "Failed to get main attachment", (Exception)((Object)e));
            }
            if (ar == null) {
                File f = new File(rc.getRepositoryLocation(), installResource.getId());
                throw ExceptionUtils.createByKey(24, "ERROR_INSTALL_ESA_FILE_NOTEXIST", f.getAbsolutePath());
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private ESAAsset createESAAsset(File esaFile, String toExtension) {
        ProvisioningFeatureDefinition fd;
        ESAAsset esaAsset;
        String esaPath = esaFile.getAbsolutePath();
        String debugHeader = "createESAAsset(" + esaFile.getAbsolutePath() + ", \"" + toExtension + "\"): ";
        try {
            if (this.esaAssetCach.containsKey(esaPath)) {
                return this.esaAssetCach.get(esaPath);
            }
            esaAsset = new ESAAsset(esaFile, toExtension, false);
            fd = esaAsset.getProvisioningFeatureDefinition();
            if (this.esaAssetCach.containsKey(fd.getSymbolicName())) {
                return this.esaAssetCach.get(fd.getSymbolicName());
            }
        }
        catch (Exception e) {
            this.esaAssetCach.put(esaPath, null);
            this.log(Level.SEVERE, debugHeader + InstallLogUtils.Messages.PROVISIONER_MESSAGES.getLogMessage("tool.install.bad.zip", esaFile.getAbsolutePath(), e.getMessage()), e);
            return null;
        }
        if (esaAsset.getSubsystemEntry() == null) {
            this.esaAssetCach.put(esaPath, null);
            this.log(Level.FINEST, debugHeader + InstallLogUtils.Messages.PROVISIONER_MESSAGES.getLogMessage("tool.install.content.no.subsystem.manifest", new Object[0]));
            return null;
        }
        fd = esaAsset.getProvisioningFeatureDefinition();
        if (!fd.isSupportedFeatureVersion()) {
            this.esaAssetCach.put(esaPath, null);
            this.log(Level.FINEST, debugHeader + InstallLogUtils.Messages.PROVISIONER_MESSAGES.getLogMessage("UNSUPPORTED_FEATURE_VERSION", fd.getFeatureName(), fd.getIbmFeatureVersion()));
            return null;
        }
        String appliesToHeader = fd.getHeader("IBM-AppliesTo");
        List productMatchers = SelfExtractor.parseAppliesTo((String)appliesToHeader);
        ReturnCode validInstallRC = SelfExtractor.validateProductMatches((File)Utils.getInstallDir(), (List)productMatchers);
        if (validInstallRC != ReturnCode.OK) {
            this.esaAssetCach.put(esaPath, null);
            this.log(Level.FINEST, debugHeader + validInstallRC.getErrorMessage());
            return null;
        }
        this.esaAssetCach.put(fd.getSymbolicName(), esaAsset);
        this.esaAssetCach.put(esaFile.getAbsolutePath(), esaAsset);
        return esaAsset;
    }

    private InstallInformation createInstallInformation(String esa, String feature, int progress) throws InstallException {
        File esaToInstall = null;
        String installRootFolder = null;
        boolean isTemporary = true;
        try {
            URL url = new URL(esa);
            String urlExtrernalForm = url.toExternalForm();
            installRootFolder = urlExtrernalForm.substring(0, urlExtrernalForm.lastIndexOf("/")) + "/";
            if (this.downloadCach.containsKey(esa)) {
                esaToInstall = this.downloadCach.get(esa);
            } else {
                this.fireProgressEvent(32, progress, InstallLogUtils.Messages.INSTALL_KERNEL_MESSAGES.getLogMessage("STATE_DOWNLOADING", url));
                esaToInstall = File.createTempFile("libertyfeature", ".esa");
                InstallUtils.download(url, esaToInstall);
                this.downloadCach.put(esa, esaToInstall);
            }
        }
        catch (MalformedURLException e) {
            int lastSeparator;
            InstallUtils.delete(esaToInstall);
            esaToInstall = new File(esa);
            isTemporary = false;
            int lastSlash = esa.lastIndexOf("/");
            int lastBackSlash = esa.lastIndexOf("\\");
            int n = lastSeparator = lastSlash > lastBackSlash ? lastSlash : lastBackSlash;
            installRootFolder = lastSeparator != -1 ? esa.substring(0, lastSeparator + 1) : "";
        }
        catch (IOException e) {
            if (esaToInstall == null) {
                throw ExceptionUtils.create(InstallLogUtils.Messages.PROVISIONER_MESSAGES.getLogMessage("tool.install.download.tmpFile", e.getMessage()), 20);
            }
            throw ExceptionUtils.create(InstallLogUtils.Messages.PROVISIONER_MESSAGES.getLogMessage("tool.install.download.esa", esaToInstall, e.getMessage()), 20);
        }
        if (!esaToInstall.exists()) {
            throw ExceptionUtils.create(InstallLogUtils.Messages.PROVISIONER_MESSAGES.getLogMessage("tool.install.file.notexist", esaToInstall), 20);
        }
        if (!esaToInstall.isFile()) {
            throw ExceptionUtils.create(InstallLogUtils.Messages.PROVISIONER_MESSAGES.getLogMessage("tool.install.file.notafile", esaToInstall), 20);
        }
        return new InstallInformation(esaToInstall, feature, installRootFolder, isTemporary);
    }

    private ESAAsset getEsaAsset(String feature, File fromDir, String toExtension) {
        File[] esaes;
        ESAAsset esaAsset;
        File esaFile = new File(fromDir, feature + ".esa");
        if (esaFile.exists() && (esaAsset = this.createESAAsset(esaFile, toExtension)) != null && esaAsset.matchFeature(feature)) {
            return esaAsset;
        }
        FilenameFilter ff = new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return name.toLowerCase().endsWith(".esa");
            }
        };
        for (File esa : esaes = fromDir.listFiles(ff)) {
            ESAAsset esaAsset2;
            if (!esa.isFile() || (esaAsset2 = this.createESAAsset(esa, toExtension)) == null || !esaAsset2.matchFeature(feature)) continue;
            return esaAsset2;
        }
        return null;
    }

    private ESAAsset getESAAssetFromCached(String feature) {
        ESAAsset esa = this.esaAssetCach.get(feature);
        if (esa != null) {
            return esa;
        }
        for (String k : this.esaAssetCach.keySet()) {
            if (!k.toLowerCase().endsWith("." + feature.toLowerCase())) continue;
            esa = this.esaAssetCach.get(k);
            String s = esa.getShortName();
            if (s != null && s.equalsIgnoreCase(feature)) {
                return esa;
            }
            s = esa.getProvideFeature();
            if (s == null || !s.equals(feature)) continue;
            return esa;
        }
        return null;
    }

    private boolean isFeatureManager() {
        return this.userAgent != null && this.userAgent.contains("featureManager");
    }

    private String resolve(InstallInformation installInformation, String toExtension, Set<String> features, ArrayList<InstallAsset> installAssets, int progress, int interval) throws InstallException {
        String shortName;
        ESAAsset esa = null;
        ProvisioningFeatureDefinition fd = null;
        try {
            String esaPath = installInformation.esaToInstall.getAbsolutePath();
            esa = this.esaAssetCach.get(esaPath);
            if (esa == null) {
                esa = new ESAAsset(installInformation.esaToInstall, toExtension, installInformation.isTemporary);
                this.esaAssetCach.put(esaPath, esa);
            } else {
                esa.setRepoType(toExtension);
            }
            if (esa.getSubsystemEntry() == null) {
                throw ExceptionUtils.create(InstallLogUtils.Messages.PROVISIONER_MESSAGES.getLogMessage("tool.install.content.no.subsystem.manifest", new Object[0]), 23);
            }
            fd = esa.getProvisioningFeatureDefinition();
            if (!fd.isSupportedFeatureVersion()) {
                throw ExceptionUtils.create(InstallLogUtils.Messages.PROVISIONER_MESSAGES.getLogMessage("UNSUPPORTED_FEATURE_VERSION", fd.getFeatureName(), fd.getIbmFeatureVersion()), 23);
            }
        }
        catch (ZipException e) {
            throw ExceptionUtils.create(InstallLogUtils.Messages.PROVISIONER_MESSAGES.getLogMessage("tool.install.bad.zip", installInformation.esaToInstall, e), e);
        }
        catch (IOException e) {
            throw ExceptionUtils.create(InstallLogUtils.Messages.PROVISIONER_MESSAGES.getLogMessage("tool.install.bad.zip", installInformation.esaToInstall, e), e);
        }
        if (!(installInformation.feature == null || installInformation.feature.equals(fd.getSymbolicName()) || (shortName = InstallUtils.getShortName(fd)) != null && shortName.equalsIgnoreCase(installInformation.feature))) {
            throw ExceptionUtils.createByKey(23, "ERROR_FAILED_TO_RESOLVE_FEATURE_FROM_ESA", installInformation.feature, installInformation.esaToInstall.getAbsolutePath());
        }
        if (features.contains(fd.getSymbolicName())) {
            return fd.getSymbolicName();
        }
        InstallUtils.validateProductMatches(fd, this.product.getInstallDir());
        features.add(fd.getSymbolicName());
        Collection featureResources = fd.getConstituents(null);
        if (featureResources.size() > 0) {
            int p = progress;
            int i = interval / featureResources.size();
            for (FeatureResource fr : featureResources) {
                p += i;
                SubsystemContentType type = fr.getType();
                if (SubsystemContentType.FEATURE_TYPE != type || features.contains(fr.getSymbolicName())) continue;
                String esaLocation = installInformation.installRootFolder + fr.getSymbolicName() + ".esa";
                try {
                    this.resolve(this.createInstallInformation(esaLocation, fr.getSymbolicName(), progress), toExtension, features, installAssets, p, i);
                }
                catch (InstallException e) {
                    if (e.getRc() == 22) continue;
                    throw ExceptionUtils.create(e.getMessage() + "\n" + InstallLogUtils.Messages.PROVISIONER_MESSAGES.getLogMessage("tool.install.missing.feature", fd.getSymbolicName(), fr.getSymbolicName()));
                }
            }
        }
        if (!this.product.isInstalled(esa)) {
            installAssets.add(esa);
        }
        return fd.getSymbolicName();
    }

    private void resolve(String feature, File fromDir, String toExtension, boolean offlineOnly, Set<String> installedFeatures, Map<String, ESAAsset> esaAssetsMap, ArrayList<InstallAsset> installAssets, ArrayList<String> unresolvedFeatures) throws InstallException {
        String featureName;
        ESAAsset esa = null;
        esa = this.getESAAssetFromCached(feature);
        if (esa == null) {
            esa = this.getEsaAsset(feature, fromDir, toExtension);
            if (esa == null) {
                if (offlineOnly) {
                    throw ExceptionUtils.createByKey("ERROR_FAILED_TO_RESOLVE_FEATURE_FROM_DIR", feature, fromDir.getAbsolutePath());
                }
                unresolvedFeatures.add(feature);
                return;
            }
        } else {
            try {
                esa.setRepoType(toExtension);
            }
            catch (IOException e) {
                throw ExceptionUtils.create(InstallLogUtils.Messages.PROVISIONER_MESSAGES.getLogMessage("tool.install.bad.zip", esa.getAsset().getAbsoluteFile(), e.getMessage()), e);
            }
        }
        if (installedFeatures.contains(featureName = esa.getFeatureName())) {
            return;
        }
        installedFeatures.add(featureName);
        ProvisioningFeatureDefinition fd = esa.getProvisioningFeatureDefinition();
        Collection featureResources = fd.getConstituents(null);
        if (featureResources.size() > 0) {
            for (FeatureResource fr : featureResources) {
                SubsystemContentType type = fr.getType();
                if (SubsystemContentType.FEATURE_TYPE != type || installedFeatures.contains(fr.getSymbolicName())) continue;
                try {
                    this.resolve(fr.getSymbolicName(), fromDir, toExtension, offlineOnly, installedFeatures, esaAssetsMap, installAssets, unresolvedFeatures);
                }
                catch (InstallException e) {
                    if (offlineOnly) {
                        throw ExceptionUtils.create(InstallLogUtils.Messages.PROVISIONER_MESSAGES.getLogMessage("tool.install.missing.feature", fd.getSymbolicName(), fr.getSymbolicName()), e);
                    }
                    unresolvedFeatures.add(feature);
                }
            }
        }
        if (!this.product.isInstalled(esa)) {
            installAssets.add(esa);
        }
    }

    private void resolveAutoFeature(Collection<ESAAsset> autoFeatures, ArrayList<InstallAsset> installAssets, Collection<ProvisioningFeatureDefinition> featureDefinitionsToCheck) {
        HashSet<ESAAsset> notSatisfied = new HashSet<ESAAsset>();
        for (ESAAsset autoFeature : autoFeatures) {
            if (installAssets.contains(autoFeature)) {
                this.log(Level.FINEST, "auto feature " + autoFeature.getProvideFeature() + " is already resolved.");
                continue;
            }
            ProvisioningFeatureDefinition pdf = autoFeature.getProvisioningFeatureDefinition();
            if (pdf == null) continue;
            if (pdf.isCapabilitySatisfied(featureDefinitionsToCheck)) {
                this.log(Level.FINEST, "auto feature " + autoFeature.getProvideFeature() + " will be installed.");
                featureDefinitionsToCheck.add(autoFeature.getProvisioningFeatureDefinition());
                installAssets.add(autoFeature);
                continue;
            }
            this.log(Level.FINEST, "auto feature " + autoFeature.getProvideFeature() + " is not satisfied.");
            notSatisfied.add(autoFeature);
        }
        if (notSatisfied.isEmpty() || autoFeatures.size() == notSatisfied.size()) {
            return;
        }
        this.resolveAutoFeature(notSatisfied, installAssets, featureDefinitionsToCheck);
    }

    private void setUserAgent() {
        String ua = System.getProperty("user.agent");
        String productVersion = this.product.getProductVersion();
        String productEdition = this.product.getProductEdition();
        if (ua != null && !ua.isEmpty()) {
            ua = String.format("com.ibm.websphere.appserver/%s (%s; %s)", productVersion, productEdition, ua);
        }
        this.userAgent = ua;
    }

    void checkAssetsNotInstalled(Collection<String> assetIds, boolean installingFeature) throws InstallException {
        this.log(Level.FINEST, "Check following assets whether they were installed or not: " + assetIds);
        if (assetIds == null || assetIds.isEmpty()) {
            throw ExceptionUtils.createByKey("ERROR_ASSETS_LIST_INVALID", new Object[0]);
        }
        RepositoryConnectionList loginInfo = new RepositoryConnectionList();
        List<List<RepositoryResource>> resources = null;
        try {
            resources = this.resolve(assetIds, loginInfo, false, installingFeature);
        }
        catch (InstallException e) {
            this.log(Level.FINEST, "checkAssetsNotInstalled() ignore exception: " + e.getMessage(), e);
            this.log(Level.FINEST, "checkAssetsNotInstalled() cause of exception: " + e.getCause().getMessage());
            return;
        }
        if (this.isEmpty(resources)) {
            throw ExceptionUtils.createByKey(22, "ASSETS_ALREADY_INSTALLED", InstallUtils.getShortNames(this.product.getFeatureDefinitions(), assetIds).toString());
        }
    }

    private static class InstallInformation {
        private final File esaToInstall;
        private final String installRootFolder;
        private final boolean isTemporary;
        private final String feature;

        public InstallInformation(File esaToInstall, String feature, String installRootFolder, boolean isTemporary) {
            this.esaToInstall = esaToInstall;
            this.feature = feature;
            this.installRootFolder = installRootFolder;
            this.isTemporary = isTemporary;
        }
    }
}

