/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webcontainer.osgi;

import com.ibm.websphere.csi.J2EEName;
import com.ibm.websphere.csi.J2EENameFactory;
import com.ibm.websphere.event.Event;
import com.ibm.websphere.event.EventEngine;
import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.ws.container.Container;
import com.ibm.ws.container.service.app.deploy.ModuleInfo;
import com.ibm.ws.container.service.app.deploy.WebModuleInfo;
import com.ibm.ws.container.service.app.deploy.extended.ExtendedModuleInfo;
import com.ibm.ws.container.service.app.deploy.extended.ModuleRuntimeContainer;
import com.ibm.ws.container.service.metadata.MetaDataException;
import com.ibm.ws.container.service.metadata.MetaDataService;
import com.ibm.ws.container.service.state.StateChangeException;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ffdc.annotation.FFDCIgnore;
import com.ibm.ws.managedobject.ManagedObjectService;
import com.ibm.ws.runtime.metadata.ComponentMetaData;
import com.ibm.ws.runtime.metadata.ModuleMetaData;
import com.ibm.ws.threading.FutureMonitor;
import com.ibm.ws.threading.listeners.CompletionListener;
import com.ibm.ws.webcontainer.SessionRegistry;
import com.ibm.ws.webcontainer.async.AsyncContextFactory;
import com.ibm.ws.webcontainer.async.AsyncContextImpl;
import com.ibm.ws.webcontainer.collaborator.CollaboratorService;
import com.ibm.ws.webcontainer.exception.WebAppHostNotFoundException;
import com.ibm.ws.webcontainer.osgi.DynamicVirtualHost;
import com.ibm.ws.webcontainer.osgi.DynamicVirtualHostManager;
import com.ibm.ws.webcontainer.osgi.WebContainerConfiguration;
import com.ibm.ws.webcontainer.osgi.WebMBeanRuntime;
import com.ibm.ws.webcontainer.osgi.container.DeployedModule;
import com.ibm.ws.webcontainer.osgi.metadata.WebCollaboratorComponentMetaDataImpl;
import com.ibm.ws.webcontainer.osgi.metadata.WebComponentMetaDataImpl;
import com.ibm.ws.webcontainer.osgi.metadata.WebModuleMetaDataImpl;
import com.ibm.ws.webcontainer.osgi.osgi.WebContainerConstants;
import com.ibm.ws.webcontainer.osgi.request.IRequestFactory;
import com.ibm.ws.webcontainer.osgi.response.IResponseFactory;
import com.ibm.ws.webcontainer.osgi.session.SessionHelper;
import com.ibm.ws.webcontainer.osgi.srt.SRTConnectionContext;
import com.ibm.ws.webcontainer.osgi.srt.SRTConnectionContextPool;
import com.ibm.ws.webcontainer.osgi.webapp.WebApp;
import com.ibm.ws.webcontainer.osgi.webapp.WebAppConfiguration;
import com.ibm.ws.webcontainer.osgi.webapp.WebAppFactory;
import com.ibm.ws.webcontainer.servlet.CacheServletWrapperFactory;
import com.ibm.ws.webcontainer.util.OneTimeUseArrayList;
import com.ibm.ws.webcontainer.util.VirtualHostContextRootMapper;
import com.ibm.wsspi.adaptable.module.adapters.AdapterFactoryService;
import com.ibm.wsspi.classloading.ClassLoadingService;
import com.ibm.wsspi.http.EncodingUtils;
import com.ibm.wsspi.http.VirtualHost;
import com.ibm.wsspi.http.VirtualHostListener;
import com.ibm.wsspi.injectionengine.ComponentNameSpaceConfigurationProvider;
import com.ibm.wsspi.injectionengine.InjectionEngine;
import com.ibm.wsspi.injectionengine.ReferenceContext;
import com.ibm.wsspi.kernel.service.location.WsLocationAdmin;
import com.ibm.wsspi.kernel.service.utils.AtomicServiceReference;
import com.ibm.wsspi.kernel.service.utils.ConcurrentServiceReferenceSet;
import com.ibm.wsspi.kernel.service.utils.FrameworkState;
import com.ibm.wsspi.webcontainer.WCCustomProperties;
import com.ibm.wsspi.webcontainer.WebContainerRequestState;
import com.ibm.wsspi.webcontainer.cache.CacheManager;
import com.ibm.wsspi.webcontainer.extension.ExtensionFactory;
import com.ibm.wsspi.webcontainer.metadata.WebModuleMetaData;
import com.ibm.wsspi.webcontainer.servlet.IServletConfig;
import com.ibm.wsspi.webcontainer.servlet.ITransferContextService;
import com.ibm.wsspi.webcontainer.util.FFDCWrapper;
import com.ibm.wsspi.webcontainer.util.ThreadContextHelper;
import com.ibm.wsspi.webcontainer.util.URIMatcherFactory;
import jakarta.servlet.ServletContainerInitializer;
import java.io.File;
import java.io.InputStream;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import java.util.logging.Level;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.ConfigurationPolicy;
import org.osgi.service.component.annotations.Modified;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;
import org.osgi.service.component.annotations.ReferencePolicyOption;

@Component(name="com.ibm.ws.webcontainer", configurationPid={"com.ibm.ws.webcontainer"}, configurationPolicy=ConfigurationPolicy.REQUIRE, property={"service.vendor=IBM", "type:String=web"})
public class WebContainer
extends com.ibm.ws.webcontainer.WebContainer
implements ModuleRuntimeContainer,
VirtualHostListener {
    private static final TraceComponent tc = Tr.register(WebContainer.class, (String)"webcontainer", (String)"com.ibm.ws.webcontainer.resources.LShimMessages");
    private static final String CLASS_NAME = "com.ibm.ws.webcontainer.osgi.WebContainer";
    private boolean initialized;
    private volatile EventEngine eventService = null;
    private volatile FutureMonitor futureMonitor;
    private final AtomicServiceReference<ClassLoadingService> classLoadingSRRef = new AtomicServiceReference("classLoadingService");
    private final AtomicServiceReference<SessionHelper> sessionHelperSRRef = new AtomicServiceReference("sessionHelper");
    private final AtomicServiceReference<CacheManager> cacheManagerSRRef = new AtomicServiceReference("cacheManager");
    private final AtomicServiceReference<InjectionEngine> injectionEngineSRRef = new AtomicServiceReference("injectionEngine");
    private final AtomicServiceReference<ManagedObjectService> managedObjectServiceSRRef = new AtomicServiceReference("managedObjectService");
    private final OneTimeUseArrayList backgroundWebAppStartFutures = new OneTimeUseArrayList();
    private static final String REFERENCE_WEB_MBEAN_RUNTIME = "webMBeanRuntime";
    private final AtomicServiceReference<WebMBeanRuntime> webMBeanRuntimeServiceRef = new AtomicServiceReference("webMBeanRuntime");
    private final ConcurrentServiceReferenceSet<ServletContainerInitializer> servletContainerInitializers = new ConcurrentServiceReferenceSet("servletContainerInitializers");
    private volatile ExecutorService es = null;
    private final AtomicReference<WsLocationAdmin> locationServiceRef = new AtomicReference();
    private final ConcurrentServiceReferenceSet<ITransferContextService> transferContextServiceRef = new ConcurrentServiceReferenceSet("transferService");
    private final AtomicReference<EncodingUtils> encodingServiceRef = new AtomicReference();
    private static final AtomicReference<WebContainer> instance = new AtomicReference();
    private DynamicVirtualHostManager vhostManager;
    private MetaDataService metaDataService = null;
    private J2EENameFactory j2eeNameFactory = null;
    public ComponentContext context = null;
    private final Set<String> contextRoots = Collections.synchronizedSet(new HashSet());
    private final Map<String, Set<DeployedModule>> pendingContextRoots = new HashMap<String, Set<DeployedModule>>();
    private Map<WebModuleInfo, DeployedModule> deployedModuleMap = new ConcurrentHashMap<WebModuleInfo, DeployedModule>();
    private SRTConnectionContextPool connContextPool;
    private static final String DEFAULT_PORT = "*";
    private static final String DEFAULT_VHOST_NAME = "default_host";
    private static String cachedServerInfo = null;
    private Object lock = new Object(){};
    private WebAppFactory webAppFactory;
    private IRequestFactory requestFactory;
    private IResponseFactory responseFactory;
    private AsyncContextFactory asyncContextFactory;
    private static final int DEFAULT_MAX_VERSION = 30;
    private static boolean serverStopping = false;
    private final AtomicInteger modulesStarting = new AtomicInteger(0);
    private URIMatcherFactory uriMatcherFactory;
    public static final int SPEC_LEVEL_30 = 30;
    public static final int SPEC_LEVEL_31 = 31;
    public static final int SPEC_LEVEL_40 = 40;
    public static final int SPEC_LEVEL_50 = 50;
    public static final int SPEC_LEVEL_60 = 60;
    public static final int SPEC_LEVEL_61 = 61;
    private static final int DEFAULT_SPEC_LEVEL = 30;
    private static int loadedContainerSpecLevel = WebContainer.loadServletVersion();

    @Reference(name="webMBeanRuntime", service=WebMBeanRuntime.class, cardinality=ReferenceCardinality.OPTIONAL, policy=ReferencePolicy.DYNAMIC)
    protected void setWebMBeanRuntime(ServiceReference<WebMBeanRuntime> ref) {
        this.webMBeanRuntimeServiceRef.setReference(ref);
    }

    protected void unsetWebMBeanRuntime(ServiceReference<WebMBeanRuntime> ref) {
        this.webMBeanRuntimeServiceRef.unsetReference(ref);
    }

    private WebContainer(String name, Container parent) {
        super(name, parent);
    }

    public WebContainer() {
        this("Was.webcontainer", null);
        this.requestMapper = new VirtualHostContextRootMapper();
        this.setVHostCompatFlag(false);
    }

    public void activate(ComponentContext compcontext, Map<String, Object> properties) {
        String methodName = "activate";
        if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
            Tr.event((TraceComponent)tc, (String)"Activating the WebContainer bundle", (Object[])new Object[0]);
        }
        this.context = compcontext;
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)methodName, (Object[])new Object[]{"Default Port [ * ]"});
            Tr.debug((TraceComponent)tc, (String)methodName, (Object[])new Object[]{"Default Virtual Host [ default_host ]"});
        }
        WebContainerConfiguration webconfig = new WebContainerConfiguration(DEFAULT_PORT);
        webconfig.setDefaultVirtualHostName(DEFAULT_VHOST_NAME);
        this.initialize(webconfig, properties);
        this.classLoadingSRRef.activate(this.context);
        this.sessionHelperSRRef.activate(this.context);
        this.cacheManagerSRRef.activate(this.context);
        this.injectionEngineSRRef.activate(this.context);
        this.managedObjectServiceSRRef.activate(this.context);
        this.servletContainerInitializers.activate(this.context);
        this.transferContextServiceRef.activate(this.context);
        this.webMBeanRuntimeServiceRef.activate(this.context);
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Object mbeanService = this.context.locateService(REFERENCE_WEB_MBEAN_RUNTIME);
            Tr.debug((TraceComponent)tc, (String)methodName, (Object[])new Object[]{"Web MBean Runtime [ " + mbeanService + " ]"});
            Tr.debug((TraceComponent)tc, (String)methodName, (Object[])new Object[]{"Web MBean Runtime Reference [ " + this.webMBeanRuntimeServiceRef.getReference() + " ]"});
            Tr.debug((TraceComponent)tc, (String)methodName, (Object[])new Object[]{"Web MBean Runtime Service [ " + this.webMBeanRuntimeServiceRef.getService() + " ]"});
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)methodName, (Object[])new Object[]{"Posting STARTED_EVENT"});
        }
        Event event = this.eventService.createEvent(WebContainerConstants.STARTED_EVENT);
        this.eventService.postEvent(event);
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)methodName, (Object[])new Object[]{"Posted STARTED_EVENT"});
        }
        self.set(this);
        instance.set(this);
        selfInit.countDown();
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)methodName, (Object[])new Object[]{"Activating the WebContainer bundle: Complete"});
        }
    }

    public static void setServerStopping(boolean serverStop) {
        serverStopping = serverStop;
    }

    public static boolean isServerStopping() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("serverStopping = " + serverStopping), (Object[])new Object[0]);
        }
        return serverStopping;
    }

    public void waitForApplicationInitialization() {
        String methodName = "waitForApplicationInitialization";
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)methodName, (Object[])new Object[0]);
        }
        Iterator<Future<?>> backgroundWebAppStartFuturesIterator = this.backgroundWebAppStartFutures.iterator();
        while (backgroundWebAppStartFuturesIterator.hasNext()) {
            try {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"waitForApplicationInitialization: Start wait for app init.", (Object[])new Object[0]);
                }
                backgroundWebAppStartFuturesIterator.next().get(30L, TimeUnit.SECONDS);
                if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) continue;
                Tr.debug((TraceComponent)tc, (String)"waitForApplicationInitialization: End wait for app init.", (Object[])new Object[0]);
            }
            catch (Exception e) {
                if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) continue;
                Tr.debug((TraceComponent)tc, (String)methodName, (Object[])new Object[]{"Exception caught while waiting for background web apps to initialize"});
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("waitForApplicationInitialization: Number of modules starting = " + this.modulesStarting.get()), (Object[])new Object[0]);
        }
        for (int i = 0; i < 40 && this.modulesStarting.get() > 0; ++i) {
            try {
                Thread.sleep(500L);
                continue;
            }
            catch (InterruptedException e) {
                i = 40;
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)methodName);
        }
    }

    @FFDCIgnore(value={Exception.class})
    public void deactivate(ComponentContext componentContext) {
        String methodName = "deactivate";
        if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
            Tr.event((TraceComponent)tc, (String)"Deactivating the WebContainer bundle", (Object[])new Object[0]);
        }
        if (FrameworkState.isStopping() && AsyncContextImpl.executorRetrieved.get()) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)methodName, (Object[])new Object[]{"shutting down now async servlet thread pool executor"});
            }
            AsyncContextImpl.ExecutorFieldHolder.field.shutdownNow();
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)methodName, (Object[])new Object[]{"Posting STOPPED_EVENT"});
        }
        Event event = this.eventService.createEvent(WebContainerConstants.STOPPED_EVENT);
        this.eventService.postEvent(event);
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)methodName, (Object[])new Object[]{"Posted STOPPED_EVENT"});
        }
        this.classLoadingSRRef.deactivate(componentContext);
        this.sessionHelperSRRef.deactivate(componentContext);
        this.cacheManagerSRRef.deactivate(componentContext);
        this.injectionEngineSRRef.deactivate(componentContext);
        this.managedObjectServiceSRRef.deactivate(this.context);
        this.servletContainerInitializers.deactivate(componentContext);
        this.transferContextServiceRef.deactivate(componentContext);
        this.webMBeanRuntimeServiceRef.deactivate(componentContext);
        instance.compareAndSet(this, null);
        self.compareAndSet(this, null);
        selfInit = new CountDownLatch(1);
        extensionFactories.clear();
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)methodName, (Object[])new Object[]{"Deactivating the WebContainer bundle: Complete"});
        }
    }

    @Modified
    protected void modified(Map<String, Object> cfg) {
        WebContainerConfiguration webconfig = new WebContainerConfiguration(DEFAULT_PORT);
        webconfig.setDefaultVirtualHostName(DEFAULT_VHOST_NAME);
        this.initialize(webconfig, cfg);
    }

    public void initialize(WebContainerConfiguration config, Map<String, Object> properties) {
        super.initialize(config);
        config.setConfiguration(properties);
        boolean isDefaultTempDir = true;
        com.ibm.ws.webcontainer.WebContainer.setIsDefaultTempDir(isDefaultTempDir);
        this.initialized = true;
    }

    @Reference(service=ClassLoadingService.class, name="classLoadingService")
    protected void setClassLoadingService(ServiceReference<ClassLoadingService> ref) {
        this.classLoadingSRRef.setReference(ref);
    }

    protected void unsetClassLoadingService(ServiceReference<ClassLoadingService> ref) {
        this.classLoadingSRRef.unsetReference(ref);
    }

    @Reference
    protected void setFutureMonitor(FutureMonitor futureMonitor) {
        this.futureMonitor = futureMonitor;
    }

    protected void unsetFutureMonitor(FutureMonitor futureMonitor) {
        this.futureMonitor = null;
    }

    @Reference(policy=ReferencePolicy.DYNAMIC)
    protected void setEventService(EventEngine service) {
        this.eventService = service;
    }

    public static EventEngine getEventService() {
        WebContainer thisInstance = instance.get();
        if (thisInstance != null) {
            return thisInstance.eventService;
        }
        return null;
    }

    protected void unsetEventService(EventEngine ref) {
    }

    @Reference(service=ITransferContextService.class, cardinality=ReferenceCardinality.MULTIPLE, policy=ReferencePolicy.DYNAMIC, name="transferService")
    protected void setTransferService(ServiceReference<ITransferContextService> ref) {
        this.transferContextServiceRef.addReference(ref);
    }

    protected void unsetTransferService(ServiceReference<ITransferContextService> ref) {
        this.transferContextServiceRef.removeReference(ref);
    }

    protected void unsetEncodingService(EncodingUtils encUtils) {
        if (encUtils == this.encodingServiceRef.get()) {
            this.encodingServiceRef.set(null);
        }
    }

    public static Iterator<ITransferContextService> getITransferContextServices() {
        WebContainer thisService = instance.get();
        if (thisService != null) {
            Iterator services = thisService.transferContextServiceRef.getServices();
            return services;
        }
        return null;
    }

    @Reference(policy=ReferencePolicy.DYNAMIC)
    protected void setExecutorService(ExecutorService service) {
        this.es = service;
    }

    @Reference(policy=ReferencePolicy.DYNAMIC)
    protected void setEncodingService(EncodingUtils encUtils) {
        this.encodingServiceRef.set(encUtils);
    }

    public static ExecutorService getExecutorService() throws Exception {
        WebContainer thisInstance = instance.get();
        if (thisInstance != null) {
            return thisInstance.es;
        }
        Exception e = new Exception("Executor Service not available");
        throw e;
    }

    protected void unsetExecutorService(ExecutorService service) {
    }

    @Reference
    protected void setCollaboratorService(CollaboratorService collaborationService) {
    }

    protected void unsetCollaboratorService(CollaboratorService ref) {
    }

    @Reference(service=SessionHelper.class, name="sessionHelper")
    protected void setSessionHelper(ServiceReference<SessionHelper> ref) {
        this.sessionHelperSRRef.setReference(ref);
    }

    protected void unsetSessionHelper(ServiceReference<SessionHelper> ref) {
        this.sessionHelperSRRef.unsetReference(ref);
    }

    @Override
    protected SessionRegistry getSessionRegistry() {
        SessionHelper sessionHelper = (SessionHelper)this.sessionHelperSRRef.getService();
        if (sessionHelper != null) {
            return sessionHelper.getRegistry();
        }
        return null;
    }

    @Reference(policy=ReferencePolicy.DYNAMIC, service=InjectionEngine.class, name="injectionEngine")
    protected void setInjectionEngine(ServiceReference<InjectionEngine> ref) {
        this.injectionEngineSRRef.setReference(ref);
    }

    protected void unsetInjectionEngine(ServiceReference<InjectionEngine> ref) {
        this.injectionEngineSRRef.unsetReference(ref);
    }

    @Reference(name="managedObjectService", service=ManagedObjectService.class, policy=ReferencePolicy.DYNAMIC, policyOption=ReferencePolicyOption.GREEDY)
    protected void setManagedObjectService(ServiceReference<ManagedObjectService> ref) {
        this.managedObjectServiceSRRef.setReference(ref);
    }

    protected void unsetManagedObjectService(ServiceReference<ManagedObjectService> ref) {
        this.managedObjectServiceSRRef.unsetReference(ref);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Reference
    protected void setVirtualHostMgr(DynamicVirtualHostManager vhostMgr) {
        this.vhostManager = vhostMgr;
        Object object = this.lock;
        synchronized (object) {
            for (ExtensionFactory ef : extensionFactories) {
                this.registerExtensionFactoryWithVirtualHosts(ef);
            }
        }
    }

    protected void unsetVirtualHostMgr(DynamicVirtualHostManager vhostMgr) {
    }

    @Override
    public DynamicVirtualHost getVirtualHost(String targetHost) throws WebAppHostNotFoundException {
        if (this.vhostManager == null) {
            return null;
        }
        return this.vhostManager.getVirtualHost(targetHost, this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Future<Boolean> addContextRootRequirement(DeployedModule deployedModule) {
        String methodName = "addContextRootRequirement";
        String contextRoot = deployedModule.getMappingContextRoot();
        Set<String> set = this.contextRoots;
        synchronized (set) {
            Future future = this.futureMonitor.createFuture(Boolean.class);
            deployedModule.addStartupListener(future, new CompletionListener<Boolean>(){

                public void failedCompletion(Future<Boolean> arg0, Throwable arg1) {
                }

                public void successfulCompletion(Future<Boolean> arg0, Boolean arg1) {
                    WebContainer.this.futureMonitor.setResult(arg0, (Object)arg1);
                }
            });
            if (this.contextRoots.contains(contextRoot)) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)methodName, (Object[])new Object[]{"contextRoot-> [" + contextRoot + "] already added , set future done for deployedModule -->" + deployedModule});
                }
                deployedModule.initTaskComplete();
            } else {
                Set<DeployedModule> pending = this.pendingContextRoots.get(contextRoot);
                if (pending == null) {
                    pending = new LinkedHashSet<DeployedModule>();
                    this.pendingContextRoots.put(contextRoot, pending);
                }
                pending.add(deployedModule);
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)methodName, (Object[])new Object[]{"contextRoot-> [" + contextRoot + "] not added , in pending future " + future + " for deployedModule -->" + deployedModule});
                }
            }
            return future;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeContextRootRequirement(DeployedModule deployedModule) {
        String contextRoot = deployedModule.getMappingContextRoot();
        Set<String> set = this.contextRoots;
        synchronized (set) {
            Set<DeployedModule> pending;
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"removeContextRootRequirement", (Object[])new Object[]{"contextRoot-> [" + contextRoot + "]"});
            }
            if ((pending = this.pendingContextRoots.get(contextRoot)) != null) {
                pending.remove(deployedModule);
                if (pending.isEmpty()) {
                    this.pendingContextRoots.remove(contextRoot);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void contextRootAdded(String contextRoot, VirtualHost vhost) {
        Set<String> set = this.contextRoots;
        synchronized (set) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"contextRootAdded", (Object[])new Object[]{"contextRoot-> [" + contextRoot + "]"});
            }
            this.contextRoots.add(contextRoot);
            Set<DeployedModule> pending = this.pendingContextRoots.remove(contextRoot);
            if (pending != null) {
                for (DeployedModule deployedModule : pending) {
                    deployedModule.initTaskComplete();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void contextRootRemoved(String contextRoot, VirtualHost vhost) {
        Set<String> set = this.contextRoots;
        synchronized (set) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"contextRootRemoved", (Object[])new Object[]{"contextRoot-> [" + contextRoot + "]"});
            }
            this.contextRoots.remove(contextRoot);
        }
    }

    public static String getTempDirectory() {
        WebContainer thisInstance = instance.get();
        if (thisInstance == null) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                Tr.event((TraceComponent)tc, (String)"WebContainer not running, returning null temp dir", (Object[])new Object[0]);
            }
            return null;
        }
        String rc = null;
        try {
            File f = thisInstance.context.getBundleContext().getDataFile("temp");
            if (null != f) {
                rc = f.getAbsolutePath() + File.separatorChar;
            }
        }
        catch (Throwable t) {
            FFDCFilter.processException((Throwable)t, (String)CLASS_NAME, (String)"getTempDirectory", (Object)thisInstance);
            if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                Tr.event((TraceComponent)tc, (String)("Error getting temp dir; " + t), (Object[])new Object[0]);
            }
            rc = null;
        }
        return rc;
    }

    @Reference
    protected void setMetaDataService(MetaDataService ref) {
        this.metaDataService = ref;
    }

    protected void unsetMetaDataService(MetaDataService ref) {
    }

    @Reference
    protected void setJ2eeNameFactory(J2EENameFactory ref) {
        this.j2eeNameFactory = ref;
    }

    protected void unsetJ2eeNameFactory(J2EENameFactory ref) {
    }

    @Override
    protected com.ibm.ws.webcontainer.srt.SRTConnectionContext getConnectionContext() {
        return this.connContextPool.get();
    }

    public ModuleMetaData createModuleMetaData(ExtendedModuleInfo moduleInfo) throws MetaDataException {
        WebModuleInfo webModule = (WebModuleInfo)moduleInfo;
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("createModuleMetaData: " + webModule.getName() + " " + webModule.getContextRoot()), (Object[])new Object[0]);
        }
        try {
            com.ibm.wsspi.adaptable.module.Container webModuleContainer = webModule.getContainer();
            WebAppConfiguration appConfig = (WebAppConfiguration)webModuleContainer.adapt(WebAppConfiguration.class);
            String appName = appConfig.getApplicationName();
            String j2eeModuleName = appConfig.getJ2EEModuleName();
            WebModuleMetaDataImpl wmmd = (WebModuleMetaDataImpl)appConfig.getMetaData();
            wmmd.setJ2EEName(this.j2eeNameFactory.create(appName, j2eeModuleName, null));
            appConfig.setWebApp(this.createWebApp((ModuleInfo)moduleInfo, appConfig));
            return wmmd;
        }
        catch (Throwable e) {
            MetaDataException m;
            Throwable cause = e.getCause();
            if (cause != null && cause instanceof MetaDataException) {
                m = (MetaDataException)cause;
            } else if (instance.get() == null) {
                m = new MetaDataException(e);
            } else {
                m = new MetaDataException(e);
                FFDCWrapper.processException(e, this.getClass().getName(), "createModuleMetaData", new Object[]{webModule, this});
            }
            if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                Tr.event((TraceComponent)tc, (String)("createModuleMetaData: " + webModule.getName() + "; " + e), (Object[])new Object[0]);
            }
            throw m;
        }
    }

    private WebApp createWebApp(ModuleInfo moduleInfo, WebAppConfiguration webAppConfig) {
        if (instance.get() == null) {
            throw new IllegalStateException("The web container has been deactivated");
        }
        ReferenceContext referenceContext = ((InjectionEngine)this.injectionEngineSRRef.getServiceWithException()).getCommonReferenceContext((ModuleMetaData)webAppConfig.getMetaData());
        ManagedObjectService managedObjectService = (ManagedObjectService)this.managedObjectServiceSRRef.getServiceWithException();
        WebApp webApp = this.webAppFactory.createWebApp(webAppConfig, moduleInfo.getClassLoader(), referenceContext, this.metaDataService, this.j2eeNameFactory, managedObjectService);
        webApp.setName(webAppConfig.getModuleName());
        webApp.setModuleContainer(moduleInfo.getContainer());
        webApp.setOrderedLibPaths(webAppConfig.getOrderedLibPaths());
        referenceContext.add((ComponentNameSpaceConfigurationProvider)webApp);
        return webApp;
    }

    public Future<Boolean> startModule(final ExtendedModuleInfo moduleInfo) throws StateChangeException {
        Future<Boolean> result;
        final WebModuleInfo webModule = (WebModuleInfo)moduleInfo;
        int starting = this.modulesStarting.incrementAndGet();
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("startModule: " + webModule.getName() + " " + webModule.getContextRoot() + ", modulesStarting = " + starting), (Object[])new Object[0]);
        }
        try {
            if (this.futureMonitor == null || instance.get() == null) {
                CompletedFuture f;
                CompletedFuture completedFuture = f = new CompletedFuture(false);
                return completedFuture;
            }
            if (WebContainer.isServerStopping()) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"startModule: server is stopping", (Object[])new Object[0]);
                }
                result = this.futureMonitor.createFutureWithResult((Object)Boolean.TRUE);
            } else {
                WebModuleMetaData wmmd = (WebModuleMetaData)((ExtendedModuleInfo)webModule).getMetaData();
                J2EEName j2eeName = wmmd.getJ2EEName();
                WebAppConfiguration appConfig = (WebAppConfiguration)wmmd.getConfiguration();
                WebCollaboratorComponentMetaDataImpl wccmdi = (WebCollaboratorComponentMetaDataImpl)wmmd.getCollaboratorComponentMetaData();
                wccmdi.setJ2EEName(j2eeName);
                this.metaDataService.fireComponentMetaDataCreated((ComponentMetaData)wccmdi);
                WebComponentMetaDataImpl wcmdi = (WebComponentMetaDataImpl)appConfig.getDefaultComponentMetaData();
                wcmdi.setJ2EEName(j2eeName);
                this.metaDataService.fireComponentMetaDataCreated((ComponentMetaData)wcmdi);
                Iterator<IServletConfig> servletConfigs = appConfig.getServletInfos();
                while (servletConfigs.hasNext()) {
                    IServletConfig servletConfig = servletConfigs.next();
                    wcmdi = (WebComponentMetaDataImpl)servletConfig.getMetaData();
                    wcmdi.setJ2EEName(this.j2eeNameFactory.create(j2eeName.getApplication(), j2eeName.getModule(), servletConfig.getName()));
                    this.metaDataService.fireComponentMetaDataCreated((ComponentMetaData)wcmdi);
                }
                ClassLoader moduleLoader = webModule.getClassLoader();
                ClassLoadingService cls = (ClassLoadingService)this.classLoadingSRRef.getService();
                ClassLoader threadClassLoader = cls.createThreadContextClassLoader(moduleLoader);
                com.ibm.wsspi.adaptable.module.Container webModuleContainer = webModule.getContainer();
                final DeployedModule dMod = new DeployedModule(webModuleContainer, appConfig, threadClassLoader);
                this.deployedModuleMap.put(webModule, dMod);
                this.addWebApplication(dMod);
                result = this.addContextRootRequirement(dMod);
                if (!WCCustomProperties.DEFER_SERVLET_LOAD) {
                    if (!this.startWebApplication(dMod)) {
                        throw new StateChangeException("startWebApplication");
                    }
                } else {
                    this.backgroundWebAppStartFutures.add(this.es, new Runnable(){

                        @Override
                        public void run() {
                            block6: {
                                try {
                                    if (WebContainer.this.startWebApplication(dMod)) {
                                        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                                            Tr.debug((TraceComponent)tc, (String)("startWebApplication async [" + webModule.getName() + "]: success."), (Object[])new Object[0]);
                                        }
                                        break block6;
                                    }
                                    throw new Exception("startWebApplication async [" + webModule.getName() + "]: failed.");
                                }
                                catch (Throwable e) {
                                    if (dMod != null && dMod instanceof DeployedModule) {
                                        dMod.initTaskFailed();
                                    }
                                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                                        Tr.debug((TraceComponent)tc, (String)("startModule async [" + webModule.getContextRoot() + "]; " + e), (Object[])new Object[0]);
                                    }
                                    WebContainer.this.stopModule(moduleInfo);
                                }
                            }
                        }
                    });
                }
                this.registerMBeans((WebModuleMetaDataImpl)wmmd, webModuleContainer);
            }
        }
        catch (Throwable e) {
            WebContainerRequestState reqState;
            FFDCWrapper.processException(e, this.getClass().getName(), "startModule", new Object[]{webModule, this});
            if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                Tr.event((TraceComponent)tc, (String)("startModule: " + webModule.getName() + "; " + e), (Object[])new Object[0]);
            }
            if ((reqState = WebContainerRequestState.getInstance(false)) != null && reqState.getAttribute("com.ibm.ws.webcontainer.contextRootAlreadyInUse") != null) {
                reqState.removeAttribute("com.ibm.ws.webcontainer.contextRootAlreadyInUse");
                this.stopModule(moduleInfo, false);
            } else {
                this.stopModule(moduleInfo);
            }
            throw new StateChangeException(e);
        }
        finally {
            starting = this.modulesStarting.decrementAndGet();
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"startModule: ", (Object)("modulesStarting = " + starting));
        }
        return result;
    }

    protected void registerMBeans(WebModuleMetaDataImpl webModule, com.ibm.wsspi.adaptable.module.Container container) {
        String methodName = "registerMBeans";
        String appName = webModule.getApplicationMetaData().getName();
        String webAppName = webModule.getName();
        String debugName = TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled() ? appName + " " + webAppName : null;
        WebMBeanRuntime mBeanRuntime = (WebMBeanRuntime)this.webMBeanRuntimeServiceRef.getService();
        if (mBeanRuntime == null) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)methodName, (Object[])new Object[]{"Web Module [ " + debugName + " ]: No MBean Runtime"});
            }
            return;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)methodName, (Object[])new Object[]{"Web Module [ " + debugName + " ]: MBean Runtime"});
        }
        String ddPath = "WEB-INF/web.xml";
        Iterator<IServletConfig> servletConfigs = webModule.getConfiguration().getServletInfos();
        webModule.mBeanServiceReg = mBeanRuntime.registerModuleMBean(appName, webAppName, container, ddPath, servletConfigs);
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)methodName, (Object[])new Object[]{"Web Module [ " + debugName + " ]: Registration [ " + webModule.mBeanServiceReg + " ]"});
        }
        servletConfigs = webModule.getConfiguration().getServletInfos();
        while (servletConfigs.hasNext()) {
            IServletConfig servletConfig = servletConfigs.next();
            String servletName = servletConfig.getServletName();
            WebComponentMetaDataImpl wcmdi = (WebComponentMetaDataImpl)servletConfig.getMetaData();
            wcmdi.mBeanServiceReg = mBeanRuntime.registerServletMBean(appName, webAppName, servletName);
            if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) continue;
            Tr.debug((TraceComponent)tc, (String)methodName, (Object[])new Object[]{"Web Module [ " + debugName + " ] Servlet [ " + servletName + " ]: Registration [ " + wcmdi.mBeanServiceReg + " ]"});
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)methodName, (Object[])new Object[]{"Web Module [ " + debugName + " ]: Completed registrations"});
        }
    }

    protected void deregisterMBeans(WebModuleMetaDataImpl webModule) {
        ServiceRegistration<?> webModuleReg;
        String methodName = "deregisterMBeans";
        String debugName = TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled() ? webModule.getApplicationMetaData().getName() + " " + webModule.getName() : null;
        WebMBeanRuntime mBeanRuntime = (WebMBeanRuntime)this.webMBeanRuntimeServiceRef.getService();
        if (mBeanRuntime == null) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)methodName, (Object[])new Object[]{"Web Module [ " + debugName + " ]: No MBean Runtime"});
            }
        } else if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)methodName, (Object[])new Object[]{"Web Module [ " + debugName + " ]: MBean Runtime"});
        }
        if ((webModuleReg = webModule.mBeanServiceReg) != null) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)methodName, (Object[])new Object[]{"Web Module [ " + debugName + " ]: Deregister module [ " + webModuleReg + " ]"});
            }
            webModule.mBeanServiceReg = null;
            if (mBeanRuntime != null) {
                try {
                    webModuleReg.unregister();
                }
                catch (IllegalStateException ise) {
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)methodName, (Object[])new Object[]{"Web Module [ " + debugName + " ]: Had already deregistered module [ " + webModuleReg + " ]"});
                    }
                }
            }
        } else if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            debugName = webModule.getApplicationMetaData().getName() + webModule.getName();
            Tr.debug((TraceComponent)tc, (String)methodName, (Object[])new Object[]{"Web Module [ " + debugName + " ]: No registration"});
        }
        Iterator<IServletConfig> servletConfigs = webModule.getConfiguration().getServletInfos();
        while (servletConfigs.hasNext()) {
            IServletConfig servletConfig = servletConfigs.next();
            String servletName = servletConfig.getServletName();
            WebComponentMetaDataImpl wcmdi = (WebComponentMetaDataImpl)servletConfig.getMetaData();
            ServiceRegistration<?> servletReg = wcmdi.mBeanServiceReg;
            if (servletReg != null) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)methodName, (Object[])new Object[]{"Servlet [ " + servletName + " ]: Deregister [ " + servletReg + " ]"});
                }
                wcmdi.mBeanServiceReg = null;
                if (mBeanRuntime == null) continue;
                try {
                    servletReg.unregister();
                }
                catch (IllegalStateException ise) {
                    if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) continue;
                    Tr.debug((TraceComponent)tc, (String)methodName, (Object[])new Object[]{"Servlet [ " + servletName + " ]: Had already deregistered [ " + servletReg + " ]"});
                }
                continue;
            }
            if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) continue;
            Tr.debug((TraceComponent)tc, (String)methodName, (Object[])new Object[]{"Servlet [ " + servletName + " ]: No registration"});
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)methodName, (Object[])new Object[]{"Web Module [ " + debugName + " ]: Completed deregistrations"});
        }
    }

    private boolean startWebApplication(DeployedModule dm) {
        String virtualHost = dm.getVirtualHostName();
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"startWebApplication", (Object[])new Object[]{"virtualHost -> [" + virtualHost + "]"});
        }
        if (virtualHost == null || virtualHost.equals("")) {
            virtualHost = DEFAULT_VHOST_NAME;
        }
        try {
            DynamicVirtualHost vHost = this.getVirtualHost(virtualHost);
            return vHost.startWebApplication(dm);
        }
        catch (WebAppHostNotFoundException e) {
            FFDCWrapper.processException(e, this.getClass().getName(), "startWebApplication", new Object[]{dm, this});
            if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                Tr.event((TraceComponent)tc, (String)("Error starting module: " + dm + "; " + e), (Object[])new Object[0]);
            }
            return false;
        }
    }

    public void stopModule(ExtendedModuleInfo moduleInfo) {
        this.stopModule(moduleInfo, true);
    }

    private void stopModule(ExtendedModuleInfo moduleInfo, boolean removeContextRoot) {
        block9: {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.entry((TraceComponent)tc, (String)"stopModule()", (Object[])new Object[]{((WebModuleInfo)moduleInfo).getName()});
            }
            WebModuleInfo webModule = (WebModuleInfo)moduleInfo;
            try {
                DeployedModule dMod = this.deployedModuleMap.remove(webModule);
                if (null == dMod) {
                    if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                        Tr.exit((TraceComponent)tc, (String)"stopModule()", (Object)"DeployedModule not known");
                    }
                    return;
                }
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("stopModule: " + webModule.getName() + " " + webModule.getContextRoot() + " , removeContextRoot [" + removeContextRoot + "]"), (Object[])new Object[0]);
                }
                if (removeContextRoot) {
                    this.removeContextRootRequirement(dMod);
                    this.removeModule(dMod);
                    this.vhostManager.purgeHost(dMod.getVirtualHostName());
                }
                WebModuleMetaData wmmd = (WebModuleMetaData)((ExtendedModuleInfo)webModule).getMetaData();
                this.deregisterMBeans((WebModuleMetaDataImpl)wmmd);
                WebAppConfiguration appConfig = (WebAppConfiguration)wmmd.getConfiguration();
                Iterator<IServletConfig> servletConfigs = appConfig.getServletInfos();
                while (servletConfigs.hasNext()) {
                    IServletConfig servletConfig = servletConfigs.next();
                    this.metaDataService.fireComponentMetaDataDestroyed((ComponentMetaData)servletConfig.getMetaData());
                }
                this.metaDataService.fireComponentMetaDataDestroyed((ComponentMetaData)appConfig.getDefaultComponentMetaData());
                this.metaDataService.fireComponentMetaDataDestroyed((ComponentMetaData)wmmd.getCollaboratorComponentMetaData());
            }
            catch (Throwable e) {
                FFDCWrapper.processException(e, this.getClass().getName(), "stopModule", new Object[]{webModule, this});
                if (!TraceComponent.isAnyTracingEnabled() || !tc.isEventEnabled()) break block9;
                Tr.event((TraceComponent)tc, (String)("stopModule: " + webModule.getName() + "; " + e), (Object[])new Object[0]);
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"stopModule()");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeModule(DeployedModule mod) {
        ClassLoader originalThreadClassLoader = ThreadContextHelper.getContextClassLoader();
        ThreadContextHelper.setClassLoader(mod.getClassLoader());
        try {
            this.removeWebApplication(mod);
        }
        catch (Exception e) {
            FFDCWrapper.processException(e, this.getClass().getName(), "removeModule", new Object[]{mod, this});
            if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                Tr.event((TraceComponent)tc, (String)("Error removing module: " + mod + "; " + e), (Object[])new Object[0]);
            }
        }
        finally {
            ThreadContextHelper.setClassLoader(originalThreadClassLoader);
            ClassLoadingService cls = (ClassLoadingService)this.classLoadingSRRef.getService();
            if (cls != null) {
                cls.destroyThreadContextClassLoader(mod.getClassLoader());
            }
        }
    }

    public boolean isInitialized() {
        return this.initialized;
    }

    @Override
    protected void releaseConnectionContext(com.ibm.ws.webcontainer.srt.SRTConnectionContext context) {
        this.connContextPool.put((SRTConnectionContext)context);
    }

    public boolean shouldDecode() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Reference(cardinality=ReferenceCardinality.MULTIPLE, policy=ReferencePolicy.DYNAMIC)
    protected void setExtensionFactory(ExtensionFactory ef) {
        Object object = this.lock;
        synchronized (object) {
            extensionFactories.add(ef);
            if (this.vhostManager != null) {
                this.registerExtensionFactoryWithVirtualHosts(ef);
            }
        }
    }

    private void registerExtensionFactoryWithVirtualHosts(ExtensionFactory ef) {
        Iterator<DynamicVirtualHost> vhostList = this.vhostManager.getVirtualHosts();
        while (vhostList.hasNext()) {
            DynamicVirtualHost vhost = vhostList.next();
            Iterator<WebApp> webApps = vhost.getWebApps();
            while (webApps.hasNext()) {
                WebApp webApp = webApps.next();
                webApp.addExtensionFactory(ef);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void unsetExtensionFactory(ExtensionFactory ef) {
        Object object = this.lock;
        synchronized (object) {
            extensionFactories.remove(ef);
            if (this.vhostManager != null) {
                Iterator<DynamicVirtualHost> vhostList = this.vhostManager.getVirtualHosts();
                while (vhostList.hasNext()) {
                    DynamicVirtualHost vhost = vhostList.next();
                    Iterator<WebApp> webApps = vhost.getWebApps();
                    while (webApps.hasNext()) {
                        WebApp webApp = webApps.next();
                        webApp.removeExtensionFactory(ef);
                    }
                }
            }
        }
    }

    @Reference(service=ServletContainerInitializer.class, cardinality=ReferenceCardinality.MULTIPLE, policy=ReferencePolicy.DYNAMIC, name="servletContainerInitializers")
    protected void setServletContainerInitializers(ServiceReference<ServletContainerInitializer> ref) {
        this.servletContainerInitializers.addReference(ref);
    }

    protected void unsetServletContainerInitializers(ServiceReference<ServletContainerInitializer> ref) {
        this.servletContainerInitializers.removeReference(ref);
    }

    public static Iterator<ServletContainerInitializer> getServletContainerInitializerExtension() {
        WebContainer thisService = instance.get();
        if (thisService != null) {
            Iterator scis = thisService.servletContainerInitializers.getServices();
            return scis;
        }
        return null;
    }

    public static EncodingUtils getEncodingUtils() {
        WebContainer thisService = instance.get();
        if (thisService != null) {
            EncodingUtils encodingUtils = thisService.encodingServiceRef.get();
            return encodingUtils;
        }
        return null;
    }

    @Override
    public void decrementNumRequests() {
    }

    public String getDefaultVirtualHostName() {
        return this.wcconfig.getDefaultVirtualHostName();
    }

    @Override
    public boolean areRequestsOutstanding() {
        return false;
    }

    @Reference(target="(containerToType=com.ibm.ws.webcontainer.osgi.webapp.WebAppConfiguration)")
    protected void setAdapterFactoryDependency(AdapterFactoryService afs) {
    }

    protected void unsetAdapterFactoryDependency(AdapterFactoryService afs) {
    }

    @Reference
    protected void setLocationService(WsLocationAdmin locAdmin) {
        this.locationServiceRef.set(locAdmin);
    }

    protected void unsetLocationService(WsLocationAdmin locAdmin) {
        if (locAdmin == this.locationServiceRef.get()) {
            this.locationServiceRef.set(null);
        }
    }

    public static WsLocationAdmin getLocationService() {
        WebContainer thisService = instance.get();
        WsLocationAdmin locationService = null;
        if (thisService != null) {
            locationService = thisService.locationServiceRef.get();
        }
        return locationService;
    }

    @Reference(service=CacheManager.class, cardinality=ReferenceCardinality.OPTIONAL, policy=ReferencePolicy.DYNAMIC, name="cacheManager")
    protected void setCacheManager(ServiceReference<CacheManager> ref) {
        this.cacheManagerSRRef.setReference(ref);
    }

    protected void unsetCacheManager(ServiceReference<CacheManager> ref) {
        this.cacheManagerSRRef.unsetReference(ref);
    }

    public static CacheManager getCacheManager() {
        WebContainer thisService = instance.get();
        CacheManager cacheManager = null;
        if (thisService != null) {
            cacheManager = thisService.getCacheManagerService();
        }
        return cacheManager;
    }

    private CacheManager getCacheManagerService() {
        return this.cacheManagerSRRef == null ? null : (CacheManager)this.cacheManagerSRRef.getService();
    }

    public static String getServerInfoFromBundle() {
        String serverInfo = cachedServerInfo;
        if (serverInfo == null) {
            WebContainer thisInstance = instance.get();
            if (thisInstance == null) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                    Tr.event((TraceComponent)tc, (String)"WebContainer not running, returning null ", (Object[])new Object[0]);
                }
                return null;
            }
            String serverName = (String)thisInstance.context.getBundleContext().getBundle().getHeaders("").get("WLP-ServerName");
            String serverVersion = (String)thisInstance.context.getBundleContext().getBundle().getHeaders("").get("WLP-ServerVersion");
            serverInfo = cachedServerInfo = serverName + '/' + serverVersion;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
            Tr.event((TraceComponent)tc, (String)("serverInfo -->" + serverInfo), (Object[])new Object[0]);
        }
        return serverInfo;
    }

    @Reference(cardinality=ReferenceCardinality.MANDATORY, policy=ReferencePolicy.DYNAMIC, policyOption=ReferencePolicyOption.GREEDY)
    protected void setConnContextPool(SRTConnectionContextPool pool) {
        this.connContextPool = pool;
    }

    protected void unsetConnContextPool(SRTConnectionContextPool pool) {
    }

    @Reference(cardinality=ReferenceCardinality.MANDATORY, policy=ReferencePolicy.DYNAMIC, policyOption=ReferencePolicyOption.GREEDY)
    protected void setWebAppFactory(WebAppFactory factory) {
        this.webAppFactory = factory;
    }

    protected void unsetWebAppFactory(WebAppFactory factory) {
    }

    @Reference(cardinality=ReferenceCardinality.MANDATORY, policy=ReferencePolicy.DYNAMIC, policyOption=ReferencePolicyOption.GREEDY)
    protected void setRequestFactory(IRequestFactory factory) {
        this.requestFactory = factory;
    }

    protected void unsetRequestFactory(IRequestFactory factory) {
    }

    public IRequestFactory getRequestFactory() {
        return this.requestFactory;
    }

    @Reference(cardinality=ReferenceCardinality.MANDATORY, policy=ReferencePolicy.DYNAMIC, policyOption=ReferencePolicyOption.GREEDY)
    protected void setResponseFactory(IResponseFactory factory) {
        this.responseFactory = factory;
    }

    protected void unsetResponseFactory(IResponseFactory factory) {
    }

    public IResponseFactory getResponseFactory() {
        return this.responseFactory;
    }

    @Reference(cardinality=ReferenceCardinality.MANDATORY, policy=ReferencePolicy.DYNAMIC, policyOption=ReferencePolicyOption.GREEDY)
    protected void setAsyncContextFactory(AsyncContextFactory factory) {
        this.asyncContextFactory = factory;
    }

    protected void unsetAsyncContextFactory(AsyncContextFactory factory) {
    }

    @Override
    public AsyncContextFactory getAsyncContextFactory() {
        return this.asyncContextFactory;
    }

    @Reference(cardinality=ReferenceCardinality.MANDATORY, policy=ReferencePolicy.DYNAMIC, policyOption=ReferencePolicyOption.GREEDY)
    protected void setURIMatcherFactory(URIMatcherFactory factory) {
        this.uriMatcherFactory = factory;
    }

    protected void unsetURIMatcherFactory(URIMatcherFactory factory) {
    }

    @Override
    public URIMatcherFactory getURIMatcherFactory() {
        return this.uriMatcherFactory;
    }

    @Reference(cardinality=ReferenceCardinality.MANDATORY, policy=ReferencePolicy.DYNAMIC, policyOption=ReferencePolicyOption.GREEDY)
    protected void setCacheServletWrapperFactory(CacheServletWrapperFactory factory) {
        cacheServletWrapperFactory = factory;
    }

    protected void unsetCacheServletWrapperFactory(CacheServletWrapperFactory factory) {
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static int loadServletVersion() {
        String methodName;
        block11: {
            methodName = "loadServletVersion";
            try (InputStream input = WebContainer.class.getClassLoader().getResourceAsStream("com/ibm/ws/webcontainer/speclevel/servletSpecLevel.properties");){
                if (input != null) {
                    int loadedVersion;
                    Properties prop = new Properties();
                    prop.load(input);
                    int n = loadedVersion = Integer.parseInt(prop.getProperty("version"));
                    return n;
                }
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)methodName, (Object[])new Object[]{"InputStream was null for servletSpecLevel.properties"});
                }
            }
            catch (Exception ex) {
                if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) break block11;
                Tr.debug((TraceComponent)tc, (String)methodName, (Object[])new Object[]{"Exception occured: " + ex.getCause()});
            }
        }
        logger.logp(Level.WARNING, CLASS_NAME, methodName, "servlet.feature.not.loaded.correctly");
        return 30;
    }

    public static int getServletContainerSpecLevel() {
        String methodName = "getServletContainerSpecLevel";
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)methodName, (Object[])new Object[]{"loadedContainerSpecLevel [ " + loadedContainerSpecLevel + " ]"});
        }
        return loadedContainerSpecLevel;
    }

    public static boolean isServletLevel60orAbove() {
        return WebContainer.getServletContainerSpecLevel() >= 60;
    }

    protected static class CompletedFuture
    implements Future {
        boolean value = false;

        public CompletedFuture(boolean v) {
            this.value = v;
        }

        @Override
        public boolean cancel(boolean mayInterruptIfRunning) {
            return false;
        }

        @Override
        public boolean isCancelled() {
            return false;
        }

        @Override
        public boolean isDone() {
            return true;
        }

        public Boolean get() throws InterruptedException, ExecutionException {
            return this.value;
        }

        public Boolean get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
            return this.value;
        }
    }
}

