/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.threading;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.websphere.ras.annotation.Trivial;
import com.ibm.ws.ffdc.annotation.FFDCIgnore;
import com.ibm.ws.kernel.service.util.JavaInfo;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.threading.CompletionStageExecutor;
import com.ibm.ws.threading.internal.LibertyCompletableFuture;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.function.Supplier;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.ConfigurationPolicy;
import org.osgi.service.component.annotations.Reference;

@TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
@Component(configurationPolicy=ConfigurationPolicy.IGNORE, service={CompletionStageFactory.class})
public class CompletionStageFactory {
    private static final boolean JAVA8;
    @Reference(target="(component.name=com.ibm.ws.threading)")
    private ExecutorService globalExecutor;
    static final long serialVersionUID = 60213179656445398L;
    private static final /* synthetic */ TraceComponent $$$tc$$$;

    @Trivial
    public <T> CompletableFuture<T> newIncompleteFuture() {
        return this.newIncompleteFuture(this.globalExecutor);
    }

    public <T> CompletableFuture<T> newIncompleteFuture(Executor executor) {
        if (executor instanceof CompletionStageExecutor) {
            return ((CompletionStageExecutor)((Object)executor)).newIncompleteFuture();
        }
        Executor executor2 = executor = executor == null ? this.globalExecutor : executor;
        if (JAVA8) {
            return new CompletableFuture();
        }
        return new LibertyCompletableFuture(executor);
    }

    @Trivial
    public CompletableFuture<Void> runAsync(Runnable action) {
        return this.runAsync(action, this.globalExecutor);
    }

    public CompletableFuture<Void> runAsync(Runnable action, Executor executor) {
        if (executor instanceof CompletionStageExecutor) {
            return ((CompletionStageExecutor)((Object)executor)).runAsync(action);
        }
        Executor executor2 = executor = executor == null ? this.globalExecutor : executor;
        if (JAVA8) {
            return CompletableFuture.runAsync(action, executor);
        }
        LibertyCompletableFuture<Void> future = new LibertyCompletableFuture<Void>(executor);
        executor.execute(new RunAsync(action, future));
        return future;
    }

    @Trivial
    public <T> CompletableFuture<T> supplyAsync(Supplier<T> supplier) {
        return this.supplyAsync(supplier, this.globalExecutor);
    }

    public <T> CompletableFuture<T> supplyAsync(Supplier<T> supplier, Executor executor) {
        if (executor instanceof CompletionStageExecutor) {
            return ((CompletionStageExecutor)((Object)executor)).supplyAsync(supplier);
        }
        Executor executor2 = executor = executor == null ? this.globalExecutor : executor;
        if (JAVA8) {
            return CompletableFuture.supplyAsync(supplier, executor);
        }
        LibertyCompletableFuture future = new LibertyCompletableFuture(executor);
        executor.execute(new SupplyAsync<T>(supplier, future));
        return future;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
    static {
        $$$tc$$$ = Tr.register((String)"com.ibm.ws.threading.CompletionStageFactory", CompletionStageFactory.class, null, null);
        JAVA8 = JavaInfo.majorVersion() == 8;
    }

    @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
    @InjectedFFDC
    @TraceOptions
    private static class SupplyAsync<T>
    implements Runnable {
        private final Supplier<T> supplier;
        private final LibertyCompletableFuture<T> future;
        static final long serialVersionUID = -257695888191371761L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        SupplyAsync(Supplier<T> supplier, LibertyCompletableFuture<T> future) {
            this.supplier = supplier;
            this.future = future;
        }

        @Override
        @FFDCIgnore(value={Throwable.class})
        public void run() {
            try {
                T result = this.supplier.get();
                this.future.complete(result);
            }
            catch (Throwable x) {
                this.future.completeExceptionally(x);
            }
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register((String)"com.ibm.ws.threading.CompletionStageFactory$SupplyAsync", SupplyAsync.class, null, null);
        }
    }

    @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
    @InjectedFFDC
    @TraceOptions
    private static class RunAsync
    implements Runnable {
        private final Runnable action;
        private final LibertyCompletableFuture<Void> future;
        static final long serialVersionUID = 2113708997074080346L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        RunAsync(Runnable action, LibertyCompletableFuture<Void> future) {
            this.action = action;
            this.future = future;
        }

        @Override
        @FFDCIgnore(value={Throwable.class})
        public void run() {
            try {
                this.action.run();
                this.future.complete(null);
            }
            catch (Throwable x) {
                this.future.completeExceptionally(x);
            }
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register((String)"com.ibm.ws.threading.CompletionStageFactory$RunAsync", RunAsync.class, null, null);
        }
    }
}

