/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.classloading.bells.internal;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.classloading.MetaInfServicesProvider;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ffdc.annotation.FFDCIgnore;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.wsspi.artifact.ArtifactContainer;
import com.ibm.wsspi.artifact.ArtifactEntry;
import com.ibm.wsspi.kernel.service.utils.FrameworkState;
import com.ibm.wsspi.library.Library;
import com.ibm.wsspi.library.LibraryChangeListener;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URL;
import java.nio.charset.Charset;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Arrays;
import java.util.Collections;
import java.util.Dictionary;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.ReentrantLock;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.Filter;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.PrototypeServiceFactory;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.ConfigurationPolicy;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;
import org.osgi.util.tracker.ServiceTracker;
import org.osgi.util.tracker.ServiceTrackerCustomizer;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
@Component(name="com.ibm.ws.classloading.bell", configurationPolicy=ConfigurationPolicy.REQUIRE)
public class Bell
implements LibraryChangeListener {
    private static final TraceComponent tc = Tr.register(Bell.class, (String)"Bell", (String)"com.ibm.ws.classloading.bells.internal.resources.BellConfigurationMessages");
    private static final char COMMENT_CHAR = '#';
    private static final String SERVICE_ATT = "service";
    private final ReentrantLock trackerLock = new ReentrantLock();
    private ServiceTracker<Library, List<ServiceRegistration<?>>> tracker;
    private Library library;
    private ComponentContext componentContext;
    private Map<String, Object> config;
    static final long serialVersionUID = 9014561660136229797L;

    @Activate
    protected void activate(ComponentContext cc, Map<String, Object> props) {
        this.componentContext = cc;
        this.config = props;
        this.update();
    }

    @Deactivate
    protected void deactivate(ComponentContext cc) {
        if (!FrameworkState.isStopping()) {
            this.unregister();
        }
    }

    void unregister() {
        this.trackerLock.lock();
        try {
            if (this.tracker != null) {
                this.tracker.close();
                this.tracker = null;
            }
        }
        finally {
            this.trackerLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    void update() {
        Filter filter;
        final BundleContext context = this.componentContext.getBundleContext();
        String libraryRef = this.library.id();
        String libraryStatusFilter = String.format("(&(objectClass=%s)(|(id=%s)(service.pid=%s)))", Library.class.getName(), libraryRef, libraryRef);
        try {
            filter = context.createFilter(libraryStatusFilter);
        }
        catch (InvalidSyntaxException invalidSyntaxException) {
            void e;
            FFDCFilter.processException((Throwable)invalidSyntaxException, (String)"com.ibm.ws.classloading.bells.internal.Bell", (String)"148", (Object)this, (Object[])new Object[0]);
            throw new RuntimeException((Throwable)e);
        }
        final Set<String> serviceNames = Bell.getServiceNames((String[])this.config.get(SERVICE_ATT));
        ServiceTracker newTracker = null;
        newTracker = new ServiceTracker(context, filter, new ServiceTrackerCustomizer<Library, List<ServiceRegistration<?>>>(){
            static final long serialVersionUID = 6050392134072406218L;
            private static final /* synthetic */ TraceComponent $$$tc$$$;

            public List<ServiceRegistration<?>> addingService(ServiceReference<Library> libraryRef) {
                Library library = (Library)context.getService(libraryRef);
                return Bell.this.registerLibraryServices(library, serviceNames);
            }

            public void modifiedService(ServiceReference<Library> libraryRef, List<ServiceRegistration<?>> metaInfServices) {
            }

            @FFDCIgnore(value={IllegalStateException.class})
            public void removedService(ServiceReference<Library> libraryRef, List<ServiceRegistration<?>> metaInfServices) {
                for (ServiceRegistration<?> registration : metaInfServices) {
                    try {
                        registration.unregister();
                    }
                    catch (IllegalStateException illegalStateException) {}
                }
                context.ungetService(libraryRef);
            }

            @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
            static {
                $$$tc$$$ = Tr.register((String)"com.ibm.ws.classloading.bells.internal.Bell$1", 1.class, (String)"Bell", (String)"com.ibm.ws.classloading.bells.internal.resources.BellConfigurationMessages");
            }
        });
        this.trackerLock.lock();
        try {
            if (this.tracker != null) {
                this.tracker.close();
            }
            this.tracker = newTracker;
            this.tracker.open();
        }
        finally {
            this.trackerLock.unlock();
        }
    }

    private static Set<String> getServiceNames(String[] configuredServices) {
        if (configuredServices == null || configuredServices.length == 0) {
            return Collections.emptySet();
        }
        return new HashSet<String>(Arrays.asList(configuredServices));
    }

    private List<ServiceRegistration<?>> registerLibraryServices(Library library, Set<String> serviceNames) {
        List<ServiceRegistration<?>> libServices;
        BundleContext context = this.getGatewayBundleContext(library);
        if (context == null) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"registerLibraryServices: can't find bundle ", (Object[])new Object[]{library.id()});
            }
            return Collections.emptyList();
        }
        Set<Object> servicesNotFound = serviceNames == null || serviceNames.isEmpty() ? Collections.EMPTY_SET : new TreeSet<String>(serviceNames);
        LinkedList<ServiceInfo> serviceInfos = new LinkedList<ServiceInfo>();
        for (ArtifactContainer artifactContainer : library.getContainers()) {
            ArtifactEntry servicesFolder = artifactContainer.getEntry("META-INF/services");
            if (servicesFolder == null) {
                if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) continue;
                Tr.debug((TraceComponent)tc, (String)"No META-INF services folder in the container: ", (Object[])new Object[]{artifactContainer});
                continue;
            }
            serviceInfos.addAll(Bell.getListOfServicesForContainer(servicesFolder.convertToContainer(), library, serviceNames, (Set<String>)servicesNotFound));
        }
        for (String string : servicesNotFound) {
            Tr.warning((TraceComponent)tc, (String)"bell.no.services.config", (Object[])new Object[]{string, library.id()});
        }
        if (serviceInfos.size() == 0) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isInfoEnabled()) {
                Tr.warning((TraceComponent)tc, (String)"bell.no.services.found", (Object[])new Object[]{library.id()});
            }
            libServices = Collections.emptyList();
        } else {
            libServices = Bell.registerServices(serviceInfos, library, context);
        }
        return libServices;
    }

    /*
     * WARNING - void declaration
     */
    private BundleContext getGatewayBundleContext(Library library) {
        ClassLoader loader = library.getClassLoader();
        Class<?> loaderClass = loader.getClass();
        while (!"LibertyLoader".equals(loaderClass.getSimpleName()) && loaderClass.getSuperclass() != null) {
            loaderClass = loaderClass.getSuperclass();
        }
        try {
            Method getBundle = loaderClass.getDeclaredMethod("getBundle", new Class[0]);
            getBundle.setAccessible(true);
            Bundle bundle = (Bundle)getBundle.invoke((Object)loader, new Object[0]);
            return bundle.getBundleContext();
        }
        catch (InvocationTargetException getBundle) {
            void e;
            FFDCFilter.processException((Throwable)getBundle, (String)"com.ibm.ws.classloading.bells.internal.Bell", (String)"265", (Object)this, (Object[])new Object[]{library});
            Throwable t = e.getTargetException();
            if (t instanceof RuntimeException) {
                throw (RuntimeException)t;
            }
            throw new RuntimeException(t);
        }
        catch (Exception e) {
            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.classloading.bells.internal.Bell", (String)"272", (Object)this, (Object[])new Object[]{library});
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new RuntimeException(e);
        }
    }

    private static BufferedReader createReader(ArtifactEntry providerConfigFile) throws IOException {
        InputStream is = providerConfigFile.getInputStream();
        InputStreamReader input = new InputStreamReader(is, Charset.forName("UTF8"));
        return new BufferedReader(input);
    }

    private static List<ServiceInfo> getListOfServicesForContainer(ArtifactContainer servicesFolder, Library library, Set<String> serviceNames, Set<String> servicesNotFound) {
        LinkedList<ServiceInfo> serviceInfos = new LinkedList<ServiceInfo>();
        if (serviceNames.isEmpty()) {
            for (ArtifactEntry providerConfigFile : servicesFolder) {
                Bell.getServiceInfos(providerConfigFile, providerConfigFile.getName(), servicesNotFound, library, serviceInfos);
            }
        } else {
            for (String serviceName : serviceNames) {
                ArtifactEntry providerConfigFile = servicesFolder.getEntry(serviceName);
                Bell.getServiceInfos(providerConfigFile, serviceName, servicesNotFound, library, serviceInfos);
            }
        }
        return serviceInfos;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private static void getServiceInfos(ArtifactEntry providerConfigFile, String serviceName, Set<String> servicesNotFound, Library library, List<ServiceInfo> serviceInfos) {
        block15: {
            if (providerConfigFile != null) {
                try {
                    BufferedReader reader = Bell.createReader(providerConfigFile);
                    try {
                        String line;
                        Hashtable<String, String> props = new Hashtable<String, String>();
                        while ((line = reader.readLine()) != null) {
                            String implClass;
                            int index = line.indexOf(35);
                            if (index != -1) {
                                String[] prop;
                                String propStr = line.substring(index + 1);
                                implClass = line.substring(0, index).trim();
                                if (implClass.length() == 0 && (prop = propStr.split("=")).length == 2) {
                                    props.put(prop[0].trim(), prop[1].trim());
                                }
                            } else {
                                implClass = line.trim();
                            }
                            if (implClass.length() <= 0) continue;
                            serviceInfos.add(new ServiceInfo(providerConfigFile, implClass, props));
                            servicesNotFound.remove(serviceName);
                            props = new Hashtable();
                        }
                    }
                    catch (Throwable throwable) {
                        try {
                            reader.close();
                        }
                        catch (IOException iOException) {
                            FFDCFilter.processException((Throwable)iOException, (String)"com.ibm.ws.classloading.bells.internal.Bell", (String)"338", null, (Object[])new Object[]{providerConfigFile, serviceName, servicesNotFound, library, serviceInfos});
                        }
                        throw throwable;
                    }
                    try {
                        reader.close();
                    }
                    catch (IOException line) {
                        FFDCFilter.processException((Throwable)line, (String)"com.ibm.ws.classloading.bells.internal.Bell", (String)"338", null, (Object[])new Object[]{providerConfigFile, serviceName, servicesNotFound, library, serviceInfos});
                    }
                }
                catch (IOException reader) {
                    FFDCFilter.processException((Throwable)reader, (String)"com.ibm.ws.classloading.bells.internal.Bell", (String)"341", null, (Object[])new Object[]{providerConfigFile, serviceName, servicesNotFound, library, serviceInfos});
                    URL fileUrl = providerConfigFile.getResource();
                    if (TraceComponent.isAnyTracingEnabled() && tc.isWarningEnabled()) {
                        void e;
                        Tr.warning((TraceComponent)tc, (String)"bell.io.error", (Object[])new Object[]{fileUrl, library.id(), e});
                    }
                }
                catch (Throwable e) {
                    FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.classloading.bells.internal.Bell", (String)"346", null, (Object[])new Object[]{providerConfigFile, serviceName, servicesNotFound, library, serviceInfos});
                    if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) break block15;
                    Tr.debug((TraceComponent)tc, (String)"addLibraryServices: error: ", (Object[])new Object[]{e});
                }
            }
        }
    }

    private static List<ServiceRegistration<?>> registerServices(List<ServiceInfo> serviceInfos, Library library, final BundleContext context) {
        LinkedList registeredServices = new LinkedList();
        for (ServiceInfo serviceInfo : serviceInfos) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Registering service: ", (Object[])new Object[]{serviceInfo});
            }
            URL fileUrl = serviceInfo.providerConfigFile.getResource();
            String interfaceName = serviceInfo.providerConfigFile.getName();
            Hashtable<String, String> properties = new Hashtable<String, String>();
            properties.putAll(serviceInfo.props);
            properties.put("implementation.class", serviceInfo.implClass);
            properties.put("exported.from", library.id());
            final ServiceRegistration reg = context.registerService(interfaceName, Bell.createServiceFactory(serviceInfo, library, fileUrl), properties);
            if (TraceComponent.isAnyTracingEnabled() && tc.isInfoEnabled()) {
                Tr.info((TraceComponent)tc, (String)"bell.service.name", (Object[])new Object[]{library.id(), fileUrl, serviceInfo.implClass});
            }
            registeredServices.add(reg);
            MetaInfServicesProvider provider = new MetaInfServicesProvider(){
                private final AtomicReference<Class<?>> implClassRef = new AtomicReference();
                static final long serialVersionUID = 3207149472647674343L;
                private static final /* synthetic */ TraceComponent $$$tc$$$;

                public Class<?> getProviderImplClass() {
                    Object service;
                    Class<?> implClass = this.implClassRef.get();
                    if (implClass == null && (service = AccessController.doPrivileged(new PrivilegedAction<Object>(){
                        static final long serialVersionUID = -4382552808571567744L;
                        private static final /* synthetic */ TraceComponent $$$tc$$$;

                        @Override
                        public Object run() {
                            return context.getService(reg.getReference());
                        }

                        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
                        static {
                            $$$tc$$$ = Tr.register((String)"com.ibm.ws.classloading.bells.internal.Bell$2$1", 1.class, (String)"Bell", (String)"com.ibm.ws.classloading.bells.internal.resources.BellConfigurationMessages");
                        }
                    })) != null) {
                        implClass = service.getClass();
                        this.implClassRef.set(implClass);
                    }
                    return implClass;
                }

                @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
                static {
                    $$$tc$$$ = Tr.register((String)"com.ibm.ws.classloading.bells.internal.Bell$2", 2.class, (String)"Bell", (String)"com.ibm.ws.classloading.bells.internal.resources.BellConfigurationMessages");
                }
            };
            Hashtable<String, Object> metaInfProps = new Hashtable<String, Object>();
            ((Dictionary)metaInfProps).put("implementation.class", serviceInfo.implClass);
            ((Dictionary)metaInfProps).put("file.path", serviceInfo.providerConfigFile.getPath().substring(1));
            ((Dictionary)metaInfProps).put("file.url", fileUrl);
            ServiceRegistration metaInfReg = context.registerService(MetaInfServicesProvider.class, (Object)provider, metaInfProps);
            registeredServices.add(metaInfReg);
        }
        return registeredServices;
    }

    private static PrototypeServiceFactory<?> createServiceFactory(final ServiceInfo serviceInfo, final Library library, final URL fileUrl) {
        return new PrototypeServiceFactory(){
            static final long serialVersionUID = -167680278732840475L;
            private static final /* synthetic */ TraceComponent $$$tc$$$;

            public Object getService(Bundle bundle, ServiceRegistration registration) {
                if (library.id() == null) {
                    return null;
                }
                Class serviceType = Bell.findClass(serviceInfo.implClass, library, fileUrl);
                if (serviceType != null) {
                    return Bell.createService(serviceType, library.id(), fileUrl);
                }
                return null;
            }

            public void ungetService(Bundle bundle, ServiceRegistration registration, Object service) {
            }

            @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
            static {
                $$$tc$$$ = Tr.register((String)"com.ibm.ws.classloading.bells.internal.Bell$3", 3.class, (String)"Bell", (String)"com.ibm.ws.classloading.bells.internal.resources.BellConfigurationMessages");
            }
        };
    }

    /*
     * WARNING - void declaration
     */
    private static Class<?> findClass(String implClass, Library library, URL fileUrl) {
        Class<?> service;
        block6: {
            ClassLoader containerClassLoader = library.getClassLoader();
            String libID = library.id();
            service = null;
            try {
                service = containerClassLoader.loadClass(implClass);
            }
            catch (NoClassDefFoundError noClassDefFoundError) {
                FFDCFilter.processException((Throwable)noClassDefFoundError, (String)"com.ibm.ws.classloading.bells.internal.Bell", (String)"454", null, (Object[])new Object[]{implClass, library, fileUrl});
                if (TraceComponent.isAnyTracingEnabled() && tc.isWarningEnabled()) {
                    void e;
                    Tr.warning((TraceComponent)tc, (String)"bell.no.inter", (Object[])new Object[]{implClass, fileUrl, libID, e});
                }
            }
            catch (ClassNotFoundException e) {
                FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.classloading.bells.internal.Bell", (String)"459", null, (Object[])new Object[]{implClass, library, fileUrl});
                if (TraceComponent.isAnyTracingEnabled() && tc.isWarningEnabled()) {
                    Tr.warning((TraceComponent)tc, (String)"bell.no.impl", (Object[])new Object[]{implClass, fileUrl, libID});
                }
            }
            catch (Throwable e) {
                FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.classloading.bells.internal.Bell", (String)"463", null, (Object[])new Object[]{implClass, library, fileUrl});
                if (!TraceComponent.isAnyTracingEnabled() || !tc.isWarningEnabled()) break block6;
                Tr.warning((TraceComponent)tc, (String)"bell.error.ctor", (Object[])new Object[]{implClass, fileUrl, libID, e});
            }
        }
        return service;
    }

    private static Object createService(Class<?> serviceType, String libID, URL fileUrl) {
        Object service;
        block6: {
            service = null;
            try {
                service = serviceType.newInstance();
            }
            catch (IllegalAccessException illegalAccessException) {
                FFDCFilter.processException((Throwable)illegalAccessException, (String)"com.ibm.ws.classloading.bells.internal.Bell", (String)"475", null, (Object[])new Object[]{serviceType, libID, fileUrl});
                if (TraceComponent.isAnyTracingEnabled() && tc.isWarningEnabled()) {
                    Tr.warning((TraceComponent)tc, (String)"bell.illegal.access", (Object[])new Object[]{serviceType.getName(), fileUrl, libID});
                }
            }
            catch (InstantiationException e) {
                FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.classloading.bells.internal.Bell", (String)"479", null, (Object[])new Object[]{serviceType, libID, fileUrl});
                if (TraceComponent.isAnyTracingEnabled() && tc.isWarningEnabled()) {
                    Tr.warning((TraceComponent)tc, (String)"bell.not.constructible", (Object[])new Object[]{serviceType.getName(), fileUrl, libID});
                }
            }
            catch (Throwable e) {
                FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.classloading.bells.internal.Bell", (String)"483", null, (Object[])new Object[]{serviceType, libID, fileUrl});
                if (!TraceComponent.isAnyTracingEnabled() || !tc.isWarningEnabled()) break block6;
                Tr.warning((TraceComponent)tc, (String)"bell.error.ctor", (Object[])new Object[]{serviceType.getName(), fileUrl, libID, e});
            }
        }
        return service;
    }

    @Reference(name="library", target="(id=unbound)")
    protected void setLibrary(Library lib) {
        this.library = lib;
    }

    protected void unsetLibrary(Library lib) {
        this.library = null;
    }

    public void libraryNotification() {
        this.update();
    }

    @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
    @InjectedFFDC
    @TraceOptions
    private static final class ServiceInfo {
        final ArtifactEntry providerConfigFile;
        final String implClass;
        final Hashtable<String, String> props;
        static final long serialVersionUID = -7125865090006567107L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        ServiceInfo(ArtifactEntry providerConfigFile, String implClass, Hashtable<String, String> props) {
            this.providerConfigFile = providerConfigFile;
            this.implClass = implClass;
            this.props = props;
        }

        public String toString() {
            return "[" + this.implClass + "] from: [" + this.providerConfigFile.getResource() + "]";
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register((String)"com.ibm.ws.classloading.bells.internal.Bell$ServiceInfo", ServiceInfo.class, (String)"Bell", (String)"com.ibm.ws.classloading.bells.internal.resources.BellConfigurationMessages");
        }
    }
}

