/*
 * Decompiled with CFR 0.152.
 */
package org.apache.yoko.rmi.util.stub;

import java.lang.reflect.Method;

public class MethodRef {
    String name;
    Class declaringClass;
    Class[] parameterTypes;
    Class returnType;
    Class[] exceptionTypes;
    int modifiers;
    Method method;
    String signature;

    public MethodRef() {
    }

    public MethodRef(Method method) {
        this.method = method;
        this.name = method.getName();
        this.setDeclaringClass(method.getDeclaringClass());
        this.setParameterTypes(method.getParameterTypes());
        this.setReturnType(method.getReturnType());
        this.setExceptionTypes(method.getExceptionTypes());
        this.setModifiers(method.getModifiers());
    }

    public Method getMethod() {
        return this.method;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public void setDeclaringClass(Class declaringClass) {
        this.declaringClass = declaringClass;
    }

    public Class getDeclaringClass() {
        return this.declaringClass;
    }

    public void setParameterTypes(Class[] parameterTypes) {
        this.parameterTypes = parameterTypes;
    }

    public Class[] getParameterTypes() {
        return this.parameterTypes;
    }

    public void setReturnType(Class returnType) {
        this.returnType = returnType;
    }

    public Class getReturnType() {
        return this.returnType;
    }

    public void setExceptionTypes(Class[] exceptionTypes) {
        this.exceptionTypes = exceptionTypes;
    }

    public Class[] getExceptionTypes() {
        return this.exceptionTypes;
    }

    public void setModifiers(int modifiers) {
        this.modifiers = modifiers;
    }

    public int getModifiers() {
        return this.modifiers;
    }

    public String getSignature() {
        if (this.signature != null) {
            return this.signature;
        }
        StringBuffer sb = new StringBuffer();
        sb.append('(');
        for (int i = 0; i < this.parameterTypes.length; ++i) {
            sb.append(MethodRef.getSignature(this.parameterTypes[i]));
        }
        sb.append(')');
        sb.append(MethodRef.getSignature(this.returnType));
        this.signature = sb.toString();
        return this.signature;
    }

    static String getSignature(Class clz) {
        if (clz.isPrimitive()) {
            if (clz == Integer.TYPE) {
                return "I";
            }
            if (clz == Boolean.TYPE) {
                return "Z";
            }
            if (clz == Byte.TYPE) {
                return "B";
            }
            if (clz == Short.TYPE) {
                return "S";
            }
            if (clz == Long.TYPE) {
                return "J";
            }
            if (clz == Double.TYPE) {
                return "D";
            }
            if (clz == Float.TYPE) {
                return "F";
            }
            if (clz == Void.TYPE) {
                return "V";
            }
            if (clz == Character.TYPE) {
                return "C";
            }
            throw new InternalError("cannot handle " + clz);
        }
        if (clz.isArray()) {
            return "[" + MethodRef.getSignature(clz.getComponentType());
        }
        return "L" + clz.getName().replace('.', '/') + ";";
    }
}

