/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.recoverylog.spi;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.ManualTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.recoverylog.spi.DistributedRecoveryLog;
import com.ibm.ws.recoverylog.spi.FailureScope;
import com.ibm.ws.recoverylog.spi.InternalLogException;
import com.ibm.ws.recoverylog.spi.InvalidRecoverableUnitException;
import com.ibm.ws.recoverylog.spi.LogAllocationException;
import com.ibm.ws.recoverylog.spi.LogClosedException;
import com.ibm.ws.recoverylog.spi.LogCorruptedException;
import com.ibm.ws.recoverylog.spi.LogCursor;
import com.ibm.ws.recoverylog.spi.LogIncompatibleException;
import com.ibm.ws.recoverylog.spi.LogProperties;
import com.ibm.ws.recoverylog.spi.MultiScopeLog;
import com.ibm.ws.recoverylog.spi.RLSUtils;
import com.ibm.ws.recoverylog.spi.RecoverableUnit;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
public class RecoveryLogImpl
implements DistributedRecoveryLog {
    private static final TraceComponent tc = Tr.register(RecoveryLogImpl.class, (String)"Transaction", (String)"com.ibm.ws.recoverylog.resources.RecoveryLogMsgs");
    private final MultiScopeLog _recoveryLog;
    private final FailureScope _failureScope;
    static final long serialVersionUID = -699630864412002892L;

    @ManualTrace
    public RecoveryLogImpl(MultiScopeLog recoveryLog, FailureScope failureScope) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"RecoveryLogImpl", (Object[])new Object[]{recoveryLog, failureScope});
        }
        this._recoveryLog = recoveryLog;
        this._failureScope = failureScope;
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"RecoveryLogImpl", (Object)this);
        }
    }

    @Override
    @ManualTrace
    public void openLog() throws LogCorruptedException, LogAllocationException, InternalLogException, LogIncompatibleException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"openLog", (Object[])new Object[]{this});
        }
        this._recoveryLog.openLog();
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"openLog");
        }
    }

    @Override
    @ManualTrace
    public void closeLog() throws InternalLogException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"closeLog", (Object[])new Object[]{this});
        }
        this._recoveryLog.closeLog();
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"closeLog");
        }
    }

    @Override
    @ManualTrace
    public void closeLog(byte[] serviceData) throws InternalLogException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"closeLog", (Object[])new Object[]{serviceData, this});
        }
        this._recoveryLog.closeLog(serviceData);
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"closeLog");
        }
    }

    @Override
    @ManualTrace
    public void closeLogImmediate() throws InternalLogException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"closeLogImmediate", (Object[])new Object[]{this});
        }
        this._recoveryLog.closeLogImmediate();
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"closeLogImmediate");
        }
    }

    @Override
    @ManualTrace
    public void recoveryComplete() throws LogClosedException, InternalLogException, LogIncompatibleException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"recoveryComplete", (Object[])new Object[]{this});
        }
        this._recoveryLog.recoveryComplete();
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"recoveryComplete");
        }
    }

    @Override
    @ManualTrace
    public void recoveryComplete(byte[] serviceData) throws LogClosedException, InternalLogException, LogIncompatibleException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"recoveryComplete", (Object[])new Object[]{serviceData, this});
        }
        this._recoveryLog.recoveryComplete(serviceData);
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"recoveryComplete");
        }
    }

    @Override
    @ManualTrace
    public void keypoint() throws LogClosedException, InternalLogException, LogIncompatibleException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"keypoint", (Object[])new Object[]{this});
        }
        this._recoveryLog.keypoint();
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"keypoint");
        }
    }

    @Override
    @ManualTrace
    public byte[] serviceData() throws LogClosedException, InternalLogException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"serviceData", (Object[])new Object[]{this});
        }
        byte[] serviceData = this._recoveryLog.serviceData();
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"serviceData", (Object)RLSUtils.toHexString(serviceData, 32));
        }
        return serviceData;
    }

    @Override
    @ManualTrace
    public RecoverableUnit createRecoverableUnit() throws LogClosedException, InternalLogException, LogIncompatibleException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"createRecoverableUnit", (Object[])new Object[]{this});
        }
        RecoverableUnit runit = this._recoveryLog.createRecoverableUnit(this._failureScope);
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"createRecoverableUnit", (Object)runit);
        }
        return runit;
    }

    @Override
    @ManualTrace
    public void removeRecoverableUnit(long identity) throws LogClosedException, InvalidRecoverableUnitException, InternalLogException, LogIncompatibleException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"removeRecoverableUnit", (Object[])new Object[]{identity, this});
        }
        this._recoveryLog.removeRecoverableUnit(identity);
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"removeRecoverableUnit");
        }
    }

    @Override
    @ManualTrace
    public RecoverableUnit lookupRecoverableUnit(long identity) throws LogClosedException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"lookupRecoverableUnit", (Object[])new Object[]{identity, this});
        }
        RecoverableUnit runit = this._recoveryLog.lookupRecoverableUnit(identity);
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"lookupRecoverableUnit", (Object)runit);
        }
        return runit;
    }

    @Override
    @ManualTrace
    public LogCursor recoverableUnits() throws LogClosedException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"recoverableUnits", (Object[])new Object[]{this});
        }
        LogCursor cursor = this._recoveryLog.recoverableUnits(this._failureScope);
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"recoverableUnits", (Object)cursor);
        }
        return cursor;
    }

    @Override
    @ManualTrace
    public LogProperties logProperties() {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"logProperties", (Object[])new Object[]{this});
        }
        LogProperties lprops = this._recoveryLog.logProperties();
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"logProperties", (Object)lprops);
        }
        return lprops;
    }

    public String toString() {
        return "" + this._recoveryLog + " [" + this._failureScope + "]";
    }

    private MultiScopeLog getMultiScopeLog() {
        return this._recoveryLog;
    }

    @Override
    @ManualTrace
    public void associateLog(DistributedRecoveryLog otherLog, boolean failAssociatedLog) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"associateLog", (Object[])new Object[]{otherLog, failAssociatedLog, this});
        }
        if (otherLog instanceof RecoveryLogImpl) {
            this._recoveryLog.associateLog(((RecoveryLogImpl)otherLog).getMultiScopeLog(), failAssociatedLog);
        } else {
            this._recoveryLog.associateLog(otherLog, failAssociatedLog);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"associateLog");
        }
    }

    @Override
    @ManualTrace
    public void delete() {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"delete", (Object[])new Object[]{this});
        }
        this._recoveryLog.delete();
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"delete", (Object)this);
        }
    }
}

