/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.microprofile.health20.services.impl;

import com.ibm.ejs.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.ws.cdi.CDIService;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.microprofile.health.services.HealthCheckBeanCallException;
import com.ibm.ws.microprofile.health20.services.HealthCheck20CDIBeanInvoker;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import java.lang.annotation.Annotation;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.enterprise.context.spi.Contextual;
import javax.enterprise.inject.spi.Bean;
import javax.enterprise.inject.spi.BeanManager;
import javax.enterprise.util.AnnotationLiteral;
import org.eclipse.microprofile.health.Health;
import org.eclipse.microprofile.health.HealthCheck;
import org.eclipse.microprofile.health.HealthCheckResponse;
import org.eclipse.microprofile.health.Liveness;
import org.eclipse.microprofile.health.Readiness;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.ConfigurationPolicy;
import org.osgi.service.component.annotations.Reference;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/ejs/ras/TraceComponent;")
@InjectedFFDC
@Component(service={HealthCheck20CDIBeanInvoker.class}, configurationPolicy=ConfigurationPolicy.IGNORE, property={"service.vendor=IBM"})
public class HealthCheck20CDIBeanInvokerImpl
implements HealthCheck20CDIBeanInvoker {
    private static final com.ibm.ejs.ras.TraceComponent tc = Tr.register(HealthCheck20CDIBeanInvokerImpl.class);
    private final Map<String, BeanManager> beanManagers;
    private CDIService cdiService;
    static final long serialVersionUID = -9211347411623896525L;

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.WebSphereTrTracingMethodAdapter"})
    public HealthCheck20CDIBeanInvokerImpl() {
        if (com.ibm.ejs.ras.TraceComponent.isAnyTracingEnabled() && tc != null && tc.isEntryEnabled()) {
            Tr.entry((com.ibm.ejs.ras.TraceComponent)tc, (String)"<init>", (Object)new Object[0]);
        }
        this.beanManagers = new HashMap<String, BeanManager>();
        if (com.ibm.ejs.ras.TraceComponent.isAnyTracingEnabled() && tc != null && tc.isEntryEnabled()) {
            Tr.exit((com.ibm.ejs.ras.TraceComponent)tc, (String)"<init>", (Object)this);
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.WebSphereTrTracingMethodAdapter"})
    @Reference(service=CDIService.class)
    protected void setCdiService(CDIService cdiService) {
        if (com.ibm.ejs.ras.TraceComponent.isAnyTracingEnabled() && tc != null && tc.isEntryEnabled()) {
            Tr.entry((com.ibm.ejs.ras.TraceComponent)tc, (String)"setCdiService", (Object)new Object[]{cdiService});
        }
        this.cdiService = cdiService;
        if (com.ibm.ejs.ras.TraceComponent.isAnyTracingEnabled() && tc != null && tc.isEntryEnabled()) {
            Tr.exit((com.ibm.ejs.ras.TraceComponent)tc, (String)"setCdiService");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.WebSphereTrTracingMethodAdapter"})
    protected void unsetCdiService(CDIService cdiService) {
        if (com.ibm.ejs.ras.TraceComponent.isAnyTracingEnabled() && tc != null && tc.isEntryEnabled()) {
            Tr.entry((com.ibm.ejs.ras.TraceComponent)tc, (String)"unsetCdiService", (Object)new Object[]{cdiService});
        }
        if (this.cdiService == cdiService) {
            this.cdiService = null;
        }
        if (com.ibm.ejs.ras.TraceComponent.isAnyTracingEnabled() && tc != null && tc.isEntryEnabled()) {
            Tr.exit((com.ibm.ejs.ras.TraceComponent)tc, (String)"unsetCdiService");
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.WebSphereTrTracingMethodAdapter"})
    public Set<HealthCheckResponse> checkAllBeans(String appName, String moduleName, String healthCheckProcedure) throws HealthCheckBeanCallException {
        void var8_11;
        if (com.ibm.ejs.ras.TraceComponent.isAnyTracingEnabled() && tc != null && tc.isEntryEnabled()) {
            Tr.entry((com.ibm.ejs.ras.TraceComponent)tc, (String)"checkAllBeans", (Object)new Object[]{appName, moduleName, healthCheckProcedure});
        }
        BeanManager beanManager = this.getBeanManager(appName, moduleName);
        HashSet<HealthCheckResponse> retVal = new HashSet<HealthCheckResponse>();
        Set<Object> healthCheckBeans = new HashSet();
        String string = healthCheckProcedure;
        int n = -1;
        switch (string.hashCode()) {
            case 2337004: {
                if (!string.equals("LIVE")) break;
                boolean bl = false;
                break;
            }
            case 77848963: {
                if (!string.equals("READY")) break;
                boolean bl = true;
            }
        }
        switch (var8_11) {
            case 0: {
                healthCheckBeans = this.getHealthCheckLivenessBeans(beanManager);
                break;
            }
            case 1: {
                healthCheckBeans = this.getHealthCheckReadinessBeans(beanManager);
                break;
            }
            default: {
                healthCheckBeans = this.getAllHealthCheckBeans(beanManager);
            }
        }
        for (Object e : healthCheckBeans) {
            HealthCheck tempHCBean = (HealthCheck)e;
            try {
                retVal.add(tempHCBean.call());
            }
            catch (Throwable throwable) {
                void e2;
                FFDCFilter.processException((Throwable)throwable, (String)"com.ibm.ws.microprofile.health20.services.impl.HealthCheck20CDIBeanInvokerImpl", (String)"81", (Object)this, (Object[])new Object[]{appName, moduleName, healthCheckProcedure});
                HealthCheckBeanCallException hcbce = new HealthCheckBeanCallException((Throwable)e2);
                hcbce.setBeanName(e.getClass().toString());
                throw hcbce;
            }
            Tr.event((com.ibm.ejs.ras.TraceComponent)tc, (String)("HealthCheck beanClass: " + e.getClass() + " called"));
        }
        HashSet<HealthCheckResponse> hashSet = retVal;
        if (com.ibm.ejs.ras.TraceComponent.isAnyTracingEnabled() && tc != null && tc.isEntryEnabled()) {
            hashSet = hashSet;
            Tr.exit((com.ibm.ejs.ras.TraceComponent)tc, (String)"checkAllBeans", hashSet);
        }
        return hashSet;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.WebSphereTrTracingMethodAdapter"})
    private Set<Object> getHealthCheckLivenessBeans(BeanManager beanManager) {
        if (com.ibm.ejs.ras.TraceComponent.isAnyTracingEnabled() && tc != null && tc.isEntryEnabled()) {
            Tr.entry((com.ibm.ejs.ras.TraceComponent)tc, (String)"getHealthCheckLivenessBeans", (Object)new Object[]{beanManager});
        }
        HashSet<Object> hcLivenessBeans = new HashSet();
        AnnotationLiteral<Liveness> hcLivenessQualifier = new AnnotationLiteral<Liveness>(){
            static final long serialVersionUID = 6090888058656956778L;
            private static final /* synthetic */ TraceComponent $$$tc$$$;

            @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
            static {
                $$$tc$$$ = com.ibm.websphere.ras.Tr.register((String)"com.ibm.ws.microprofile.health20.services.impl.HealthCheck20CDIBeanInvokerImpl$1", 1.class, (String)"HEALTH", (String)"com.ibm.ws.microprofile.health.resources.Health");
            }
        };
        HashSet<Object> hashSet = hcLivenessBeans = this.getHealthCheckBeans(beanManager, (Annotation)hcLivenessQualifier);
        if (com.ibm.ejs.ras.TraceComponent.isAnyTracingEnabled() && tc != null && tc.isEntryEnabled()) {
            hashSet = hashSet;
            Tr.exit((com.ibm.ejs.ras.TraceComponent)tc, (String)"getHealthCheckLivenessBeans", hashSet);
        }
        return hashSet;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.WebSphereTrTracingMethodAdapter"})
    private Set<Object> getHealthCheckReadinessBeans(BeanManager beanManager) {
        if (com.ibm.ejs.ras.TraceComponent.isAnyTracingEnabled() && tc != null && tc.isEntryEnabled()) {
            Tr.entry((com.ibm.ejs.ras.TraceComponent)tc, (String)"getHealthCheckReadinessBeans", (Object)new Object[]{beanManager});
        }
        HashSet<Object> hcReadinessBeans = new HashSet();
        AnnotationLiteral<Readiness> hcReadinessQualifier = new AnnotationLiteral<Readiness>(){
            static final long serialVersionUID = 1498108855060207588L;
            private static final /* synthetic */ TraceComponent $$$tc$$$;

            @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
            static {
                $$$tc$$$ = com.ibm.websphere.ras.Tr.register((String)"com.ibm.ws.microprofile.health20.services.impl.HealthCheck20CDIBeanInvokerImpl$2", 2.class, (String)"HEALTH", (String)"com.ibm.ws.microprofile.health.resources.Health");
            }
        };
        HashSet<Object> hashSet = hcReadinessBeans = this.getHealthCheckBeans(beanManager, (Annotation)hcReadinessQualifier);
        if (com.ibm.ejs.ras.TraceComponent.isAnyTracingEnabled() && tc != null && tc.isEntryEnabled()) {
            hashSet = hashSet;
            Tr.exit((com.ibm.ejs.ras.TraceComponent)tc, (String)"getHealthCheckReadinessBeans", hashSet);
        }
        return hashSet;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.WebSphereTrTracingMethodAdapter"})
    private Set<Object> getHealthCheckHealthBeans(BeanManager beanManager) {
        if (com.ibm.ejs.ras.TraceComponent.isAnyTracingEnabled() && tc != null && tc.isEntryEnabled()) {
            Tr.entry((com.ibm.ejs.ras.TraceComponent)tc, (String)"getHealthCheckHealthBeans", (Object)new Object[]{beanManager});
        }
        HashSet<Object> hcHealthBeans = new HashSet();
        AnnotationLiteral<Health> hcHealthQualifier = new AnnotationLiteral<Health>(){
            static final long serialVersionUID = 3076036709563461836L;
            private static final /* synthetic */ TraceComponent $$$tc$$$;

            @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
            static {
                $$$tc$$$ = com.ibm.websphere.ras.Tr.register((String)"com.ibm.ws.microprofile.health20.services.impl.HealthCheck20CDIBeanInvokerImpl$3", 3.class, (String)"HEALTH", (String)"com.ibm.ws.microprofile.health.resources.Health");
            }
        };
        HashSet<Object> hashSet = hcHealthBeans = this.getHealthCheckBeans(beanManager, (Annotation)hcHealthQualifier);
        if (com.ibm.ejs.ras.TraceComponent.isAnyTracingEnabled() && tc != null && tc.isEntryEnabled()) {
            hashSet = hashSet;
            Tr.exit((com.ibm.ejs.ras.TraceComponent)tc, (String)"getHealthCheckHealthBeans", hashSet);
        }
        return hashSet;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.WebSphereTrTracingMethodAdapter"})
    private Set<Object> getAllHealthCheckBeans(BeanManager beanManager) {
        if (com.ibm.ejs.ras.TraceComponent.isAnyTracingEnabled() && tc != null && tc.isEntryEnabled()) {
            Tr.entry((com.ibm.ejs.ras.TraceComponent)tc, (String)"getAllHealthCheckBeans", (Object)new Object[]{beanManager});
        }
        HashSet<Object> hcAllBeans = new HashSet<Object>();
        hcAllBeans.addAll(this.getHealthCheckLivenessBeans(beanManager));
        hcAllBeans.addAll(this.getHealthCheckReadinessBeans(beanManager));
        hcAllBeans.addAll(this.getHealthCheckHealthBeans(beanManager));
        HashSet<Object> hashSet = hcAllBeans;
        if (com.ibm.ejs.ras.TraceComponent.isAnyTracingEnabled() && tc != null && tc.isEntryEnabled()) {
            hashSet = hashSet;
            Tr.exit((com.ibm.ejs.ras.TraceComponent)tc, (String)"getAllHealthCheckBeans", hashSet);
        }
        return hashSet;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.WebSphereTrTracingMethodAdapter"})
    private Set<Object> getHealthCheckBeans(BeanManager beanManager, Annotation hcQualifier) {
        if (com.ibm.ejs.ras.TraceComponent.isAnyTracingEnabled() && tc != null && tc.isEntryEnabled()) {
            Tr.entry((com.ibm.ejs.ras.TraceComponent)tc, (String)"getHealthCheckBeans", (Object)new Object[]{beanManager, hcQualifier});
        }
        HashSet<Object> healthCheckBeans = new HashSet<Object>();
        if (beanManager != null) {
            Set beans = beanManager.getBeans(HealthCheck.class, new Annotation[]{hcQualifier});
            for (Bean bean : beans) {
                Tr.event((com.ibm.ejs.ras.TraceComponent)tc, (String)("Bean Found: HealthCheck beanClass = " + bean.getBeanClass() + ", class = " + bean.getClass() + ", name = " + bean.getName()));
                healthCheckBeans.add(beanManager.getReference(bean, HealthCheck.class, beanManager.createCreationalContext((Contextual)bean)));
            }
        }
        HashSet<Object> hashSet = healthCheckBeans;
        if (com.ibm.ejs.ras.TraceComponent.isAnyTracingEnabled() && tc != null && tc.isEntryEnabled()) {
            hashSet = hashSet;
            Tr.exit((com.ibm.ejs.ras.TraceComponent)tc, (String)"getHealthCheckBeans", hashSet);
        }
        return hashSet;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.WebSphereTrTracingMethodAdapter"})
    private BeanManager getBeanManager(String appName, String moduleName) {
        if (com.ibm.ejs.ras.TraceComponent.isAnyTracingEnabled() && tc != null && tc.isEntryEnabled()) {
            Tr.entry((com.ibm.ejs.ras.TraceComponent)tc, (String)"getBeanManager", (Object)new Object[]{appName, moduleName});
        }
        String key = appName + "#" + moduleName;
        BeanManager manager = this.beanManagers.get(key);
        if (manager == null) {
            if (this.beanManagers.containsKey(key) || this.cdiService == null) {
                BeanManager beanManager = null;
                if (com.ibm.ejs.ras.TraceComponent.isAnyTracingEnabled() && tc != null && tc.isEntryEnabled()) {
                    beanManager = beanManager;
                    Tr.exit((com.ibm.ejs.ras.TraceComponent)tc, (String)"getBeanManager", beanManager);
                }
                return beanManager;
            }
            manager = this.cdiService.getCurrentModuleBeanManager();
            this.beanManagers.put(key, manager);
        }
        BeanManager beanManager = manager;
        if (com.ibm.ejs.ras.TraceComponent.isAnyTracingEnabled() && tc != null && tc.isEntryEnabled()) {
            beanManager = beanManager;
            Tr.exit((com.ibm.ejs.ras.TraceComponent)tc, (String)"getBeanManager", (Object)beanManager);
        }
        return beanManager;
    }

    @Override
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.WebSphereTrTracingMethodAdapter"})
    public void removeModuleReferences(String appName, String moduleName) {
        if (com.ibm.ejs.ras.TraceComponent.isAnyTracingEnabled() && tc != null && tc.isEntryEnabled()) {
            Tr.entry((com.ibm.ejs.ras.TraceComponent)tc, (String)"removeModuleReferences", (Object)new Object[]{appName, moduleName});
        }
        String key = appName + "#" + moduleName;
        this.beanManagers.remove(key);
        if (com.ibm.ejs.ras.TraceComponent.isAnyTracingEnabled() && tc != null && tc.isEntryEnabled()) {
            Tr.exit((com.ibm.ejs.ras.TraceComponent)tc, (String)"removeModuleReferences");
        }
    }
}

