/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sip.stack.transaction;

import com.ibm.sip.util.log.Log;
import com.ibm.sip.util.log.LogMgr;
import com.ibm.ws.jain.protocol.ip.sip.SipJainFactories;
import com.ibm.ws.jain.protocol.ip.sip.SipProviderImpl;
import com.ibm.ws.jain.protocol.ip.sip.message.CancelRequest;
import com.ibm.ws.jain.protocol.ip.sip.message.RequestImpl;
import com.ibm.ws.jain.protocol.ip.sip.message.ResponseImpl;
import com.ibm.ws.sip.stack.context.MessageContext;
import com.ibm.ws.sip.stack.context.MessageContextFactory;
import com.ibm.ws.sip.stack.transaction.SIPStackConfiguration;
import com.ibm.ws.sip.stack.transaction.transactions.BranchMethodKey;
import com.ibm.ws.sip.stack.transaction.transactions.MergedRequestKey;
import com.ibm.ws.sip.stack.transaction.transactions.SIPTransactionsModel;
import com.ibm.ws.sip.stack.transaction.transactions.ct.SIPClientTranaction;
import com.ibm.ws.sip.stack.transaction.transactions.ct.SIPClientTransactionImpl;
import com.ibm.ws.sip.stack.transaction.transactions.ct.SIPInviteClientTransactionImpl;
import com.ibm.ws.sip.stack.transaction.transactions.ct.SIPNonInviteClientTransactionImpl;
import com.ibm.ws.sip.stack.transaction.transactions.st.SIPInviteServerTransactionImpl;
import com.ibm.ws.sip.stack.transaction.transactions.st.SIPNonInviteServerTransactionImpl;
import com.ibm.ws.sip.stack.transaction.transactions.st.SIPServerTransaction;
import com.ibm.ws.sip.stack.transaction.transactions.st.SIPServerTransactionImpl;
import com.ibm.ws.sip.stack.transaction.transport.SIPTransportException;
import com.ibm.ws.sip.stack.transaction.transport.TransportCommLayerMgr;
import com.ibm.ws.sip.stack.transaction.transport.connections.SIPConnection;
import com.ibm.ws.sip.stack.transaction.util.ThreadPool;
import jain.protocol.ip.sip.SipEvent;
import jain.protocol.ip.sip.SipParseException;
import jain.protocol.ip.sip.SipProvider;
import jain.protocol.ip.sip.TransactionDoesNotExistException;
import jain.protocol.ip.sip.header.ToHeader;
import jain.protocol.ip.sip.message.Message;
import jain.protocol.ip.sip.message.Request;
import jain.protocol.ip.sip.message.Response;
import java.util.Timer;

public class SIPTransactionStack {
    private SIPTransactionsModel m_transactionsModel;
    private TransportCommLayerMgr m_transportCommLayerMgr;
    private UACommLayer m_uaCommLayer;
    private SIPStackConfiguration m_stackConfiguration;
    private Timer m_transactionsTimer;
    private boolean m_isRunning;
    private static final LogMgr c_logger = Log.get(SIPTransactionStack.class);
    private static volatile SIPTransactionStack s_instance;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static SIPTransactionStack instance() {
        SIPTransactionStack result = s_instance;
        if (result != null) return result;
        Class<SIPTransactionStack> clazz = SIPTransactionStack.class;
        synchronized (SIPTransactionStack.class) {
            result = s_instance;
            if (result != null) return result;
            s_instance = result = new SIPTransactionStack();
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return result;
        }
    }

    private SIPTransactionStack() {
        this.init();
    }

    private void init() {
        this.m_stackConfiguration = new SIPStackConfiguration();
        if (c_logger.isInfoEnabled()) {
            c_logger.info("info.com.ibm.ws.sip.stack.transaction.SIPTransactionStack.init.1", (Object)"Start", null);
        }
        this.m_transactionsModel = SIPTransactionsModel.instance();
        this.m_transportCommLayerMgr = TransportCommLayerMgr.instance();
        if (c_logger.isInfoEnabled()) {
            c_logger.info("info.com.ibm.ws.sip.stack.transaction.SIPTransactionStack.init.2", (Object)"Start", null);
        }
        this.m_uaCommLayer = new UACommLayer();
        this.m_transactionsTimer = new Timer(true);
        this.m_isRunning = true;
        if (c_logger.isInfoEnabled()) {
            c_logger.info("info.com.ibm.ws.sip.stack.transaction.SIPTransactionStack.init.3", (Object)"Start", null);
        }
    }

    public boolean isRunning() {
        return this.m_isRunning;
    }

    public Timer getTimer() {
        return this.m_transactionsTimer;
    }

    public SIPStackConfiguration getConfiguration() {
        return this.m_stackConfiguration;
    }

    public SIPTransactionsModel getTransactionsModel() {
        return this.m_transactionsModel;
    }

    public UACommLayer getUACommLayer() {
        return this.m_uaCommLayer;
    }

    public TransportCommLayerMgr getTransportCommLayerMgr() {
        return this.m_transportCommLayerMgr;
    }

    public void sendRequestToTransportCore(MessageContext messageContext, SipProvider provider, SIPConnection connection) throws SIPTransportException {
        this.m_transportCommLayerMgr.sendMessage(messageContext, provider, connection);
    }

    public long prossesUASipRequest(Request sipRequest, SipProvider provider, long transactionId) throws SipParseException {
        long retTidVal = 0L;
        SIPClientTranaction sipClientTransaction = null;
        if ("ACK".equals(sipRequest.getMethod())) {
            MessageContext messageContext = null;
            try {
                messageContext = MessageContextFactory.instance().getMessageContext(sipRequest);
                this.sendRequestToTransportCore(messageContext, provider, null);
            }
            catch (SIPTransportException exp) {
                if (c_logger.isTraceDebugEnabled()) {
                    c_logger.traceDebug(this, "processsUASipRequest", exp.getMessage());
                }
                if (messageContext != null) {
                    messageContext.writeError(exp);
                }
            }
        } else {
            if (sipRequest.getMethod().equals("CANCEL")) {
                SIPInviteClientTransactionImpl original = this.m_transactionsModel.getInviteFromCancel(sipRequest);
                if (original == null) {
                    if (c_logger.isTraceDebugEnabled()) {
                        c_logger.traceDebug(this, "processUASipRequest", "Cannot match INVITE transaction to CANCEL request");
                    }
                } else {
                    original.setCancelTimer();
                }
            }
            BranchMethodKey key = this.m_transactionsModel.createTransactionId(sipRequest);
            sipClientTransaction = this.createClientTransaction(sipRequest, provider, key, transactionId);
            this.m_transactionsModel.putClientTransaction(sipClientTransaction);
            sipClientTransaction.processRequest(sipRequest);
            retTidVal = sipClientTransaction.getId();
        }
        return retTidVal;
    }

    public long prossesUASipACKRequest(long inviteClientTransactionId, Request sipAckRequest) throws SipParseException, TransactionDoesNotExistException {
        SIPClientTranaction sipTransaction = this.m_transactionsModel.getClientTransaction(inviteClientTransactionId);
        sipTransaction.processRequest(sipAckRequest);
        return inviteClientTransactionId;
    }

    public long prossesUASipResponse(Response sipResponse, long transactionId) throws SipParseException, TransactionDoesNotExistException {
        SIPServerTransaction sipTransaction = this.m_transactionsModel.getServerTransaction(transactionId);
        sipTransaction.processResponse(sipResponse);
        return sipTransaction.getId();
    }

    public void prossesTransportSipMessage(Message sipMsg, SipProvider provider, SIPConnection sipTransportConnection) throws SipParseException {
        BranchMethodKey key = this.m_transactionsModel.createTransactionId(sipMsg);
        if (sipMsg.isRequest()) {
            RequestImpl sipRequest = (RequestImpl)sipMsg;
            SIPServerTransaction serverTransaction = this.m_transactionsModel.getServerTransaction(key, sipRequest);
            if (serverTransaction == null) {
                MergedRequestKey sourceId;
                boolean auto482toMergedRequests = this.m_stackConfiguration.isAuto482ResponseToMergedRequests();
                if (auto482toMergedRequests) {
                    sourceId = this.m_transactionsModel.createMergedTransactionId(sipRequest);
                    ToHeader to = sipRequest.getToHeader();
                    String toTag = to.getTag();
                    if ((toTag == null || toTag.length() == 0) && this.m_transactionsModel.isMergedServerTransaction(sourceId)) {
                        block22: {
                            Response response = SipJainFactories.getInstance().getMesssageFactory().createResponse(482, sipRequest);
                            MessageContext messageContext = null;
                            try {
                                messageContext = MessageContextFactory.instance().getMessageContext(response);
                                this.m_transportCommLayerMgr.sendMessage(messageContext, provider, sipTransportConnection);
                            }
                            catch (SIPTransportException e2) {
                                if (c_logger.isTraceDebugEnabled()) {
                                    c_logger.traceDebug(this, "processTransportSipMessage", e2.getMessage());
                                }
                                if (messageContext == null) break block22;
                                messageContext.writeError(e2);
                            }
                        }
                        return;
                    }
                } else {
                    sourceId = null;
                }
                if (!"ACK".equals(sipRequest.getMethod())) {
                    serverTransaction = this.createServerTransaction(sipRequest, provider, key, sourceId);
                    this.m_transactionsModel.putServerTransaction(serverTransaction);
                    serverTransaction.setTransportConnection(sipTransportConnection);
                }
            }
            if (sipRequest instanceof CancelRequest) {
                CancelRequest cancelRequest = (CancelRequest)sipRequest;
                try {
                    this.m_transactionsModel.correlateCancelToInviteTransaction(cancelRequest);
                }
                catch (TransactionDoesNotExistException e3) {
                    block23: {
                        try {
                            if (c_logger.isTraceDebugEnabled()) {
                                c_logger.traceDebug(this, "processTransportSipMessage", "Can't correlate CANCEL to INVITE transaction");
                            }
                            this.m_transactionsModel.remove(serverTransaction);
                            Response response = SipJainFactories.getInstance().getMesssageFactory().createResponse(481, sipRequest);
                            int length = response.getReasonPhrase().length() + e3.getMessage().length() + 16;
                            StringBuffer reason = new StringBuffer(length);
                            reason.append(response.getReasonPhrase());
                            reason.append("; ");
                            reason.append(e3.getMessage());
                            response.setReasonPhrase(reason.toString());
                            MessageContext messageContext = MessageContextFactory.instance().getMessageContext(response);
                            messageContext.setSipConnection(sipTransportConnection);
                            this.m_transportCommLayerMgr.sendMessage(messageContext, provider, sipTransportConnection);
                        }
                        catch (SIPTransportException transportX) {
                            if (!c_logger.isTraceDebugEnabled()) break block23;
                            c_logger.traceDebug(this, "processTransportSipMessage", transportX.getMessage());
                        }
                    }
                    return;
                }
            }
            if (serverTransaction == null) {
                SipEvent event = new SipEvent((Object)provider, -1L, sipRequest);
                this.m_uaCommLayer.sendEventToUA(event);
            } else {
                if (serverTransaction.getTransportConnection() == null) {
                    serverTransaction.setTransportConnection(sipTransportConnection);
                }
                serverTransaction.processRequest(sipRequest);
            }
        } else {
            ResponseImpl sipResponse = (ResponseImpl)sipMsg;
            SIPClientTranaction clientTransaction = this.m_transactionsModel.getClientTransaction(key);
            if (clientTransaction != null && clientTransaction.getState() != 3) {
                clientTransaction.setTransportConnection(sipTransportConnection);
                clientTransaction.processResponse(sipResponse);
            } else {
                if (c_logger.isTraceDebugEnabled()) {
                    c_logger.traceDebug(this, "processTransportSipMessage", "Got a stray response");
                }
                SipEvent event = new SipEvent((Object)provider, -1L, sipResponse);
                this.m_uaCommLayer.sendEventToUA(event);
            }
        }
    }

    public SIPClientTranaction createClientTransaction(Request req, SipProvider provider, BranchMethodKey key, long transactionId) throws SipParseException {
        SIPClientTransactionImpl retVal = null;
        String method = req.getMethod();
        retVal = "INVITE".equals(method) ? new SIPInviteClientTransactionImpl(this, provider, req, key, transactionId) : new SIPNonInviteClientTransactionImpl(this, provider, req, key, transactionId);
        return retVal;
    }

    private SIPServerTransaction createServerTransaction(Request req, SipProvider provider, BranchMethodKey key, MergedRequestKey fromCallIdCSeqKey) throws SipParseException {
        SIPServerTransactionImpl transaction = req.getMethod().equals("INVITE") ? new SIPInviteServerTransactionImpl(this, provider, req, key, fromCallIdCSeqKey) : new SIPNonInviteServerTransactionImpl(this, provider, req, key, fromCallIdCSeqKey);
        return transaction;
    }

    public class UACommLayer {
        public void sendEventToUA(final SipEvent event) {
            Runnable r = new Runnable(){

                @Override
                public void run() {
                    if (c_logger.isTraceDebugEnabled()) {
                        c_logger.traceDebug(this, "sendEventToUA", "dispaching transaction " + event.getTransactionId());
                    }
                    SipProviderImpl provider = (SipProviderImpl)event.getSource();
                    provider.onTransportEvent(event);
                }
            };
            ThreadPool.instance().invoke(r);
        }
    }
}

