/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sip.container.servlets;

import com.ibm.sip.util.log.Log;
import com.ibm.sip.util.log.LogMgr;
import com.ibm.websphere.servlet.session.IBMApplicationSession;
import com.ibm.websphere.sip.IBMSipSession;
import com.ibm.websphere.sip.WSApplicationSession;
import com.ibm.ws.sip.container.converged.servlet.session.ConvergedAppUtils;
import com.ibm.ws.sip.container.failover.repository.SessionRepository;
import com.ibm.ws.sip.container.servlets.SipApplicationSessionImpl;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.servlet.http.HttpSession;
import javax.servlet.sip.SipApplicationSession;
import javax.servlet.sip.URI;
import javax.xml.namespace.QName;
import javax.xml.ws.WebServiceContext;
import javax.xml.ws.wsaddressing.W3CEndpointReference;
import javax.xml.ws.wsaddressing.W3CEndpointReferenceBuilder;

public class WASXSipApplicationSessionImpl
extends SipApplicationSessionImpl
implements IBMApplicationSession,
WSApplicationSession {
    private static final long serialVersionUID = 1L;
    private static final transient LogMgr c_logger = Log.get(WASXSipApplicationSessionImpl.class);
    private Set<String> m_httpSessions;

    public WASXSipApplicationSessionImpl() {
    }

    public WASXSipApplicationSessionImpl(String id) {
        super(id);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void destoryHttpSession() {
        if (this.m_httpSessions != null) {
            String vhost = null;
            String uri = null;
            Set<String> set = this.m_httpSessions;
            synchronized (set) {
                Iterator<String> iterHttpSessions = this.m_httpSessions.iterator();
                while (iterHttpSessions.hasNext()) {
                    HttpSession httpSession;
                    if (vhost == null) {
                        vhost = this.getAppDescriptor().getVirtualHostName();
                        uri = this.getAppDescriptor().getRootURI();
                        if (c_logger.isTraceDebugEnabled()) {
                            c_logger.traceDebug(this, "destoryHttpSession", "getting vhost[" + vhost + "],uri[" + uri + "]");
                        }
                    }
                    String id = iterHttpSessions.next();
                    if (c_logger.isTraceDebugEnabled()) {
                        c_logger.traceDebug(this, "destoryHttpSession", "getting httpSession[" + id + "]");
                    }
                    if ((httpSession = ConvergedAppUtils.getHttpSessionById(vhost, uri, id)) != null) {
                        if (c_logger.isTraceDebugEnabled()) {
                            c_logger.traceDebug(this, "destoryHttpSession", "invalidating httpSession[" + id + "]");
                        }
                        httpSession.invalidate();
                    }
                    iterHttpSessions.remove();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void invalidate() {
        Object object = this.getSynchronizer();
        synchronized (object) {
            this.destoryHttpSession();
            super.invalidate();
        }
    }

    @Override
    public Iterator getSessions(String protocol) {
        if (protocol.equalsIgnoreCase("HTTP")) {
            if (this.m_httpSessions == null) {
                return Collections.EMPTY_SET.iterator();
            }
            return this.getAllHttpSessions().iterator();
        }
        return super.getSessions(protocol);
    }

    @Override
    public Object getSession(String id, SipApplicationSession.Protocol protocol) throws NullPointerException, IllegalStateException {
        if (c_logger.isTraceEntryExitEnabled()) {
            Object[] params = new Object[]{id, protocol};
            c_logger.traceEntry((Object)this, " getSession", params);
        }
        if (protocol == SipApplicationSession.Protocol.HTTP) {
            if (this.m_httpSessions == null) {
                if (c_logger.isTraceDebugEnabled()) {
                    c_logger.traceDebug(this, "getSession", " m_httpSessions is null");
                }
                return Collections.EMPTY_SET.iterator();
            }
            String vhost = null;
            String uri = null;
            vhost = this.getAppDescriptor().getVirtualHostName();
            uri = this.getAppDescriptor().getRootURI();
            if (c_logger.isTraceDebugEnabled()) {
                c_logger.traceDebug(this, "getSession", "getting vhost[" + vhost + "],uri[" + uri + "]");
            }
            for (String sessionId : this.m_httpSessions) {
                if (!sessionId.equalsIgnoreCase(id)) continue;
                HttpSession httpSession = ConvergedAppUtils.getHttpSessionById(vhost, uri, id);
                if (c_logger.isTraceDebugEnabled()) {
                    c_logger.traceDebug(this, "getSession", "Requested HTTP session found = " + httpSession);
                }
                return httpSession;
            }
        }
        return super.getSession(id, protocol);
    }

    public void encodeURI(Object arg0) {
        super.encodeURI((URI)arg0);
    }

    public String encodeURI(String uri) {
        int pPos;
        StringBuffer buf = new StringBuffer(uri);
        int startPos = Integer.MAX_VALUE;
        int qmPos = buf.indexOf("?");
        if (qmPos > -1) {
            startPos = qmPos;
        }
        if ((pPos = buf.indexOf("#")) > -1) {
            startPos = Math.min(startPos, pPos);
        }
        StringBuffer buf2 = new StringBuffer();
        buf2.append(";");
        buf2.append("ibmappid");
        buf2.append("=");
        buf2.append(this.getId());
        if (startPos == Integer.MAX_VALUE) {
            buf.append(buf2);
        } else {
            buf.insert(startPos, buf2);
        }
        return buf.toString();
    }

    public void addHttpSession(HttpSession httpSession) {
        if (c_logger.isTraceEntryExitEnabled()) {
            c_logger.traceEntry((Object)"WASXSipApplicationSessionImpl", "addHttpSession ", httpSession.getId(), httpSession);
        }
        if (httpSession != null) {
            this.createHttpSessionsSetIfNeeded();
            this.m_httpSessions.add(httpSession.getId());
            SessionRepository.getInstance().put(this);
        }
        if (c_logger.isTraceEntryExitEnabled()) {
            c_logger.traceExit("WASXSipApplicationSessionImpl", "addHttpSession ");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createHttpSessionsSetIfNeeded() {
        if (this.m_httpSessions == null) {
            WASXSipApplicationSessionImpl wASXSipApplicationSessionImpl = this;
            synchronized (wASXSipApplicationSessionImpl) {
                if (this.m_httpSessions == null) {
                    this.m_httpSessions = Collections.synchronizedSet(new HashSet(1));
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeHttpSession(String id) {
        if (c_logger.isTraceEntryExitEnabled()) {
            c_logger.traceEntry((Object)"WASXSipApplicationSessionImpl", "removeHttpSession ", new Object[]{id});
        }
        Set<String> set = this.m_httpSessions;
        synchronized (set) {
            if (id != null && this.m_httpSessions != null) {
                this.m_httpSessions.remove(id);
                this.setLastAccessedTime();
                this.store();
            }
        }
        if (c_logger.isTraceEntryExitEnabled()) {
            c_logger.traceEntry((Object)"WASXSipApplicationSessionImpl", "removeHttpSession ", new Object[]{id});
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected List getAllHttpSessions() {
        ArrayList<HttpSession> result = Collections.EMPTY_LIST;
        Set<String> set = this.m_httpSessions;
        synchronized (set) {
            if (this.m_httpSessions.isEmpty()) {
                return result;
            }
            String vhost = this.getAppDescriptor().getVirtualHostName();
            String uri = this.getAppDescriptor().getRootURI();
            if (c_logger.isTraceDebugEnabled()) {
                c_logger.traceDebug(this, "getAllHttpSessions", "getting vhost[" + vhost + "],uri[" + uri + "]");
            }
            result = new ArrayList<HttpSession>(this.m_httpSessions.size());
            for (String id : this.m_httpSessions) {
                if (c_logger.isTraceDebugEnabled()) {
                    c_logger.traceDebug(this, "getAllHttpSessions", "getting httpSession[" + id + "]");
                }
                HttpSession httpSession = ConvergedAppUtils.getHttpSessionById(vhost, uri, id);
                if (c_logger.isTraceDebugEnabled() && (id == null || httpSession == null) && c_logger.isTraceDebugEnabled()) {
                    c_logger.traceDebug(this, "getAllHttpSessions", "mismatch between http sessions in web container and SIP container. check flow.");
                }
                if (httpSession == null) continue;
                result.add(httpSession);
            }
            if (c_logger.isTraceDebugEnabled()) {
                c_logger.traceDebug(this, "getAllHttpSessions", "found sessions. count:" + result.size());
            }
            return result;
        }
    }

    @Override
    public Iterator getSessions() {
        List<IBMSipSession> combineHttpAndSIP;
        if (this.m_httpSessions == null || this.m_httpSessions.isEmpty()) {
            if (c_logger.isTraceDebugEnabled()) {
                c_logger.traceDebug(this, "getSessions", "no HTTP sessions. will give only SIP sessions.");
            }
            return super.getSessions();
        }
        if (c_logger.isTraceDebugEnabled()) {
            c_logger.traceDebug(this, "getSessions", "getting SIP and HTTP sessions");
        }
        if ((combineHttpAndSIP = this.getAllSIPSessions()).isEmpty()) {
            if (c_logger.isTraceDebugEnabled()) {
                c_logger.traceDebug(this, "getSessions", "SIP session list is empty. returning only HTTP.");
            }
            return this.getAllHttpSessions().iterator();
        }
        combineHttpAndSIP.addAll(this.getAllHttpSessions());
        if (c_logger.isTraceDebugEnabled()) {
            c_logger.traceDebug(this, "getSessions", "found total of " + combineHttpAndSIP.size() + " sessions.");
        }
        return combineHttpAndSIP.iterator();
    }

    @Override
    public URL encodeURL(URL url) throws IllegalStateException {
        super.encodeURL(url);
        try {
            return new URL(this.encodeURI(url.toString()));
        }
        catch (MalformedURLException e2) {
            throw new IllegalStateException(e2);
        }
    }

    @Override
    public W3CEndpointReference createEPR(String appSessionId) throws Exception {
        if (c_logger.isTraceEntryExitEnabled()) {
            c_logger.traceEntry((Object)null, "createEPR", (Object)appSessionId);
        }
        String namespace = new String("http://impl.webservice.commsvc.ws.ibm.com/");
        QName portQName = new QName(namespace, "ControllerPort");
        QName serviceQName = new QName(namespace, "ControllerService");
        W3CEndpointReference epr = this.createEPR(appSessionId, portQName, serviceQName, null);
        if (c_logger.isTraceEntryExitEnabled()) {
            c_logger.traceExit(null, "createEPR");
        }
        return epr;
    }

    @Override
    public W3CEndpointReference createEPR(String appSessionId, QName portQName, QName serviceQName, WebServiceContext context) throws Exception {
        if (c_logger.isTraceEntryExitEnabled()) {
            c_logger.traceEntry((Object)null, "createEPR", (Object)appSessionId);
        }
        W3CEndpointReferenceBuilder w3cBuilder = new W3CEndpointReferenceBuilder();
        w3cBuilder.serviceName(serviceQName);
        w3cBuilder.endpointName(portQName);
        return w3cBuilder.build();
    }

    @Override
    public boolean isReadyToInvalidate() throws IllegalStateException {
        boolean result;
        if (c_logger.isTraceEntryExitEnabled()) {
            c_logger.traceEntry("WASXSipApplicationSessionImpl", "isReadyToInvalidate ");
        }
        boolean bl = result = this.m_httpSessions == null || this.m_httpSessions.isEmpty();
        if (result) {
            result = super.isReadyToInvalidate();
        } else if (c_logger.isTraceDebugEnabled()) {
            c_logger.traceDebug("WASXSipApplicationSessionImpl.isReadyToInvalidate there are still valid HTTP sessions, SAS is not ready to be invalidated");
        }
        if (c_logger.isTraceEntryExitEnabled()) {
            c_logger.traceExit("WASXSipApplicationSessionImpl", "isReadyToInvalidate result=" + result);
        }
        return result;
    }

    public void sync() {
    }
}

