/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.jain.protocol.ip.sip.message;

import com.ibm.ws.jain.protocol.ip.sip.header.HeaderFactoryImpl;
import com.ibm.ws.jain.protocol.ip.sip.header.ViaHeaderImpl;
import com.ibm.ws.jain.protocol.ip.sip.message.CancelRequest;
import com.ibm.ws.jain.protocol.ip.sip.message.RequestImpl;
import com.ibm.ws.jain.protocol.ip.sip.message.ResponseImpl;
import jain.protocol.ip.sip.SipParseException;
import jain.protocol.ip.sip.address.URI;
import jain.protocol.ip.sip.header.CSeqHeader;
import jain.protocol.ip.sip.header.CallIdHeader;
import jain.protocol.ip.sip.header.ContentLengthHeader;
import jain.protocol.ip.sip.header.ContentTypeHeader;
import jain.protocol.ip.sip.header.FromHeader;
import jain.protocol.ip.sip.header.Header;
import jain.protocol.ip.sip.header.HeaderIterator;
import jain.protocol.ip.sip.header.ToHeader;
import jain.protocol.ip.sip.message.MessageFactory;
import jain.protocol.ip.sip.message.Request;
import jain.protocol.ip.sip.message.Response;
import java.util.ArrayList;
import java.util.List;

public class MessageFactoryImpl
implements MessageFactory {
    @Override
    public Request createRequest(URI requestURI, String method, CallIdHeader callIdHeader, CSeqHeader cSeqHeader, FromHeader fromHeader, ToHeader toHeader, List viaHeaders, String body, ContentTypeHeader contentTypeHeader) throws IllegalArgumentException, SipParseException {
        Request req = this.createRequest(requestURI, method, callIdHeader, cSeqHeader, fromHeader, toHeader, viaHeaders);
        req.setBody(body, contentTypeHeader);
        return req;
    }

    @Override
    public Request createRequest(URI requestURI, String method, CallIdHeader callIdHeader, CSeqHeader cSeqHeader, FromHeader fromHeader, ToHeader toHeader, List viaHeaders, byte[] body, ContentTypeHeader contentTypeHeader) throws IllegalArgumentException, SipParseException {
        Request req = this.createRequest(requestURI, method, callIdHeader, cSeqHeader, fromHeader, toHeader, viaHeaders);
        req.setBody(body, contentTypeHeader);
        return req;
    }

    @Override
    public Response createResponse(int statusCode, CallIdHeader callIdHeader, CSeqHeader cSeqHeader, FromHeader fromHeader, ToHeader toHeader, List viaHeaders) throws IllegalArgumentException, SipParseException {
        if (callIdHeader == null || cSeqHeader == null || fromHeader == null || toHeader == null || viaHeaders == null || viaHeaders.isEmpty()) {
            throw new IllegalArgumentException("MessageFactory: null argument");
        }
        for (int i = 0; i < viaHeaders.size(); ++i) {
            Object obj = viaHeaders.get(i);
            if (obj == null) {
                throw new IllegalArgumentException("Message Factory: Null via headers");
            }
            if (obj instanceof ViaHeaderImpl) continue;
            throw new IllegalArgumentException("MessageFactory: Via Headers in bad format");
        }
        ResponseImpl resImpl = new ResponseImpl();
        resImpl.setStatusCode(statusCode);
        resImpl.setCallIdHeader(callIdHeader);
        resImpl.setCSeqHeader(cSeqHeader);
        resImpl.setFromHeader(fromHeader);
        resImpl.setToHeader(toHeader);
        resImpl.setViaHeaders(viaHeaders);
        return resImpl;
    }

    @Override
    public Request createRequest(URI requestURI, String method, CallIdHeader callIdHeader, CSeqHeader cSeqHeader, FromHeader fromHeader, ToHeader toHeader, List viaHeaders) throws IllegalArgumentException, SipParseException {
        if (requestURI == null || method == null || callIdHeader == null || cSeqHeader == null || fromHeader == null || toHeader == null || viaHeaders == null || viaHeaders.isEmpty()) {
            throw new IllegalArgumentException("Message Factory: null argument");
        }
        for (int i = 0; i < viaHeaders.size(); ++i) {
            Object obj = viaHeaders.get(i);
            if (obj == null) {
                throw new IllegalArgumentException("Message Factory: Null via headers");
            }
            if (obj instanceof ViaHeaderImpl) continue;
            throw new IllegalArgumentException("MessageFactory: Via Headers in bad format");
        }
        boolean isCancel = method != null && method.equalsIgnoreCase("CANCEL");
        RequestImpl reqImpl = isCancel ? new CancelRequest() : new RequestImpl();
        reqImpl.setRequestURI(requestURI);
        reqImpl.setMethod(method);
        reqImpl.setCSeqHeader(cSeqHeader);
        reqImpl.setCallIdHeader(callIdHeader);
        reqImpl.setFromHeader(fromHeader);
        reqImpl.setToHeader(toHeader);
        reqImpl.setViaHeaders(viaHeaders);
        return reqImpl;
    }

    @Override
    public Response createResponse(int statusCode, CallIdHeader callIdHeader, CSeqHeader cSeqHeader, FromHeader fromHeader, ToHeader toHeader, List viaHeaders, String body, ContentTypeHeader contentTypeHeader) throws IllegalArgumentException, SipParseException {
        if (callIdHeader == null || cSeqHeader == null || fromHeader == null || toHeader == null || viaHeaders == null || viaHeaders.isEmpty() || body == null || contentTypeHeader == null) {
            throw new IllegalArgumentException("Message Factory: null argument");
        }
        for (int i = 0; i < viaHeaders.size(); ++i) {
            Object obj = viaHeaders.get(i);
            if (obj == null) {
                throw new IllegalArgumentException("Message Factory: Null via headers");
            }
            if (obj instanceof ViaHeaderImpl) continue;
            throw new IllegalArgumentException("MessageFactory: Via Headers in bad format");
        }
        ResponseImpl resImpl = new ResponseImpl();
        resImpl.setStatusCode(statusCode);
        resImpl.setCallIdHeader(callIdHeader);
        resImpl.setCSeqHeader(cSeqHeader);
        resImpl.setFromHeader(fromHeader);
        resImpl.setToHeader(toHeader);
        resImpl.setViaHeaders(viaHeaders);
        resImpl.setBody(body, contentTypeHeader);
        return resImpl;
    }

    @Override
    public Response createResponse(int statusCode, Request request) throws IllegalArgumentException, SipParseException {
        if (request == null) {
            throw new IllegalArgumentException("MessageFactory: Null Request");
        }
        if (!(request instanceof RequestImpl)) {
            throw new IllegalArgumentException("request must be fromIBM JAIN SIP implementation");
        }
        RequestImpl requestImpl = (RequestImpl)request;
        ResponseImpl response = new ResponseImpl();
        response.setStatusCode(statusCode);
        CallIdHeader callId = request.getCallIdHeader();
        CSeqHeader cseq = request.getCSeqHeader();
        FromHeader from = request.getFromHeader();
        ToHeader to = request.getToHeader();
        if (callId == null || cseq == null || from == null || to == null) {
            throw new IllegalArgumentException("request lacks mandatory header");
        }
        response.setCallIdHeader((CallIdHeader)callId.clone());
        response.setCSeqHeader((CSeqHeader)cseq.clone());
        response.setFromHeader((FromHeader)from.clone());
        response.setToHeader((ToHeader)to.clone());
        ArrayList<Header> viaHeaders = new ArrayList<Header>(3);
        HeaderIterator iterator = request.getViaHeaders();
        if (iterator != null) {
            while (iterator.hasNext()) {
                viaHeaders.add(iterator.next());
            }
            if (!viaHeaders.isEmpty()) {
                response.setViaHeaders(viaHeaders);
            }
        }
        if (statusCode >= 180 && statusCode < 190 || statusCode >= 200 && statusCode < 300) {
            ArrayList<Header> recordRouteHeaders = new ArrayList<Header>(3);
            iterator = request.getRecordRouteHeaders();
            if (iterator != null) {
                while (iterator.hasNext()) {
                    recordRouteHeaders.add(iterator.next());
                }
                if (!recordRouteHeaders.isEmpty()) {
                    response.setRecordRouteHeaders(recordRouteHeaders);
                }
            }
        }
        if (requestImpl.isLoopback()) {
            response.setLoopback(true);
        }
        return response;
    }

    @Override
    public Response createResponse(int statusCode, Request request, byte[] body, ContentTypeHeader contentTypeHeader) throws IllegalArgumentException, SipParseException {
        ResponseImpl response = (ResponseImpl)this.createResponse(statusCode, request);
        ContentLengthHeader contentLength = new HeaderFactoryImpl().createContentLengthHeader(body.length);
        response.setContentLengthHeader(contentLength);
        response.setBody(body, contentTypeHeader);
        return response;
    }

    @Override
    public Response createResponse(int statusCode, Request request, String body, ContentTypeHeader contentTypeHeader) throws IllegalArgumentException, SipParseException {
        ResponseImpl response = (ResponseImpl)this.createResponse(statusCode, request);
        ContentLengthHeader contentLength = new HeaderFactoryImpl().createContentLengthHeader(body.length());
        response.setContentLengthHeader(contentLength);
        response.setBody(body, contentTypeHeader);
        return response;
    }

    @Override
    public Response createResponse(int statusCode, CallIdHeader callIdHeader, CSeqHeader cSeqHeader, FromHeader fromHeader, ToHeader toHeader, List viaHeaders, byte[] body, ContentTypeHeader contentTypeHeader) throws IllegalArgumentException, SipParseException {
        if (callIdHeader == null || cSeqHeader == null || fromHeader == null || toHeader == null || viaHeaders == null || viaHeaders.isEmpty() || body == null || contentTypeHeader == null) {
            throw new IllegalArgumentException("MessageFactory: null arguments");
        }
        for (int i = 0; i < viaHeaders.size(); ++i) {
            Object obj = viaHeaders.get(i);
            if (obj == null) {
                throw new IllegalArgumentException("Message Factory: Null via headers");
            }
            if (obj instanceof ViaHeaderImpl) continue;
            throw new IllegalArgumentException("MessageFactory: Via Headers in bad format");
        }
        ResponseImpl resImpl = new ResponseImpl();
        resImpl.setStatusCode(statusCode);
        resImpl.setCallIdHeader(callIdHeader);
        resImpl.setCSeqHeader(cSeqHeader);
        resImpl.setFromHeader(fromHeader);
        resImpl.setToHeader(toHeader);
        resImpl.setViaHeaders(viaHeaders);
        resImpl.setBody(body, contentTypeHeader);
        return resImpl;
    }
}

