/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wssecurity.cxf.interceptor;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.Sensitive;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.wssecurity.cxf.validator.UsernameTokenValidator;
import com.ibm.ws.wssecurity.cxf.validator.Utils;
import com.ibm.ws.wssecurity.cxf.validator.WssSamlAssertionValidator;
import com.ibm.ws.wssecurity.signature.SignatureAlgorithms;
import com.ibm.wsspi.kernel.service.utils.SerializableProtectedString;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.apache.cxf.binding.soap.SoapMessage;
import org.apache.cxf.binding.soap.interceptor.AbstractSoapInterceptor;
import org.apache.cxf.interceptor.Fault;
import org.apache.cxf.message.Message;
import org.apache.cxf.message.MessageUtils;
import org.apache.cxf.ws.security.wss4j.PolicyBasedWSS4JInInterceptor;
import org.apache.cxf.ws.security.wss4j.PolicyBasedWSS4JOutInterceptor;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
public class WSSecurityLibertyPluginInterceptor
extends AbstractSoapInterceptor {
    static final Map<String, Object> providerConfigMap = Collections.synchronizedMap(new HashMap());
    static final Map<String, Object> clientConfigMap = Collections.synchronizedMap(new HashMap());
    private static final TraceComponent tc = Tr.register(WSSecurityLibertyPluginInterceptor.class, (String)"WSSecurity", (String)"com.ibm.ws.wssecurity.resources.WSSecurityMessages");
    private static final String SIGNATURE_METHOD = "signatureAlgorithm";
    static Map<String, Object> samlTokenConfigMap = null;
    static final long serialVersionUID = 4211940688980554572L;

    public WSSecurityLibertyPluginInterceptor() {
        super("pre-protocol");
        this.addBefore(PolicyBasedWSS4JInInterceptor.class.getName());
        this.addBefore(PolicyBasedWSS4JOutInterceptor.class.getName());
    }

    public static void setBindingsConfiguration(Map<String, Object> map) {
        if (map != null) {
            if (!providerConfigMap.isEmpty()) {
                providerConfigMap.clear();
            }
            providerConfigMap.putAll(map);
        } else {
            providerConfigMap.clear();
        }
    }

    public static void setClientBindingsConfiguration(Map<String, Object> map) {
        if (map != null) {
            if (!clientConfigMap.isEmpty()) {
                clientConfigMap.clear();
            }
            clientConfigMap.putAll(map);
        } else {
            clientConfigMap.clear();
        }
    }

    public static void setSamlTokenConfiguration(Map<String, Object> tmpSamlTokenConfigMap) {
        samlTokenConfigMap = tmpSamlTokenConfigMap;
    }

    public void handleMessage(@Sensitive SoapMessage message) throws Fault {
        if (message == null) {
            return;
        }
        boolean isReq = MessageUtils.isRequestor((Message)message);
        if (isReq) {
            Set<String> client_config_keys = clientConfigMap.keySet();
            Iterator<String> keyIt = client_config_keys.iterator();
            boolean user_id_exists = false;
            if (message.getContextualProperty("ws-security.username") != null) {
                user_id_exists = true;
            }
            while (keyIt.hasNext()) {
                String samlCallbackHandler;
                String key = keyIt.next();
                if (message.getContextualProperty(key) == null) {
                    Map tempMap;
                    if ("ws-security.signature.properties".equals(key)) {
                        tempMap = (Map)clientConfigMap.get("ws-security.signature.properties");
                        if (tempMap != null) {
                            HashMap<String, Object> sigPropsMap = new HashMap<String, Object>(tempMap);
                            Utils.modifyConfigMap(sigPropsMap);
                            Properties sigProps = new Properties();
                            sigProps.putAll((Map<?, ?>)sigPropsMap);
                            message.setContextualProperty(key, (Object)sigProps);
                            message.setContextualProperty("ws-security.signature.crypto", (Object)Utils.getCrypto(sigProps));
                            SignatureAlgorithms.setAlgorithm(message, (String)tempMap.get(SIGNATURE_METHOD));
                        }
                    } else if ("ws-security.encryption.properties".equals(key)) {
                        tempMap = (Map)clientConfigMap.get("ws-security.encryption.properties");
                        if (tempMap != null) {
                            HashMap<String, Object> encPropsMap = new HashMap<String, Object>(tempMap);
                            Utils.modifyConfigMap(encPropsMap);
                            Properties encProps = new Properties();
                            encProps.putAll((Map<?, ?>)encPropsMap);
                            message.setContextualProperty(key, (Object)encProps);
                            message.setContextualProperty("ws-security.encryption.crypto", (Object)Utils.getCrypto(encProps));
                        }
                    } else if ("ws-security.password".equals(key)) {
                        if (!user_id_exists) {
                            String pwd = Utils.changePasswordType((SerializableProtectedString)clientConfigMap.get("ws-security.password"));
                            message.setContextualProperty(key, (Object)pwd);
                        }
                    } else {
                        message.setContextualProperty(key, clientConfigMap.get(key));
                    }
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)"Client Config attribute is set on message = ", (Object[])new Object[]{key, ", value = ", clientConfigMap.get(key)});
                    }
                }
                if ((samlCallbackHandler = (String)message.getContextualProperty("ws-security.saml-callback-handler")) != null && !samlCallbackHandler.isEmpty()) continue;
                message.setContextualProperty("ws-security.saml-callback-handler", (Object)"com.ibm.ws.wssecurity.callback.Saml20PropagationCallbackHandler");
            }
        } else {
            Object validator = message.getContextualProperty("ws-security.ut.validator");
            if (validator == null) {
                message.put("ws-security.ut.validator", (Object)new UsernameTokenValidator());
            }
            if ((validator = message.getContextualProperty("ws-security.saml2.validator")) == null) {
                message.put("ws-security.saml2.validator", (Object)new WssSamlAssertionValidator(samlTokenConfigMap));
            }
            Set<String> provider_config_keys = providerConfigMap.keySet();
            for (String key : provider_config_keys) {
                Map tempMap;
                if ("ws-security.signature.properties".equals(key)) {
                    tempMap = (Map)providerConfigMap.get("ws-security.signature.properties");
                    if (tempMap != null) {
                        HashMap<String, Object> sigPropsMap = new HashMap<String, Object>(tempMap);
                        Utils.modifyConfigMap(sigPropsMap);
                        Properties sigProps = new Properties();
                        sigProps.putAll((Map<?, ?>)sigPropsMap);
                        message.setContextualProperty(key, (Object)sigProps);
                        message.setContextualProperty("ws-security.signature.crypto", (Object)Utils.getCrypto(sigProps));
                        SignatureAlgorithms.setAlgorithm(message, (String)tempMap.get(SIGNATURE_METHOD));
                    }
                } else if ("ws-security.encryption.properties".equals(key)) {
                    tempMap = (Map)providerConfigMap.get("ws-security.encryption.properties");
                    if (tempMap != null) {
                        HashMap<String, Object> encPropsMap = new HashMap<String, Object>(tempMap);
                        Utils.modifyConfigMap(encPropsMap);
                        Properties encProps = new Properties();
                        encProps.putAll((Map<?, ?>)encPropsMap);
                        message.setContextualProperty(key, (Object)encProps);
                        message.setContextualProperty("ws-security.encryption.crypto", (Object)Utils.getCrypto(encProps));
                    }
                } else if ("ws-security.password".equals(key)) {
                    String pwd = Utils.changePasswordType((SerializableProtectedString)providerConfigMap.get("ws-security.password"));
                    message.setContextualProperty(key, (Object)pwd);
                } else {
                    if ("ws-security.cache.config.file".equals(key)) {
                        // empty if block
                    }
                    message.setContextualProperty(key, providerConfigMap.get(key));
                }
                if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) continue;
                Tr.debug((TraceComponent)tc, (String)"Provider Config attribute is set on message = ", (Object[])new Object[]{key, ", value = ", providerConfigMap.get(key)});
            }
        }
    }
}

