/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.openapi.runtime.util;

import io.smallrye.openapi.runtime.io.schema.SchemaConstant;
import io.smallrye.openapi.runtime.util.ModelUtil;
import io.smallrye.openapi.runtime.util.TypeUtil;
import io.smallrye.openapi.runtime.util.UtilMessages;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.eclipse.microprofile.openapi.models.media.Schema;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.AnnotationTarget;
import org.jboss.jandex.AnnotationValue;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.DotName;
import org.jboss.jandex.FieldInfo;
import org.jboss.jandex.IndexView;
import org.jboss.jandex.MethodInfo;
import org.jboss.jandex.MethodParameterInfo;
import org.jboss.jandex.Type;

public class JandexUtil {
    private static final Pattern COMPONENT_KEY_PATTERN = Pattern.compile("^[a-zA-Z0-9\\.\\-_]+$");

    private JandexUtil() {
    }

    public static String refValue(AnnotationInstance annotation, RefType refType) {
        AnnotationValue value = annotation.value("ref");
        if (value == null) {
            return null;
        }
        String ref = value.asString();
        if (!COMPONENT_KEY_PATTERN.matcher(ref).matches()) {
            return ref;
        }
        if (refType == null) {
            throw UtilMessages.msg.refTypeNotNull();
        }
        ref = "#/components/" + refType.componentPath + "/" + ref;
        return ref;
    }

    public static <T> T value(AnnotationInstance annotation, String name) {
        AnnotationValue value = annotation.value(name);
        if (value == null) {
            return null;
        }
        boolean isArray = AnnotationValue.Kind.ARRAY == value.kind();
        switch (isArray ? value.componentKind() : value.kind()) {
            case BOOLEAN: {
                return (T)(isArray ? value.asBooleanArray() : (boolean[])value.asBoolean());
            }
            case BYTE: {
                return (T)(isArray ? value.asByteArray() : (byte[])value.asByte());
            }
            case CHARACTER: {
                return (T)(isArray ? value.asCharArray() : (char[])Character.valueOf(value.asChar()));
            }
            case CLASS: {
                return (T)(isArray ? value.asClassArray() : value.asClass());
            }
            case DOUBLE: {
                return (T)(isArray ? value.asDoubleArray() : (double[])value.asDouble());
            }
            case ENUM: {
                return (T)(isArray ? value.asEnumArray() : value.asEnum());
            }
            case FLOAT: {
                return (T)(isArray ? value.asFloatArray() : (float[])Float.valueOf(value.asFloat()));
            }
            case INTEGER: {
                return (T)(isArray ? value.asIntArray() : (int[])value.asInt());
            }
            case LONG: {
                return (T)(isArray ? value.asLongArray() : (long[])value.asLong());
            }
            case NESTED: {
                return (T)(isArray ? value.asNestedArray() : value.asNested());
            }
            case SHORT: {
                return (T)(isArray ? value.asShortArray() : (short[])value.asShort());
            }
            case STRING: {
                return (T)(isArray ? value.asStringArray() : value.asString());
            }
        }
        return null;
    }

    public static <T> T value(AnnotationInstance annotation, String name, T defaultValue) {
        T value = JandexUtil.value(annotation, name);
        return value != null ? value : defaultValue;
    }

    public static String stringValue(AnnotationInstance annotation, String propertyName) {
        AnnotationValue value = annotation.value(propertyName);
        if (value == null) {
            return null;
        }
        return value.asString();
    }

    public static Optional<String> optionalStringValue(AnnotationInstance annotation, String propertyName) {
        String value = JandexUtil.stringValue(annotation, propertyName);
        if (value == null) {
            return Optional.empty();
        }
        return Optional.of(value);
    }

    public static Optional<Boolean> booleanValue(AnnotationInstance annotation, String propertyName) {
        AnnotationValue value = annotation.value(propertyName);
        if (value != null) {
            return Optional.of(value.asBoolean());
        }
        return Optional.empty();
    }

    public static boolean booleanValueWithDefault(AnnotationInstance annotation, String propertyName) {
        AnnotationValue value = annotation.value(propertyName);
        return value != null && value.asBoolean();
    }

    public static Integer intValue(AnnotationInstance annotation, String propertyName) {
        AnnotationValue value = annotation.value(propertyName);
        if (value == null) {
            return null;
        }
        return value.asInt();
    }

    public static Optional<List<String>> stringListValue(AnnotationInstance annotation, String propertyName) {
        AnnotationValue value = annotation.value(propertyName);
        if (value != null) {
            return Optional.of(new ArrayList<String>(Arrays.asList(value.asStringArray())));
        }
        return Optional.empty();
    }

    public static <T extends Enum<?>> T enumValue(AnnotationInstance annotation, String propertyName, Class<T> clazz) {
        AnnotationValue value = annotation.value(propertyName);
        if (value == null) {
            return null;
        }
        return JandexUtil.enumValue(value.asString(), clazz);
    }

    public static <T extends Enum<?>> T enumValue(String strVal, Class<T> clazz) {
        Enum[] constants;
        for (Enum t : constants = (Enum[])clazz.getEnumConstants()) {
            if (!t.toString().equals(strVal)) continue;
            return (T)t;
        }
        for (Enum t : constants) {
            if (!t.name().equalsIgnoreCase(strVal)) continue;
            return (T)t;
        }
        return null;
    }

    public static boolean isRef(AnnotationInstance annotation) {
        return annotation.value("ref") != null;
    }

    public static boolean isEmpty(AnnotationInstance annotation) {
        return annotation.values() == null || annotation.values().isEmpty();
    }

    public static AnnotationInstance getClassAnnotation(ClassInfo ct, DotName name) {
        return JandexUtil.getClassAnnotation(ct, Arrays.asList(name));
    }

    public static AnnotationInstance getClassAnnotation(ClassInfo ct, Collection<DotName> names) {
        if (names == null || names.isEmpty()) {
            return null;
        }
        for (DotName dn : names) {
            AnnotationInstance classAnnotation = ct.classAnnotation(dn);
            if (classAnnotation == null) continue;
            return classAnnotation;
        }
        return null;
    }

    public static AnnotationInstance getAnnotation(MethodInfo mi, DotName ... names) {
        return JandexUtil.getAnnotation(mi, Arrays.asList(names));
    }

    public static AnnotationInstance getAnnotation(FieldInfo field, DotName name) {
        return JandexUtil.getAnnotation(field, Arrays.asList(name));
    }

    public static AnnotationInstance getAnnotation(FieldInfo field, Collection<DotName> names) {
        if (names == null || names.isEmpty()) {
            return null;
        }
        for (DotName dn : names) {
            AnnotationInstance annotation = field.annotation(dn);
            if (annotation == null) continue;
            return annotation;
        }
        return null;
    }

    public static AnnotationInstance getAnnotation(MethodInfo mi, Collection<DotName> names) {
        if (names == null || names.isEmpty()) {
            return null;
        }
        for (DotName dn : names) {
            AnnotationInstance annotation = mi.annotation(dn);
            if (annotation == null) continue;
            return annotation;
        }
        return null;
    }

    public static boolean hasAnyOneOfAnnotation(MethodInfo method, DotName ... annotations) {
        return JandexUtil.hasAnyOneOfAnnotation(method, Arrays.asList(annotations));
    }

    public static boolean hasAnyOneOfAnnotation(MethodInfo method, Collection<DotName> annotations) {
        for (DotName dotName : annotations) {
            if (!method.hasAnnotation(dotName)) continue;
            return true;
        }
        return false;
    }

    public static List<AnnotationInstance> getParameterAnnotations(MethodInfo method, short paramPosition) {
        return method.annotations().stream().filter(annotation -> {
            AnnotationTarget target = annotation.target();
            return target != null && target.kind() == AnnotationTarget.Kind.METHOD_PARAMETER && target.asMethodParameter().position() == paramPosition;
        }).collect(Collectors.toList());
    }

    public static String nameFromRef(AnnotationInstance annotation) {
        String ref = annotation.value("ref").asString();
        return ModelUtil.nameFromRef(ref);
    }

    public static List<AnnotationInstance> getRepeatableAnnotation(AnnotationTarget target, DotName singleAnnotationName, DotName repeatableAnnotationName) {
        AnnotationInstance[] nestedArray;
        ArrayList<AnnotationInstance> annotations = new ArrayList<AnnotationInstance>();
        AnnotationInstance annotation = TypeUtil.getAnnotation(target, singleAnnotationName);
        if (annotation != null) {
            annotations.add(annotation);
        }
        if (repeatableAnnotationName != null && (nestedArray = (AnnotationInstance[])TypeUtil.getAnnotationValue(target, repeatableAnnotationName, "value")) != null) {
            annotations.addAll(Arrays.asList(nestedArray));
        }
        return annotations;
    }

    public static Type getMethodParameterType(MethodInfo method, short position) {
        return (Type)method.parameters().get(position);
    }

    public static Type getMethodParameterType(MethodParameterInfo parameter) {
        return (Type)parameter.method().parameters().get(parameter.position());
    }

    public static AnnotationInstance getMethodParameterAnnotation(MethodInfo method, int parameterIndex, DotName annotationName) {
        for (AnnotationInstance annotation : method.annotations()) {
            if (annotation.target().kind() != AnnotationTarget.Kind.METHOD_PARAMETER || annotation.target().asMethodParameter().position() != parameterIndex || !annotation.name().equals((Object)annotationName)) continue;
            return annotation;
        }
        return null;
    }

    public static List<AnnotationValue> schemaDisplayValues(AnnotationInstance annotation) {
        return annotation.values().stream().filter(value -> !SchemaConstant.PROPERTIES_NONDISPLAY.contains(value.name())).collect(Collectors.toList());
    }

    public static boolean isSimpleClassSchema(AnnotationInstance annotation) {
        return JandexUtil.schemaDisplayValues(annotation).isEmpty() && JandexUtil.hasImplementation(annotation);
    }

    public static boolean isSimpleArraySchema(AnnotationInstance annotation) {
        if (JandexUtil.schemaDisplayValues(annotation).size() != 1) {
            return false;
        }
        return JandexUtil.isArraySchema(annotation);
    }

    public static boolean isArraySchema(AnnotationInstance annotation) {
        if (!JandexUtil.hasImplementation(annotation)) {
            return false;
        }
        Schema.SchemaType type = JandexUtil.enumValue(annotation, "type", Schema.SchemaType.class);
        return type == Schema.SchemaType.ARRAY;
    }

    public static boolean hasImplementation(AnnotationInstance annotation) {
        return annotation.value("implementation") != null;
    }

    public static Map<ClassInfo, Type> inheritanceChain(IndexView index, ClassInfo klazz, Type type) {
        LinkedHashMap<ClassInfo, Type> chain = new LinkedHashMap<ClassInfo, Type>();
        do {
            chain.put(klazz, type);
        } while ((type = klazz.superClassType()) != null && (klazz = index.getClassByName(TypeUtil.getName(type))) != null);
        return chain;
    }

    public static boolean equals(AnnotationTarget t1, AnnotationTarget t2) {
        if (t1 == t2) {
            return true;
        }
        if (t1 == null || t2 == null || t1.kind() != t2.kind()) {
            return false;
        }
        switch (t1.kind()) {
            case CLASS: {
                return JandexUtil.equals(t1.asClass(), t2.asClass());
            }
            case FIELD: {
                return JandexUtil.equals(t1.asField(), t2.asField());
            }
            case METHOD_PARAMETER: {
                return JandexUtil.equals(t1.asMethodParameter(), t2.asMethodParameter());
            }
        }
        return t1.equals(t2);
    }

    public static boolean equals(ClassInfo c1, ClassInfo c2) {
        return c1.name().equals((Object)c2.name());
    }

    public static boolean equals(FieldInfo f1, FieldInfo f2) {
        return JandexUtil.equals(f1.declaringClass(), f2.declaringClass()) && f1.name().equals(f2.name());
    }

    public static boolean equals(MethodParameterInfo p1, MethodParameterInfo p2) {
        return p1.method().equals((Object)p2.method()) && p1.position() == p2.position();
    }

    public static enum RefType {
        HEADER("headers"),
        SCHEMA("schemas"),
        SECURITY_SCHEME("securitySchemes"),
        CALLBACK("callbacks"),
        LINK("links"),
        RESPONSE("responses"),
        PARAMETER("parameters"),
        EXAMPLE("examples"),
        REQUEST_BODY("requestBodies");

        String componentPath;

        private RefType(String componentPath) {
            this.componentPath = componentPath;
        }

        public static RefType fromComponentPath(String path) {
            for (RefType ref : RefType.values()) {
                if (!ref.componentPath.equals(path)) continue;
                return ref;
            }
            return null;
        }
    }
}

