/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.graphql.execution.error;

import java.util.Collections;
import java.util.List;
import java.util.Optional;

public class ExceptionLists {
    private final List<String> hideList;
    private final List<String> showList;

    public ExceptionLists(Optional<List<String>> maybeHideList, Optional<List<String>> maybeShowList) {
        this.hideList = maybeHideList.isPresent() ? maybeHideList.get() : Collections.EMPTY_LIST;
        this.showList = maybeShowList.isPresent() ? maybeShowList.get() : Collections.EMPTY_LIST;
    }

    boolean shouldHide(Throwable throwable) {
        return this.isListed(throwable, this.hideList);
    }

    boolean shouldShow(Throwable throwable) {
        return this.isListed(throwable, this.showList);
    }

    private boolean isListed(Throwable throwable, List<String> classNames) {
        if (classNames == null || classNames.isEmpty() || throwable == null) {
            return false;
        }
        return this.isListed(throwable.getClass(), classNames);
    }

    private boolean isListed(Class throwableClass, List<String> classNames) {
        if (classNames == null || classNames.isEmpty() || throwableClass == null || throwableClass.getName().equals(Object.class.getName())) {
            return false;
        }
        if (classNames.contains(throwableClass.getName())) {
            return true;
        }
        return this.isListed(throwableClass.getSuperclass(), classNames);
    }
}

