/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.ras.instrument.internal.bci;

import com.ibm.ws.ras.instrument.internal.bci.AbstractRasMethodAdapter;
import com.ibm.ws.ras.instrument.internal.bci.AbstractTracingRasClassAdapter;
import org.objectweb.asm.Label;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.Type;

public class JSR47TracingMethodAdapter
extends AbstractRasMethodAdapter<AbstractTracingRasClassAdapter> {
    public JSR47TracingMethodAdapter(AbstractTracingRasClassAdapter classAdapter, MethodVisitor visitor, int access, String methodName, String descriptor, String signature, String[] exceptions) {
        super(classAdapter, true, visitor, access, methodName, descriptor, signature, exceptions);
    }

    @Override
    public boolean onMethodEntry() {
        if (this.isTrivial() || this.isAlreadyTraced()) {
            return false;
        }
        if (this.isStaticInitializer()) {
            return false;
        }
        Label skipTraceLabel = new Label();
        this.visitInvokeTraceGuardMethod("isLoggable", "FINER", skipTraceLabel);
        this.visitGetTraceObjectField();
        this.visitLoadClassName();
        this.visitLoadMethodName();
        this.createTraceArrayForParameters();
        this.visitMethodInsn(182, "java/util/logging/Logger", "entering", "(Ljava/lang/String;Ljava/lang/String;[Ljava/lang/Object;)V", false);
        this.visitLabel(skipTraceLabel);
        return true;
    }

    @Override
    public boolean onMethodReturn() {
        if (this.isTrivial() || this.isAlreadyTraced()) {
            return false;
        }
        if (this.isStaticInitializer()) {
            return false;
        }
        Label skipTraceLabel = new Label();
        this.visitInvokeTraceGuardMethod("isLoggable", "FINER", skipTraceLabel);
        boolean traceValueOnStack = this.setupReturnObjectValueForExitTrace();
        if (traceValueOnStack) {
            this.visitGetTraceObjectField();
            this.visitInsn(95);
            this.visitLoadClassName();
            this.visitInsn(95);
            this.visitLoadMethodName();
            this.visitInsn(95);
            this.visitMethodInsn(182, "java/util/logging/Logger", "exiting", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/Object;)V", false);
        } else {
            this.visitGetTraceObjectField();
            this.visitLoadClassName();
            this.visitLoadMethodName();
            this.visitMethodInsn(182, "java/util/logging/Logger", "exiting", "(Ljava/lang/String;Ljava/lang/String;)V", false);
        }
        this.visitLabel(skipTraceLabel);
        return true;
    }

    @Override
    public boolean onThrowInstruction() {
        if (!((AbstractTracingRasClassAdapter)this.getClassAdapter()).isTraceExceptionOnThrow() || this.isAlreadyTraced()) {
            return false;
        }
        Label skipTraceLabel = new Label();
        this.visitInvokeTraceGuardMethod("isLoggable", "FINER", skipTraceLabel);
        this.visitInsn(89);
        this.visitGetTraceObjectField();
        this.visitInsn(95);
        this.visitLoadClassName();
        this.visitInsn(95);
        this.visitLoadMethodName();
        this.visitInsn(95);
        this.visitMethodInsn(182, "java/util/logging/Logger", "throwing", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/Throwable;)V", false);
        this.visitLabel(skipTraceLabel);
        return true;
    }

    @Override
    public boolean onExceptionHandlerEntry(Type exception, int var) {
        if (!((AbstractTracingRasClassAdapter)this.getClassAdapter()).isTraceExceptionOnHandling() || this.isAlreadyTraced()) {
            return false;
        }
        Label skipTraceLabel = new Label();
        this.visitInvokeTraceGuardMethod("isLoggable", "FINER", skipTraceLabel);
        if (var == -1) {
            this.visitInsn(89);
        } else {
            this.visitVarInsn(25, var);
        }
        this.visitGetTraceObjectField();
        this.visitInsn(95);
        this.visitGetLoggingLevel("FINER");
        this.visitInsn(95);
        this.visitLoadClassName();
        this.visitInsn(95);
        this.visitLoadMethodName();
        this.visitInsn(95);
        this.visitLdcInsn("HANDLING");
        this.visitInsn(95);
        this.visitMethodInsn(182, "java/util/logging/Logger", "logp", "(Ljava/util/logging/Level;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/Throwable;)V", false);
        this.visitLabel(skipTraceLabel);
        return true;
    }

    @Override
    public void initializeTraceObjectField() {
        if (!((AbstractTracingRasClassAdapter)this.getClassAdapter()).isTraceObjectFieldInitializationRequired() || this.isAlreadyTraced()) {
            return;
        }
        this.visitLoadClassName();
        this.visitMethodInsn(184, "java/util/logging/Logger", "getLogger", "(Ljava/lang/String;)Ljava/util/logging/Logger;", false);
        this.visitSetTraceObjectField();
    }

    private void visitGetLoggingLevel(String levelName) {
        this.visitFieldInsn(178, "java/util/logging/Level", levelName, "Ljava/util/logging/Level;");
    }

    private void visitInvokeTraceGuardMethod(String guardMethodName, String levelName, Label skipTraceLabel) {
        this.visitGetTraceObjectField();
        this.visitJumpInsn(198, skipTraceLabel);
        this.visitGetTraceObjectField();
        this.visitGetLoggingLevel(levelName);
        this.visitMethodInsn(182, "java/util/logging/Logger", "isLoggable", "(Ljava/util/logging/Level;)Z", false);
        this.visitJumpInsn(153, skipTraceLabel);
    }
}

