/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.reactive.streams.utils;

import io.reactivex.Flowable;
import io.reactivex.internal.subscriptions.EmptySubscription;
import io.smallrye.reactive.streams.utils.CancellationSubscriber;
import io.smallrye.reactive.streams.utils.CollectorSubscriber;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.stream.Collector;
import org.reactivestreams.Publisher;
import org.reactivestreams.Subscriber;

public final class FlowableCollector<T, A, R>
extends Flowable<R> {
    private final Publisher<T> source;
    private final Collector<T, A, R> collector;

    public FlowableCollector(Publisher<T> source, Collector<T, A, R> collector) {
        this.source = source;
        this.collector = collector;
    }

    protected void subscribeActual(Subscriber<? super R> s) {
        Function<A, R> finisher;
        BiConsumer<A, T> accumulator;
        A initialValue;
        try {
            initialValue = this.collector.supplier().get();
            accumulator = this.collector.accumulator();
            finisher = this.collector.finisher();
        }
        catch (Exception ex) {
            this.source.subscribe(new CancellationSubscriber());
            EmptySubscription.error((Throwable)ex, s);
            return;
        }
        this.source.subscribe(new CollectorSubscriber<T, A, R>(s, initialValue, accumulator, finisher));
    }
}

