/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.annocache.targets.internal;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.websphere.ras.annotation.Trivial;
import com.ibm.ws.annocache.targets.cache.internal.TargetCacheImpl_DataCon;
import com.ibm.ws.annocache.targets.cache.internal.TargetCacheImpl_DataMod;
import com.ibm.ws.annocache.targets.internal.AnnotationTargetsImpl_Targets;
import com.ibm.ws.annocache.targets.internal.TargetsScannerBaseImpl;
import com.ibm.ws.annocache.targets.internal.TargetsTableClassesMultiImpl;
import com.ibm.ws.annocache.targets.internal.TargetsTableContainersImpl;
import com.ibm.ws.annocache.targets.internal.TargetsTableImpl;
import com.ibm.ws.annocache.targets.internal.TargetsVisitorClassImpl;
import com.ibm.ws.annocache.util.internal.UtilImpl_IdentityStringSet;
import com.ibm.ws.annocache.util.internal.UtilImpl_InternMap;
import com.ibm.ws.annocache.util.internal.UtilImpl_PoolExecutor;
import com.ibm.ws.annocache.util.internal.UtilImpl_Utils;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.wsspi.annocache.classsource.ClassSource;
import com.ibm.wsspi.annocache.classsource.ClassSource_Aggregate;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;

@TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class TargetsScannerOverallImpl
extends TargetsScannerBaseImpl {
    public static final String CLASS_NAME;
    protected final Object internMapControl;
    protected final Object targetsControl;
    protected TargetCacheImpl_DataMod modData;
    protected TargetsTableContainersImpl containerTable;
    protected String changedContainerTableReason;
    protected boolean changedContainerTable;
    protected final Map<String, String> changedTargetsReasons;
    protected final Set<String> changedTargets;
    protected String changedAnyTargetsReason;
    protected boolean changedAnyTargets;
    protected String changedClassTableReason;
    protected boolean changedClassTable;
    protected Set<String> i_resolvedClassNames;
    protected Set<String> i_unresolvedClassNames;
    protected String changedClassNamesReason;
    protected boolean changedClassNames;
    private static final boolean HAVE_DIFFERENT_INTERN_MAPS = false;
    protected static final boolean DO_LOAD = true;
    static final long serialVersionUID = -5071306443164932271L;
    private static final /* synthetic */ TraceComponent $$$tc$$$;

    @Trivial
    private static String printString(Set<String> values) {
        if (values.isEmpty()) {
            return "{ }";
        }
        if (values.size() == 1) {
            Iterator<String> iterator = values.iterator();
            if (iterator.hasNext()) {
                String value = iterator.next();
                return "{ " + value + " }";
            }
            return null;
        }
        StringBuilder builder = new StringBuilder();
        builder.append("{ ");
        boolean first = true;
        int valueNo = 0;
        int valueLim = 10;
        for (String value : values) {
            if (!first) {
                builder.append(", ");
            } else {
                first = false;
            }
            if (valueNo == valueLim) {
                value = "...";
            }
            builder.append(value);
            if (valueNo == valueLim) break;
            ++valueNo;
        }
        builder.append(" }");
        return builder.toString();
    }

    @Trivial
    private String priorResult(String resultType, String resultReason, boolean result) {
        return MessageFormat.format("[ {0} ] ENTER / RETURN Valid (prior result) [ {1} ] [ {2} ]: {3}", this.getHashText(), resultType, result, resultReason);
    }

    @Trivial
    private String newResult(String resultType, String isValidReason, boolean isValid) {
        return MessageFormat.format("[ {0} ] RETURN Valid (new result) [ {1} ] [ {2} ]: {3}", this.getHashText(), resultType, isValid, isValidReason);
    }

    protected TargetsScannerOverallImpl(AnnotationTargetsImpl_Targets targets, ClassSource_Aggregate rootClassSource, TargetCacheImpl_DataMod modData) {
        super(targets, rootClassSource);
        String methodName = "<init>";
        this.internMapControl = new InternMapControl();
        this.targetsControl = new TargetsControl();
        this.modData = modData;
        this.containerTable = null;
        this.changedContainerTableReason = null;
        this.changedContainerTable = false;
        this.changedTargets = new HashSet<String>();
        this.changedTargetsReasons = new HashMap<String, String>();
        this.changedAnyTargetsReason = null;
        this.changedAnyTargets = false;
        this.changedClassTableReason = null;
        this.changedClassTable = false;
        this.i_resolvedClassNames = null;
        this.i_unresolvedClassNames = null;
        this.changedClassNamesReason = null;
        this.changedClassNames = false;
        if (logger.isLoggable(Level.FINER)) {
            logger.logp(Level.FINER, CLASS_NAME, methodName, "[ {0} ]", this.getHashText());
        }
    }

    @Trivial
    protected Object getInternMapControl() {
        return this.internMapControl;
    }

    @Trivial
    protected Object getTargetsControl() {
        return this.targetsControl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Trivial
    public TargetsTableImpl getTargetsTable(String classSourceName) {
        Object object = this.getTargetsControl();
        synchronized (object) {
            return super.getTargetsTable(classSourceName);
        }
    }

    public TargetsTableImpl createIsolatedTargetsTable(String classSourceName, String classSourceStamp) {
        TargetsTableImpl targetsTable = new TargetsTableImpl(this.getFactory(), classSourceName, this.getUseJandexFormat());
        targetsTable.setStamp(classSourceStamp);
        return targetsTable;
    }

    protected TargetsTableImpl createResultTargetsTable(ClassSource_Aggregate.ScanPolicy scanPolicy, TargetCacheImpl_DataCon conData) {
        if (this.isolateResultTargets(conData)) {
            TargetsTableImpl resultTable = new TargetsTableImpl(this.getFactory(), scanPolicy.name(), false);
            resultTable.setStamp("** UNRECORDED **");
            return resultTable;
        }
        return this.createResultTargetsTable(scanPolicy);
    }

    protected boolean isolateResultTargets(TargetCacheImpl_DataCon conData) {
        String isolateCase;
        boolean isolate;
        String methodName = "isolateResultTargets";
        if (!this.isScanSingleThreaded()) {
            isolate = true;
            isolateCase = "Isolated: Multi-threaded";
        } else {
            isolate = false;
            isolateCase = "Integrated: Single-threaded";
        }
        if (logger.isLoggable(Level.FINER)) {
            logger.logp(Level.FINER, CLASS_NAME, methodName, "[ {0} ] Result targets {1}", new Object[]{this.getHashText(), isolateCase});
        }
        return isolate;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected TargetsTableImpl internTargetsTable(TargetsTableImpl targetsTable) {
        Object object = this.getInternMapControl();
        synchronized (object) {
            targetsTable = new TargetsTableImpl(targetsTable, this.getClassNameInternMap(), this.getFieldNameInternMap(), this.getMethodSignatureInternMap());
        }
        if (logger.isLoggable(Level.FINER)) {
            this.verifyTargets(targetsTable);
        }
        return targetsTable;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected TargetsTableImpl internResultTargetsTable(TargetsTableImpl targetsTable, TargetCacheImpl_DataCon conData) {
        if (this.isolateResultTargets(conData)) {
            Object object = this.getInternMapControl();
            synchronized (object) {
                targetsTable = new TargetsTableImpl(targetsTable, this.getClassNameInternMap(), this.getFieldNameInternMap(), this.getMethodSignatureInternMap());
            }
        }
        if (logger.isLoggable(Level.FINER)) {
            this.verifyTargets(targetsTable);
        }
        return targetsTable;
    }

    private void verifyTargets(TargetsTableImpl targetsTable) {
        String methodName = "verifyTargets";
        if (logger.isLoggable(Level.FINER)) {
            logger.logp(Level.FINER, CLASS_NAME, methodName, "[ {0} ] ENTER", this.getHashText());
        }
        Set<String> i_packageNames = targetsTable.i_getPackageNames();
        this.verify("Package names", i_packageNames);
        Set<String> i_classNames = targetsTable.i_getClassNames();
        this.verify("Class names", i_classNames);
        Set<String> i_packageAnnotations = targetsTable.i_getPackageAnnotations().getHeldSet();
        this.verify("Package annotations", i_packageAnnotations);
        Set<String> i_classAnnotations = targetsTable.i_getClassAnnotations().getHeldSet();
        this.verify("Class annotations", i_classAnnotations);
        Set<String> i_fieldAnnotations = targetsTable.i_getFieldAnnotations().getHeldSet();
        this.verify("Field annotations", i_fieldAnnotations);
        Set<String> i_methodAnnotations = targetsTable.i_getMethodAnnotations().getHeldSet();
        this.verify("Method annotations", i_methodAnnotations);
        if (logger.isLoggable(Level.FINER)) {
            logger.logp(Level.FINER, CLASS_NAME, methodName, "[ {0} ] RETURN", this.getHashText());
        }
    }

    public ClassSource getExternalClassSource() {
        ClassSource_Aggregate useRootClassSource = this.getRootClassSource();
        for (ClassSource classSource : useRootClassSource.getClassSources()) {
            if (useRootClassSource.getScanPolicy(classSource) != ClassSource_Aggregate.ScanPolicy.EXTERNAL) continue;
            return classSource;
        }
        return null;
    }

    @Trivial
    public TargetCacheImpl_DataMod getModData() {
        return this.modData;
    }

    @Trivial
    public int getWriteLimit() {
        return this.getModData().getCacheOptions().getWriteLimit();
    }

    @Override
    public boolean getUseJandexFormat() {
        return this.getModData().getCacheOptions().getUseJandexFormat();
    }

    public long getCacheReadTime() {
        return this.getModData().getReadTime();
    }

    public long getCacheWriteTime() {
        return this.getModData().getWriteTime();
    }

    public long getContainerReadTime() {
        return this.getModData().getContainerReadTime();
    }

    public long getContainerWriteTime() {
        return this.getModData().getContainerWriteTime();
    }

    @Trivial
    public TargetsTableContainersImpl getContainerTable() {
        return this.containerTable;
    }

    @Trivial
    public String getChangedContainerReason() {
        return this.changedContainerTableReason;
    }

    @Trivial
    public boolean getChangedContainerTable() {
        return this.changedContainerTable;
    }

    protected void setContainerTable(TargetsTableContainersImpl containerTable, String reason, boolean isChanged) {
        this.containerTable = containerTable;
        this.changedContainerTableReason = reason;
        this.changedContainerTable = isChanged;
    }

    @Trivial
    protected Map<String, String> getChangedTargetsTableReasons() {
        return this.changedTargetsReasons;
    }

    @Trivial
    protected Set<String> getChangedTargetsTable() {
        return this.changedTargets;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setChangedTargetsTable(String classSourceName, String reason, boolean isChanged) {
        Object object = this.getTargetsControl();
        synchronized (object) {
            this.getChangedTargetsTableReasons().put(classSourceName, reason);
            if (isChanged) {
                this.getChangedTargetsTable().add(classSourceName);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getChangedTargetsTableReason(String classSourceName) {
        Object object = this.getTargetsControl();
        synchronized (object) {
            return this.getChangedTargetsTableReasons().get(classSourceName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isChangedTargetsTable(String classSourceName) {
        Object object = this.getTargetsControl();
        synchronized (object) {
            return this.getChangedTargetsTable().contains(classSourceName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void putTargetsTable(String classSourceName, TargetsTableImpl targetsTable, String reason, boolean isChanged) {
        Object object = this.getTargetsControl();
        synchronized (object) {
            this.putTargetsTable(classSourceName, targetsTable);
            this.setChangedTargetsTable(classSourceName, reason, isChanged);
        }
    }

    public String getChangedAnyTargetsReason() {
        return this.changedAnyTargetsReason;
    }

    public boolean isChangedAnyTargets() {
        return this.changedAnyTargets;
    }

    public String getChangedClassTableReason() {
        return this.changedClassTableReason;
    }

    public boolean isChangedClassTable() {
        return this.changedClassTable;
    }

    public void setClassTable(TargetsTableClassesMultiImpl classTable, String reason, boolean isChanged) {
        this.setClassTable(classTable);
        this.changedClassTableReason = reason;
        this.changedClassTable = isChanged;
    }

    @Trivial
    public Set<String> getResolvedClassNames() {
        return this.i_resolvedClassNames;
    }

    @Trivial
    public Set<String> getUnresolvedClassNames() {
        return this.i_unresolvedClassNames;
    }

    public String getChangedClassNamesReason() {
        return this.changedClassNamesReason;
    }

    public boolean isChangedClassNames() {
        return this.changedClassNames;
    }

    protected boolean validContainerTable() {
        TargetsTableContainersImpl useContainerTable;
        String isChangedReason;
        boolean isChanged;
        String methodName = "validContainerTable";
        if (this.containerTable != null) {
            if (logger.isLoggable(Level.FINER)) {
                String resultMsg = this.priorResult("container table", this.changedContainerTableReason, !this.changedContainerTable);
                logger.logp(Level.FINER, CLASS_NAME, methodName, resultMsg);
            }
            return !this.changedContainerTable;
        }
        if (logger.isLoggable(Level.FINER)) {
            logger.logp(Level.FINER, CLASS_NAME, methodName, "[ {0} ] ENTER", this.getHashText());
        }
        if (this.modData.getIsLightweight()) {
            isChanged = false;
            isChangedReason = "Lightweight";
            useContainerTable = this.createContainerTable(this.rootClassSource);
        } else if (!this.modData.shouldRead("Containers table") || !this.modData.hasContainersTable()) {
            isChanged = true;
            isChangedReason = "Cache miss";
            useContainerTable = this.createContainerTable(this.rootClassSource);
        } else {
            useContainerTable = this.createContainerTable();
            if (!this.modData.readContainerTable(useContainerTable)) {
                isChanged = true;
                isChangedReason = "Cache miss (read failure)";
                useContainerTable = this.createContainerTable(this.rootClassSource);
            } else if (this.modData.isAlwaysValid()) {
                isChanged = false;
                isChangedReason = "Cache hit (forced valid)";
            } else {
                TargetsTableContainersImpl newContainerTable = this.createContainerTable(this.rootClassSource);
                if (newContainerTable.sameAs(useContainerTable)) {
                    isChanged = false;
                    isChangedReason = "Cache hit (valid)";
                } else {
                    useContainerTable = newContainerTable;
                    isChanged = true;
                    isChangedReason = "Cache hit (invalid)";
                }
            }
        }
        if (isChanged && this.modData.shouldWrite("Containers table")) {
            this.modData.writeContainersTable(useContainerTable);
        }
        this.setContainerTable(useContainerTable, isChangedReason, isChanged);
        if (logger.isLoggable(Level.FINER)) {
            String resultMsg = this.newResult("container table", isChangedReason, !isChanged);
            logger.logp(Level.FINER, CLASS_NAME, methodName, resultMsg);
        }
        return !isChanged;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean validInternalContainer(ClassSource classSource, ClassSource_Aggregate.ScanPolicy scanPolicy) {
        TargetCacheImpl_DataCon conData;
        String methodName = "validInternalContainer";
        String useHash = logger.isLoggable(Level.FINER) ? this.getHashText() : null;
        boolean classSourceIsNamed = classSource.getName() != null;
        String classSourceName = classSource.getCanonicalName();
        TargetCacheImpl_DataCon targetCacheImpl_DataCon = conData = this.modData.getSourceConForcing(classSourceIsNamed, classSourceName);
        synchronized (targetCacheImpl_DataCon) {
            boolean isValid;
            TargetsTableImpl priorTargets;
            String isValidStampReason;
            TargetsTableImpl priorTargetsTable = this.getTargetsTable(classSourceName);
            if (priorTargetsTable != null) {
                boolean priorIsChanged = this.isChangedTargetsTable(classSourceName);
                if (useHash != null) {
                    String priorIsChangedReason = this.getChangedTargetsTableReason(classSourceName);
                    logger.logp(Level.FINER, CLASS_NAME, methodName, this.priorResult("Internal class source " + classSourceName, priorIsChangedReason, priorIsChanged));
                }
                return !priorIsChanged;
            }
            String currentStamp = classSource.getStamp();
            if (useHash != null) {
                logger.logp(Level.FINER, CLASS_NAME, methodName, "[ {0} ] ENTER [ {1} ] [ {2} ]", new Object[]{useHash, classSourceName, currentStamp});
            }
            if ((isValidStampReason = conData.isValid(this, classSourceName, currentStamp)) == null) {
                TargetsTableImpl conTable;
                if (useHash != null) {
                    logger.logp(Level.FINER, CLASS_NAME, methodName, this.newResult("Internal class source " + classSourceName, "Valid stamp", true));
                }
                if ((conTable = conData.getTargetsTable()) != null) {
                    conTable = this.internTargetsTable(conTable);
                }
                this.putTargetsTable(classSourceName, conTable, "Valid stamp", false);
                return true;
            }
            if (useHash != null) {
                logger.logp(Level.FINER, CLASS_NAME, methodName, "[ {0} ] [ {1} ]: Valid stamp [ false ]: {2}", new Object[]{useHash, classSourceName, isValidStampReason});
            }
            TargetsTableImpl newTargets = this.createIsolatedTargetsTable(classSourceName, currentStamp);
            this.scanInternal(classSource, TargetsVisitorClassImpl.DONT_RECORD_RESOLVED, TargetsVisitorClassImpl.DONT_RECORD_UNRESOLVED, newTargets);
            String isValidReason = !conData.hasCoreDataFile() ? "New data" : (!conData.readCoreData(priorTargets = this.createIsolatedTargetsTable(classSourceName, currentStamp)) ? "Read failure" : (!newTargets.getClassTable().sameAs(priorTargets.getClassTable(), false) ? "Change to classes" : (!newTargets.getAnnotationTable().sameAs(priorTargets.getAnnotationTable(), false) ? "Change to annotations" : null)));
            if (isValidReason == null) {
                isValidReason = "Only the stamp changed";
                isValid = true;
            } else {
                isValid = false;
            }
            if (useHash != null) {
                logger.logp(Level.FINER, CLASS_NAME, methodName, "[ {0} ] [ {1} ]: Is valid [ {2} ]: {3}", new Object[]{useHash, classSourceName, isValid, isValidReason});
            }
            conData.writeStamp(this.modData, newTargets);
            if (!isValid) {
                conData.writeData(this.modData, newTargets);
            }
            conData.setTargetsTable(newTargets);
            this.putTargetsTable(classSourceName, this.internTargetsTable(newTargets), isValidReason, !isValid);
            if (useHash != null) {
                logger.logp(Level.FINER, CLASS_NAME, methodName, this.newResult("Internal class source " + classSourceName, isValidReason, isValid));
            }
            return isValid;
        }
    }

    protected boolean validInternalContainers_Select() {
        String useHashText;
        String methodName = "validInternalContainers_Select";
        String string = useHashText = logger.isLoggable(Level.FINER) ? this.getHashText() : null;
        if (this.changedAnyTargetsReason != null) {
            if (useHashText != null) {
                logger.logp(Level.FINER, CLASS_NAME, methodName, "[ {0} ] ENTER / RETURN [ {1} ] {2}", new Object[]{useHashText, !this.changedAnyTargets, this.changedAnyTargetsReason});
            }
            return !this.changedAnyTargets;
        }
        if (useHashText != null) {
            logger.logp(Level.FINER, CLASS_NAME, methodName, "[ {0} ] ENTER", useHashText);
        }
        if (this.isScanSingleThreaded() || this.isScanSingleSource()) {
            if (useHashText != null) {
                logger.logp(Level.FINER, CLASS_NAME, methodName, "[ {0} ] Single-threaded scanning", useHashText);
            }
            this.validInternalContainers();
        } else {
            if (useHashText != null) {
                logger.logp(Level.FINER, CLASS_NAME, methodName, "[ {0} ] Multi-threaded scanning", useHashText);
            }
            this.validInternalContainers_Concurrent();
        }
        if (useHashText != null) {
            logger.logp(Level.FINER, CLASS_NAME, methodName, "[ {0} ] ENTER / RETURN [ {1} ] {2}", new Object[]{useHashText, !this.changedAnyTargets, this.changedAnyTargetsReason});
        }
        return !this.changedAnyTargets;
    }

    /*
     * WARNING - void declaration
     */
    @Trivial
    protected void validInternalContainers() {
        void var7_14;
        String useHashText;
        String methodName = "validInternalContainers";
        String string = useHashText = logger.isLoggable(Level.FINER) ? this.getHashText() : null;
        if (useHashText != null) {
            logger.logp(Level.FINER, CLASS_NAME, methodName, "[ {0} ] ENTER", useHashText);
        }
        boolean changedTable = !this.validContainerTable();
        int changedContainers = 0;
        int internalContainers = 0;
        for (ClassSource classSource : this.rootClassSource.getClassSources()) {
            ClassSource_Aggregate.ScanPolicy childScanPolicy = this.rootClassSource.getScanPolicy(classSource);
            if (childScanPolicy == ClassSource_Aggregate.ScanPolicy.EXTERNAL) continue;
            ++internalContainers;
            if (this.validInternalContainer(classSource, childScanPolicy)) continue;
            ++changedContainers;
        }
        boolean changed = false;
        Object var7_9 = null;
        if (changedTable) {
            changed = true;
            String string2 = "changed containers list";
        }
        if (changedContainers > 0) {
            changed = true;
            if (changedTable) {
                void var7_11;
                String string3 = (String)var7_11 + "; changed tables [ " + changedContainers + " ]";
            } else {
                String string4 = "changed tables [ " + changedContainers + " ]";
            }
        }
        this.changedAnyTargetsReason = var7_14;
        this.changedAnyTargets = changed;
        if (!this.changedAnyTargets) {
            if (useHashText != null) {
                logger.logp(Level.FINER, CLASS_NAME, methodName, "[ {0} ] RETURN [ {1} ] unchanged internal containers", new Object[]{useHashText, internalContainers});
            }
            return;
        }
        if (useHashText != null) {
            logger.logp(Level.FINER, CLASS_NAME, methodName, "[ {0} ] Changed [ {1} ] out of [ {2} ] internal containers: [ {3} ]", new Object[]{useHashText, changedContainers, internalContainers, this.changedAnyTargetsReason});
        }
        this.forceInternalContainers();
        if (useHashText != null) {
            logger.logp(Level.FINER, CLASS_NAME, methodName, "[ {0} ] RETURN Completed [ {1} ] of [ {2} ] internal containers", new Object[]{useHashText, changedContainers, internalContainers});
        }
    }

    protected void forceInternalContainers_Select() {
        int numMissingTables = 0;
        for (ClassSource classSource : this.rootClassSource.getClassSources()) {
            String classSourceName;
            ClassSource_Aggregate.ScanPolicy childScanPolicy = this.rootClassSource.getScanPolicy(classSource);
            if (childScanPolicy == ClassSource_Aggregate.ScanPolicy.EXTERNAL || this.getTargetsTable(classSourceName = classSource.getCanonicalName()) != null) continue;
            ++numMissingTables;
        }
        if (numMissingTables == 0) {
            return;
        }
        if (this.isScanSingleThreaded() || numMissingTables == 1) {
            this.forceInternalContainers();
        } else {
            this.forceInternalContainers_Concurrent();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Trivial
    protected void forceInternalContainers() {
        String useHashText;
        String methodName = "forceInternalContainers";
        String string = useHashText = logger.isLoggable(Level.FINER) ? this.getHashText() : null;
        if (useHashText != null) {
            logger.logp(Level.FINER, CLASS_NAME, methodName, "[ {0} ] ENTER", useHashText);
        }
        for (ClassSource classSource : this.rootClassSource.getClassSources()) {
            String dataReason;
            boolean didRead;
            TargetsTableImpl conTargets;
            TargetCacheImpl_DataCon conData;
            ClassSource_Aggregate.ScanPolicy childScanPolicy = this.rootClassSource.getScanPolicy(classSource);
            if (childScanPolicy == ClassSource_Aggregate.ScanPolicy.EXTERNAL) continue;
            boolean classSourceIsNamed = classSource.getName() != null;
            String classSourceName = classSource.getCanonicalName();
            String classSourceStamp = classSource.getStamp();
            TargetsTableImpl priorTargets = this.getTargetsTable(classSourceName);
            if (priorTargets != null) continue;
            TargetCacheImpl_DataCon targetCacheImpl_DataCon = conData = this.modData.getSourceConForcing(classSourceIsNamed, classSourceName);
            synchronized (targetCacheImpl_DataCon) {
                if (conData.getHasStampFile() && conData.hasCoreDataFile()) {
                    conTargets = this.createIsolatedTargetsTable(classSourceName, classSourceStamp);
                    if (!conData.readStamp(conTargets.getStampTable()) || !conData.readCoreData(conTargets)) {
                        conTargets = null;
                        didRead = false;
                    } else {
                        didRead = true;
                    }
                } else {
                    conTargets = null;
                    didRead = false;
                }
                if (didRead) {
                    dataReason = "Cache read";
                } else {
                    conTargets = this.createIsolatedTargetsTable(classSourceName, classSourceStamp);
                    this.scanInternal(classSource, TargetsVisitorClassImpl.DONT_RECORD_RESOLVED, TargetsVisitorClassImpl.DONT_RECORD_UNRESOLVED, conTargets);
                    conData.writeStamp(this.modData, conTargets);
                    conData.writeData(this.modData, conTargets);
                    dataReason = "New scan";
                }
                conData.setTargetsTable(conTargets);
            }
            this.putTargetsTable(classSourceName, this.internTargetsTable(conTargets), dataReason, !didRead);
        }
        if (useHashText != null) {
            logger.logp(Level.FINER, CLASS_NAME, methodName, "[ {0} ] RETURN", useHashText);
        }
    }

    protected UtilImpl_PoolExecutor createSourceExecutor() {
        List<? extends ClassSource> childSources = this.rootClassSource.getClassSources();
        int numChildSources = childSources.size();
        int scanThreads = this.getScanThreads();
        if (scanThreads <= -1) {
            scanThreads = 64;
        }
        if (scanThreads > numChildSources) {
            scanThreads = numChildSources;
        }
        if (scanThreads > 64) {
            scanThreads = 64;
        }
        int corePoolSize = scanThreads;
        int maxPoolSize = scanThreads;
        return UtilImpl_PoolExecutor.createBlockingExecutor(corePoolSize, maxPoolSize, numChildSources);
    }

    /*
     * WARNING - void declaration
     */
    protected void forceInternalContainers_Concurrent() {
        String useHashText;
        String methodName = "forceInternalContainers_Concurrent";
        String string = useHashText = logger.isLoggable(Level.FINER) ? this.getHashText() : null;
        if (useHashText != null) {
            logger.logp(Level.FINER, CLASS_NAME, methodName, "[ {0} ] ENTER", useHashText);
        }
        List<? extends ClassSource> childClassSources = this.rootClassSource.getClassSources();
        int numChildSources = childClassSources.size();
        final UtilImpl_PoolExecutor readPool = this.createSourceExecutor();
        for (int sourceNo = 0; sourceNo < numChildSources; ++sourceNo) {
            final ClassSource childClassSource = childClassSources.get(sourceNo);
            ClassSource_Aggregate.ScanPolicy childScanPolicy = this.rootClassSource.getScanPolicy(childClassSource);
            if (childScanPolicy == ClassSource_Aggregate.ScanPolicy.EXTERNAL) {
                readPool.completeExecution();
                continue;
            }
            final boolean classSourceIsNamed = childClassSource.getName() != null;
            final String classSourceName = childClassSource.getCanonicalName();
            final String classSourceStamp = childClassSource.getStamp();
            TargetsTableImpl priorTargets = this.getTargetsTable(classSourceName);
            if (priorTargets != null) {
                readPool.completeExecution();
                continue;
            }
            Runnable validator = new Runnable(){
                static final long serialVersionUID = 7507853906857420608L;
                private static final /* synthetic */ TraceComponent $$$tc$$$;

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    try {
                        String dataReason;
                        boolean didRead;
                        TargetsTableImpl conTargets;
                        TargetCacheImpl_DataCon conData;
                        TargetCacheImpl_DataCon targetCacheImpl_DataCon = conData = TargetsScannerOverallImpl.this.modData.getSourceConForcing(classSourceIsNamed, classSourceName);
                        synchronized (targetCacheImpl_DataCon) {
                            if (conData.getHasStampFile() && conData.hasCoreDataFile()) {
                                conTargets = TargetsScannerOverallImpl.this.createIsolatedTargetsTable(classSourceName, classSourceStamp);
                                if (!conData.readStamp(conTargets.getStampTable()) || !conData.readCoreData(conTargets)) {
                                    conTargets = null;
                                    didRead = false;
                                } else {
                                    didRead = true;
                                }
                            } else {
                                conTargets = null;
                                didRead = false;
                            }
                            if (didRead) {
                                dataReason = "Cache read";
                            } else {
                                conTargets = TargetsScannerOverallImpl.this.createIsolatedTargetsTable(classSourceName, classSourceStamp);
                                TargetsScannerOverallImpl.this.scanInternal(childClassSource, TargetsVisitorClassImpl.DONT_RECORD_RESOLVED, TargetsVisitorClassImpl.DONT_RECORD_UNRESOLVED, conTargets);
                                conData.writeStamp(TargetsScannerOverallImpl.this.modData, conTargets);
                                conData.writeData(TargetsScannerOverallImpl.this.modData, conTargets);
                                dataReason = "New scan";
                            }
                            conData.setTargetsTable(conTargets);
                        }
                        TargetsScannerOverallImpl.this.putTargetsTable(classSourceName, TargetsScannerOverallImpl.this.internTargetsTable(conTargets), dataReason, !didRead);
                    }
                    finally {
                        readPool.completeExecution();
                    }
                }

                @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
                static {
                    $$$tc$$$ = Tr.register((String)"com.ibm.ws.annocache.targets.internal.TargetsScannerOverallImpl$1", 1.class, (String)"com.ibm.ws.annocache", (String)"com.ibm.ws.anno.resources.internal.AnnoMessages");
                }
            };
            readPool.execute(validator);
        }
        try {
            readPool.waitForCompletion();
        }
        catch (InterruptedException sourceNo) {
            void e;
            FFDCFilter.processException((Throwable)sourceNo, (String)"com.ibm.ws.annocache.targets.internal.TargetsScannerOverallImpl", (String)"1324", (Object)this, (Object[])new Object[0]);
            logger.logp(Level.WARNING, CLASS_NAME, methodName, "[ {0} ] ANNO_TARGETS_CACHE_EXCEPTION [ {1} ]", new Object[]{this.getHashText(), e});
            logger.logp(Level.WARNING, CLASS_NAME, methodName, "Cache error", (Throwable)e);
        }
        if (useHashText != null) {
            logger.logp(Level.FINER, CLASS_NAME, methodName, "[ {0} ] RETURN", useHashText);
        }
    }

    /*
     * WARNING - void declaration
     */
    protected void validInternalContainers_Concurrent() {
        String useHashText;
        String methodName = "validInternalContainers_Concurrent";
        String string = useHashText = logger.isLoggable(Level.FINER) ? this.getHashText() : null;
        if (useHashText != null) {
            logger.logp(Level.FINER, CLASS_NAME, methodName, "[ {0} ] ENTER", useHashText);
        }
        boolean changedTable = !this.validContainerTable();
        List<? extends ClassSource> childClassSources = this.rootClassSource.getClassSources();
        int numChildSources = childClassSources.size();
        final boolean[] validContainers = new boolean[numChildSources];
        final UtilImpl_PoolExecutor validatorPool = this.createSourceExecutor();
        int internalContainers = 0;
        for (int sourceNo = 0; sourceNo < numChildSources; ++sourceNo) {
            final ClassSource childClassSource = childClassSources.get(sourceNo);
            final ClassSource_Aggregate.ScanPolicy childScanPolicy = this.rootClassSource.getScanPolicy(childClassSource);
            if (childScanPolicy == ClassSource_Aggregate.ScanPolicy.EXTERNAL) {
                validContainers[sourceNo] = true;
                validatorPool.completeExecution();
                continue;
            }
            ++internalContainers;
            final int useSourceNo = sourceNo;
            Runnable validator = new Runnable(){
                static final long serialVersionUID = -1420874323341084455L;
                private static final /* synthetic */ TraceComponent $$$tc$$$;

                @Override
                public void run() {
                    try {
                        validContainers[useSourceNo] = TargetsScannerOverallImpl.this.validInternalContainer(childClassSource, childScanPolicy);
                    }
                    finally {
                        validatorPool.completeExecution();
                    }
                }

                @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
                static {
                    $$$tc$$$ = Tr.register((String)"com.ibm.ws.annocache.targets.internal.TargetsScannerOverallImpl$2", 2.class, (String)"com.ibm.ws.annocache", (String)"com.ibm.ws.anno.resources.internal.AnnoMessages");
                }
            };
            validatorPool.execute(validator);
        }
        try {
            validatorPool.waitForCompletion();
        }
        catch (InterruptedException sourceNo) {
            void e;
            FFDCFilter.processException((Throwable)sourceNo, (String)"com.ibm.ws.annocache.targets.internal.TargetsScannerOverallImpl", (String)"1400", (Object)this, (Object[])new Object[0]);
            logger.logp(Level.WARNING, CLASS_NAME, methodName, "[ {0} ] ANNO_TARGETS_CACHE_EXCEPTION [ {1} ]", new Object[]{this.getHashText(), e});
            logger.logp(Level.WARNING, CLASS_NAME, methodName, "Cache error", (Throwable)e);
        }
        int changedContainers = 0;
        for (Object validContainer : (ClassSource)validContainers) {
            if (validContainer != false) continue;
            ++changedContainers;
        }
        boolean changed = false;
        String changedReason = null;
        if (changedTable) {
            changed = true;
            changedReason = "changed containers list";
        }
        if (changedContainers > 0) {
            changed = true;
            changedReason = changedTable ? changedReason + "; changed tables [ " + Integer.valueOf(changedContainers) + " ]" : changedReason + "Changed tables [ " + Integer.valueOf(changedContainers) + " ]";
        }
        this.changedAnyTargetsReason = changedReason;
        this.changedAnyTargets = changed;
        if (!this.changedAnyTargets) {
            if (useHashText != null) {
                logger.logp(Level.FINER, CLASS_NAME, methodName, "[ {0} ] RETURN [ {1} ] unchanged internal containers", new Object[]{useHashText, internalContainers});
            }
            return;
        }
        if (useHashText != null) {
            logger.logp(Level.FINER, CLASS_NAME, methodName, "[ {0} ] Changed [ {1} ] out of [ {2} ] internal containers", new Object[]{useHashText, changedContainers, internalContainers});
        }
        final UtilImpl_PoolExecutor completionPool = this.createSourceExecutor();
        for (final ClassSource classSource : this.rootClassSource.getClassSources()) {
            ClassSource_Aggregate.ScanPolicy childScanPolicy = this.rootClassSource.getScanPolicy(classSource);
            if (childScanPolicy == ClassSource_Aggregate.ScanPolicy.EXTERNAL) {
                completionPool.completeExecution();
                continue;
            }
            final boolean classSourceIsNamed = classSource.getName() != null;
            final String classSourceName = classSource.getCanonicalName();
            TargetsTableImpl alreadyRefreshedTargets = this.getTargetsTable(classSourceName);
            if (alreadyRefreshedTargets != null) {
                completionPool.completeExecution();
                continue;
            }
            Runnable validator = new Runnable(){
                static final long serialVersionUID = 3958184905239873212L;
                private static final /* synthetic */ TraceComponent $$$tc$$$;

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    try {
                        TargetCacheImpl_DataCon conData;
                        String classSourceStamp = classSource.getStamp();
                        TargetsTableImpl newTargets = TargetsScannerOverallImpl.this.createIsolatedTargetsTable(classSourceName, classSourceStamp);
                        TargetsScannerOverallImpl.this.scanInternal(classSource, TargetsVisitorClassImpl.DONT_RECORD_RESOLVED, TargetsVisitorClassImpl.DONT_RECORD_UNRESOLVED, newTargets);
                        TargetCacheImpl_DataCon targetCacheImpl_DataCon = conData = TargetsScannerOverallImpl.this.modData.getSourceConForcing(classSourceIsNamed, classSourceName);
                        synchronized (targetCacheImpl_DataCon) {
                            conData.writeStamp(TargetsScannerOverallImpl.this.modData, newTargets);
                            conData.writeData(TargetsScannerOverallImpl.this.modData, newTargets);
                            conData.setTargetsTable(newTargets);
                        }
                        TargetsScannerOverallImpl.this.putTargetsTable(classSourceName, TargetsScannerOverallImpl.this.internTargetsTable(newTargets), "New data", false);
                    }
                    finally {
                        completionPool.completeExecution();
                    }
                }

                @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
                static {
                    $$$tc$$$ = Tr.register((String)"com.ibm.ws.annocache.targets.internal.TargetsScannerOverallImpl$3", 3.class, (String)"com.ibm.ws.annocache", (String)"com.ibm.ws.anno.resources.internal.AnnoMessages");
                }
            };
            completionPool.execute(validator);
        }
        try {
            completionPool.waitForCompletion();
        }
        catch (InterruptedException validContainer) {
            void e;
            FFDCFilter.processException((Throwable)validContainer, (String)"com.ibm.ws.annocache.targets.internal.TargetsScannerOverallImpl", (String)"1511", (Object)this, (Object[])new Object[0]);
            logger.logp(Level.WARNING, CLASS_NAME, methodName, "[ {0} ] ANNO_TARGETS_CACHE_EXCEPTION [ {1} ]", new Object[]{this.getHashText(), e});
            logger.logp(Level.WARNING, CLASS_NAME, methodName, "Cache error", (Throwable)e);
        }
        if (useHashText != null) {
            logger.logp(Level.FINER, CLASS_NAME, methodName, "[ {0} ] RETURN Completed [ {1} ] of [ {2} ] internal containers", new Object[]{useHashText, changedContainers, internalContainers});
        }
    }

    protected void validInternalUnresolved() {
        String validReason;
        boolean didRead;
        boolean didValidate;
        boolean doRead;
        String methodName = "validInternalUnresolved";
        if (this.i_resolvedClassNames != null) {
            if (logger.isLoggable(Level.FINER)) {
                logger.logp(Level.FINER, CLASS_NAME, methodName, this.priorResult("Unresolved classes", this.changedClassNamesReason, !this.changedClassNames));
            }
            return;
        }
        if (logger.isLoggable(Level.FINER)) {
            logger.logp(Level.FINER, CLASS_NAME, methodName, "[ {0} ] ENTER", this.getHashText());
        }
        if (this.modData.isAlwaysValid()) {
            doRead = true;
            didValidate = false;
        } else {
            doRead = this.validInternalContainers_Select();
            didValidate = true;
        }
        if (!doRead) {
            didRead = false;
            validReason = "Changed container data";
        } else if (!this.modData.shouldRead("Unresolved class data")) {
            didRead = false;
            validReason = "Cache miss (read disabled)";
        } else if (!this.modData.hasResolvedRefs()) {
            didRead = false;
            validReason = "Cache miss (resolved)";
        } else if (!this.modData.hasUnresolvedRefs()) {
            didRead = false;
            validReason = "Cache miss (unresolved)";
        } else {
            UtilImpl_IdentityStringSet i_cachedResolved = null;
            UtilImpl_IdentityStringSet i_cachedUnresolved = null;
            i_cachedResolved = this.createIdentityStringSet();
            if (!this.modData.readResolvedRefs(this.getClassNameInternMap(), i_cachedResolved)) {
                didRead = false;
                validReason = "Cache miss (failed to read resolved)";
            } else {
                i_cachedUnresolved = this.createIdentityStringSet();
                if (!this.modData.readUnresolvedRefs(this.getClassNameInternMap(), i_cachedUnresolved)) {
                    didRead = false;
                    validReason = "Cache miss (failed to read unresolved)";
                } else {
                    didRead = true;
                    validReason = "Cache hit";
                }
            }
            if (didRead) {
                this.i_resolvedClassNames = i_cachedResolved;
                this.i_unresolvedClassNames = i_cachedUnresolved;
                this.changedClassNames = false;
                this.changedClassNamesReason = validReason;
            }
        }
        if (logger.isLoggable(Level.FINER)) {
            logger.logp(Level.FINER, CLASS_NAME, methodName, "[ {0} ] Read [ {1} ] ({2})", new Object[]{this.getHashText(), didRead, validReason});
        }
        if (!didRead) {
            if (!didValidate) {
                boolean i_cachedResolved = this.validInternalContainers_Select();
            }
            this.forceInternalContainers_Select();
            UtilImpl_IdentityStringSet i_newResolved = this.createIdentityStringSet();
            UtilImpl_IdentityStringSet i_newUnresolved = this.createIdentityStringSet();
            for (ClassSource classSource : this.rootClassSource.getClassSources()) {
                if (this.rootClassSource.getScanPolicy(classSource) == ClassSource_Aggregate.ScanPolicy.EXTERNAL) continue;
                this.getTargetsTable(classSource).updateClassNames(i_newResolved, i_newUnresolved);
                if (!logger.isLoggable(Level.FINER)) continue;
                logger.logp(Level.FINER, CLASS_NAME, methodName, "[ {0} ] Class source [ {1} ] Resolved [ {2} ]", new Object[]{this.getHashText(), classSource.getCanonicalName(), TargetsScannerOverallImpl.printString(i_newResolved)});
                logger.logp(Level.FINER, CLASS_NAME, methodName, "[ {0} ] Class source [ {1} ] Unresolved [ {2} ]", new Object[]{this.getHashText(), classSource.getCanonicalName(), TargetsScannerOverallImpl.printString(i_newUnresolved)});
            }
            this.i_resolvedClassNames = i_newResolved;
            this.i_unresolvedClassNames = i_newUnresolved;
            this.changedClassNames = true;
            this.changedClassNamesReason = validReason;
            if (logger.isLoggable(Level.FINER)) {
                logger.logp(Level.FINER, CLASS_NAME, methodName, "[ {0} ] Recomposed", this.getHashText());
            }
            if (this.modData.shouldWrite("Resolved refs")) {
                this.modData.writeResolvedRefs(this.i_resolvedClassNames);
            }
            if (this.modData.shouldWrite("Unresolved refs")) {
                this.modData.writeUnresolvedRefs(this.i_unresolvedClassNames);
            }
            if (logger.isLoggable(Level.FINER)) {
                logger.logp(Level.FINER, CLASS_NAME, methodName, "[ {0} ] Written", this.getHashText());
            }
        }
        if (logger.isLoggable(Level.FINER)) {
            logger.logp(Level.FINER, CLASS_NAME, methodName, this.newResult("Unresolved classes", validReason, didRead));
            this.verifyUnresolved();
        }
    }

    @Trivial
    private void verify(String description, Set<String> i_values) {
        String methodName = "verify";
        logger.logp(Level.FINER, CLASS_NAME, methodName, "{0} count [ {1} ]", new Object[]{description, Integer.toString(i_values.size())});
        for (String i_value : i_values) {
            if (this.internClassName(i_value, false) == null) {
                logger.logp(Level.FINER, CLASS_NAME, methodName, "[ {0} ] is not interned", i_value);
                continue;
            }
            logger.logp(Level.FINER, CLASS_NAME, methodName, "[ {0} ] is interned", i_value);
        }
    }

    private void verifyUnresolved() {
        String methodName = "verifyUnresolved";
        if (logger.isLoggable(Level.FINER)) {
            logger.logp(Level.FINER, CLASS_NAME, methodName, "[ {0} ] ENTER", this.getHashText());
        }
        this.verify("Resolved class names", this.i_resolvedClassNames);
        this.verify("Unresolved class names", this.i_unresolvedClassNames);
        if (logger.isLoggable(Level.FINER)) {
            logger.logp(Level.FINER, CLASS_NAME, methodName, "[ {0} ] RETURN", this.getHashText());
        }
    }

    protected void validInternalResults() {
        String validReason;
        boolean didRead;
        boolean didValidate;
        boolean doRead;
        String methodName = "validInternalResults";
        if (logger.isLoggable(Level.FINER)) {
            logger.logp(Level.FINER, CLASS_NAME, methodName, "[ {0} ] ENTER", this.getHashText());
        }
        if (this.modData.isAlwaysValid()) {
            doRead = true;
            didValidate = false;
        } else {
            doRead = this.validInternalContainers_Select();
            didValidate = true;
        }
        if (logger.isLoggable(Level.FINER)) {
            logger.logp(Level.FINER, CLASS_NAME, methodName, "[ {0} ] Do read [ {1} ] Validate [ {2} ]", new Object[]{this.getHashText(), doRead, didValidate});
        }
        TargetsTableImpl[] cachedTables = this.createResultTables();
        if (!doRead) {
            didRead = false;
            validReason = "Changed container data";
        } else {
            didRead = this.readInternalResults_Select(cachedTables);
            validReason = didRead ? "Cache hit" : "Cache miss or read failure";
            if (logger.isLoggable(Level.FINER)) {
                logger.logp(Level.FINER, CLASS_NAME, methodName, "[ {0} ] Did read [ {1} ]", new Object[]{this.getHashText(), doRead});
            }
        }
        if (!didRead) {
            if (!didValidate) {
                boolean bl = this.validInternalContainers_Select();
            }
            this.forceInternalContainers_Select();
            TargetsTableImpl[] newTables = this.createResultTables();
            this.mergeInternalResults(newTables, !this.FORCE_SEED_RESULTS);
            ClassSource_Aggregate.ScanPolicy[] scanPolicyArray = ClassSource_Aggregate.ScanPolicy.values();
            int n = scanPolicyArray.length;
            for (int i = 0; i < n; ++i) {
                ClassSource_Aggregate.ScanPolicy scanPolicy = scanPolicyArray[i];
                if (this.getPolicyCount(scanPolicy) == 0) {
                    if (!logger.isLoggable(Level.FINER)) continue;
                    logger.logp(Level.FINER, CLASS_NAME, methodName, "Skip write of result [ " + (Object)((Object)scanPolicy) + " ]: No sources use that policy.");
                    continue;
                }
                if (scanPolicy == ClassSource_Aggregate.ScanPolicy.EXTERNAL || !this.modData.shouldWrite("Result container")) continue;
                this.modData.writeResultCon(scanPolicy, newTables[scanPolicy.ordinal()]);
            }
            cachedTables = newTables;
        }
        this.putResultTables(cachedTables);
        if (logger.isLoggable(Level.FINER)) {
            for (ClassSource_Aggregate.ScanPolicy scanPolicy : ClassSource_Aggregate.ScanPolicy.values()) {
                TargetsTableImpl resultTable;
                if (scanPolicy == ClassSource_Aggregate.ScanPolicy.EXTERNAL || (resultTable = cachedTables[scanPolicy.ordinal()]) == null) continue;
                logger.logp(Level.FINER, CLASS_NAME, methodName, "[ {0} ] Result [ {1} ]", new Object[]{this.getHashText(), scanPolicy});
                this.verifyTargets(resultTable);
            }
        }
        if (logger.isLoggable(Level.FINER)) {
            logger.logp(Level.FINER, CLASS_NAME, methodName, this.newResult("Internal results", validReason, didRead));
        }
    }

    protected boolean readInternalResults_Select(TargetsTableImpl[] tables) {
        if (this.isScanSingleThreaded() || this.isScanSingleSource()) {
            return this.readInternalResults(tables);
        }
        return this.readInternalResults_Concurrent(tables);
    }

    protected boolean readInternalResults(TargetsTableImpl[] tables) {
        boolean isAnyMissing = false;
        for (ClassSource_Aggregate.ScanPolicy scanPolicy : ClassSource_Aggregate.ScanPolicy.values()) {
            if (scanPolicy == ClassSource_Aggregate.ScanPolicy.EXTERNAL) continue;
            if (this.getPolicyCount(scanPolicy) == 0) {
                tables[scanPolicy.ordinal()] = this.createResultTargetsTable(scanPolicy);
                continue;
            }
            if (this.readResults(scanPolicy, tables) != null) continue;
            isAnyMissing = true;
        }
        return !isAnyMissing;
    }

    /*
     * WARNING - void declaration
     */
    protected boolean readInternalResults_Concurrent(final TargetsTableImpl[] tables) {
        String methodName = "readInternalResults";
        final boolean[] missingResults = new boolean[ClassSource_Aggregate.ScanPolicy.values().length];
        Thread[] readThreads = new Thread[ClassSource_Aggregate.ScanPolicy.values().length];
        for (ClassSource_Aggregate.ScanPolicy scanPolicy : ClassSource_Aggregate.ScanPolicy.values()) {
            if (scanPolicy == ClassSource_Aggregate.ScanPolicy.EXTERNAL) continue;
            if (this.getPolicyCount(scanPolicy) == 0) {
                tables[scanPolicy.ordinal()] = this.createResultTargetsTable(scanPolicy);
                continue;
            }
            final ClassSource_Aggregate.ScanPolicy useScanPolicy = scanPolicy;
            Runnable readRunner = new Runnable(){
                static final long serialVersionUID = -4722974397635194527L;
                private static final /* synthetic */ TraceComponent $$$tc$$$;

                @Override
                public void run() {
                    if (TargetsScannerOverallImpl.this.readResults(useScanPolicy, tables) == null) {
                        missingResults[useScanPolicy.ordinal()] = true;
                    }
                }

                @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
                static {
                    $$$tc$$$ = Tr.register((String)"com.ibm.ws.annocache.targets.internal.TargetsScannerOverallImpl$4", 4.class, (String)"com.ibm.ws.annocache", (String)"com.ibm.ws.anno.resources.internal.AnnoMessages");
                }
            };
            Thread readThread = UtilImpl_Utils.createThread(readRunner, "annotation reader : " + scanPolicy.name());
            readThread.start();
            readThreads[scanPolicy.ordinal()] = readThread;
        }
        for (ClassSource_Aggregate.ScanPolicy scanPolicy : ClassSource_Aggregate.ScanPolicy.values()) {
            if (scanPolicy == ClassSource_Aggregate.ScanPolicy.EXTERNAL || this.getPolicyCount(scanPolicy) == 0) continue;
            try {
                readThreads[scanPolicy.ordinal()].join();
            }
            catch (InterruptedException useScanPolicy) {
                void e;
                FFDCFilter.processException((Throwable)useScanPolicy, (String)"com.ibm.ws.annocache.targets.internal.TargetsScannerOverallImpl", (String)"1940", (Object)this, (Object[])new Object[]{tables});
                logger.logp(Level.WARNING, CLASS_NAME, methodName, "[ {0} ] ANNO_TARGETS_CACHE_EXCEPTION [ {1} ]", new Object[]{this.getHashText(), e});
                logger.logp(Level.WARNING, CLASS_NAME, methodName, "Cache error", (Throwable)e);
                missingResults[scanPolicy.ordinal()] = true;
            }
        }
        for (ClassSource_Aggregate.ScanPolicy scanPolicy : ClassSource_Aggregate.ScanPolicy.values()) {
            if (scanPolicy == ClassSource_Aggregate.ScanPolicy.EXTERNAL || !missingResults[scanPolicy.ordinal()]) continue;
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected TargetsTableImpl readResults(ClassSource_Aggregate.ScanPolicy scanPolicy, TargetsTableImpl[] tables) {
        TargetsTableImpl cachedResultData;
        TargetCacheImpl_DataCon resultCon;
        if (!this.modData.shouldRead("Result container")) {
            return null;
        }
        TargetCacheImpl_DataCon targetCacheImpl_DataCon = resultCon = this.modData.getResultCon(scanPolicy);
        synchronized (targetCacheImpl_DataCon) {
            if (!resultCon.hasCoreDataFile()) {
                return null;
            }
            cachedResultData = this.createResultTargetsTable(scanPolicy, resultCon);
            if (!resultCon.readCoreData(cachedResultData)) {
                return null;
            }
        }
        cachedResultData = this.internResultTargetsTable(cachedResultData, resultCon);
        if (tables != null) {
            tables[scanPolicy.ordinal()] = cachedResultData;
        }
        return cachedResultData;
    }

    protected boolean validInternalClasses() {
        String reason;
        boolean isChanged;
        TargetsTableClassesMultiImpl cachedClassTable;
        boolean didValidate;
        boolean doRead;
        String methodName = "validInternalClasses";
        if (logger.isLoggable(Level.FINER)) {
            logger.logp(Level.FINER, CLASS_NAME, methodName, "[ {0} ] ENTER", this.getHashText());
        }
        if (this.modData.isAlwaysValid()) {
            doRead = true;
            didValidate = false;
        } else {
            doRead = this.validInternalContainers_Select();
            didValidate = true;
        }
        if (!doRead) {
            cachedClassTable = null;
            isChanged = true;
            reason = "Changed data";
        } else if (!this.modData.shouldRead("Class refs") || !this.modData.hasClasses()) {
            cachedClassTable = null;
            isChanged = true;
            reason = "Absent class refs";
        } else {
            cachedClassTable = this.createClassTable();
            if (!this.modData.readClasses(cachedClassTable)) {
                cachedClassTable = null;
                isChanged = true;
                reason = "Class refs read failure";
            } else {
                isChanged = false;
                reason = "Cached";
            }
        }
        if (cachedClassTable == null) {
            if (!didValidate) {
                boolean bl = this.validInternalContainers_Select();
            }
            this.forceInternalContainers_Select();
            cachedClassTable = this.createClassTable();
            this.mergeClasses(cachedClassTable);
            if (this.modData.shouldWrite("Class refs")) {
                this.modData.writeClasses(cachedClassTable);
            }
        }
        this.classTable = cachedClassTable;
        this.setClassTable(this.classTable, reason, isChanged);
        if (logger.isLoggable(Level.FINER)) {
            logger.logp(Level.FINER, CLASS_NAME, methodName, this.newResult("Internal results", reason, !isChanged));
        }
        return !isChanged;
    }

    protected void validInternal() {
        this.validInternalUnresolved();
        this.validInternalResults();
        this.validInternalClasses();
        this.displayCoverage();
        if (logger.isLoggable(Level.FINER)) {
            this.logInternalResults(logger);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void validExternal() {
        TargetsTableClassesMultiImpl useClassTable;
        String methodName = "validExternal";
        ClassSource externalClassSource = this.getExternalClassSource();
        if (externalClassSource == null) {
            throw new IllegalStateException("An external class source is required");
        }
        String classSourceName = externalClassSource.getCanonicalName();
        TargetsTableImpl externalData = this.getTargetsTable(classSourceName);
        if (externalData != null) {
            String isChangedReason = this.getChangedTargetsTableReason(classSourceName);
            boolean isChanged = this.isChangedTargetsTable(classSourceName);
            if (logger.isLoggable(Level.FINER)) {
                logger.logp(Level.FINER, CLASS_NAME, methodName, this.priorResult("External source " + classSourceName, isChangedReason, isChanged));
            }
            return;
        }
        if (logger.isLoggable(Level.FINER)) {
            logger.logp(Level.FINER, CLASS_NAME, methodName, "ENTER: External source [ {0} ]", classSourceName);
        }
        boolean isChanged = true;
        String isChangedReason = "Always invalid";
        this.validInternalUnresolved();
        externalData = this.scanExternal(externalClassSource, this.i_resolvedClassNames, this.i_unresolvedClassNames);
        TargetsTableClassesMultiImpl targetsTableClassesMultiImpl = useClassTable = this.getClassTable();
        synchronized (targetsTableClassesMultiImpl) {
            this.mergeClasses(useClassTable, externalData);
        }
        this.putTargetsTable(classSourceName, externalData, isChangedReason, isChanged);
        this.putExternalResults(externalData);
        if (logger.isLoggable(Level.FINER)) {
            this.logClassInfo(logger);
            this.logExternalResults(logger);
        }
        if (logger.isLoggable(Level.FINER)) {
            logger.logp(Level.FINER, CLASS_NAME, methodName, this.newResult("External source " + classSourceName, isChangedReason, !isChanged));
        }
    }

    @Trivial
    public void logClassInfo(Logger useLogger) {
        String methodName = "logClassInfo";
        if (useLogger.isLoggable(Level.FINER)) {
            return;
        }
        UtilImpl_InternMap useClassNameInternMap = this.getClassNameInternMap();
        TargetsTableClassesMultiImpl useClassTable = this.getClassTable();
        useLogger.logp(Level.FINER, CLASS_NAME, methodName, "Interned [ {0} ] class names [ {1} ] bytes", new Object[]{useClassNameInternMap.getSize(), useClassNameInternMap.getTotalLength()});
        useLogger.logp(Level.FINER, CLASS_NAME, methodName, "Packages [ {0} ]", useClassTable.i_getPackageNames().size());
        useLogger.logp(Level.FINER, CLASS_NAME, methodName, "Classes [ {0} ]", useClassTable.i_getClassNames().size());
        for (String classSourceName : useClassTable.getClassSourceNames()) {
            Set<String> i_packageNames = useClassTable.getPackageNames(classSourceName);
            useLogger.logp(Level.FINER, CLASS_NAME, methodName, "Packages [ {0} ] [ {1} ]", new Object[]{classSourceName, i_packageNames.size()});
            Set<String> i_classNames = useClassTable.getClassNames(classSourceName);
            useLogger.logp(Level.FINER, CLASS_NAME, methodName, "Classes [ {0} ] [ {1} ]", new Object[]{classSourceName, i_classNames.size()});
        }
    }

    @Trivial
    public void logInternalResults(Logger useLogger) {
        String methodName = "logInternalResults";
        if (logger.isLoggable(Level.FINER)) {
            return;
        }
        TargetsTableImpl[] useResultTables = this.getResultTables();
        for (ClassSource_Aggregate.ScanPolicy policy : ClassSource_Aggregate.ScanPolicy.values()) {
            if (policy == ClassSource_Aggregate.ScanPolicy.EXTERNAL) continue;
            TargetsTableImpl resultTable = useResultTables[policy.ordinal()];
            int totalAnnotations = resultTable.countAnnotations();
            useLogger.logp(Level.FINER, CLASS_NAME, methodName, "Result [ {0} ] [ {1} ]", new Object[]{policy.name(), totalAnnotations});
        }
    }

    @Trivial
    public void logExternalResults(Logger useLogger) {
        String methodName = "logExternalResults";
        if (useLogger.isLoggable(Level.FINER)) {
            return;
        }
        TargetsTableImpl[] useResultTables = this.getResultTables();
        TargetsTableImpl resultTable = useResultTables[ClassSource_Aggregate.ScanPolicy.EXTERNAL.ordinal()];
        int totalAnnotations = resultTable.countAnnotations();
        useLogger.logp(Level.FINER, CLASS_NAME, methodName, "Result [ {0} ] [ {1} ]", new Object[]{ClassSource_Aggregate.ScanPolicy.EXTERNAL.name(), totalAnnotations});
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
    static {
        $$$tc$$$ = Tr.register((String)"com.ibm.ws.annocache.targets.internal.TargetsScannerOverallImpl", TargetsScannerOverallImpl.class, (String)"com.ibm.ws.annocache", (String)"com.ibm.ws.anno.resources.internal.AnnoMessages");
        CLASS_NAME = TargetsScannerOverallImpl.class.getSimpleName();
    }

    @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
    @InjectedFFDC
    @TraceOptions
    protected static class TargetsControl {
        static final long serialVersionUID = 655043718915627808L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        protected TargetsControl() {
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register((String)"com.ibm.ws.annocache.targets.internal.TargetsScannerOverallImpl$TargetsControl", TargetsControl.class, (String)"com.ibm.ws.annocache", (String)"com.ibm.ws.anno.resources.internal.AnnoMessages");
        }
    }

    @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
    @InjectedFFDC
    @TraceOptions
    protected static class InternMapControl {
        static final long serialVersionUID = -1054968491687703642L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        protected InternMapControl() {
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register((String)"com.ibm.ws.annocache.targets.internal.TargetsScannerOverallImpl$InternMapControl", InternMapControl.class, (String)"com.ibm.ws.annocache", (String)"com.ibm.ws.anno.resources.internal.AnnoMessages");
        }
    }
}

