/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.websphere.exception;

import com.ibm.websphere.exception.DistributedExceptionEnabled;
import com.ibm.websphere.exception.ExceptionInstantiationException;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.PrintWriter;
import java.io.Serializable;
import java.io.StringWriter;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.text.MessageFormat;
import java.util.MissingResourceException;
import java.util.ResourceBundle;

public class DistributedExceptionInfo
implements Serializable {
    private static final long serialVersionUID = 7298223355966269413L;
    private String message;
    private String className;
    private transient DistributedExceptionEnabled currentException = null;
    private String stackTrace;
    private DistributedExceptionInfo previousExceptionInfo;
    private byte[] previousException = null;
    private transient Throwable previousExceptionObject = null;
    private String lineSeparator;
    private String resourceBundleName = null;
    private String resourceKey = null;
    private Object[] formatArguments;
    private static final String DIST_EX_RESOURCE_BUNDLE_NAME = "com.ibm.ws.cache.resources.dynacache";

    public DistributedExceptionInfo(DistributedExceptionEnabled currentException) {
        if (currentException != null) {
            this.setExceptionInfo(currentException);
        }
    }

    public DistributedExceptionInfo(DistributedExceptionEnabled currentException, Throwable previousException) {
        if (currentException != null) {
            this.setExceptionInfo(currentException);
        }
        if (previousException != null) {
            this.setPreviousExceptionInfo(previousException);
            this.previousExceptionObject = previousException;
        }
    }

    public DistributedExceptionInfo(String defaultMessage, DistributedExceptionEnabled currentException) {
        if (currentException != null) {
            this.setExceptionInfo(currentException);
        }
        this.message = defaultMessage;
    }

    public DistributedExceptionInfo(String defaultMessage, DistributedExceptionEnabled currentException, Throwable previousException) {
        if (currentException != null) {
            this.setExceptionInfo(currentException);
        }
        if (previousException != null) {
            this.setPreviousExceptionInfo(previousException);
            this.previousExceptionObject = previousException;
        }
        this.message = defaultMessage;
    }

    public DistributedExceptionInfo(String resourceBundleName, String resourceKey, Object[] formatArguments, String defaultText, DistributedExceptionEnabled currentException) {
        this.resourceBundleName = resourceBundleName;
        this.resourceKey = resourceKey;
        this.formatArguments = formatArguments;
        this.setMessage(defaultText);
        if (currentException != null) {
            this.setExceptionInfo(currentException);
        }
    }

    public DistributedExceptionInfo(String resourceBundleName, String resourceKey, Object[] formatArguments, String defaultText, DistributedExceptionEnabled currentException, Throwable previousException) {
        this.resourceBundleName = resourceBundleName;
        this.resourceKey = resourceKey;
        this.formatArguments = formatArguments;
        this.setMessage(defaultText);
        if (currentException != null) {
            this.setExceptionInfo(currentException);
        }
        if (previousException != null) {
            this.setPreviousExceptionInfo(previousException);
            this.previousExceptionObject = previousException;
        }
    }

    private DistributedExceptionInfo(Throwable previousException) {
        if (previousException != null) {
            this.setClassName(previousException.getClass().getName());
            this.message = previousException.getMessage();
            this.previousExceptionObject = previousException;
        }
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        if (this.previousExceptionObject != null) {
            this.serializePreviousException();
            if (this.currentException == null) {
                this.setStackTrace(this.previousExceptionObject);
            }
        }
        if (this.currentException != null) {
            this.serializeCurrentException();
        }
        out.defaultWriteObject();
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
    }

    public String getClassName() {
        return this.className;
    }

    public String getDefaultMessage() {
        return this.message;
    }

    private String getErrorMsg(String resourceBundle, String resourceKey, String defaultEnglishMessage) {
        ResourceBundle bundle = null;
        String errorMsg = null;
        try {
            bundle = ResourceBundle.getBundle(resourceBundle);
        }
        catch (MissingResourceException e) {
            errorMsg = defaultEnglishMessage;
        }
        if (bundle != null) {
            try {
                errorMsg = bundle.getString(resourceKey);
            }
            catch (MissingResourceException e) {
                errorMsg = defaultEnglishMessage;
            }
        }
        return errorMsg;
    }

    public Throwable getException(String exceptionClassName) throws ExceptionInstantiationException {
        if (exceptionClassName == null) {
            return null;
        }
        Throwable ex = null;
        if (this.previousExceptionInfo != null) {
            ex = this.previousExceptionInfo.getClassName().equals(exceptionClassName) ? this.getPreviousException() : this.previousExceptionInfo.getException(exceptionClassName);
        }
        return ex;
    }

    public Object[] getFormatArguments() {
        return this.formatArguments;
    }

    private String getLineSeparator() {
        return this.lineSeparator;
    }

    public String getMessage() {
        if (this.resourceBundleName != null && this.resourceKey != null) {
            String key;
            String retrievedMessage = null;
            String internalMessage = null;
            String defaultEnglishMessage = null;
            ResourceBundle bundle = null;
            try {
                bundle = ResourceBundle.getBundle(this.resourceBundleName);
            }
            catch (MissingResourceException e) {
                key = null;
                if (this.message == null) {
                    key = "missingResourceBundleNoDft";
                    defaultEnglishMessage = "There was an error retrieving resource bundle {0}. \nThere is no default message.";
                } else {
                    key = "missingResourceBundleWithDft";
                    defaultEnglishMessage = "There was an error retrieving resource bundle {0}. \nThe default exception message is: {2}.";
                }
                internalMessage = this.getErrorMsg(DIST_EX_RESOURCE_BUNDLE_NAME, key, defaultEnglishMessage);
            }
            if (bundle != null) {
                try {
                    retrievedMessage = bundle.getString(this.resourceKey);
                }
                catch (MissingResourceException e) {
                    key = null;
                    if (this.message == null) {
                        key = "missingResourceKeyNoDft";
                        defaultEnglishMessage = "There was an error retrieving resource key {1} in resource bundle {0}. \nThere is no default message.";
                    } else {
                        key = "missingResourceKeyWithDft";
                        defaultEnglishMessage = "There was an error retrieving resource key {1} in resource bundle {0}. \nThe default exception message is: {2}.";
                    }
                    internalMessage = this.getErrorMsg(DIST_EX_RESOURCE_BUNDLE_NAME, key, defaultEnglishMessage);
                }
            }
            String formattedMessage = null;
            if (retrievedMessage != null) {
                formattedMessage = this.formatArguments != null ? MessageFormat.format(retrievedMessage, this.formatArguments) : retrievedMessage;
            } else if (internalMessage != null) {
                Object[] intFormatArguments = new Object[]{this.resourceBundleName, this.resourceKey, this.message};
                formattedMessage = MessageFormat.format(internalMessage, intFormatArguments);
            } else {
                return this.message;
            }
            return formattedMessage;
        }
        return this.message;
    }

    public Throwable getOriginalException() throws ExceptionInstantiationException {
        Throwable prevEx = null;
        if (this.previousExceptionInfo != null && (prevEx = this.previousExceptionInfo.getOriginalException()) == null) {
            prevEx = this.getPreviousException();
        }
        return prevEx;
    }

    public Throwable getPreviousException() throws ExceptionInstantiationException {
        Throwable ex = null;
        if (this.previousExceptionObject != null) {
            return this.previousExceptionObject;
        }
        if (this.previousException != null) {
            try {
                final ByteArrayInputStream bais = new ByteArrayInputStream(this.previousException);
                ObjectInputStream ois = (ObjectInputStream)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                    public Object run() throws IOException {
                        return new ObjectInputStream(bais);
                    }
                });
                ex = (Throwable)ois.readObject();
            }
            catch (PrivilegedActionException pae) {
                throw new ExceptionInstantiationException(pae.getException());
            }
            catch (Exception e) {
                throw new ExceptionInstantiationException(e);
            }
        }
        return ex;
    }

    public DistributedExceptionInfo getPreviousExceptionInfo() {
        return this.previousExceptionInfo;
    }

    public String getResourceBundleName() {
        return this.resourceBundleName;
    }

    public String getResourceKey() {
        return this.resourceKey;
    }

    private String getResourceText(String key) {
        String text = null;
        if (key != null) {
            ResourceBundle bundle = null;
            try {
                bundle = ResourceBundle.getBundle(DIST_EX_RESOURCE_BUNDLE_NAME);
            }
            catch (MissingResourceException missingResourceException) {
                // empty catch block
            }
            if (bundle != null) {
                try {
                    text = bundle.getString(key);
                }
                catch (MissingResourceException missingResourceException) {
                    // empty catch block
                }
            }
        }
        return text;
    }

    public void printStackTrace(PrintWriter pw) {
        String lineSep = this.getLineSeparatorProperty();
        this.printText(pw, "currentException", "Current exception:");
        this.printStackTrace(lineSep, pw);
        this.printText(pw, "endOfExTraces", "End of exception traces");
    }

    void printStackTrace(String lineSep, PrintWriter pw) {
        this.printText(pw, "msg", "Message:");
        pw.println("   " + this.getMessage());
        this.printText(pw, "stackTrace", "Stack trace:");
        if (this.stackTrace == null) {
            if (this.currentException != null) {
                this.serializeCurrentException();
            }
            if (this.stackTrace == null && this.previousExceptionObject != null) {
                this.setStackTrace(this.previousExceptionObject);
            }
        }
        if (this.stackTrace != null) {
            if (lineSep.equals(this.lineSeparator)) {
                pw.println(this.stackTrace);
            } else {
                char traceLineSep = lineSep.charAt(0);
                char currentLineSep = this.lineSeparator.charAt(0);
                StringBuffer sb = new StringBuffer(this.stackTrace);
                for (int i = 0; i < sb.length(); ++i) {
                    if (sb.charAt(i) != traceLineSep) continue;
                    sb.setCharAt(i, currentLineSep);
                }
                pw.println(this.stackTrace);
            }
        }
        if (this.previousExceptionInfo != null) {
            this.printText(pw, "previousException", "Previous exception:");
            this.previousExceptionInfo.printStackTrace(lineSep, pw);
        }
    }

    private void printText(PrintWriter pw, String key, String defaultText) {
        String text = null;
        if (key != null) {
            ResourceBundle bundle = null;
            try {
                bundle = ResourceBundle.getBundle(DIST_EX_RESOURCE_BUNDLE_NAME);
            }
            catch (MissingResourceException e) {
                text = defaultText;
            }
            if (bundle != null) {
                try {
                    text = bundle.getString(key);
                }
                catch (MissingResourceException e) {
                    text = defaultText;
                }
            }
        } else {
            text = defaultText;
        }
        pw.println(text);
    }

    private void setClassName(String newClassName) {
        this.className = newClassName;
    }

    public void setDefaultMessage(String defaultText) {
        this.setMessage(defaultText);
    }

    private String getLineSeparatorProperty() {
        return (String)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return System.getProperty("line.separator");
            }
        });
    }

    private void setExceptionInfo(DistributedExceptionEnabled e) {
        if (e != null) {
            this.setClassName(e.getClass().getName());
        }
        this.currentException = e;
    }

    private void serializeCurrentException() {
        this.setLineSeparator(this.getLineSeparatorProperty());
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        this.currentException.printSuperStackTrace(pw);
        this.setStackTrace(sw.toString());
    }

    private void setExceptionInfo(Throwable e) {
        if (e != null) {
            this.setClassName(e.getClass().getName());
        }
    }

    private void setLineSeparator(String newLineSeparator) {
        this.lineSeparator = newLineSeparator;
    }

    public void setLocalizationInfo(String resourceBundleName, String resourceKey, Object[] formatArguments) {
        this.resourceBundleName = resourceBundleName;
        this.resourceKey = resourceKey;
        this.formatArguments = formatArguments;
    }

    private void setMessage(String newMessage) {
        this.message = newMessage;
    }

    private void serializePreviousException() {
        try {
            final ByteArrayOutputStream bas = new ByteArrayOutputStream();
            ObjectOutputStream oos = (ObjectOutputStream)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws IOException {
                    return new ObjectOutputStream(bas);
                }
            });
            oos.writeObject(this.previousExceptionObject);
            this.previousException = bas.toByteArray();
        }
        catch (PrivilegedActionException pae) {
            pae.getException().printStackTrace();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void setPreviousExceptionInfo(Throwable previousException) {
        this.previousExceptionInfo = previousException instanceof DistributedExceptionEnabled ? ((DistributedExceptionEnabled)((Object)previousException)).getExceptionInfo() : new DistributedExceptionInfo(previousException);
    }

    private void setStackTrace(String st) {
        this.stackTrace = st;
    }

    private void setStackTrace(Throwable e) {
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        e.printStackTrace(pw);
        this.stackTrace = sw.toString();
        this.setLineSeparator(this.getLineSeparatorProperty());
    }
}

