/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.kernel.boot.logging;

import com.ibm.ws.kernel.boot.logging.DefaultFileStreamFactory;
import com.ibm.ws.kernel.boot.logging.TaggedFileOutputStreamFactory;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;

public class TextFileOutputStreamFactory {
    public static FileOutputStream createOutputStream(final File file) throws IOException {
        try {
            return AccessController.doPrivileged(new PrivilegedExceptionAction<FileOutputStream>(){

                @Override
                public FileOutputStream run() throws IOException {
                    return DelegateHolder.delegate.createOutputStream(file);
                }
            });
        }
        catch (PrivilegedActionException e) {
            throw (IOException)e.getException();
        }
    }

    public static FileOutputStream createOutputStream(final File file, final boolean append) throws IOException {
        try {
            return AccessController.doPrivileged(new PrivilegedExceptionAction<FileOutputStream>(){

                @Override
                public FileOutputStream run() throws IOException {
                    return DelegateHolder.delegate.createOutputStream(file, append);
                }
            });
        }
        catch (PrivilegedActionException e) {
            throw (IOException)e.getException();
        }
    }

    public static FileOutputStream createOutputStream(final String name) throws IOException {
        try {
            return AccessController.doPrivileged(new PrivilegedExceptionAction<FileOutputStream>(){

                @Override
                public FileOutputStream run() throws IOException {
                    return DelegateHolder.delegate.createOutputStream(name);
                }
            });
        }
        catch (PrivilegedActionException e) {
            throw (IOException)e.getException();
        }
    }

    public static FileOutputStream createOutputStream(final String name, final boolean append) throws IOException {
        try {
            return AccessController.doPrivileged(new PrivilegedExceptionAction<FileOutputStream>(){

                @Override
                public FileOutputStream run() throws IOException {
                    return DelegateHolder.delegate.createOutputStream(name, append);
                }
            });
        }
        catch (PrivilegedActionException e) {
            throw (IOException)e.getException();
        }
    }

    private static final class DelegateHolder {
        private static final Delegate delegate;

        private DelegateHolder() {
        }

        static {
            String systemOS = System.getProperty("os.name");
            delegate = systemOS.equals("z/OS") ? new TaggedFileOutputStreamFactory() : new DefaultFileStreamFactory();
        }
    }

    static interface Delegate {
        public FileOutputStream createOutputStream(File var1) throws IOException;

        public FileOutputStream createOutputStream(File var1, boolean var2) throws IOException;

        public FileOutputStream createOutputStream(String var1) throws IOException;

        public FileOutputStream createOutputStream(String var1, boolean var2) throws IOException;
    }
}

