/*
 * Decompiled with CFR 0.152.
 */
package org.apache.yoko.orb.OB;

import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Condition;
import java.util.logging.Level;
import org.apache.yoko.orb.CORBA.InputStream;
import org.apache.yoko.orb.CORBA.OutputStream;
import org.apache.yoko.orb.CORBA.OutputStreamHolder;
import org.apache.yoko.orb.IOP.MutableServiceContexts;
import org.apache.yoko.orb.IOP.ServiceContexts;
import org.apache.yoko.orb.OB.Assert;
import org.apache.yoko.orb.OB.Client;
import org.apache.yoko.orb.OB.CodeConverters;
import org.apache.yoko.orb.OB.DowncallEmitter;
import org.apache.yoko.orb.OB.FailureException;
import org.apache.yoko.orb.OB.LocationForward;
import org.apache.yoko.orb.OB.Logger;
import org.apache.yoko.orb.OB.MinorCodes;
import org.apache.yoko.orb.OB.ORBInstance;
import org.apache.yoko.orb.OB.RefCountPolicyList;
import org.apache.yoko.orb.OB.UnresolvedException;
import org.apache.yoko.orb.OCI.GiopVersion;
import org.apache.yoko.orb.OCI.ProfileInfo;
import org.apache.yoko.util.ObjectFormatter;
import org.apache.yoko.util.concurrent.AutoLock;
import org.apache.yoko.util.concurrent.AutoReadWriteLock;
import org.omg.CORBA.CompletionStatus;
import org.omg.CORBA.NO_RESPONSE;
import org.omg.CORBA.SystemException;
import org.omg.CORBA.UNKNOWN;
import org.omg.CORBA.UserException;
import org.omg.IOP.IOR;
import org.omg.IOP.ServiceContext;

public class Downcall {
    protected final ORBInstance orbInstance_;
    private final Logger logger_;
    private final Client client_;
    private DowncallEmitter emitter_;
    protected ProfileInfo profileInfo_;
    protected RefCountPolicyList policies_;
    private final int reqId_;
    protected final String op_;
    protected final boolean responseExpected_;
    private OutputStream out_;
    private InputStream in_;
    protected final AutoReadWriteLock stateLock = new AutoReadWriteLock();
    protected State state = State.UNSENT;
    private Condition stateWaitCondition;
    protected Exception ex_;
    protected String exId_;
    protected IOR forwardIOR_;
    public final ServiceContexts requestContexts = new ServiceContexts();
    public final ServiceContexts replyContexts = new ServiceContexts();

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    void checkForException() throws LocationForward, FailureException {
        try (AutoLock readLock = this.stateLock.getReadLock();){
            switch (this.state) {
                case USER_EXCEPTION: {
                    return;
                }
                case SYSTEM_EXCEPTION: {
                    Assert.ensure(this.ex_ != null);
                    this.ex_.fillInStackTrace();
                    throw (SystemException)((Object)this.ex_);
                }
                case FAILURE_EXCEPTION: {
                    Assert.ensure(this.ex_ != null);
                    throw new FailureException((SystemException)((Object)this.ex_));
                }
                case STALE_CONNECTION: {
                    Assert.ensure(this.ex_ != null);
                    throw new FailureException((SystemException)((Object)this.ex_), false);
                }
                case FORWARD: {
                    Assert.ensure(this.forwardIOR_ != null);
                    throw new LocationForward(this.forwardIOR_, false);
                }
                case FORWARD_PERM: {
                    Assert.ensure(this.forwardIOR_ != null);
                    throw new LocationForward(this.forwardIOR_, true);
                }
            }
            return;
        }
    }

    protected final OutputStream preMarshalBase() throws LocationForward, FailureException {
        OutputStreamHolder out = new OutputStreamHolder();
        this.emitter_ = this.client_.startDowncall(this, out);
        this.out_ = out.value;
        this.checkForException();
        return this.out_;
    }

    public Downcall(ORBInstance orbInstance, Client client, ProfileInfo profileInfo, RefCountPolicyList policies, String op, boolean resp) {
        this.orbInstance_ = orbInstance;
        this.logger_ = this.orbInstance_.getLogger();
        this.client_ = client;
        this.profileInfo_ = profileInfo;
        this.policies_ = policies;
        this.op_ = op;
        this.responseExpected_ = resp;
        try (AutoLock writeLock = this.stateLock.getWriteLock();){
            this.state = State.UNSENT;
        }
        this.ex_ = null;
        client.prepareForDowncall(policies);
        this.reqId_ = this.client_.getNewRequestID();
        this.logger_.fine("Downcall created for operation " + op + " with id " + this.reqId_);
    }

    public final ORBInstance orbInstance() {
        return this.orbInstance_;
    }

    public final Client client() {
        return this.client_;
    }

    public final ProfileInfo profileInfo() {
        return this.profileInfo_;
    }

    public final RefCountPolicyList policies() {
        return this.policies_;
    }

    public final Exception excep() {
        return this.ex_;
    }

    public final int requestId() {
        return this.reqId_;
    }

    public final String operation() {
        return this.op_;
    }

    public final boolean responseExpected() {
        return this.responseExpected_;
    }

    public final OutputStream output() {
        return this.out_;
    }

    public final InputStream input() {
        return this.in_;
    }

    public final ServiceContexts getRequestContexts() {
        return this.requestContexts;
    }

    public final void addToRequestContexts(ServiceContext sc) {
        this.requestContexts.mutable().add(sc);
    }

    public final void setReplyContexts(ServiceContexts contexts) {
        if (!this.replyContexts.isEmpty() && this.logger_.isDebugEnabled()) {
            this.logger_.fine("Expected empty reply contexts, but found " + this.replyContexts.size());
            for (ServiceContext sc : contexts) {
                this.logger_.fine("\t" + ObjectFormatter.format((ServiceContext)sc));
            }
        }
        MutableServiceContexts mutable = this.replyContexts.mutable();
        for (ServiceContext sc : contexts) {
            mutable.add(sc, true);
        }
    }

    public OutputStream preMarshal() throws LocationForward, FailureException {
        return this.preMarshalBase();
    }

    public final void marshalEx(SystemException ex) throws LocationForward, FailureException {
        this.setFailureException(ex);
        this.checkForException();
        throw Assert.fail();
    }

    public final void postMarshal() throws LocationForward, FailureException {
    }

    public final void locate() throws LocationForward, FailureException {
        Assert.ensure(this.responseExpected_);
        Assert.ensure(this.op_.equals("_locate"));
        boolean finished = this.emitter_.sendReceive(this);
        Assert.ensure(finished);
        this.checkForException();
    }

    public final void request() throws LocationForward, FailureException {
        Assert.ensure(this.responseExpected_);
        boolean finished = this.emitter_.sendReceive(this);
        Assert.ensure(finished);
        this.checkForException();
    }

    public final void oneway() throws LocationForward, FailureException {
        Assert.ensure(!this.responseExpected_);
        if (this.policies_.syncScope == 1) {
            boolean finished = this.emitter_.send(this, true);
            Assert.ensure(finished);
            this.checkForException();
        } else {
            boolean finished = this.emitter_.send(this, false);
            if (finished) {
                this.checkForException();
            }
        }
    }

    public final void deferred() throws LocationForward, FailureException {
        Assert.ensure(this.responseExpected_);
        boolean finished = this.emitter_.send(this, true);
        if (finished) {
            this.checkForException();
        }
    }

    public final void response() throws LocationForward, FailureException {
        Assert.ensure(this.responseExpected_);
        boolean finished = this.emitter_.receive(this, true);
        Assert.ensure(finished);
        this.checkForException();
    }

    public final boolean poll() throws LocationForward, FailureException {
        Assert.ensure(this.responseExpected_);
        boolean finished = this.emitter_.receive(this, false);
        if (finished) {
            try (AutoLock lock = this.stateLock.getReadLock();){
                this.checkForException();
                boolean bl = this.state != State.PENDING;
                return bl;
            }
        }
        return false;
    }

    public final InputStream preUnmarshal() throws LocationForward, FailureException {
        return this.in_;
    }

    public final void unmarshalEx(SystemException ex) throws LocationForward, FailureException {
        this.setFailureException(ex);
        this.checkForException();
        throw Assert.fail();
    }

    public void postUnmarshal() throws LocationForward, FailureException {
        try (AutoLock lock = this.stateLock.getReadLock();){
            if (this.state == State.USER_EXCEPTION && this.ex_ == null && this.exId_ == null) {
                this.setSystemException((SystemException)new UNKNOWN(MinorCodes.describeUnknown(1330446337), 1330446337, CompletionStatus.COMPLETED_YES));
            }
            this.checkForException();
        }
    }

    public final String unmarshalExceptionId() {
        try (AutoLock lock = this.stateLock.getReadLock();){
            Assert.ensure(this.state == State.USER_EXCEPTION);
            int pos = this.in_.getPosition();
            String id = this.in_.read_string();
            this.in_.setPosition(pos);
            String string = id;
            return string;
        }
    }

    public final boolean unsent() {
        try (AutoLock lock = this.stateLock.getReadLock();){
            boolean bl = this.state == State.UNSENT;
            return bl;
        }
    }

    public final boolean pending() {
        try (AutoLock lock = this.stateLock.getReadLock();){
            boolean bl = this.state == State.PENDING;
            return bl;
        }
    }

    public final boolean noException() {
        try (AutoLock lock = this.stateLock.getReadLock();){
            boolean bl = this.state == State.NO_EXCEPTION;
            return bl;
        }
    }

    public final boolean userException() {
        try (AutoLock lock = this.stateLock.getReadLock();){
            boolean bl = this.state == State.USER_EXCEPTION;
            return bl;
        }
    }

    public final void setPending() {
        try (AutoLock lock = this.stateLock.getWriteLock();){
            Assert.ensure(this.responseExpected_);
            this.state = State.PENDING;
            if (null != this.stateWaitCondition) {
                this.stateWaitCondition.signalAll();
            }
        }
    }

    public final void setNoException(InputStream in) {
        try (AutoLock lock = this.stateLock.getWriteLock();){
            this.state = State.NO_EXCEPTION;
            if (in == null) {
                Assert.ensure(!this.responseExpected_);
            } else {
                Assert.ensure(this.responseExpected_);
                this.in_ = in;
                this.in_._OB_ORBInstance(this.orbInstance_);
                CodeConverters codeConverters = this.client_.codeConverters();
                this.in_._OB_codeConverters(codeConverters, GiopVersion.get(this.profileInfo_.major, this.profileInfo_.minor));
            }
            if (null != this.stateWaitCondition) {
                this.stateWaitCondition.signalAll();
            }
        }
    }

    public final void setUserException(InputStream in) {
        try (AutoLock lock = this.stateLock.getWriteLock();){
            Assert.ensure(in != null);
            Assert.ensure(this.responseExpected_);
            this.state = State.USER_EXCEPTION;
            this.in_ = in;
            this.in_._OB_ORBInstance(this.orbInstance_);
            CodeConverters codeConverters = this.client_.codeConverters();
            this.in_._OB_codeConverters(codeConverters, GiopVersion.get(this.profileInfo_.major, this.profileInfo_.minor));
            if (null != this.stateWaitCondition) {
                this.stateWaitCondition.signalAll();
            }
        }
    }

    public void setUserException(UserException ex, String exId) {
        try (AutoLock lock = this.stateLock.getWriteLock();){
            Assert.ensure(this.responseExpected_);
            Assert.ensure(this.ex_ == null);
            this.state = State.USER_EXCEPTION;
            this.ex_ = ex;
            if (null != this.stateWaitCondition) {
                this.stateWaitCondition.signalAll();
            }
        }
    }

    public final void setUserException(UserException ex) {
        try (AutoLock lock = this.stateLock.getWriteLock();){
            Assert.ensure(this.responseExpected_);
            Assert.ensure(this.ex_ == null);
            this.state = State.USER_EXCEPTION;
            this.ex_ = ex;
            if (null != this.stateWaitCondition) {
                this.stateWaitCondition.signalAll();
            }
        }
    }

    public final void setUserException(String exId) {
        try (AutoLock lock = this.stateLock.getWriteLock();){
            Assert.ensure(this.responseExpected_);
            Assert.ensure(this.ex_ == null);
            this.state = State.USER_EXCEPTION;
            this.exId_ = exId;
            this.logger_.fine("Received user exception " + exId);
            if (null != this.stateWaitCondition) {
                this.stateWaitCondition.signalAll();
            }
        }
    }

    public final void setSystemException(SystemException ex) {
        try (AutoLock lock = this.stateLock.getWriteLock();){
            Assert.ensure(this.responseExpected_);
            Assert.ensure(this.ex_ == null);
            this.state = State.SYSTEM_EXCEPTION;
            this.ex_ = ex;
            this.logger_.log(Level.FINE, "Received system exception", ex);
            if (null != this.stateWaitCondition) {
                this.stateWaitCondition.signalAll();
            }
        }
    }

    final void notifyStaleConnection() {
        try (AutoLock lock = this.stateLock.getWriteLock();){
            this.state = State.STALE_CONNECTION;
        }
    }

    public final void setFailureException(SystemException ex) {
        try (AutoLock lock = this.stateLock.getWriteLock();){
            Assert.ensure(this.ex_ == null);
            if (this.state != State.STALE_CONNECTION) {
                this.state = State.FAILURE_EXCEPTION;
            }
            this.ex_ = ex;
            this.logger_.log(Level.FINE, "Received failure exception", ex);
            if (null != this.stateWaitCondition) {
                this.stateWaitCondition.signalAll();
            }
        }
    }

    public final void setLocationForward(IOR ior, boolean perm) {
        try (AutoLock lock = this.stateLock.getWriteLock();){
            Assert.ensure(this.responseExpected_);
            Assert.ensure(this.forwardIOR_ == null);
            this.state = perm ? State.FORWARD_PERM : State.FORWARD;
            this.forwardIOR_ = ior;
            if (null != this.stateWaitCondition) {
                this.stateWaitCondition.signalAll();
            }
        }
        Assert.ensure(this.responseExpected_);
    }

    public final void allowWaiting() {
        try (AutoLock lock = this.stateLock.getWriteLock();){
            Assert.ensure(this.stateWaitCondition == null);
            this.stateWaitCondition = lock.newCondition();
        }
    }

    public final boolean waitUntilCompleted(boolean block) {
        int t = this.policies_.requestTimeout;
        try (AutoLock lock = this.stateLock.getWriteLock();){
            Assert.ensure(this.stateWaitCondition != null);
            while (this.state == State.UNSENT || this.state == State.PENDING) {
                if (!block) {
                    boolean bl = false;
                    return bl;
                }
                try {
                    if (t <= 0) {
                        this.stateWaitCondition.await();
                        continue;
                    }
                    State oldState = this.state;
                    this.stateWaitCondition.await(t, TimeUnit.MILLISECONDS);
                    if (this.state != oldState) continue;
                    throw new NO_RESPONSE("Timeout during receive", 0, CompletionStatus.COMPLETED_MAYBE);
                }
                catch (InterruptedException interruptedException) {
                }
            }
            if (this.ex_ instanceof UnresolvedException) {
                this.ex_ = ((UnresolvedException)((Object)this.ex_)).resolve();
            }
            boolean bl = true;
            return bl;
        }
    }

    protected static enum State {
        UNSENT,
        PENDING,
        NO_EXCEPTION,
        USER_EXCEPTION,
        SYSTEM_EXCEPTION,
        FAILURE_EXCEPTION,
        STALE_CONNECTION,
        FORWARD,
        FORWARD_PERM;

    }
}

