/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.processor.gd;

import com.ibm.ejs.ras.TraceNLS;
import com.ibm.ejs.util.am.AlarmListener;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.sib.Reliability;
import com.ibm.websphere.sib.exception.SIErrorException;
import com.ibm.websphere.sib.exception.SIException;
import com.ibm.websphere.sib.exception.SIResourceException;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.sib.mfp.control.ControlNack;
import com.ibm.ws.sib.processor.gd.ControllableStream;
import com.ibm.ws.sib.processor.gd.GDConfig;
import com.ibm.ws.sib.processor.gd.StateStream;
import com.ibm.ws.sib.processor.gd.TickRange;
import com.ibm.ws.sib.processor.impl.interfaces.UpstreamControl;
import com.ibm.ws.sib.processor.utils.am.MPAlarmManager;
import com.ibm.ws.sib.utils.SIBUuid12;
import com.ibm.ws.sib.utils.ras.SibTr;
import java.util.List;

public class InternalInputStream
extends ControllableStream {
    private static final TraceComponent tc = SibTr.register(InternalInputStream.class, (String)"SIBProcessor", (String)"com.ibm.ws.sib.processor.CWSIPMessages");
    private static final TraceNLS nls = TraceNLS.getTraceNLS((String)"com.ibm.ws.sib.processor.CWSIPMessages");
    volatile long iack;
    private StateStream iststream;
    private int priority;
    private Reliability reliability;
    AckExpiryHandle ackExpiry;
    UpstreamControl upControl;
    SIBUuid12 streamID;
    private MPAlarmManager am;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public InternalInputStream(int priority, Reliability reliability, UpstreamControl upControl, SIBUuid12 sourceStream, List scratch, MPAlarmManager am) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"InternalInputStream", (Object)new Object[]{new Integer(priority), reliability, upControl, sourceStream, scratch, am});
        }
        InternalInputStream internalInputStream = this;
        synchronized (internalInputStream) {
            this.priority = priority;
            this.reliability = reliability;
            this.upControl = upControl;
            this.am = am;
            this.streamID = sourceStream;
            this.iststream = new StateStream();
            this.iststream.init();
            this.iack = 0L;
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"InternalInputStream", (Object)this);
        }
    }

    private void sendAck() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"sendAck");
        }
        try {
            this.upControl.sendAckMessage(null, null, null, this.iack, this.priority, this.reliability, this.streamID, false);
        }
        catch (SIException e) {
            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.sib.processor.gd.InternalInputStream.sendAck", (String)"1:161:1.42", (Object)this);
            SibTr.exception((TraceComponent)tc, (Exception)((Object)e));
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"sendAck");
        }
    }

    protected void scheduleAck() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"scheduleAck");
        }
        if (GDConfig.GD_ACK_PROPAGATION_THRESHOLD == 0) {
            this.sendAck();
        } else if (this.ackExpiry == null) {
            this.ackExpiry = new AckExpiryHandle();
            this.am.create(GDConfig.GD_ACK_PROPAGATION_THRESHOLD, this.ackExpiry, this.ackExpiry);
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"scheduleAck");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processNack(ControlNack nm) throws SIResourceException {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"processNack", (Object)nm);
        }
        long startstamp = nm.getStartTick();
        long endstamp = nm.getEndTick();
        InternalInputStream internalInputStream = this;
        synchronized (internalInputStream) {
            TickRange tr2;
            this.iststream.setCursor(startstamp);
            boolean changed = false;
            TickRange tr = this.iststream.getNext();
            do {
                if (tr.type == 0) {
                    changed = true;
                    long maxStartstamp = InternalInputStream.max(tr.startstamp, startstamp);
                    long minEndstamp = InternalInputStream.min(tr.endstamp, endstamp);
                    this.upControl.sendNackMessage(null, null, null, maxStartstamp, minEndstamp, this.priority, this.reliability, this.streamID);
                }
                tr2 = tr;
                tr = this.iststream.getNext();
            } while (tr.startstamp <= endstamp && tr2 != tr);
            if (changed) {
                tr = new TickRange(1, startstamp, endstamp);
                this.iststream.writeRange(tr);
                new ReqExpiryHandle(tr);
            }
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"processNack");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processAckExpected(long stamp) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"processAckExpected", (Object)new Object[]{new Long(stamp)});
        }
        InternalInputStream internalInputStream = this;
        synchronized (internalInputStream) {
            this.sendAck();
            if (stamp > this.iack) {
                try {
                    this.upControl.sendNackMessage(null, null, null, this.iack + 1L, stamp, this.priority, this.reliability, this.streamID);
                }
                catch (SIResourceException e) {
                    FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.sib.processor.gd.InternalInputStream.processAckExpected", (String)"1:379:1.42", (Object)this);
                    SibTr.exception((TraceComponent)tc, (Exception)((Object)e));
                    SibTr.error((TraceComponent)tc, (String)"INTERNAL_MESSAGING_ERROR_CWSIP0002", (Object)new Object[]{"com.ibm.ws.sib.processor.gd.InternalInputStream", "1:386:1.42", e});
                    if (tc.isEntryEnabled()) {
                        SibTr.exit((TraceComponent)tc, (String)"processAckExpected", (Object)((Object)e));
                    }
                    throw new SIErrorException(nls.getFormattedMessage("INTERNAL_MESSAGING_ERROR_CWSIP0002", new Object[]{"com.ibm.ws.sib.processor.gd.InternalInputStream", "1:397:1.42", e}, null), (Throwable)e);
                }
            }
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"processAckExpected");
        }
    }

    public synchronized void releaseMemory() {
        this.iststream = new StateStream();
        this.iststream.init();
    }

    private static long max(long a, long b) {
        return a > b ? a : b;
    }

    private static long min(long a, long b) {
        return a < b ? a : b;
    }

    public long getAckPrefix() {
        return this.iack;
    }

    public synchronized List writeAckPrefix(long stamp) {
        this.iack = stamp;
        this.scheduleAck();
        return null;
    }

    @Override
    public long getCompletedPrefix() {
        return this.iststream.getCompletedPrefix();
    }

    @Override
    public StateStream getStateStream() {
        return this.iststream;
    }

    @Override
    public void writeSilenceForced(long tick) {
    }

    @Override
    protected int getPriority() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getPriority");
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getPriority", (Object)new Integer(this.priority));
        }
        return this.priority;
    }

    @Override
    protected Reliability getReliability() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getReliability");
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getReliability", (Object)this.reliability);
        }
        return this.reliability;
    }

    class ReqExpiryHandle
    implements AlarmListener {
        TickRange tr;

        ReqExpiryHandle(TickRange tr) {
            if (tc.isEntryEnabled()) {
                SibTr.entry((TraceComponent)tc, (String)"ReqExpiryHandle", (Object)tr);
            }
            this.tr = tr;
            InternalInputStream.this.am.create(GDConfig.GD_REQUESTED_FORGETTING_THRESHOLD, this);
            if (tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"ReqExpiryHandle", (Object)this);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void alarm(Object thandle) {
            if (tc.isEntryEnabled()) {
                SibTr.entry((TraceComponent)tc, (String)"alarm", (Object)thandle);
            }
            InternalInputStream internalInputStream = InternalInputStream.this;
            synchronized (internalInputStream) {
                if (this.tr.type == 1) {
                    this.tr.type = 0;
                    InternalInputStream.this.iststream.writeRange(this.tr);
                }
            }
            if (tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"alarm");
            }
        }
    }

    class AckExpiryHandle
    implements AlarmListener {
        AckExpiryHandle() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void alarm(Object thandle) {
            if (tc.isEntryEnabled()) {
                SibTr.entry((TraceComponent)tc, (String)"alarm", (Object)thandle);
            }
            if (thandle == InternalInputStream.this.ackExpiry) {
                AckExpiryHandle ackExpiryHandle = this;
                synchronized (ackExpiryHandle) {
                    InternalInputStream.this.ackExpiry = null;
                }
                try {
                    InternalInputStream.this.upControl.sendAckMessage(null, null, null, InternalInputStream.this.iack, InternalInputStream.this.priority, InternalInputStream.this.reliability, InternalInputStream.this.streamID, false);
                }
                catch (SIException e) {
                    FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.sib.processor.gd.InternalInputStream.AckExpiryHandle.alarm", (String)"1:228:1.42", (Object)this);
                }
            }
            if (tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"alarm");
            }
        }
    }
}

