/*
 * Decompiled with CFR 0.152.
 */
package graphql.schema;

import graphql.Assert;
import graphql.PublicApi;
import graphql.schema.GraphQLInputType;
import graphql.schema.GraphQLModifiedType;
import graphql.schema.GraphQLOutputType;
import graphql.schema.GraphQLSchemaElement;
import graphql.schema.GraphQLType;
import graphql.schema.GraphQLTypeUtil;
import graphql.schema.GraphQLTypeVisitor;
import graphql.schema.SchemaElementChildrenContainer;
import graphql.util.TraversalControl;
import graphql.util.TraverserContext;
import java.util.Collections;
import java.util.List;

@PublicApi
public class GraphQLNonNull
implements GraphQLType,
GraphQLInputType,
GraphQLOutputType,
GraphQLModifiedType {
    private final GraphQLType originalWrappedType;
    private GraphQLType replacedWrappedType;
    public static final String CHILD_WRAPPED_TYPE = "wrappedType";

    public static GraphQLNonNull nonNull(GraphQLType wrappedType) {
        return new GraphQLNonNull(wrappedType);
    }

    public GraphQLNonNull(GraphQLType wrappedType) {
        Assert.assertNotNull(wrappedType, "wrappedType can't be null", new Object[0]);
        this.assertNonNullWrapping(wrappedType);
        this.originalWrappedType = wrappedType;
    }

    private void assertNonNullWrapping(GraphQLType wrappedType) {
        Assert.assertTrue(!GraphQLTypeUtil.isNonNull(wrappedType), String.format("A non null type cannot wrap an existing non null type '%s'", GraphQLTypeUtil.simplePrint(wrappedType)), new Object[0]);
    }

    @Override
    public GraphQLType getWrappedType() {
        return this.replacedWrappedType != null ? this.replacedWrappedType : this.originalWrappedType;
    }

    void replaceType(GraphQLType type) {
        this.assertNonNullWrapping(type);
        this.replacedWrappedType = type;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        GraphQLNonNull that = (GraphQLNonNull)o;
        GraphQLType wrappedType = this.getWrappedType();
        return !(wrappedType == null ? that.getWrappedType() != null : !wrappedType.equals(that.getWrappedType()));
    }

    public int hashCode() {
        return this.getWrappedType() != null ? this.getWrappedType().hashCode() : 0;
    }

    public String toString() {
        return GraphQLTypeUtil.simplePrint(this);
    }

    @Override
    public TraversalControl accept(TraverserContext<GraphQLSchemaElement> context, GraphQLTypeVisitor visitor) {
        return visitor.visitGraphQLNonNull(this, context);
    }

    @Override
    public List<GraphQLSchemaElement> getChildren() {
        return Collections.singletonList(this.getWrappedType());
    }

    @Override
    public SchemaElementChildrenContainer getChildrenWithTypeReferences() {
        return SchemaElementChildrenContainer.newSchemaElementChildrenContainer().child(CHILD_WRAPPED_TYPE, this.originalWrappedType).build();
    }

    @Override
    public GraphQLSchemaElement withNewChildren(SchemaElementChildrenContainer newChildren) {
        return GraphQLNonNull.nonNull((GraphQLType)newChildren.getChildOrNull(CHILD_WRAPPED_TYPE));
    }
}

