/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jbatch.spi;

import com.ibm.jbatch.spi.BatchJobUtil;
import com.ibm.jbatch.spi.BatchSecurityHelper;
import com.ibm.jbatch.spi.DatabaseAlreadyInitializedException;
import com.ibm.jbatch.spi.DatabaseConfigurationBean;
import com.ibm.jbatch.spi.ExecutorServiceProvider;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import java.util.logging.Level;
import java.util.logging.Logger;

@TraceObjectField(fieldName="logger", fieldDesc="Ljava/util/logging/Logger;")
@InjectedFFDC
public final class BatchSPIManager {
    private static final String sourceClass = BatchSPIManager.class.getName();
    private static final Logger logger = Logger.getLogger(sourceClass);
    private static final BatchSPIManager INSTANCE = new BatchSPIManager();
    private BatchJobUtil batchJobUtil;
    private BatchSecurityHelper batchSecurityHelper;
    private ExecutorServiceProvider executorServiceProvider;
    private final byte[] databaseConfigurationCompleteLock;
    private Boolean databaseConfigurationComplete;
    private DatabaseConfigurationBean dataBaseConfigurationBean;
    static final long serialVersionUID = 3156832868054850459L;

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    private BatchSPIManager() {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.jbatch.spi.BatchSPIManager", "<init>", new Object[0]);
        }
        this.batchJobUtil = null;
        this.batchSecurityHelper = null;
        this.executorServiceProvider = null;
        this.databaseConfigurationCompleteLock = new byte[0];
        this.databaseConfigurationComplete = Boolean.FALSE;
        this.dataBaseConfigurationBean = null;
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.exiting("com.ibm.jbatch.spi.BatchSPIManager", "<init>", this);
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public static BatchSPIManager getInstance() {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.jbatch.spi.BatchSPIManager", "getInstance", new Object[0]);
        }
        BatchSPIManager batchSPIManager = INSTANCE;
        if (logger != null && logger.isLoggable(Level.FINER)) {
            batchSPIManager = batchSPIManager;
            logger.exiting("com.ibm.jbatch.spi.BatchSPIManager", "getInstance", batchSPIManager);
        }
        return batchSPIManager;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public BatchJobUtil getBatchJobUtil() {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.jbatch.spi.BatchSPIManager", "getBatchJobUtil", new Object[0]);
        }
        BatchJobUtil batchJobUtil = this.batchJobUtil;
        if (logger != null && logger.isLoggable(Level.FINER)) {
            batchJobUtil = batchJobUtil;
            logger.exiting("com.ibm.jbatch.spi.BatchSPIManager", "getBatchJobUtil", batchJobUtil);
        }
        return batchJobUtil;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public BatchSecurityHelper getBatchSecurityHelper() {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.jbatch.spi.BatchSPIManager", "getBatchSecurityHelper", new Object[0]);
        }
        BatchSecurityHelper batchSecurityHelper = this.batchSecurityHelper;
        if (logger != null && logger.isLoggable(Level.FINER)) {
            batchSecurityHelper = batchSecurityHelper;
            logger.exiting("com.ibm.jbatch.spi.BatchSPIManager", "getBatchSecurityHelper", batchSecurityHelper);
        }
        return batchSecurityHelper;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public ExecutorServiceProvider getExecutorServiceProvider() {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.jbatch.spi.BatchSPIManager", "getExecutorServiceProvider", new Object[0]);
        }
        ExecutorServiceProvider executorServiceProvider = this.executorServiceProvider;
        if (logger != null && logger.isLoggable(Level.FINER)) {
            executorServiceProvider = executorServiceProvider;
            logger.exiting("com.ibm.jbatch.spi.BatchSPIManager", "getExecutorServiceProvider", executorServiceProvider);
        }
        return executorServiceProvider;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public void registerBatchJobUtil(BatchJobUtil helper) {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.jbatch.spi.BatchSPIManager", "registerBatchJobUtil", new Object[]{helper});
        }
        this.batchJobUtil = helper;
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.exiting("com.ibm.jbatch.spi.BatchSPIManager", "registerBatchJobUtil");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public void registerBatchSecurityHelper(BatchSecurityHelper helper) {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.jbatch.spi.BatchSPIManager", "registerBatchSecurityHelper", new Object[]{helper});
        }
        this.batchSecurityHelper = helper;
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.exiting("com.ibm.jbatch.spi.BatchSPIManager", "registerBatchSecurityHelper");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public void registerExecutorServiceProvider(ExecutorServiceProvider provider) {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.jbatch.spi.BatchSPIManager", "registerExecutorServiceProvider", new Object[]{provider});
        }
        this.executorServiceProvider = provider;
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.exiting("com.ibm.jbatch.spi.BatchSPIManager", "registerExecutorServiceProvider");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public DatabaseConfigurationBean getDataBaseConfigurationBean() {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.jbatch.spi.BatchSPIManager", "getDataBaseConfigurationBean", new Object[0]);
        }
        DatabaseConfigurationBean databaseConfigurationBean = this.dataBaseConfigurationBean;
        if (logger != null && logger.isLoggable(Level.FINER)) {
            databaseConfigurationBean = databaseConfigurationBean;
            logger.exiting("com.ibm.jbatch.spi.BatchSPIManager", "getDataBaseConfigurationBean", databaseConfigurationBean);
        }
        return databaseConfigurationBean;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public void registerDatabaseConfigurationBean(DatabaseConfigurationBean bean) throws DatabaseAlreadyInitializedException {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.jbatch.spi.BatchSPIManager", "registerDatabaseConfigurationBean", new Object[]{bean});
        }
        byte[] byArray = this.databaseConfigurationCompleteLock;
        synchronized (this.databaseConfigurationCompleteLock) {
            if (this.databaseConfigurationComplete.booleanValue()) {
                throw new DatabaseAlreadyInitializedException("Tried to set database configuration but it's too late, since configuration has already been hardened.");
            }
            this.dataBaseConfigurationBean = bean;
            // ** MonitorExit[var2_2] (shouldn't be in output)
            if (logger != null && logger.isLoggable(Level.FINER)) {
                logger.exiting("com.ibm.jbatch.spi.BatchSPIManager", "registerDatabaseConfigurationBean");
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public DatabaseConfigurationBean getFinalDatabaseConfiguration() {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.jbatch.spi.BatchSPIManager", "getFinalDatabaseConfiguration", new Object[0]);
        }
        byte[] byArray = this.databaseConfigurationCompleteLock;
        synchronized (this.databaseConfigurationCompleteLock) {
            DatabaseConfigurationBean databaseConfigurationBean;
            block4: {
                this.databaseConfigurationComplete = Boolean.TRUE;
                databaseConfigurationBean = this.dataBaseConfigurationBean;
                // ** MonitorExit[var1_1] (shouldn't be in output)
                if (logger == null || !logger.isLoggable(Level.FINER)) break block4;
                databaseConfigurationBean = databaseConfigurationBean;
                logger.exiting("com.ibm.jbatch.spi.BatchSPIManager", "getFinalDatabaseConfiguration", databaseConfigurationBean);
            }
            return databaseConfigurationBean;
        }
    }
}

