/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wsat.service;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import javax.xml.namespace.QName;

@TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class WSATFault {
    private static final String WSCOOR_NS = "http://docs.oasis-open.org/ws-tx/wscoor/2006/06";
    private static final String WSAT_NS = "http://docs.oasis-open.org/ws-tx/wsat/2006/06";
    private static final String CODE_SENDER = "Sender";
    private static final QName SUBCODE_INVALID_STATE;
    private static final QName SUBCODE_INVALID_PROTOCOL;
    private static final QName SUBCODE_INVALID_PARAMETERS;
    private static final QName SUBCODE_CANNOT_CREATE_CONTEXT;
    private static final QName SUBCODE_CANNOT_REGISTER_PARTICIPANT;
    private static final QName SUBCODE_INCONSISTENT_INTERNAL_STATE;
    private static final QName SUBCODE_UNKNOWN_TRANSACTION;
    private static final String REASON_INVALID_STATE = "The message was invalid for the current state of the activity";
    private static final String REASON_INVALID_PROTOCOL = "The protocol is invalid or not supported by the coordinator";
    private static final String REASON_INVALID_PARAMETERS = "The message contained invalid parameters and could not be processed";
    private static final String REASON_CANNOT_CREATE_CONTEXT = "CoordinationContext could not be created";
    private static final String REASON_CANNOT_REGISTER_PARTICIPANT = "Participant could not be registered";
    private static final String REASON_INCONSISTENT_INTERNAL_STATE = "A global consistency failure has occurred. This is an unrecoverable condition";
    private static final String REASON_UNKNOWN_TRANSACTION = "The coordinator has no knowledge of the transaction. This is an unrecoverable condition";
    private final String code;
    private final QName subcode;
    private final String reason;
    private final String detail;
    static final long serialVersionUID = -8991445739658455467L;
    private static final /* synthetic */ TraceComponent $$$tc$$$;

    public static WSATFault getInvalidState(String detail) {
        return new WSATFault(CODE_SENDER, SUBCODE_INVALID_STATE, REASON_INVALID_STATE, detail);
    }

    public static WSATFault getInvalidProtocol(String detail) {
        return new WSATFault(CODE_SENDER, SUBCODE_INVALID_PROTOCOL, REASON_INVALID_PROTOCOL, detail);
    }

    public static WSATFault getInvalidParameters(String detail) {
        return new WSATFault(CODE_SENDER, SUBCODE_INVALID_PARAMETERS, REASON_INVALID_PARAMETERS, detail);
    }

    public static WSATFault getCannotCreateContext(String detail) {
        return new WSATFault(CODE_SENDER, SUBCODE_CANNOT_CREATE_CONTEXT, REASON_CANNOT_CREATE_CONTEXT, detail);
    }

    public static WSATFault getCannotRegisterParticipant(String detail) {
        return new WSATFault(CODE_SENDER, SUBCODE_CANNOT_REGISTER_PARTICIPANT, REASON_CANNOT_REGISTER_PARTICIPANT, detail);
    }

    public static WSATFault getInconsistentInternalState(String detail) {
        return new WSATFault(CODE_SENDER, SUBCODE_INCONSISTENT_INTERNAL_STATE, REASON_INCONSISTENT_INTERNAL_STATE, detail);
    }

    public static WSATFault getUnknownTransaction(String detail) {
        return new WSATFault(CODE_SENDER, SUBCODE_UNKNOWN_TRANSACTION, REASON_UNKNOWN_TRANSACTION, detail);
    }

    public WSATFault(String code, QName subcode, String reason, String detail) {
        this.code = code;
        this.subcode = subcode;
        this.reason = reason;
        this.detail = detail;
    }

    public String getCode() {
        return this.code;
    }

    public QName getSubcode() {
        return this.subcode;
    }

    public String getReason() {
        return this.reason;
    }

    public String getDetail() {
        return this.detail;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
    static {
        $$$tc$$$ = Tr.register((String)"com.ibm.ws.wsat.service.WSATFault", WSATFault.class, (String)"wsat", (String)"com.ibm.ws.wsat.resources.WSAT");
        SUBCODE_INVALID_STATE = new QName(WSCOOR_NS, "InvalidState");
        SUBCODE_INVALID_PROTOCOL = new QName(WSCOOR_NS, "InvalidProtocol");
        SUBCODE_INVALID_PARAMETERS = new QName(WSCOOR_NS, "InvalidParameters");
        SUBCODE_CANNOT_CREATE_CONTEXT = new QName(WSCOOR_NS, "CannotCreateContext");
        SUBCODE_CANNOT_REGISTER_PARTICIPANT = new QName(WSCOOR_NS, "CannotRegisterParticipant");
        SUBCODE_INCONSISTENT_INTERNAL_STATE = new QName(WSAT_NS, "InconsistentInternalState");
        SUBCODE_UNKNOWN_TRANSACTION = new QName(WSAT_NS, "UnknownTransaction");
    }
}

