/*
 * Decompiled with CFR 0.152.
 */
package io.openliberty.microprofile.openapi20.validation;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import io.openliberty.microprofile.openapi20.utils.OpenAPIModelWalker;
import io.openliberty.microprofile.openapi20.validation.OASValidationResult;
import io.openliberty.microprofile.openapi20.validation.TypeValidator;
import io.openliberty.microprofile.openapi20.validation.ValidationHelper;
import io.openliberty.microprofile.openapi20.validation.ValidatorUtils;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.microprofile.openapi.models.security.OAuthFlow;
import org.eclipse.microprofile.openapi.models.security.OAuthFlows;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class OAuthFlowsValidator
extends TypeValidator<OAuthFlows> {
    private static final TraceComponent tc = Tr.register(OAuthFlowsValidator.class, (String)"MPOPENAPI", (String)"io.openliberty.microprofile.openapi.internal.resources.validation.ValidationMessages");
    private static final OAuthFlowsValidator INSTANCE = new OAuthFlowsValidator();
    static final long serialVersionUID = -1841852015124263114L;

    public static OAuthFlowsValidator getInstance() {
        return INSTANCE;
    }

    private OAuthFlowsValidator() {
    }

    @Override
    public void validate(ValidationHelper helper, OpenAPIModelWalker.Context context, String key, OAuthFlows t) {
        if (t != null) {
            String message;
            if (t.getImplicit() != null) {
                OAuthFlow implicit = t.getImplicit();
                if (StringUtils.isNotBlank((CharSequence)implicit.getTokenUrl())) {
                    message = Tr.formatMessage((TraceComponent)tc, (String)"nonApplicableFieldWithValue", (Object[])new Object[]{"tokenUrl", implicit.getTokenUrl(), "OAuth Flow Object", "implicit"});
                    helper.addValidationEvent(new OASValidationResult.ValidationEvent(OASValidationResult.ValidationEvent.Severity.WARNING, context.getLocation(), message));
                }
                ValidatorUtils.validateRequiredField(implicit.getAuthorizationUrl(), context, "authorizationUrl").ifPresent(helper::addValidationEvent);
            }
            if (t.getPassword() != null) {
                OAuthFlow password = t.getPassword();
                if (StringUtils.isNotBlank((CharSequence)password.getAuthorizationUrl())) {
                    message = Tr.formatMessage((TraceComponent)tc, (String)"nonApplicableFieldWithValue", (Object[])new Object[]{"authorizationUrl", password.getAuthorizationUrl(), "OAuth Flow Object", "password"});
                    helper.addValidationEvent(new OASValidationResult.ValidationEvent(OASValidationResult.ValidationEvent.Severity.WARNING, context.getLocation(), message));
                }
                ValidatorUtils.validateRequiredField(password.getTokenUrl(), context, "tokenUrl").ifPresent(helper::addValidationEvent);
            }
            if (t.getClientCredentials() != null) {
                OAuthFlow clientCred = t.getClientCredentials();
                if (StringUtils.isNotBlank((CharSequence)clientCred.getAuthorizationUrl())) {
                    message = Tr.formatMessage((TraceComponent)tc, (String)"nonApplicableFieldWithValue", (Object[])new Object[]{"authorizationUrl", clientCred.getAuthorizationUrl(), "OAuth Flow Object", "clientCredentials"});
                    helper.addValidationEvent(new OASValidationResult.ValidationEvent(OASValidationResult.ValidationEvent.Severity.WARNING, context.getLocation(), message));
                }
                ValidatorUtils.validateRequiredField(clientCred.getTokenUrl(), context, "tokenUrl").ifPresent(helper::addValidationEvent);
            }
            if (t.getAuthorizationCode() != null) {
                OAuthFlow authCode = t.getAuthorizationCode();
                ValidatorUtils.validateRequiredField(authCode.getTokenUrl(), context, "tokenUrl").ifPresent(helper::addValidationEvent);
                ValidatorUtils.validateRequiredField(authCode.getAuthorizationUrl(), context, "authorizationUrl").ifPresent(helper::addValidationEvent);
            }
        }
    }
}

