/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.ws.security.cache;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import net.sf.ehcache.CacheManager;
import net.sf.ehcache.config.CacheConfiguration;
import net.sf.ehcache.config.Configuration;
import net.sf.ehcache.config.ConfigurationFactory;
import org.apache.cxf.Bus;
import org.apache.cxf.common.classloader.ClassLoaderUtils;
import org.apache.cxf.resource.ResourceManager;
import org.apache.cxf.ws.security.cache.EHCacheReplayCacheFactory;

public final class EHCacheManagerHolder {
    private static final ConcurrentHashMap<String, AtomicInteger> COUNTS = new ConcurrentHashMap(8, 0.75f, 2);

    private EHCacheManagerHolder() {
    }

    public static CacheConfiguration getCacheConfiguration(String key, CacheManager cacheManager) {
        CacheConfiguration cc = (CacheConfiguration)cacheManager.getConfiguration().getCacheConfigurations().get(key);
        if (cc == null && key.contains("-")) {
            cc = (CacheConfiguration)cacheManager.getConfiguration().getCacheConfigurations().get(key.substring(0, key.lastIndexOf(45) - 1));
        }
        if (cc == null) {
            cc = cacheManager.getConfiguration().getDefaultCacheConfiguration();
        }
        cc = cc == null ? new CacheConfiguration() : cc.clone();
        cc.setName(key);
        return cc;
    }

    public static CacheManager getCacheManager(Bus bus, URL configFileURL) {
        AtomicInteger a;
        CacheManager cacheManager = null;
        if (configFileURL == null) {
            cacheManager = EHCacheManagerHolder.findDefaultCacheManager(bus);
        }
        if (cacheManager == null) {
            cacheManager = configFileURL == null ? CacheManager.create() : CacheManager.create((URL)configFileURL);
        }
        if ((a = COUNTS.get(cacheManager.getName())) == null) {
            COUNTS.putIfAbsent(cacheManager.getName(), new AtomicInteger());
            a = COUNTS.get(cacheManager.getName());
        }
        if (a.incrementAndGet() == 1) {
            // empty if block
        }
        return cacheManager;
    }

    private static CacheManager findDefaultCacheManager(Bus bus) {
        String defaultConfigFile = "cxf-ehcache.xml";
        URL configFileURL = null;
        if (bus != null) {
            ResourceManager rm = (ResourceManager)bus.getExtension(ResourceManager.class);
            configFileURL = (URL)rm.resolveResource(defaultConfigFile, URL.class);
        }
        try {
            if (configFileURL == null) {
                configFileURL = ClassLoaderUtils.getResource((String)defaultConfigFile, EHCacheReplayCacheFactory.class);
            }
            if (configFileURL == null) {
                configFileURL = new URL(defaultConfigFile);
            }
        }
        catch (IOException rm) {
            // empty catch block
        }
        try {
            Configuration conf = ConfigurationFactory.parseConfiguration(configFileURL);
            conf.setName(bus.getId());
            if ("java.io.tmpdir".equals(conf.getDiskStoreConfiguration().getOriginalPath())) {
                String path = conf.getDiskStoreConfiguration().getPath() + File.separator + bus.getId();
                conf.getDiskStoreConfiguration().setPath(path);
            }
            return CacheManager.create((Configuration)conf);
        }
        catch (Throwable t) {
            return null;
        }
    }

    public static void releaseCacheManger(CacheManager cacheManager) {
        AtomicInteger a = COUNTS.get(cacheManager.getName());
        if (a == null) {
            return;
        }
        if (a.decrementAndGet() == 0) {
            cacheManager.shutdown();
        }
    }
}

