/*
 * Decompiled with CFR 0.152.
 */
package graphql.execution;

import graphql.Assert;
import graphql.ExecutionResult;
import graphql.PublicApi;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CompletableFuture;

@PublicApi
public class FieldValueInfo {
    private final CompleteValueType completeValueType;
    private final CompletableFuture<ExecutionResult> fieldValue;
    private final List<FieldValueInfo> fieldValueInfos;

    private FieldValueInfo(CompleteValueType completeValueType, CompletableFuture<ExecutionResult> fieldValue, List<FieldValueInfo> fieldValueInfos) {
        Assert.assertNotNull(fieldValueInfos, "fieldValueInfos can't be null", new Object[0]);
        this.completeValueType = completeValueType;
        this.fieldValue = fieldValue;
        this.fieldValueInfos = fieldValueInfos;
    }

    public CompleteValueType getCompleteValueType() {
        return this.completeValueType;
    }

    public CompletableFuture<ExecutionResult> getFieldValue() {
        return this.fieldValue;
    }

    public List<FieldValueInfo> getFieldValueInfos() {
        return this.fieldValueInfos;
    }

    public static Builder newFieldValueInfo(CompleteValueType completeValueType) {
        return new Builder(completeValueType);
    }

    public String toString() {
        return "FieldValueInfo{completeValueType=" + (Object)((Object)this.completeValueType) + ", fieldValue=" + this.fieldValue + ", fieldValueInfos=" + this.fieldValueInfos + '}';
    }

    public static class Builder {
        private CompleteValueType completeValueType;
        private CompletableFuture<ExecutionResult> executionResultFuture;
        private List<FieldValueInfo> listInfos = new ArrayList<FieldValueInfo>();

        public Builder(CompleteValueType completeValueType) {
            this.completeValueType = completeValueType;
        }

        public Builder completeValueType(CompleteValueType completeValueType) {
            this.completeValueType = completeValueType;
            return this;
        }

        public Builder fieldValue(CompletableFuture<ExecutionResult> executionResultFuture) {
            this.executionResultFuture = executionResultFuture;
            return this;
        }

        public Builder fieldValueInfos(List<FieldValueInfo> listInfos) {
            Assert.assertNotNull(listInfos, "fieldValueInfos can't be null", new Object[0]);
            this.listInfos = listInfos;
            return this;
        }

        public FieldValueInfo build() {
            return new FieldValueInfo(this.completeValueType, this.executionResultFuture, this.listInfos);
        }
    }

    public static enum CompleteValueType {
        OBJECT,
        LIST,
        NULL,
        SCALAR,
        ENUM;

    }
}

