/*
 * Decompiled with CFR 0.152.
 */
package graphql.execution;

import graphql.Assert;
import graphql.AssertException;
import graphql.PublicApi;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.StringTokenizer;

@PublicApi
public class ExecutionPath {
    private static final ExecutionPath ROOT_PATH = new ExecutionPath();
    private final ExecutionPath parent;
    private final PathSegment segment;
    private final List<Object> pathList;

    public static ExecutionPath rootPath() {
        return ROOT_PATH;
    }

    private ExecutionPath() {
        this.parent = null;
        this.segment = null;
        this.pathList = this.toListImpl();
    }

    private ExecutionPath(ExecutionPath parent, PathSegment segment) {
        this.parent = Assert.assertNotNull(parent, "Must provide a parent path", new Object[0]);
        this.segment = Assert.assertNotNull(segment, "Must provide a sub path", new Object[0]);
        this.pathList = this.toListImpl();
    }

    public int getLevel() {
        int counter = 0;
        ExecutionPath currentPath = this;
        while (currentPath != null) {
            if (currentPath.segment instanceof StringPathSegment) {
                ++counter;
            }
            currentPath = currentPath.parent;
        }
        return counter;
    }

    public ExecutionPath getPathWithoutListEnd() {
        if (ROOT_PATH.equals(this)) {
            return ROOT_PATH;
        }
        if (this.segment instanceof StringPathSegment) {
            return this;
        }
        return this.parent;
    }

    public String getSegmentName() {
        if (this.segment instanceof StringPathSegment) {
            return ((StringPathSegment)this.segment).getValue();
        }
        if (this.parent == null) {
            return null;
        }
        return ((StringPathSegment)this.parent.segment).getValue();
    }

    public static ExecutionPath parse(String pathString) {
        pathString = pathString == null ? "" : pathString;
        pathString = pathString.trim();
        StringTokenizer st = new StringTokenizer(pathString, "/[]", true);
        ExecutionPath path = ExecutionPath.rootPath();
        while (st.hasMoreTokens()) {
            String token = st.nextToken();
            if ("/".equals(token)) {
                Assert.assertTrue(st.hasMoreTokens(), ExecutionPath.mkErrMsg(), pathString);
                path = path.segment(st.nextToken());
                continue;
            }
            if ("[".equals(token)) {
                Assert.assertTrue(st.countTokens() >= 2, ExecutionPath.mkErrMsg(), pathString);
                path = path.segment(Integer.parseInt(st.nextToken()));
                String closingBrace = st.nextToken();
                Assert.assertTrue(closingBrace.equals("]"), ExecutionPath.mkErrMsg(), pathString);
                continue;
            }
            throw new AssertException(String.format(ExecutionPath.mkErrMsg(), pathString));
        }
        return path;
    }

    public static ExecutionPath fromList(List<?> objects) {
        Assert.assertNotNull(objects);
        ExecutionPath path = ExecutionPath.rootPath();
        for (Object object : objects) {
            if (object instanceof Number) {
                path = path.segment(((Number)object).intValue());
                continue;
            }
            path = path.segment(String.valueOf(object));
        }
        return path;
    }

    private static String mkErrMsg() {
        return "Invalid path string : '%s'";
    }

    public ExecutionPath segment(String segment) {
        return new ExecutionPath(this, new StringPathSegment(segment));
    }

    public ExecutionPath segment(int segment) {
        return new ExecutionPath(this, new IntPathSegment(segment));
    }

    public ExecutionPath dropSegment() {
        if (this == ExecutionPath.rootPath()) {
            return null;
        }
        return this.parent;
    }

    public ExecutionPath replaceSegment(int segment) {
        Assert.assertTrue(!ROOT_PATH.equals(this), "You MUST not call this with the root path", new Object[0]);
        List<Object> objects = this.toList();
        objects.set(objects.size() - 1, new IntPathSegment(segment).getValue());
        return ExecutionPath.fromList(objects);
    }

    public ExecutionPath replaceSegment(String segment) {
        Assert.assertTrue(!ROOT_PATH.equals(this), "You MUST not call this with the root path", new Object[0]);
        List<Object> objects = this.toList();
        objects.set(objects.size() - 1, new StringPathSegment(segment).getValue());
        return ExecutionPath.fromList(objects);
    }

    public boolean isListSegment() {
        return this.segment instanceof IntPathSegment;
    }

    public boolean isNamedSegment() {
        return this.segment instanceof StringPathSegment;
    }

    public boolean isRootPath() {
        return this == ROOT_PATH;
    }

    public ExecutionPath append(ExecutionPath path) {
        List<Object> objects = this.toList();
        objects.addAll(Assert.assertNotNull(path).toList());
        return ExecutionPath.fromList(objects);
    }

    public ExecutionPath sibling(String siblingField) {
        Assert.assertTrue(!ROOT_PATH.equals(this), "You MUST not call this with the root path", new Object[0]);
        return new ExecutionPath(this.parent, new StringPathSegment(siblingField));
    }

    public List<Object> toList() {
        return new ArrayList<Object>(this.pathList);
    }

    private List<Object> toListImpl() {
        if (this.parent == null) {
            return Collections.emptyList();
        }
        ArrayList<Object> list = new ArrayList<Object>();
        ExecutionPath p = this;
        while (p.segment != null) {
            list.add(p.segment.getValue());
            p = p.parent;
        }
        Collections.reverse(list);
        return list;
    }

    public String toString() {
        if (this.parent == null) {
            return "";
        }
        if (ROOT_PATH.equals(this.parent)) {
            return this.segment.toString();
        }
        return this.parent.toString() + this.segment.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ExecutionPath that = (ExecutionPath)o;
        return this.pathList.equals(that.pathList);
    }

    public int hashCode() {
        return this.pathList.hashCode();
    }

    private static class IntPathSegment
    implements PathSegment<Integer> {
        private final int value;

        IntPathSegment(int value) {
            this.value = value;
        }

        @Override
        public Integer getValue() {
            return this.value;
        }

        public String toString() {
            return "[" + this.value + ']';
        }
    }

    private static class StringPathSegment
    implements PathSegment<String> {
        private final String value;

        StringPathSegment(String value) {
            Assert.assertTrue(value != null && !value.isEmpty(), "empty path component", new Object[0]);
            this.value = value;
        }

        @Override
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return '/' + this.value;
        }
    }

    private static interface PathSegment<T> {
        public T getValue();
    }
}

