/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.kernel.launch.internal;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ffdc.annotation.FFDCIgnore;
import com.ibm.ws.kernel.boot.internal.commands.ServerDumpUtil;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.net.URL;
import java.security.AccessController;
import java.security.CodeSource;
import java.security.Permission;
import java.security.PermissionCollection;
import java.security.PrivilegedAction;
import java.security.ProtectionDomain;
import java.util.Arrays;
import java.util.Enumeration;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class NoRethrowSecurityManager
extends SecurityManager {
    public static final String lineSep = System.getProperty("line.separator");
    private static final TraceComponent tc = Tr.register(NoRethrowSecurityManager.class, (String)"bootstrap", (String)"com.ibm.ws.kernel.boot.resources.LauncherMessages");
    static final long serialVersionUID = -5712111433844080254L;

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
    public NoRethrowSecurityManager() {
        if (TraceComponent.isAnyTracingEnabled() && tc != null && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"<init>", (Object[])new Object[0]);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc != null && tc.isEntryEnabled()) {
            Tr.exit((Object)this, (TraceComponent)tc, (String)"<init>", (Object)this);
        }
    }

    @Override
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
    @FFDCIgnore(value={SecurityException.class})
    public void checkPermission(Permission perm) {
        if (TraceComponent.isAnyTracingEnabled() && tc != null && tc.isEntryEnabled()) {
            Tr.entry((Object)this, (TraceComponent)tc, (String)"checkPermission", (Object[])new Object[]{perm});
        }
        try {
            super.checkPermission(perm);
        }
        catch (SecurityException ex) {
            this.handleSecurityException(perm, ex);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc != null && tc.isEntryEnabled()) {
            Tr.exit((Object)this, (TraceComponent)tc, (String)"checkPermission");
        }
    }

    @Override
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
    @FFDCIgnore(value={SecurityException.class})
    public void checkPermission(Permission perm, Object context) {
        if (TraceComponent.isAnyTracingEnabled() && tc != null && tc.isEntryEnabled()) {
            Tr.entry((Object)this, (TraceComponent)tc, (String)"checkPermission", (Object[])new Object[]{perm, context});
        }
        try {
            super.checkPermission(perm, context);
        }
        catch (SecurityException ex) {
            this.handleSecurityException(perm, ex);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc != null && tc.isEntryEnabled()) {
            Tr.exit((Object)this, (TraceComponent)tc, (String)"checkPermission");
        }
    }

    /*
     * WARNING - void declaration
     */
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
    public void handleSecurityException(Permission perm, SecurityException e) throws SecurityException {
        if (TraceComponent.isAnyTracingEnabled() && tc != null && tc.isEntryEnabled()) {
            Tr.entry((Object)this, (TraceComponent)tc, (String)"handleSecurityException", (Object[])new Object[]{perm, e});
        }
        StringWriter sw = new StringWriter();
        e.printStackTrace(new PrintWriter(sw));
        String stackStr = sw.toString();
        Object[] codebaseloc = null;
        try {
            codebaseloc = this.getCodeBaseLoc(perm);
        }
        catch (Exception exception) {
            void e2;
            FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.kernel.launch.internal.NoRethrowSecurityManager", (String)"70", (Object)this, (Object[])new Object[]{perm, e});
            StringWriter sw2 = new StringWriter();
            e2.printStackTrace(new PrintWriter(sw2));
            String stackStr2 = sw2.toString();
            Tr.error((TraceComponent)tc, (String)"error.java.security.exception.codebase", (Object[])new Object[]{e2.toString() + "(" + e2.getMessage() + ")" + lineSep + lineSep + stackStr2});
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            String strDebug = "\nJava SecurityException:\n perm.getName<>: " + perm.getName() + "\n e.getMessage<>: " + e.getMessage() + "\nBegin SecurityException\n" + stackStr + "\nCode base location information:\n" + Arrays.toString(codebaseloc) + "\n class ==> : " + (String)codebaseloc[0] + "\nSuggested Action: Verify the attempted operation is permitted by examining all Java 2 security policy files and application code. Additional permissions may be required, a doPrivileged API may be needed in some code on the call stack, or the Security Manager properly prevented access to a resource the caller does not have permission to access.\nEnd SecurityException\n";
            Tr.debug((TraceComponent)tc, (String)strDebug, (Object[])new Object[0]);
        }
        if (!ServerDumpUtil.isZos()) {
            Tr.warning((TraceComponent)tc, (String)"warning.java.security.permdenied", (Object[])new Object[]{lineSep + lineSep, lineSep + lineSep + "      " + perm.getName() + " : " + e.getMessage() + lineSep + lineSep + lineSep, codebaseloc[0], lineSep + lineSep, lineSep + lineSep + stackStr + lineSep + lineSep, lineSep + lineSep + (String)codebaseloc[1]});
        } else {
            Tr.warning((TraceComponent)tc, (String)"warning.zOS.java.security.permdenied1", (Object[])new Object[]{lineSep + lineSep, lineSep + lineSep + "      " + perm.getName() + " : " + e.getMessage() + lineSep + lineSep + lineSep, codebaseloc[0], lineSep + lineSep + (String)codebaseloc[1]});
            Tr.warning((TraceComponent)tc, (String)"warning.zOS.java.security.permdenied2", (Object[])new Object[]{"\nBegin SecurityException\n" + stackStr + "\nEnd SecurityException\n"});
        }
        if (TraceComponent.isAnyTracingEnabled() && tc != null && tc.isEntryEnabled()) {
            Tr.exit((Object)this, (TraceComponent)tc, (String)"handleSecurityException");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
    public String[] getCodeBaseLoc(Permission perm) {
        if (TraceComponent.isAnyTracingEnabled() && tc != null && tc.isEntryEnabled()) {
            Tr.entry((Object)this, (TraceComponent)tc, (String)"getCodeBaseLoc", (Object[])new Object[]{perm});
        }
        final Permission inPerm = perm;
        String[] stringArray = AccessController.doPrivileged(new PrivilegedAction<String[]>(){
            static final long serialVersionUID = -8757968748865938868L;
            private static final /* synthetic */ TraceComponent $$$tc$$$;
            {
                if (TraceComponent.isAnyTracingEnabled() && $$$tc$$$ != null && $$$tc$$$.isEntryEnabled()) {
                    Tr.entry((TraceComponent)$$$tc$$$, (String)"<init>", (Object[])new Object[]{NoRethrowSecurityManager.this, permission});
                }
                if (TraceComponent.isAnyTracingEnabled() && $$$tc$$$ != null && $$$tc$$$.isEntryEnabled()) {
                    Tr.exit((Object)this, (TraceComponent)$$$tc$$$, (String)"<init>", (Object)this);
                }
            }

            @Override
            @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
            public String[] run() {
                if (TraceComponent.isAnyTracingEnabled() && $$$tc$$$ != null && $$$tc$$$.isEntryEnabled()) {
                    Tr.entry((Object)this, (TraceComponent)$$$tc$$$, (String)"run", (Object[])new Object[0]);
                }
                Class[] classes = NoRethrowSecurityManager.this.getClassContext();
                StringBuffer sb = new StringBuffer(classes.length * 100);
                sb.append(lineSep);
                String[] retMsg = new String[2];
                for (int i = 0; i < classes.length; ++i) {
                    Class clazz = classes[i];
                    ProtectionDomain pd = clazz.getProtectionDomain();
                    if (classes[i].getName().indexOf("com.ibm.ws.kernel.launch.internal.NoRethrowSecurityManager") != -1) {
                        for (int j = i + 1; j < classes.length; ++j) {
                            if (classes[j].getName().indexOf("java.lang.ClassLoader") != -1) {
                                if (tc.isDebugEnabled()) {
                                    Tr.debug((TraceComponent)tc, (String)"Not printing AccessError since ClassLoader.getResource returns null per JavaDoc when privileges not there.", (Object[])new Object[0]);
                                }
                                String[] codebaseloc = new String[]{"_nolog", ""};
                                String[] stringArray = codebaseloc;
                                if (TraceComponent.isAnyTracingEnabled() && $$$tc$$$ != null && $$$tc$$$.isEntryEnabled()) {
                                    stringArray = stringArray;
                                    Tr.exit((Object)this, (TraceComponent)$$$tc$$$, (String)"run", (Object)stringArray);
                                }
                                return stringArray;
                            }
                            ProtectionDomain pd2 = classes[j].getProtectionDomain();
                            if (!NoRethrowSecurityManager.this.isOffendingClass(classes, j, pd2, inPerm)) continue;
                            retMsg[0] = lineSep + lineSep + "     " + classes[j].getName() + "  in  {" + NoRethrowSecurityManager.this.getCodeSource(pd2) + "}" + lineSep + lineSep;
                            break;
                        }
                    }
                    CodeSource cs = pd.getCodeSource();
                    String csStr = NoRethrowSecurityManager.this.getCodeSource(pd);
                    sb.append(classes[i].getName()).append(" : ").append(csStr + lineSep);
                    sb.append("  ").append(NoRethrowSecurityManager.this.permissionToString(cs, clazz.getClassLoader(), pd.getPermissions())).append(lineSep);
                }
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("Permission Error Code is " + retMsg[0]), (Object[])new Object[0]);
                }
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("Code Base Location: is " + sb.toString()), (Object[])new Object[0]);
                }
                retMsg[1] = "";
                String[] stringArray = retMsg;
                if (TraceComponent.isAnyTracingEnabled() && $$$tc$$$ != null && $$$tc$$$.isEntryEnabled()) {
                    stringArray = stringArray;
                    Tr.exit((Object)this, (TraceComponent)$$$tc$$$, (String)"run", (Object)stringArray);
                }
                return stringArray;
            }

            @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
            static {
                $$$tc$$$ = Tr.register((String)"com.ibm.ws.kernel.launch.internal.NoRethrowSecurityManager$1", 1.class, (String)"bootstrap", (String)"com.ibm.ws.kernel.boot.resources.LauncherMessages");
            }
        });
        if (TraceComponent.isAnyTracingEnabled() && tc != null && tc.isEntryEnabled()) {
            stringArray = stringArray;
            Tr.exit((Object)this, (TraceComponent)tc, (String)"getCodeBaseLoc", (Object)stringArray);
        }
        return stringArray;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
    public String getCodeSource(ProtectionDomain pd) {
        URL url;
        if (TraceComponent.isAnyTracingEnabled() && tc != null && tc.isEntryEnabled()) {
            Tr.entry((Object)this, (TraceComponent)tc, (String)"getCodeSource", (Object[])new Object[]{pd});
        }
        CodeSource cs = pd.getCodeSource();
        String csStr = null;
        csStr = cs == null ? "null code source" : ((url = cs.getLocation()) == null ? "null code URL" : url.toString());
        String string = csStr;
        if (TraceComponent.isAnyTracingEnabled() && tc != null && tc.isEntryEnabled()) {
            string = string;
            Tr.exit((Object)this, (TraceComponent)tc, (String)"getCodeSource", (Object)string);
        }
        return string;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
    public String permissionToString(CodeSource cs, ClassLoader classloaderClass, PermissionCollection col) {
        if (TraceComponent.isAnyTracingEnabled() && tc != null && tc.isEntryEnabled()) {
            Tr.entry((Object)this, (TraceComponent)tc, (String)"permissionToString", (Object[])new Object[]{cs, classloaderClass, col});
        }
        StringBuffer buf = new StringBuffer("ClassLoader: ");
        if (classloaderClass == null) {
            buf.append("Primordial Classloader");
        } else {
            buf.append(classloaderClass.getClass().getName());
        }
        buf.append(lineSep);
        buf.append("  Permissions granted to CodeSource ").append(cs).append(lineSep);
        if (col != null) {
            Enumeration<Permission> e = col.elements();
            buf.append("  {").append(lineSep);
            while (e.hasMoreElements()) {
                Permission p = e.nextElement();
                buf.append("    ").append(p.toString()).append(";").append(lineSep);
            }
            buf.append("  }");
        } else {
            buf.append("  {").append(lineSep).append("  }");
        }
        String string = buf.toString();
        if (TraceComponent.isAnyTracingEnabled() && tc != null && tc.isEntryEnabled()) {
            string = string;
            Tr.exit((Object)this, (TraceComponent)tc, (String)"permissionToString", (Object)string);
        }
        return string;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
    boolean isOffendingClass(Class<?>[] classes, int j, ProtectionDomain pd2, Permission inPerm) {
        if (TraceComponent.isAnyTracingEnabled() && tc != null && tc.isEntryEnabled()) {
            Tr.entry((Object)this, (TraceComponent)tc, (String)"isOffendingClass", (Object[])new Object[]{classes, j, pd2, inPerm});
        }
        boolean bl = !classes[j].getName().startsWith("java") && classes[j].getName().indexOf("com.ibm.ws.kernel.launch.internal.NoRethrowSecurityManager") == -1 && classes[j].getName().indexOf("ClassLoader") == -1 && (j == classes.length - 1 || classes[j + 1].getName().indexOf("ClassLoader") == -1) && !pd2.implies(inPerm);
        if (TraceComponent.isAnyTracingEnabled() && tc != null && tc.isEntryEnabled()) {
            bl = bl;
            Tr.exit((Object)this, (TraceComponent)tc, (String)"isOffendingClass", (Object)bl);
        }
        return bl;
    }
}

